/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.gles;

import android.annotation.TargetApi;
import android.opengl.GLES20;
import android.util.Log;
import com.yy.mediaframework.gles.GlUtil;
import com.yy.mediaframework.utils.YMFLog;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public class Texture2dProgram {
    private static final String TAG = "GlUtil";
    static final float[] SLAVE_VEX_RIGHT_BOTTOM = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, -1.0f, 1.0f, -1.0f};
    private final FloatBuffer mSlaveVertexBuffer;
    private ProgramType mProgramType;
    private int mProgramHandle;
    private int muMVPMatrixLoc;
    private int muTexMatrixLoc;
    private int muKernelLoc;
    private int muTexOffsetLoc;
    private int muColorAdjustLoc;
    private int maPositionLoc;
    private int maTextureCoordLoc;
    private int mSlaveProgramHandle;
    private int muSlavePicMVPMatrixLoc;
    private int muSlavePicTexMatrixLoc;
    private int maSlavePicPositionLoc;
    private int maSlavePicTextureCoordLoc;
    private int muTextureLoc;
    private int muSlavePicTextureLoc;
    private int muExtraTextureEnableLoc;
    private int maExtraTextureCoordLoc;
    private int muExtraTextureLoc;
    private int muExtraTexture2EnableLoc;
    private int maExtraTextureCoord2Loc;
    private int muExtraTexture2Loc;
    private int mTextureTarget;
    private float[] mKernel = new float[9];
    private float[] mTexOffset;
    private float mColorAdjust;
    private static final String VERTEX_SHADER = "uniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute vec4 aPosition;\nattribute vec4 aTextureCoord;\nvarying vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n";
    private static final String VERTEX_SHADER_WITH_EXTRA_TXT = "uniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute vec4 aPosition;\nattribute vec4 aTextureCoord;\nattribute vec4 aExtraTextureCoord;\nvarying vec2 vTextureCoord;\nvarying vec2 vExtraTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vExtraTextureCoord = vec2(aExtraTextureCoord.x, aExtraTextureCoord.y);\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}";
    private static final String VERTEX_SHADER_WITH_EXTRA_TXT_2 = "uniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute vec4 aPosition;\nattribute vec4 aTextureCoord;\nattribute vec4 aExtraTextureCoord;\nattribute vec4 aExtraTextureCoord2;\nvarying vec2 vTextureCoord;\nvarying vec2 vExtraTextureCoord;\nvarying vec2 vExtraTextureCoord2;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vExtraTextureCoord = vec2(aExtraTextureCoord.x, aExtraTextureCoord.y);\n    vExtraTextureCoord2 = vec2(aExtraTextureCoord2.x, aExtraTextureCoord2.y);\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}";
    private static final String FRAGMENT_SHADER_2D = "precision mediump float;\nvarying vec2 vTextureCoord;\nuniform sampler2D sTexture;\nvoid main() {\n    gl_FragColor = texture2D(sTexture, vTextureCoord);\n}\n";
    private static final String FRAGMENT_SHADER_2D_WITH_EXTRA_TXT = "precision mediump float;\nvarying vec2 vTextureCoord;\nvarying vec2 vExtraTextureCoord;\nuniform sampler2D uTexture;\nuniform sampler2D uExtraTexture;\nuniform int uExtraTxtEnabled;\n\nvoid main() {\n    if (uExtraTxtEnabled == 1) {\n       vec4 base = texture2D(uTexture, vTextureCoord);\n       vec4 overlay = texture2D(uExtraTexture, vExtraTextureCoord);\n       vec4 outputColor;\n       outputColor.r = overlay.r + base.r * base.a * (1.0 - overlay.a);\n       outputColor.g = overlay.g + base.g * base.a * (1.0 - overlay.a);\n       outputColor.b = overlay.b + base.b * base.a * (1.0 - overlay.a);\n       outputColor.a = overlay.a + base.a * (1.0 - overlay.a);\n       gl_FragColor = outputColor;\n    }\n    else {\n        gl_FragColor = texture2D(uTexture, vTextureCoord);\n    }\n}";
    private static final String FRAGMENT_SHADER_2D_WITH_EXTRA_TXT_2 = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nvarying vec2 vTextureCoord;\nvarying vec2 vExtraTextureCoord;\nvarying vec2 vExtraTextureCoord2;\nuniform sampler2D uTexture;\nuniform sampler2D uExtraTexture;\nuniform sampler2D uExtraTexture2;\nuniform int uExtraTxtEnabled;\nuniform int uExtraTxt2Enabled;\nuniform int uSlavePicEnabled;\n\nvoid main() {\n    vec4 outputColor = texture2D(uTexture, vTextureCoord);\n    if (uExtraTxt2Enabled == 1) {\n        vec4 overlay2 = texture2D(uExtraTexture2, vExtraTextureCoord2);\n        outputColor.r = overlay2.r * overlay2.a + outputColor.r * outputColor.a * (1.0 - overlay2.a);\n        outputColor.g = overlay2.g * overlay2.a + outputColor.g * outputColor.a * (1.0 - overlay2.a);\n        outputColor.b = overlay2.b * overlay2.a + outputColor.b * outputColor.a * (1.0 - overlay2.a);\n        outputColor.a = overlay2.a + outputColor.a - overlay2.a * outputColor.a;\n    }\n    if (uExtraTxtEnabled == 1) {\n        vec4 overlay = texture2D(uExtraTexture, vExtraTextureCoord);\n        outputColor.r = overlay.r + outputColor.r * (1.0 - overlay.a);\n        outputColor.g = overlay.g + outputColor.g * (1.0 - overlay.a);\n        outputColor.b = overlay.b + outputColor.b * (1.0 - overlay.a);\n        outputColor.a = overlay.a + outputColor.a - overlay.a * outputColor.a;\n    }\n    gl_FragColor = outputColor;\n}";
    private static final String FRAGMENT_SHADER_EXT = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform samplerExternalOES sTexture;\nvoid main() {\n    gl_FragColor = texture2D(sTexture, vTextureCoord);\n}\n";
    private static final String FRAGMENT_SHADER_EXT_BW = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform samplerExternalOES sTexture;\nvoid main() {\n    vec4 tc = texture2D(sTexture, vTextureCoord);\n    float color = tc.r * 0.3 + tc.g * 0.59 + tc.b * 0.11;\n    gl_FragColor = vec4(color, color, color, 1.0);\n}\n";
    public static final int KERNEL_SIZE = 9;
    private static final String FRAGMENT_SHADER_EXT_FILT = "#extension GL_OES_EGL_image_external : require\n#define KERNEL_SIZE 9\nprecision highp float;\nvarying vec2 vTextureCoord;\nuniform samplerExternalOES sTexture;\nuniform float uKernel[KERNEL_SIZE];\nuniform vec2 uTexOffset[KERNEL_SIZE];\nuniform float uColorAdjust;\nvoid main() {\n    int i = 0;\n    vec4 sum = vec4(0.0);\n    if (vTextureCoord.x < vTextureCoord.y - 0.005) {\n        for (i = 0; i < KERNEL_SIZE; i++) {\n            vec4 texc = texture2D(sTexture, vTextureCoord + uTexOffset[i]);\n            sum += texc * uKernel[i];\n        }\n    sum += uColorAdjust;\n    } else if (vTextureCoord.x > vTextureCoord.y + 0.005) {\n        sum = texture2D(sTexture, vTextureCoord);\n    } else {\n        sum.r = 1.0;\n    }\n    gl_FragColor = sum;\n}\n";

    public Texture2dProgram(ProgramType programType) {
        this.mProgramType = programType;
        switch (programType) {
            case TEXTURE_2D: {
                this.mTextureTarget = 3553;
                this.mProgramHandle = GlUtil.createProgram(VERTEX_SHADER, FRAGMENT_SHADER_2D);
                break;
            }
            case TEXTURE_2D_WITH_EXTRA_TXT: {
                this.mTextureTarget = 3553;
                this.mProgramHandle = GlUtil.createProgram(VERTEX_SHADER_WITH_EXTRA_TXT, FRAGMENT_SHADER_2D_WITH_EXTRA_TXT);
                break;
            }
            case TEXTURE_2D_WITH_EXTRA_TXT_2: {
                this.mTextureTarget = 3553;
                this.mProgramHandle = GlUtil.createProgram(VERTEX_SHADER_WITH_EXTRA_TXT_2, FRAGMENT_SHADER_2D_WITH_EXTRA_TXT_2);
                this.mSlaveProgramHandle = GlUtil.createProgram(VERTEX_SHADER, FRAGMENT_SHADER_EXT);
                break;
            }
            case TEXTURE_EXT: {
                this.mTextureTarget = 36197;
                this.mProgramHandle = GlUtil.createProgram(VERTEX_SHADER, FRAGMENT_SHADER_EXT);
                break;
            }
            case TEXTURE_EXT_BW: {
                this.mTextureTarget = 36197;
                this.mProgramHandle = GlUtil.createProgram(VERTEX_SHADER, FRAGMENT_SHADER_EXT_BW);
                break;
            }
            case TEXTURE_EXT_FILT: {
                this.mTextureTarget = 36197;
                this.mProgramHandle = GlUtil.createProgram(VERTEX_SHADER, FRAGMENT_SHADER_EXT_FILT);
                break;
            }
            default: {
                throw new RuntimeException("Unhandled type " + (Object)((Object)programType));
            }
        }
        if (this.mProgramHandle == 0) {
            throw new RuntimeException("Unable to create program");
        }
        YMFLog.info(this, "[Util    ]", "Created program " + this.mProgramHandle + " (" + (Object)((Object)programType) + ")");
        this.maPositionLoc = GLES20.glGetAttribLocation((int)this.mProgramHandle, (String)"aPosition");
        GlUtil.checkLocation(this.maPositionLoc, "aPosition");
        this.maTextureCoordLoc = GLES20.glGetAttribLocation((int)this.mProgramHandle, (String)"aTextureCoord");
        GlUtil.checkLocation(this.maTextureCoordLoc, "aTextureCoord");
        this.maSlavePicPositionLoc = GLES20.glGetAttribLocation((int)this.mSlaveProgramHandle, (String)"aPosition");
        GlUtil.checkLocation(this.maSlavePicPositionLoc, "aPosition");
        this.maSlavePicTextureCoordLoc = GLES20.glGetAttribLocation((int)this.mSlaveProgramHandle, (String)"aTextureCoord");
        GlUtil.checkLocation(this.maSlavePicTextureCoordLoc, "aTextureCoord");
        this.muMVPMatrixLoc = GLES20.glGetUniformLocation((int)this.mProgramHandle, (String)"uMVPMatrix");
        GlUtil.checkLocation(this.muMVPMatrixLoc, "uMVPMatrix");
        this.muTexMatrixLoc = GLES20.glGetUniformLocation((int)this.mProgramHandle, (String)"uTexMatrix");
        GlUtil.checkLocation(this.muTexMatrixLoc, "uTexMatrix");
        this.muSlavePicMVPMatrixLoc = GLES20.glGetUniformLocation((int)this.mSlaveProgramHandle, (String)"uMVPMatrix");
        GlUtil.checkLocation(this.muSlavePicMVPMatrixLoc, "uMVPMatrix");
        this.muSlavePicTexMatrixLoc = GLES20.glGetUniformLocation((int)this.mSlaveProgramHandle, (String)"uTexMatrix");
        GlUtil.checkLocation(this.muSlavePicTexMatrixLoc, "uTexMatrix");
        this.muExtraTextureEnableLoc = GLES20.glGetUniformLocation((int)this.mProgramHandle, (String)"uExtraTxtEnabled");
        this.maExtraTextureCoordLoc = GLES20.glGetAttribLocation((int)this.mProgramHandle, (String)"aExtraTextureCoord");
        this.muExtraTextureLoc = GLES20.glGetUniformLocation((int)this.mProgramHandle, (String)"uExtraTexture");
        this.muExtraTexture2EnableLoc = GLES20.glGetUniformLocation((int)this.mProgramHandle, (String)"uExtraTxt2Enabled");
        this.maExtraTextureCoord2Loc = GLES20.glGetAttribLocation((int)this.mProgramHandle, (String)"aExtraTextureCoord2");
        this.muExtraTexture2Loc = GLES20.glGetUniformLocation((int)this.mProgramHandle, (String)"uExtraTexture2");
        this.muTextureLoc = GLES20.glGetUniformLocation((int)this.mProgramHandle, (String)"uTexture");
        this.muSlavePicTextureLoc = GLES20.glGetUniformLocation((int)this.mSlaveProgramHandle, (String)"sTexture");
        this.muKernelLoc = GLES20.glGetUniformLocation((int)this.mProgramHandle, (String)"uKernel");
        if (this.muKernelLoc < 0) {
            this.muKernelLoc = -1;
            this.muTexOffsetLoc = -1;
            this.muColorAdjustLoc = -1;
        } else {
            this.muTexOffsetLoc = GLES20.glGetUniformLocation((int)this.mProgramHandle, (String)"uTexOffset");
            GlUtil.checkLocation(this.muTexOffsetLoc, "uTexOffset");
            this.muColorAdjustLoc = GLES20.glGetUniformLocation((int)this.mProgramHandle, (String)"uColorAdjust");
            GlUtil.checkLocation(this.muColorAdjustLoc, "uColorAdjust");
            this.setKernel(new float[]{0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f}, 0.0f);
            this.setTexSize(256, 256);
        }
        this.mSlaveVertexBuffer = ByteBuffer.allocateDirect(SLAVE_VEX_RIGHT_BOTTOM.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.mSlaveVertexBuffer.put(SLAVE_VEX_RIGHT_BOTTOM).position(0);
    }

    public void release() {
        Log.d((String)TAG, (String)("deleting program " + this.mProgramHandle));
        GLES20.glDeleteProgram((int)this.mProgramHandle);
        this.mProgramHandle = -1;
    }

    public ProgramType getProgramType() {
        return this.mProgramType;
    }

    @TargetApi(value=15)
    public int createTextureObject() {
        int[] textures = new int[1];
        GLES20.glGenTextures((int)1, (int[])textures, (int)0);
        GlUtil.checkGlError("glGenTextures");
        int texId = textures[0];
        GLES20.glBindTexture((int)this.mTextureTarget, (int)texId);
        GlUtil.checkGlError("glBindTexture " + texId);
        GLES20.glTexParameterf((int)36197, (int)10241, (float)9728.0f);
        GLES20.glTexParameterf((int)36197, (int)10240, (float)9729.0f);
        GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
        GlUtil.checkGlError("glTexParameter");
        return texId;
    }

    public void setKernel(float[] values, float colorAdj) {
        if (values.length != 9) {
            throw new IllegalArgumentException("Kernel size is " + values.length + " vs. " + 9);
        }
        System.arraycopy(values, 0, this.mKernel, 0, 9);
        this.mColorAdjust = colorAdj;
    }

    public void setTexSize(int width, int height) {
        float rw = 1.0f / (float)width;
        float rh = 1.0f / (float)height;
        this.mTexOffset = new float[]{-rw, -rh, 0.0f, -rh, rw, -rh, -rw, 0.0f, 0.0f, 0.0f, rw, 0.0f, -rw, rh, 0.0f, rh, rw, rh};
    }

    public void draw(float[] mvpMatrix, FloatBuffer vertexBuffer, int firstVertex, int vertexCount, int coordsPerVertex, int vertexStride, float[] texMatrix, FloatBuffer texBuffer, int textureId, int texStride) {
        this.draw(mvpMatrix, vertexBuffer, firstVertex, vertexCount, coordsPerVertex, vertexStride, texMatrix, texBuffer, textureId, texStride, null, -1);
    }

    public void draw(float[] mvpMatrix, FloatBuffer vertexBuffer, int firstVertex, int vertexCount, int coordsPerVertex, int vertexStride, float[] texMatrix, FloatBuffer texBuffer, int textureId, int texStride, FloatBuffer extraTxtBuffer, int extraTextureId) {
        this.draw(mvpMatrix, vertexBuffer, firstVertex, vertexCount, coordsPerVertex, vertexStride, texMatrix, texBuffer, textureId, texStride, extraTxtBuffer, extraTextureId, null, -1, null);
    }

    public void draw(float[] mvpMatrix, FloatBuffer vertexBuffer, int firstVertex, int vertexCount, int coordsPerVertex, int vertexStride, float[] texMatrix, FloatBuffer mainTextureCoords, int mainTextureId, int texStride, FloatBuffer waterMarkTextureCoords, int waterMarkTextureId, FloatBuffer stickerTextureCoords, int stickerTextureId, float[] slavePicTexMatrix) {
        this.draw(mvpMatrix, vertexBuffer, firstVertex, vertexCount, coordsPerVertex, vertexStride, texMatrix, mainTextureCoords, mainTextureId, texStride, waterMarkTextureCoords, waterMarkTextureId, stickerTextureCoords, stickerTextureId);
    }

    public void draw(float[] mvpMatrix, FloatBuffer vertexBuffer, int firstVertex, int vertexCount, int coordsPerVertex, int vertexStride, float[] texMatrix, FloatBuffer mainTextureCoords, int mainTextureId, int texStride, FloatBuffer waterMarkTextureCoords, int waterMarkTextureId, FloatBuffer stickerTextureCoords, int stickerTextureId) {
        GlUtil.checkGlError("draw start");
        GLES20.glUseProgram((int)this.mProgramHandle);
        GlUtil.checkGlError("glUseProgram");
        GLES20.glUniformMatrix4fv((int)this.muMVPMatrixLoc, (int)1, (boolean)false, (float[])mvpMatrix, (int)0);
        GlUtil.checkGlError("glUniformMatrix4fv");
        GLES20.glUniformMatrix4fv((int)this.muTexMatrixLoc, (int)1, (boolean)false, (float[])texMatrix, (int)0);
        GlUtil.checkGlError("glUniformMatrix4fv");
        GLES20.glEnableVertexAttribArray((int)this.maPositionLoc);
        GlUtil.checkGlError("glEnableVertexAttribArray");
        GLES20.glVertexAttribPointer((int)this.maPositionLoc, (int)coordsPerVertex, (int)5126, (boolean)false, (int)vertexStride, (Buffer)vertexBuffer);
        GlUtil.checkGlError("glVertexAttribPointer");
        GLES20.glEnableVertexAttribArray((int)this.maTextureCoordLoc);
        GlUtil.checkGlError("glEnableVertexAttribArray");
        GLES20.glVertexAttribPointer((int)this.maTextureCoordLoc, (int)2, (int)5126, (boolean)false, (int)texStride, (Buffer)mainTextureCoords);
        GlUtil.checkGlError("glVertexAttribPointer");
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)mainTextureId);
        GLES20.glUniform1i((int)this.muTextureLoc, (int)0);
        if (this.muKernelLoc >= 0) {
            GLES20.glUniform1fv((int)this.muKernelLoc, (int)9, (float[])this.mKernel, (int)0);
            GLES20.glUniform2fv((int)this.muTexOffsetLoc, (int)9, (float[])this.mTexOffset, (int)0);
            GLES20.glUniform1f((int)this.muColorAdjustLoc, (float)this.mColorAdjust);
        }
        if (this.muExtraTextureEnableLoc >= 0) {
            this.drawWaterMark(waterMarkTextureId, texStride, waterMarkTextureCoords);
        }
        if (this.muExtraTexture2EnableLoc >= 0) {
            this.drawSticker(stickerTextureId, texStride, stickerTextureCoords);
        }
        GlUtil.checkGlError("glDrawArrays");
        GLES20.glDrawArrays((int)5, (int)firstVertex, (int)vertexCount);
        GlUtil.checkGlError("glDrawArrays");
        GLES20.glDisableVertexAttribArray((int)this.maPositionLoc);
        GLES20.glDisableVertexAttribArray((int)this.maTextureCoordLoc);
        GLES20.glBindTexture((int)this.mTextureTarget, (int)0);
        GLES20.glUseProgram((int)0);
    }

    public void drawSlavePicture(int slavePicTextureId, float[] mvpMatrix, float[] slavePicTexMatrix, float[] texMatrix, int coordsPerVertex, int vertexStride, int texStride, int firstVertex, int vertexCount, FloatBuffer slavePicVertexBuffer, FloatBuffer slavePicTextureCoords) {
        if (slavePicTextureId < 0) {
            YMFLog.info(this, "[Util    ]", "invalid slavePicTextureId:" + slavePicTextureId);
            return;
        }
        GLES20.glUseProgram((int)this.mSlaveProgramHandle);
        GLES20.glActiveTexture((int)33984);
        GlUtil.checkGlError("glActiveTexture");
        GLES20.glBindTexture((int)36197, (int)slavePicTextureId);
        GlUtil.checkGlError("glBindTexture");
        GLES20.glUniform1i((int)this.muSlavePicTextureLoc, (int)0);
        GLES20.glUniformMatrix4fv((int)this.muSlavePicMVPMatrixLoc, (int)1, (boolean)false, (float[])mvpMatrix, (int)0);
        GlUtil.checkGlError("glUniformMatrix4fv");
        if (slavePicTexMatrix == null) {
            GLES20.glUniformMatrix4fv((int)this.muSlavePicTexMatrixLoc, (int)1, (boolean)false, (float[])texMatrix, (int)0);
        } else {
            GLES20.glUniformMatrix4fv((int)this.muSlavePicTexMatrixLoc, (int)1, (boolean)false, (float[])slavePicTexMatrix, (int)0);
        }
        GlUtil.checkGlError("glUniformMatrix4fv");
        GLES20.glEnableVertexAttribArray((int)this.maSlavePicPositionLoc);
        GlUtil.checkGlError("glEnableVertexAttribArray");
        if (slavePicVertexBuffer != null) {
            slavePicVertexBuffer.rewind();
        }
        GLES20.glVertexAttribPointer((int)this.maSlavePicPositionLoc, (int)coordsPerVertex, (int)5126, (boolean)false, (int)vertexStride, (Buffer)(slavePicVertexBuffer == null ? this.mSlaveVertexBuffer : slavePicVertexBuffer));
        GlUtil.checkGlError("glVertexAttribPointer");
        GLES20.glEnableVertexAttribArray((int)this.maSlavePicTextureCoordLoc);
        GlUtil.checkGlError("glEnableVertexAttribArray");
        GLES20.glVertexAttribPointer((int)this.maSlavePicTextureCoordLoc, (int)2, (int)5126, (boolean)false, (int)texStride, (Buffer)slavePicTextureCoords);
        GlUtil.checkGlError("glVertexAttribPointer");
        GLES20.glDrawArrays((int)5, (int)firstVertex, (int)vertexCount);
        GlUtil.checkGlError("glDrawArrays");
        GLES20.glDisableVertexAttribArray((int)this.maSlavePicPositionLoc);
        GLES20.glDisableVertexAttribArray((int)this.maSlavePicTextureCoordLoc);
        GLES20.glBindTexture((int)36197, (int)0);
        GLES20.glUseProgram((int)0);
    }

    private String transform2String(float[] transform) {
        StringBuilder builder = new StringBuilder();
        for (float f : transform) {
            builder.append(String.valueOf(f));
            builder.append("_");
        }
        return builder.toString();
    }

    private String transform2String(FloatBuffer buffer) {
        if (buffer == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder("vertex buffer::");
        for (int i = 0; i < buffer.limit(); ++i) {
            builder.append(buffer.get(i) + " ");
        }
        buffer.rewind();
        return builder.toString();
    }

    private void drawWaterMark(int waterMarkTextureId, int texStride, FloatBuffer waterMarkTextureCoords) {
        if (waterMarkTextureId > 0) {
            GLES20.glUniform1i((int)this.muExtraTextureEnableLoc, (int)1);
            GLES20.glActiveTexture((int)33985);
            GLES20.glBindTexture((int)3553, (int)waterMarkTextureId);
            GLES20.glUniform1i((int)this.muExtraTextureLoc, (int)1);
            GLES20.glEnableVertexAttribArray((int)this.maExtraTextureCoordLoc);
            GLES20.glVertexAttribPointer((int)this.maExtraTextureCoordLoc, (int)2, (int)5126, (boolean)false, (int)texStride, (Buffer)waterMarkTextureCoords);
            GlUtil.checkGlError("glVertexAttribPointer");
        } else {
            GlUtil.checkGlError("glDrawArrays");
            GLES20.glUniform1i((int)this.muExtraTextureEnableLoc, (int)0);
            GLES20.glUniform1i((int)this.muExtraTextureLoc, (int)1);
            GlUtil.checkGlError("glDrawArrays");
        }
    }

    private void drawSticker(int stickerTextureId, int texStride, FloatBuffer stickerTextureCoords) {
        if (stickerTextureId > 0) {
            GLES20.glUniform1i((int)this.muExtraTexture2EnableLoc, (int)1);
            GLES20.glActiveTexture((int)33986);
            GLES20.glBindTexture((int)3553, (int)stickerTextureId);
            GLES20.glUniform1i((int)this.muExtraTexture2Loc, (int)2);
            GLES20.glEnableVertexAttribArray((int)this.maExtraTextureCoord2Loc);
            GLES20.glVertexAttribPointer((int)this.maExtraTextureCoord2Loc, (int)2, (int)5126, (boolean)false, (int)texStride, (Buffer)stickerTextureCoords);
            GlUtil.checkGlError("glVertexAttribPointer");
        } else {
            GLES20.glUniform1i((int)this.muExtraTexture2EnableLoc, (int)0);
            GLES20.glUniform1i((int)this.muExtraTexture2Loc, (int)2);
            GlUtil.checkGlError("glDrawArrays");
        }
    }

    public static enum ProgramType {
        TEXTURE_2D,
        TEXTURE_2D_WITH_EXTRA_TXT,
        TEXTURE_2D_WITH_EXTRA_TXT_2,
        TEXTURE_EXT,
        TEXTURE_EXT_BW,
        TEXTURE_EXT_FILT;

    }
}

