/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.gles;

import android.annotation.TargetApi;
import android.graphics.RectF;
import android.opengl.GLES20;
import android.opengl.Matrix;
import com.yy.mediaframework.model.YYMediaSample;
import com.yy.mediaframework.utils.YMFLog;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;

public class GlUtil {
    public static final String TAG = "GlUtil";
    public static final float[] IDENTITY_MATRIX = new float[16];
    private static final int SIZEOF_FLOAT = 4;

    private GlUtil() {
    }

    public static int createProgram(String vertexSource, String fragmentSource) {
        int vertexShader = GlUtil.loadShader(35633, vertexSource);
        if (vertexShader == 0) {
            return 0;
        }
        int pixelShader = GlUtil.loadShader(35632, fragmentSource);
        if (pixelShader == 0) {
            return 0;
        }
        int program = GLES20.glCreateProgram();
        GlUtil.checkGlError("glCreateProgram");
        if (program == 0) {
            YMFLog.error(null, "[Util    ]", "Could not create program");
        }
        GLES20.glAttachShader((int)program, (int)vertexShader);
        GlUtil.checkGlError("glAttachShader");
        GLES20.glAttachShader((int)program, (int)pixelShader);
        GlUtil.checkGlError("glAttachShader");
        GLES20.glLinkProgram((int)program);
        int[] linkStatus = new int[1];
        GLES20.glGetProgramiv((int)program, (int)35714, (int[])linkStatus, (int)0);
        if (linkStatus[0] != 1) {
            YMFLog.error(null, "[Util    ]", "Could not link program:" + GLES20.glGetProgramInfoLog((int)program));
            GLES20.glDeleteProgram((int)program);
            program = 0;
        }
        GLES20.glDeleteShader((int)vertexShader);
        GLES20.glDeleteShader((int)pixelShader);
        return program;
    }

    public static int loadShader(int shaderType, String source) {
        int shader = GLES20.glCreateShader((int)shaderType);
        GlUtil.checkGlError("glCreateShader type:" + shaderType);
        GLES20.glShaderSource((int)shader, (String)source);
        GLES20.glCompileShader((int)shader);
        int[] compiled = new int[1];
        GLES20.glGetShaderiv((int)shader, (int)35713, (int[])compiled, (int)0);
        if (compiled[0] == 0) {
            YMFLog.error(null, "[Util    ]", "Could not compile shader " + shaderType + ":" + GLES20.glGetShaderInfoLog((int)shader));
            GLES20.glDeleteShader((int)shader);
            shader = 0;
        }
        return shader;
    }

    public static void checkGlError(String op) {
        int error = GLES20.glGetError();
        if (error != 0) {
            String msg = op + ": glError 0x" + Integer.toHexString(error);
            YMFLog.error(null, "[Util    ]", msg);
        }
    }

    public static void checkLocation(int location, String label) {
        if (location < 0) {
            throw new RuntimeException("Unable to locate '" + label + "' in program");
        }
    }

    public static int createImageTexture(ByteBuffer data, int width, int height, int format) {
        int[] textureHandles = new int[1];
        GLES20.glGenTextures((int)1, (int[])textureHandles, (int)0);
        int textureHandle = textureHandles[0];
        GlUtil.checkGlError("glGenTextures");
        GLES20.glBindTexture((int)3553, (int)textureHandle);
        GLES20.glTexParameteri((int)3553, (int)10241, (int)9729);
        GLES20.glTexParameteri((int)3553, (int)10240, (int)9729);
        GlUtil.checkGlError("loadImageTexture");
        GLES20.glTexImage2D((int)3553, (int)0, (int)format, (int)width, (int)height, (int)0, (int)format, (int)5121, (Buffer)data);
        GlUtil.checkGlError("loadImageTexture");
        return textureHandle;
    }

    public static int createOESTexture() {
        int[] textures = new int[1];
        GLES20.glGenTextures((int)1, (int[])textures, (int)0);
        GLES20.glBindTexture((int)36197, (int)textures[0]);
        GLES20.glTexParameterf((int)36197, (int)10241, (float)9729.0f);
        GLES20.glTexParameterf((int)36197, (int)10240, (float)9729.0f);
        GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
        return textures[0];
    }

    public static int createTexture(int width, int height) {
        int[] textures = new int[1];
        GLES20.glGenTextures((int)1, (int[])textures, (int)0);
        GLES20.glBindTexture((int)3553, (int)textures[0]);
        GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
        GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
        GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
        GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5121, null);
        return textures[0];
    }

    public static FloatBuffer createFloatBuffer(float[] coords) {
        ByteBuffer bb = ByteBuffer.allocateDirect(coords.length * 4);
        bb.order(ByteOrder.nativeOrder());
        FloatBuffer fb = bb.asFloatBuffer();
        fb.put(coords);
        fb.position(0);
        return fb;
    }

    @TargetApi(value=18)
    public static void logVersionInfo() {
        YMFLog.info(null, "[Util    ]", "vendor  :" + GLES20.glGetString((int)7936));
        YMFLog.info(null, "[Util    ]", "renderer:" + GLES20.glGetString((int)7937));
        YMFLog.info(null, "[Util    ]", "version :" + GLES20.glGetString((int)7938));
    }

    public String getGPUInfo() {
        String version = GLES20.glGetString((int)7938);
        String vendor = GLES20.glGetString((int)7936);
        String render = GLES20.glGetString((int)7937);
        IntBuffer max = IntBuffer.allocate(1);
        GLES20.glGetIntegerv((int)34930, (IntBuffer)max);
        int maxTextureUnit = max.get(0);
        GLES20.glGetIntegerv((int)3379, (IntBuffer)max);
        int maxTextureSize = max.get(0);
        String sparator = ": ";
        String info = version + sparator + vendor + sparator + render + sparator + maxTextureUnit + sparator + maxTextureSize;
        YMFLog.info(null, "[Util    ]", info);
        return info;
    }

    public static String getGpuVendor() {
        return GLES20.glGetString((int)7937);
    }

    public static FloatBuffer setFlipX(FloatBuffer texCoordArray) {
        float[] textureCords = new float[]{texCoordArray.get(2), texCoordArray.get(3), texCoordArray.get(0), texCoordArray.get(1), texCoordArray.get(6), texCoordArray.get(7), texCoordArray.get(4), texCoordArray.get(5)};
        return GlUtil.createFloatBuffer(textureCords);
    }

    public static FloatBuffer setFlipY(FloatBuffer texCoordArray) {
        float[] textureCords = new float[]{texCoordArray.get(4), texCoordArray.get(5), texCoordArray.get(6), texCoordArray.get(7), texCoordArray.get(0), texCoordArray.get(1), texCoordArray.get(2), texCoordArray.get(3)};
        return GlUtil.createFloatBuffer(textureCords);
    }

    public static FloatBuffer adjustTexture(FloatBuffer texCoordArray, float incomingWidth, float incomingHeight, float outputWidth, float outputHeight) {
        float ratioMax = Math.max(outputWidth / incomingWidth, outputHeight / incomingHeight);
        int imageWidthNew = Math.round(incomingWidth * ratioMax);
        int imageHeightNew = Math.round(incomingHeight * ratioMax);
        float ratioWidth = (float)imageWidthNew / outputWidth;
        float ratioHeight = (float)imageHeightNew / outputHeight;
        float distHorizontal = (1.0f - 1.0f / ratioWidth) / 2.0f;
        float distVertical = (1.0f - 1.0f / ratioHeight) / 2.0f;
        float[] textureCords = new float[]{GlUtil.addDistance(texCoordArray.get(0), distHorizontal), GlUtil.addDistance(texCoordArray.get(1), distVertical), GlUtil.addDistance(texCoordArray.get(2), distHorizontal), GlUtil.addDistance(texCoordArray.get(3), distVertical), GlUtil.addDistance(texCoordArray.get(4), distHorizontal), GlUtil.addDistance(texCoordArray.get(5), distVertical), GlUtil.addDistance(texCoordArray.get(6), distHorizontal), GlUtil.addDistance(texCoordArray.get(7), distVertical)};
        YMFLog.info(null, "[Util    ]", "adjustTexture, textureCords:" + Arrays.toString(textureCords));
        return GlUtil.createFloatBuffer(textureCords);
    }

    public static FloatBuffer adjustTextureArea(RectF rectF, int screenWidth, int screenHeight, boolean needFlipY) {
        float top = rectF.top / (float)screenHeight;
        float bottom = rectF.bottom / (float)screenHeight;
        float left = rectF.left / (float)screenWidth;
        float right = rectF.right / (float)screenWidth;
        YMFLog.info(null, "[Util    ]", "screenWidth:" + screenWidth + ", screenHeight:" + screenHeight);
        float[] textureCords = needFlipY ? new float[]{left, top, right, top, left, bottom, right, bottom} : new float[]{left, bottom, right, bottom, left, top, right, top};
        YMFLog.info(null, "[Util    ]", "adjustTextureArea textureCords:" + Arrays.toString(textureCords));
        return GlUtil.createFloatBuffer(textureCords);
    }

    private static float addDistance(float coordinate, float distance) {
        return coordinate == 0.0f ? distance : 1.0f - distance;
    }

    public static FloatBuffer adjustSlaveTexture(int dstWidth, int dstHeight, int srcWidth, int srcHeight) {
        if (0 == srcWidth || 0 == srcHeight || 0 == dstWidth || 0 == dstHeight) {
            YMFLog.warn(null, "[Util    ]", "invalid size, return default texture coordinations");
            return null;
        }
        float srcAr = 1.0f * (float)srcWidth / (float)srcHeight;
        float dstAr = 1.0f * (float)dstWidth / (float)dstHeight;
        float xoffset = 0.0f;
        float yoffset = 0.0f;
        if (srcWidth == 720 && srcHeight == 1280) {
            if (srcAr < dstAr) {
                yoffset = 0.5f * (1.0f - srcAr / dstAr);
            }
        } else if (srcWidth == 1280 && srcHeight == 720) {
            if (srcAr > dstAr) {
                xoffset = 0.5f * (1.0f - dstAr / srcAr);
            }
        } else if (srcWidth == 480 && srcHeight == 640) {
            if (srcAr > dstAr) {
                xoffset = 0.5f * (1.0f - srcAr);
            } else {
                yoffset = 0.0f;
            }
        } else if (srcWidth == 640 && srcHeight == 480) {
            if (srcAr < dstAr) {
                yoffset = 0.5f * (1.0f - 1.0f / srcAr);
            } else {
                xoffset = 0.0f;
            }
        }
        float left = xoffset;
        float right = 1.0f - xoffset;
        float bottom = yoffset;
        float top = 1.0f - yoffset;
        float[] textureCords = new float[]{left, bottom, right, bottom, left, top, right, top};
        return GlUtil.createFloatBuffer(textureCords);
    }

    public static FloatBuffer adjustDualCameraSlaveTexture(YYMediaSample sample, int srcWidth, int srcHeight) {
        int dstWidth = 0;
        int dstHeight = 0;
        FloatBuffer slaveTextureCoord = null;
        if (srcWidth < srcHeight) {
            dstWidth = 9;
            dstHeight = 16;
        } else if (srcWidth > srcHeight) {
            dstWidth = 16;
            dstHeight = 9;
        }
        if (srcWidth * dstHeight != srcHeight * dstWidth) {
            slaveTextureCoord = GlUtil.adjustSlaveTexture(dstWidth, dstHeight, srcWidth, srcHeight);
            if (sample.mOrientation == 1 && sample.mOrginalCameraFacing != sample.mCameraFacing) {
                slaveTextureCoord = GlUtil.setFlipY(slaveTextureCoord);
            }
        }
        return slaveTextureCoord;
    }

    static {
        Matrix.setIdentityM((float[])IDENTITY_MATRIX, (int)0);
    }
}

