/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.gles;

import android.graphics.RectF;
import android.opengl.Matrix;
import android.util.Log;
import com.yy.mediaframework.gles.Drawable2d;
import com.yy.mediaframework.gles.GlUtil;
import com.yy.mediaframework.gles.Texture2dProgram;
import com.yy.mediaframework.utils.YMFLog;
import java.nio.FloatBuffer;

public class FullFrameRect {
    private static final String TAG = "FullFrameRect";
    private Drawable2d mRectDrawable;
    private Texture2dProgram mProgram;
    public final float[] IDENTITY_MATRIX = new float[16];
    public final FloatBuffer DEFAULT_TEX_COORD_BUFFER = Drawable2d.FULL_RECTANGLE_TEX_BUF;
    private FloatBuffer[] mCurTexCoordArray = new FloatBuffer[4];
    private FloatBuffer[] mOrigTexCoordArray = new FloatBuffer[4];
    private FloatBuffer mMainTextureCoord;
    private FloatBuffer mSlaveTextureCoord;
    public static final int MAIN_TEXTURE = 0;
    public static final int EXTRA_TEXTURE_WATERMARK = 1;
    public static final int EXTRA_TEXTURE_STICKER = 2;
    public static final int EXTRA_TEXTURE_SLAVE_PICTURE = 3;
    private boolean[] mFlipX = new boolean[]{false, false, false, false};
    private boolean[] mFlipY = new boolean[]{false, false, false, false};
    private boolean need2print = true;

    public FullFrameRect(Texture2dProgram program) {
        this(program, Drawable2d.Prefab.FULL_RECTANGLE);
    }

    public FullFrameRect(Texture2dProgram program, Drawable2d.Prefab d2dType) {
        this.mProgram = program;
        Matrix.setIdentityM((float[])this.IDENTITY_MATRIX, (int)0);
        this.mRectDrawable = new Drawable2d(d2dType);
        this.mCurTexCoordArray[0] = this.mOrigTexCoordArray[0] = this.mRectDrawable.getTexCoordArray();
        this.mMainTextureCoord = this.mOrigTexCoordArray[0];
        this.mCurTexCoordArray[1] = this.mOrigTexCoordArray[1] = this.DEFAULT_TEX_COORD_BUFFER;
        this.mCurTexCoordArray[2] = this.mOrigTexCoordArray[2] = this.DEFAULT_TEX_COORD_BUFFER;
        this.mCurTexCoordArray[3] = this.mOrigTexCoordArray[3] = this.DEFAULT_TEX_COORD_BUFFER;
        this.mSlaveTextureCoord = this.mOrigTexCoordArray[3];
    }

    public FullFrameRect(Texture2dProgram program, Drawable2d.Prefab d2dType, FloatBuffer waterMarkCoords, FloatBuffer stickerCoords) {
        this.mProgram = program;
        Matrix.setIdentityM((float[])this.IDENTITY_MATRIX, (int)0);
        this.mRectDrawable = new Drawable2d(d2dType);
        this.mCurTexCoordArray[0] = this.mOrigTexCoordArray[0] = this.mRectDrawable.getTexCoordArray();
        this.mMainTextureCoord = this.mOrigTexCoordArray[0];
        this.mCurTexCoordArray[1] = this.mOrigTexCoordArray[1] = waterMarkCoords;
        this.mCurTexCoordArray[2] = this.mOrigTexCoordArray[2] = stickerCoords;
        this.mCurTexCoordArray[3] = this.mOrigTexCoordArray[3] = this.DEFAULT_TEX_COORD_BUFFER;
        this.mSlaveTextureCoord = this.mOrigTexCoordArray[3];
    }

    public void changeDrawable2d(Drawable2d.Prefab d2dType) {
        this.mRectDrawable = new Drawable2d(d2dType);
    }

    public void release(boolean doEglCleanup) {
        if (this.mProgram != null) {
            if (doEglCleanup) {
                this.mProgram.release();
            }
            this.mProgram = null;
        }
    }

    public void release() {
        this.release(true);
    }

    public Texture2dProgram getProgram() {
        return this.mProgram;
    }

    public void changeProgram(Texture2dProgram program) {
        this.mProgram.release();
        this.mProgram = program;
    }

    public int createTextureObject() {
        return this.mProgram.createTextureObject();
    }

    public void scaleMVPMatrix(float x, float y) {
        Matrix.setIdentityM((float[])this.IDENTITY_MATRIX, (int)0);
        Matrix.scaleM((float[])this.IDENTITY_MATRIX, (int)0, (float)x, (float)y, (float)1.0f);
    }

    public void drawFrame(int textureId, float[] mainTextureMatrix, int waterMarkTextureId, int stickerTextureId, int slavePicTextureId, float[] slaveTextureMatrix, FloatBuffer slavePicVertexBuffer) {
        FloatBuffer slaveTextureCoord = null;
        if (slavePicTextureId >= 0) {
            slaveTextureCoord = GlUtil.setFlipY(this.mSlaveTextureCoord);
        }
        this.drawFrame(textureId, this.mRectDrawable.getVertexArray(), this.mMainTextureCoord, mainTextureMatrix, waterMarkTextureId, stickerTextureId, slavePicTextureId, slaveTextureMatrix, slavePicVertexBuffer, slaveTextureCoord);
    }

    public void drawFrame(int textureId, float[] mainTextureMatrix, int waterMarkTextureId, int stickerTextureId, int slavePicTextureId, float[] slaveTextureMatrix, FloatBuffer slavePicVertexBuffer, FloatBuffer slaveTextureCoord) {
        this.drawFrame(textureId, this.mRectDrawable.getVertexArray(), this.mMainTextureCoord, mainTextureMatrix, waterMarkTextureId, stickerTextureId, slavePicTextureId, slaveTextureMatrix, slavePicVertexBuffer, slaveTextureCoord == null ? GlUtil.setFlipY(this.mSlaveTextureCoord) : GlUtil.setFlipY(slaveTextureCoord));
    }

    public void drawFrame(int mainTextureId, FloatBuffer mainVertexBuffer, FloatBuffer mainTexCoordBuffer, float[] mainTextureMatrix, int waterMarkTextureId, int stickerTextureId, int slavePicTextureId, float[] slaveTextureMatrix, FloatBuffer slavePicVertexBuffer, FloatBuffer slaveTextureCoord) {
        if (slavePicTextureId >= 0) {
            this.mProgram.draw(this.IDENTITY_MATRIX, mainVertexBuffer, 0, this.mRectDrawable.getVertexCount(), this.mRectDrawable.getCoordsPerVertex(), this.mRectDrawable.getVertexStride(), mainTextureMatrix, mainTexCoordBuffer, mainTextureId, this.mRectDrawable.getTexCoordStride(), this.mCurTexCoordArray[1], waterMarkTextureId, this.mCurTexCoordArray[2], stickerTextureId);
            this.mProgram.drawSlavePicture(slavePicTextureId, this.IDENTITY_MATRIX, slaveTextureMatrix, mainTextureMatrix, this.mRectDrawable.getCoordsPerVertex(), this.mRectDrawable.getVertexStride(), this.mRectDrawable.getTexCoordStride(), 0, this.mRectDrawable.getVertexCount(), slavePicVertexBuffer, slaveTextureCoord);
        } else {
            this.mProgram.draw(this.IDENTITY_MATRIX, mainVertexBuffer, 0, this.mRectDrawable.getVertexCount(), this.mRectDrawable.getCoordsPerVertex(), this.mRectDrawable.getVertexStride(), mainTextureMatrix, mainTexCoordBuffer, mainTextureId, this.mRectDrawable.getTexCoordStride(), this.mCurTexCoordArray[1], waterMarkTextureId, this.mCurTexCoordArray[2], stickerTextureId);
        }
    }

    private String convertFloatBuffer2String(FloatBuffer buffer) {
        if (buffer == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder("Buffer::");
        for (int i = 0; i < buffer.capacity(); ++i) {
            float temp = buffer.get(i);
            builder.append(temp);
            builder.append("  ");
        }
        buffer.rewind();
        return builder.toString();
    }

    public void adjustTexture(float incomingWidth, float incomingHeight, float outputWidth, float outputHeight) {
        this.need2print = true;
        this.mCurTexCoordArray[0] = this.mOrigTexCoordArray[0];
        this.mCurTexCoordArray[1] = this.mOrigTexCoordArray[1];
        this.mCurTexCoordArray[2] = this.mOrigTexCoordArray[2];
        this.mCurTexCoordArray[3] = this.mOrigTexCoordArray[3];
        for (int i = 0; i < this.mCurTexCoordArray.length; ++i) {
            if (this.mFlipX[i]) {
                this.mCurTexCoordArray[i] = GlUtil.setFlipX(this.mCurTexCoordArray[i]);
            }
            if (!this.mFlipY[i]) continue;
            this.mCurTexCoordArray[i] = GlUtil.setFlipY(this.mCurTexCoordArray[i]);
        }
        this.mMainTextureCoord = this.mCurTexCoordArray[0] = GlUtil.adjustTexture(this.mCurTexCoordArray[0], incomingWidth, incomingHeight, outputWidth, outputHeight);
    }

    public void adjustTextureArea(RectF cropArea, int screenWidth, int screenHeight, boolean needFlipY) {
        this.need2print = true;
        this.mCurTexCoordArray[0] = this.mOrigTexCoordArray[0];
        this.mCurTexCoordArray[1] = this.mOrigTexCoordArray[1];
        this.mCurTexCoordArray[2] = this.mOrigTexCoordArray[2];
        this.mCurTexCoordArray[3] = this.mOrigTexCoordArray[3];
        for (int i = 0; i < this.mCurTexCoordArray.length; ++i) {
            if (this.mFlipX[i]) {
                this.mCurTexCoordArray[i] = GlUtil.setFlipX(this.mCurTexCoordArray[i]);
            }
            if (!this.mFlipY[i]) continue;
            this.mCurTexCoordArray[i] = GlUtil.setFlipY(this.mCurTexCoordArray[i]);
        }
        this.mMainTextureCoord = this.mCurTexCoordArray[0] = GlUtil.adjustTextureArea(cropArea, screenWidth, screenHeight, needFlipY);
    }

    public void adjustAllTexutre(float incomingWidth, float incomingHeight, float outputWidth, float outputHeight) {
        this.mMainTextureCoord = this.mCurTexCoordArray[0] = this.mOrigTexCoordArray[0];
        this.mCurTexCoordArray[1] = this.mOrigTexCoordArray[1];
        this.mCurTexCoordArray[2] = this.mOrigTexCoordArray[2];
        this.mCurTexCoordArray[3] = this.mOrigTexCoordArray[3];
        for (int i = 0; i < this.mCurTexCoordArray.length; ++i) {
            if (this.mFlipX[i]) {
                this.mCurTexCoordArray[i] = GlUtil.setFlipX(this.mCurTexCoordArray[i]);
            }
            if (this.mFlipY[i]) {
                this.mCurTexCoordArray[i] = GlUtil.setFlipY(this.mCurTexCoordArray[i]);
            }
            this.mCurTexCoordArray[i] = GlUtil.adjustTexture(this.mCurTexCoordArray[i], incomingWidth, incomingHeight, outputWidth, outputHeight);
        }
    }

    public void flipSlaveScreenX() {
        this.mSlaveTextureCoord = GlUtil.setFlipX(this.mCurTexCoordArray[3]);
    }

    public void resetFlip() {
        this.mMainTextureCoord = this.mCurTexCoordArray[0];
        this.mSlaveTextureCoord = this.mCurTexCoordArray[3];
    }

    public void flipYScreen() {
        this.mMainTextureCoord = GlUtil.setFlipY(this.mCurTexCoordArray[0]);
        this.mSlaveTextureCoord = GlUtil.setFlipY(this.mCurTexCoordArray[3]);
    }

    public void flipYScreenXMaster() {
        this.mMainTextureCoord = GlUtil.setFlipX(GlUtil.setFlipY(this.mCurTexCoordArray[0]));
        this.mSlaveTextureCoord = GlUtil.setFlipY(this.mCurTexCoordArray[3]);
    }

    public void flipYScreenXSlave() {
        this.mMainTextureCoord = GlUtil.setFlipY(this.mCurTexCoordArray[0]);
        this.mSlaveTextureCoord = GlUtil.setFlipX(GlUtil.setFlipY(this.mCurTexCoordArray[3]));
    }

    public void flipXYScreen() {
        this.mMainTextureCoord = GlUtil.setFlipX(GlUtil.setFlipY(this.mCurTexCoordArray[0]));
        this.mSlaveTextureCoord = GlUtil.setFlipX(GlUtil.setFlipY(this.mCurTexCoordArray[3]));
    }

    public void flipXMasterPicture() {
        this.mMainTextureCoord = GlUtil.setFlipX(this.mCurTexCoordArray[0]);
        this.mSlaveTextureCoord = this.mCurTexCoordArray[3];
    }

    public void flipXSlavePicture() {
        this.mMainTextureCoord = this.mCurTexCoordArray[0];
        this.mSlaveTextureCoord = GlUtil.setFlipX(this.mCurTexCoordArray[3]);
    }

    public void flipXScreen() {
        this.mMainTextureCoord = GlUtil.setFlipX(this.mCurTexCoordArray[0]);
        this.mSlaveTextureCoord = GlUtil.setFlipX(this.mCurTexCoordArray[3]);
    }

    public void setTextureFlipX(int type) {
        Log.e((String)TAG, (String)("setTextureFlipX:" + type));
        this.need2print = true;
        switch (type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.mFlipX[type] = !this.mFlipX[type];
                this.mCurTexCoordArray[type] = GlUtil.setFlipX(this.mOrigTexCoordArray[type]);
                break;
            }
            default: {
                YMFLog.info(this, "[Util    ]", "setTextureFlipX::no support type");
            }
        }
    }

    public void setTextureFlipY(int type) {
        this.need2print = true;
        switch (type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.mFlipY[type] = !this.mFlipY[type];
                this.mCurTexCoordArray[type] = GlUtil.setFlipY(this.mOrigTexCoordArray[type]);
                break;
            }
            default: {
                YMFLog.info(this, "[Util    ]", "setTextureFlipY::no support type");
            }
        }
    }
}

