/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.gles;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.opengl.EGL14;
import android.opengl.EGLSurface;
import android.opengl.GLES20;
import com.yy.mediaframework.gles.EglCore;
import com.yy.mediaframework.gles.EglSurfaceBaseKhronos;
import com.yy.mediaframework.gles.GlUtil;
import com.yy.mediaframework.gles.IEglSurfaceBase;
import com.yy.mediaframework.utils.YMFLog;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

@TargetApi(value=17)
public class EglSurfaceBase
implements IEglSurfaceBase {
    protected static final String TAG = "GlUtil";
    protected EglCore mEglCore;
    private EGLSurface mEGLSurface = EGL14.EGL_NO_SURFACE;
    private int mWidth = -1;
    private int mHeight = -1;

    protected EglSurfaceBase(EglCore eglCore) {
        this.mEglCore = eglCore;
    }

    @Override
    @TargetApi(value=17)
    public void createWindowSurface(Object surface) {
        if (this.mEGLSurface != EGL14.EGL_NO_SURFACE) {
            throw new IllegalStateException("surface already created");
        }
        this.mEGLSurface = this.mEglCore.createWindowSurface(surface);
        YMFLog.info(this, "[Procedur]", "createWindowSurface:" + this.mEGLSurface);
    }

    @Override
    @TargetApi(value=17)
    public void createOffscreenSurface(int width, int height) {
        if (this.mEGLSurface != EGL14.EGL_NO_SURFACE) {
            throw new IllegalStateException("surface already created");
        }
        this.mEGLSurface = this.mEglCore.createOffscreenSurface(width, height);
        YMFLog.info(this, "[Procedur]", "createOffscreenSurface:" + this.mEGLSurface);
        this.mWidth = width;
        this.mHeight = height;
    }

    @Override
    public int getWidth() {
        if (this.mWidth < 0) {
            return this.mEglCore.querySurface(this.mEGLSurface, 12375);
        }
        return this.mWidth;
    }

    @Override
    public int getHeight() {
        if (this.mHeight < 0) {
            return this.mEglCore.querySurface(this.mEGLSurface, 12374);
        }
        return this.mHeight;
    }

    @Override
    @TargetApi(value=17)
    public void releaseEglSurface() {
        this.mEglCore.releaseSurface(this.mEGLSurface);
        this.mEGLSurface = EGL14.EGL_NO_SURFACE;
        this.mHeight = -1;
        this.mWidth = -1;
    }

    @Override
    public void makeCurrent() {
        this.mEglCore._makeCurrent(this.mEGLSurface);
    }

    @Override
    public boolean isCurrent() {
        return this.mEglCore._isCurrent(this.mEGLSurface);
    }

    @Override
    public void makeCurrentReadFrom(Object readSurface) {
        if (!(readSurface instanceof EglSurfaceBaseKhronos)) {
            throw new RuntimeException("makeCurrentReadFrom readSurface is not getInstance of  EglSurfaceBase");
        }
        this.mEglCore._makeCurrent(this.mEGLSurface, ((EglSurfaceBase)readSurface).mEGLSurface);
    }

    public void makeCurrentReadFrom(EglSurfaceBase readSurface) {
        this.mEglCore._makeCurrent(this.mEGLSurface, readSurface.mEGLSurface);
    }

    @Override
    public boolean swapBuffers() {
        boolean result = this.mEglCore.swapBuffers(this.mEGLSurface);
        if (!result) {
            YMFLog.error((Object)this, "[Procedur]", "WARNING: swapBuffers() failed");
        }
        return result;
    }

    @Override
    public void setPresentationTime(long nsecs) {
        this.mEglCore._setPresentationTime(this.mEGLSurface, nsecs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveFrame(File file) throws IOException {
        if (!this.mEglCore.isCurrent(this.mEGLSurface)) {
            throw new RuntimeException("Expected EGL context/surface is not current");
        }
        String filename = file.toString();
        int width = this.getWidth();
        int height = this.getHeight();
        ByteBuffer buf = ByteBuffer.allocateDirect(width * height * 4);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        GLES20.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6408, (int)5121, (Buffer)buf);
        GlUtil.checkGlError("glReadPixels");
        buf.rewind();
        FilterOutputStream bos = null;
        try {
            bos = new BufferedOutputStream(new FileOutputStream(filename));
            Bitmap bmp = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bmp.copyPixelsFromBuffer((Buffer)buf);
            bmp.compress(Bitmap.CompressFormat.PNG, 90, (OutputStream)bos);
            bmp.recycle();
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    YMFLog.error((Object)this, "[Procedur]", "close BufferedOutputStream failed:" + e);
                }
                finally {
                    bos = null;
                }
            }
        }
        YMFLog.debug((Object)this, "[Procedur]", "Saved " + width + "x" + height + " frame as '" + filename + "'");
    }

    public EGLSurface getEGLSurface() {
        return this.mEGLSurface;
    }
}

