/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.gles;

import android.graphics.SurfaceTexture;
import android.view.Surface;
import android.view.SurfaceHolder;
import com.yy.mediaframework.gles.EglSurfaceBaseKhronos;
import com.yy.mediaframework.gles.IEglCore;
import com.yy.mediaframework.gles.IEglSurfaceBase;
import com.yy.mediaframework.gles.IWindowSurface;
import com.yy.mediaframework.gles.WindowSurfaceKhronos;
import com.yy.mediaframework.utils.YMFLog;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGL11;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;
import javax.microedition.khronos.opengles.GL;

public class EglCoreKhronos
implements IEglCore {
    private static final String TAG = "EglCore";
    private EGL10 mEgl = (EGL10)EGLContext.getEGL();
    private EGLContext mEGLContext;
    private EGLDisplay mEGLDisplay = this.mEgl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
    private EGLConfig mEGLConfig;

    public EglCoreKhronos() {
        if (this.mEGLDisplay == EGL10.EGL_NO_DISPLAY) {
            throw new RuntimeException("eglGetDisplay failed");
        }
        int[] version = new int[2];
        if (!this.mEgl.eglInitialize(this.mEGLDisplay, version)) {
            throw new RuntimeException("eglInitialize failed");
        }
        this.mEGLConfig = this.chooseConfig(this.mEgl, this.mEGLDisplay);
    }

    protected EglCoreKhronos(EGLContext sharedContext) {
        if (this.mEGLDisplay == EGL10.EGL_NO_DISPLAY) {
            throw new RuntimeException("eglGetDisplay failed");
        }
        int[] version = new int[2];
        if (!this.mEgl.eglInitialize(this.mEGLDisplay, version)) {
            throw new RuntimeException("eglInitialize failed");
        }
        this.mEGLConfig = this.chooseConfig(this.mEgl, this.mEGLDisplay, sharedContext);
    }

    public EGLConfig chooseConfig(EGL10 egl, EGLDisplay display, EGLContext sharedContext) {
        int[] num_config;
        int[] mConfigSpec = this.filterConfigSpec(new int[]{12324, 8, 12323, 8, 12322, 8, 12321, 8, 12344});
        if (!egl.eglChooseConfig(display, mConfigSpec, null, 0, num_config = new int[1])) {
            throw new IllegalArgumentException("eglChooseConfig failed");
        }
        int numConfigs = num_config[0];
        if (numConfigs <= 0) {
            throw new IllegalArgumentException("No configs match configSpec");
        }
        EGLConfig[] configs = new EGLConfig[numConfigs];
        if (!egl.eglChooseConfig(display, mConfigSpec, configs, numConfigs, num_config)) {
            throw new IllegalArgumentException("eglChooseConfig#2 failed");
        }
        EGLConfig config = this.doChooseConfig(egl, display, configs);
        if (config == null) {
            throw new IllegalArgumentException("No config chosen");
        }
        int EGL_CONTEXT_CLIENT_VERSION = 12440;
        int mEGLContextClientVersion = 2;
        int[] attrib_list = new int[]{EGL_CONTEXT_CLIENT_VERSION, mEGLContextClientVersion, 12344};
        this.mEGLContext = egl.eglCreateContext(display, config, sharedContext, (int[])(mEGLContextClientVersion != 0 ? attrib_list : null));
        return config;
    }

    private int[] filterConfigSpec(int[] configSpec) {
        int len = configSpec.length;
        int[] newConfigSpec = new int[len + 2];
        System.arraycopy(configSpec, 0, newConfigSpec, 0, len - 1);
        newConfigSpec[len - 1] = 12352;
        newConfigSpec[len] = 4;
        newConfigSpec[len + 1] = 12344;
        return newConfigSpec;
    }

    public EGLConfig chooseConfig(EGL10 egl, EGLDisplay display) {
        int[] num_config;
        int[] mConfigSpec = this.filterConfigSpec(new int[]{12324, 8, 12323, 8, 12322, 8, 12321, 8, 12344});
        if (!egl.eglChooseConfig(display, mConfigSpec, null, 0, num_config = new int[1])) {
            throw new IllegalArgumentException("eglChooseConfig failed");
        }
        int numConfigs = num_config[0];
        if (numConfigs <= 0) {
            throw new IllegalArgumentException("No configs match configSpec");
        }
        EGLConfig[] configs = new EGLConfig[numConfigs];
        if (!egl.eglChooseConfig(display, mConfigSpec, configs, numConfigs, num_config)) {
            throw new IllegalArgumentException("eglChooseConfig#2 failed");
        }
        EGLConfig config = this.doChooseConfig(egl, display, configs);
        if (config == null) {
            throw new IllegalArgumentException("No config chosen");
        }
        int EGL_CONTEXT_CLIENT_VERSION = 12440;
        int mEGLContextClientVersion = 2;
        int[] attrib_list = new int[]{EGL_CONTEXT_CLIENT_VERSION, mEGLContextClientVersion, 12344};
        this.mEGLContext = egl.eglCreateContext(display, config, EGL10.EGL_NO_CONTEXT, (int[])(mEGLContextClientVersion != 0 ? attrib_list : null));
        return config;
    }

    public EGLConfig doChooseConfig(EGL10 egl, EGLDisplay display, EGLConfig[] configs) {
        for (EGLConfig config : configs) {
            int d = this.findConfigAttrib(egl, display, config, 12325, 0);
            int s = this.findConfigAttrib(egl, display, config, 12326, 0);
            int r = this.findConfigAttrib(egl, display, config, 12324, 0);
            int g = this.findConfigAttrib(egl, display, config, 12323, 0);
            int b = this.findConfigAttrib(egl, display, config, 12322, 0);
            int a = this.findConfigAttrib(egl, display, config, 12321, 0);
            if (r != 8 || g != 8 || b != 8 || a != 8) continue;
            return config;
        }
        return null;
    }

    private int findConfigAttrib(EGL10 egl, EGLDisplay display, EGLConfig config, int attribute, int defaultValue) {
        int[] value = new int[1];
        if (egl.eglGetConfigAttrib(display, config, attribute, value)) {
            return value[0];
        }
        return defaultValue;
    }

    public GL getGL() {
        return this.mEgl.eglGetCurrentContext().getGL();
    }

    public void releaseSurface(EGLSurface eglSurface) {
        this.mEgl.eglDestroySurface(this.mEgl.eglGetCurrentDisplay(), eglSurface);
    }

    public EGLSurface createWindowSurface(Object surface) {
        if (!(surface instanceof Surface || surface instanceof SurfaceTexture || surface instanceof SurfaceHolder)) {
            throw new RuntimeException("invalid surface: " + surface);
        }
        int[] surfaceAttribs = new int[]{12344};
        EGLSurface eglSurface = this.mEgl.eglCreateWindowSurface(this.mEGLDisplay, this.mEGLConfig, surface, null);
        this.checkEglError("eglCreateWindowSurface");
        if (eglSurface == null) {
            throw new RuntimeException("surface was null");
        }
        return eglSurface;
    }

    public EGLSurface createOffscreenSurface(int width, int height) {
        int[] surfaceAttribs = new int[]{12375, width, 12374, height, 12344};
        EGLSurface eglSurface = this.mEgl.eglCreatePbufferSurface(this.mEGLDisplay, this.mEGLConfig, surfaceAttribs);
        this.checkEglError("eglCreatePbufferSurface");
        if (eglSurface == null) {
            throw new RuntimeException("surface was null");
        }
        return eglSurface;
    }

    public void _makeCurrent(EGLSurface eglSurface) {
        if (this.mEGLDisplay == EGL11.EGL_NO_DISPLAY) {
            YMFLog.info(this, "[Util    ]", "NOTE: makeCurrent w/o display");
        }
        if (!this.mEgl.eglMakeCurrent(this.mEGLDisplay, eglSurface, eglSurface, this.mEGLContext)) {
            YMFLog.error((Object)this, "[Util    ]", " eglMakeCurrent:" + this.mEGLContext + " eglSurface:" + eglSurface + " mEGLDisplay:" + this.mEGLDisplay);
            throw new RuntimeException("eglMakeCurrent failed");
        }
    }

    public void _makeCurrent(EGLSurface drawSurface, EGLSurface readSurface) {
        EGLDisplay display = this.mEgl.eglGetCurrentDisplay();
        if (display == EGL11.EGL_NO_DISPLAY) {
            YMFLog.debug((Object)this, "[Util    ]", "NOTE: makeCurrent w/o display");
        }
        if (!this.mEgl.eglMakeCurrent(display, drawSurface, readSurface, this.mEgl.eglGetCurrentContext())) {
            throw new RuntimeException("eglMakeCurrent(draw,read) failed");
        }
    }

    protected boolean _swapBuffers(EGLSurface eglSurface) {
        return this.mEgl.eglSwapBuffers(this.mEgl.eglGetCurrentDisplay(), eglSurface);
    }

    protected void _setPresentationTime(EGLSurface eglSurface, long nsecs) {
    }

    protected boolean _isCurrent(EGLSurface eglSurface) {
        return this.mEGLContext.equals(this.mEgl.eglGetCurrentContext()) && eglSurface.equals(this.mEgl.eglGetCurrentSurface(12377));
    }

    protected int _querySurface(EGLSurface eglSurface, int what) {
        int[] value = new int[1];
        this.mEgl.eglQuerySurface(this.mEgl.eglGetCurrentDisplay(), eglSurface, what, value);
        return value[0];
    }

    public String queryString(int what) {
        return this.mEgl.eglQueryString(this.mEgl.eglGetCurrentDisplay(), what);
    }

    @Override
    public int getGlVersion() {
        return 2;
    }

    @Override
    public IEglSurfaceBase createSurfaceBase() {
        return new EglSurfaceBaseKhronos(this);
    }

    @Override
    public IWindowSurface createWindowSurface(Surface surface, boolean releaseSurface) {
        return new WindowSurfaceKhronos(this, surface);
    }

    @Override
    public IWindowSurface createWindowSurface(SurfaceHolder holder, boolean releaseSurace) {
        return new WindowSurfaceKhronos(this, holder, releaseSurace);
    }

    @Override
    public IWindowSurface createWindowSurface(SurfaceTexture surfaceTexture) {
        return new WindowSurfaceKhronos(this, surfaceTexture);
    }

    public void logCurrent(String msg) {
        EGLDisplay display = this.mEgl.eglGetCurrentDisplay();
        EGLContext context = this.mEgl.eglGetCurrentContext();
        EGLSurface surface = this.mEgl.eglGetCurrentSurface(12377);
        YMFLog.info(this, "[Util    ]", "Current EGL:" + msg + ", display:" + display + ", context:" + context + ", surface:" + surface);
    }

    private EGLSurface getCurrentSurface() {
        return this.mEgl.eglGetCurrentSurface(12377);
    }

    private void checkEglError(String msg) {
        int error = this.mEgl.eglGetError();
        if (error != 12288) {
            throw new RuntimeException(msg + ": EGL error: 0x" + Integer.toHexString(error));
        }
    }

    @Override
    public void release() {
        if (this.mEGLDisplay != EGL10.EGL_NO_DISPLAY) {
            this.mEgl.eglDestroyContext(this.mEGLDisplay, this.mEGLContext);
            this.mEgl.eglTerminate(this.mEGLDisplay);
        }
        this.mEGLDisplay = EGL10.EGL_NO_DISPLAY;
        this.mEGLContext = EGL10.EGL_NO_CONTEXT;
        this.mEGLConfig = null;
    }

    @Override
    public void makeCurrent(IEglSurfaceBase eglSurfaceBase) {
        if (eglSurfaceBase == null) {
            return;
        }
        if (!(eglSurfaceBase instanceof EglSurfaceBaseKhronos)) {
            throw new RuntimeException("EGL version error,  eglSurfaceBase is not EglSurfaceBaseKhronos ");
        }
        eglSurfaceBase.makeCurrent();
    }

    @Override
    public void makeCurrent(IEglSurfaceBase drawSurface, IEglSurfaceBase readSurface) {
        EGLSurface dSf = null;
        EGLSurface rSf = null;
        if (drawSurface != null && drawSurface instanceof EglSurfaceBaseKhronos) {
            dSf = ((EglSurfaceBaseKhronos)drawSurface).getEGLSurface();
        } else if (drawSurface != null) {
            throw new RuntimeException("EGL version error,  drawSurface is not getInstance of  EglSurfaceBaseKhronos");
        }
        if (readSurface != null && readSurface instanceof EglSurfaceBaseKhronos) {
            rSf = ((EglSurfaceBaseKhronos)readSurface).getEGLSurface();
        } else if (readSurface != null) {
            throw new RuntimeException("EGL version error,  readSurface is not getInstance of  EglSurfaceBaseKhronos");
        }
        EGLDisplay display = this.mEgl.eglGetCurrentDisplay();
        if (display == EGL11.EGL_NO_DISPLAY) {
            YMFLog.debug((Object)this, "[Util    ]", "NOTE: makeCurrent w/o display");
        }
        if (!this.mEgl.eglMakeCurrent(display, dSf, rSf, this.mEgl.eglGetCurrentContext())) {
            throw new RuntimeException("eglMakeCurrent(draw,read) failed");
        }
    }

    @Override
    public void makeNothingCurrent() {
        if (!this.mEgl.eglMakeCurrent(this.mEgl.eglGetCurrentDisplay(), EGL11.EGL_NO_SURFACE, EGL11.EGL_NO_SURFACE, EGL11.EGL_NO_CONTEXT)) {
            throw new RuntimeException("eglMakeCurrent failed");
        }
    }

    @Override
    public boolean swapBuffers(IEglSurfaceBase eglSfBase) {
        if (eglSfBase != null && eglSfBase instanceof EglSurfaceBaseKhronos) {
            return this._swapBuffers(((EglSurfaceBaseKhronos)eglSfBase).getEGLSurface());
        }
        if (eglSfBase != null) {
            throw new RuntimeException("EGL version error,  eglSurfaceBase is not EglSurfaceBaseKhronos ");
        }
        return false;
    }

    @Override
    public void setPresentationTime(IEglSurfaceBase eglSfBase, long nsecs) {
        if (eglSfBase != null && eglSfBase instanceof EglSurfaceBaseKhronos) {
            this._setPresentationTime(((EglSurfaceBaseKhronos)eglSfBase).getEGLSurface(), nsecs);
        } else if (eglSfBase != null) {
            throw new RuntimeException("EGL version error,  eglSurfaceBase is not EglSurfaceBaseKhronos ");
        }
    }

    @Override
    public boolean isCurrent(IEglSurfaceBase eglSfBase) {
        if (eglSfBase != null && eglSfBase instanceof EglSurfaceBaseKhronos) {
            this._isCurrent(((EglSurfaceBaseKhronos)eglSfBase).getEGLSurface());
        } else if (eglSfBase != null) {
            throw new RuntimeException("EGL version error,  eglSurfaceBase is not EglSurfaceBaseKhronos ");
        }
        return false;
    }

    @Override
    public int querySurface(IEglSurfaceBase eglSfBase, int what) {
        if (eglSfBase != null && eglSfBase instanceof EglSurfaceBaseKhronos) {
            this._querySurface(((EglSurfaceBaseKhronos)eglSfBase).getEGLSurface(), what);
        } else if (eglSfBase != null) {
            throw new RuntimeException("EGL version error,  eglSurfaceBase is not EglSurfaceBaseKhronos ");
        }
        return -1;
    }

    public EGLContext getEGLContext() {
        return this.mEGLContext;
    }
}

