/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.filters;

import android.view.SurfaceView;
import com.yy.mediaframework.Constant;
import com.yy.mediaframework.YYVideoSDK;
import com.yy.mediaframework.base.VideoEncoderType;
import com.yy.mediaframework.filters.AbstractYYMediaFilter;
import com.yy.mediaframework.filters.VideoLiveFilterContext;
import com.yy.mediaframework.filters.YMFEmptyFilter;
import com.yy.mediaframework.filters.YMFI420ScaleFilter;
import com.yy.mediaframework.filters.YMFI420ToNV12Filter;
import com.yy.mediaframework.filters.YMFI420WaterMarkFilter;
import com.yy.mediaframework.filters.YMFNV21ToI420Filter;
import com.yy.mediaframework.filters.YMFNV21ToTextureFilter;
import com.yy.mediaframework.filters.YMFOesToTexture2DFilter;
import com.yy.mediaframework.filters.YMFPaletteFilter;
import com.yy.mediaframework.filters.YMFTextureCallbackFilter;
import com.yy.mediaframework.filters.YMFTextureReaderFilter;
import com.yy.mediaframework.gpuimage.custom.IGPUProcess;
import com.yy.mediaframework.model.YYMediaSample;
import com.yy.mediaframework.opengles.YMFPreviewView;
import com.yy.mediaframework.utils.MediaCodecUtil;
import com.yy.mediaframework.utils.YMFLog;

public class YMFProcessGroupFilter
extends AbstractYYMediaFilter {
    private static final String TAG = "YMFProcessGroupFilter";
    private boolean mUseGpu = false;
    private YMFPreviewView mPreviewFilter;
    private YMFPaletteFilter mPaletteFilter;
    private AbstractYYMediaFilter mStartFilter;
    private YMFI420ScaleFilter mI420ScaleFilter;
    private YMFI420ToNV12Filter mI420ToNv12Filter;
    private YMFNV21ToI420Filter mNv21ToI420Filter;
    private VideoLiveFilterContext mFilterContext;
    private YMFTextureReaderFilter mTextureReaderPreviewFilter;
    private YMFTextureCallbackFilter mTextureCallbackFilter;
    private YMFI420WaterMarkFilter mI420WaterMarkFilter;
    private YMFOesToTexture2DFilter mOesToTexture2DFilter;
    private YMFNV21ToTextureFilter mNv21ToTextureFilter;
    private Constant.ScaleMode mScaleMode = Constant.ScaleMode.AspectFit;
    public VideoEncoderType mEncodeType = VideoEncoderType.HARD_ENCODER_H264;

    public YMFProcessGroupFilter(VideoLiveFilterContext ctx) {
        this.mStartFilter = new YMFEmptyFilter(ctx);
        this.mPaletteFilter = new YMFPaletteFilter(ctx);
        this.mNv21ToI420Filter = new YMFNV21ToI420Filter(ctx);
        this.mI420ScaleFilter = new YMFI420ScaleFilter(ctx);
        this.mI420ToNv12Filter = new YMFI420ToNV12Filter(ctx);
        this.mI420WaterMarkFilter = new YMFI420WaterMarkFilter(ctx);
        this.mOesToTexture2DFilter = new YMFOesToTexture2DFilter(ctx);
        this.mNv21ToTextureFilter = new YMFNV21ToTextureFilter(ctx);
        this.mTextureCallbackFilter = new YMFTextureCallbackFilter(ctx);
        this.mTextureReaderPreviewFilter = new YMFTextureReaderFilter(ctx);
        this.mFilterContext = ctx;
        this.initFilters(this.mUseGpu);
    }

    public void setPreviewView(SurfaceView view) {
        if (view instanceof YMFPreviewView) {
            this.mPreviewFilter = (YMFPreviewView)view;
        } else {
            YMFLog.error((Object)this, "[Preview ]", "need YMFPreviewView. ");
        }
        if (this.mPreviewFilter != null) {
            this.mPreviewFilter.setVideoFilterContext(this.mFilterContext);
            this.mFilterContext.setWaterMarkUpdateCB(this.mPreviewFilter);
            this.mPreviewFilter.setScaleMode(this.mScaleMode);
        }
        if (this.mPreviewFilter != null) {
            this.mFilterContext.getGLManager().post(new Runnable(){

                @Override
                public void run() {
                    YMFProcessGroupFilter.this.initFilters(YMFProcessGroupFilter.this.mUseGpu);
                }
            });
        }
        YMFLog.info(this, "[Preview ]", "setPreviewView finish.");
    }

    public void setGpuProcess(IGPUProcess gpuProcess) {
        if (this.mTextureCallbackFilter != null) {
            this.mTextureCallbackFilter.setGpuProcess(gpuProcess);
        }
    }

    public void setScaleMode(Constant.ScaleMode scaleMode) {
        this.mScaleMode = scaleMode;
        if (this.mPreviewFilter != null) {
            this.mPreviewFilter.setScaleMode(this.mScaleMode);
        }
    }

    private void resetFilters() {
        this.mStartFilter.removeAllDownStream();
        this.mPaletteFilter.removeAllDownStream();
        this.mNv21ToI420Filter.removeAllDownStream();
        this.mI420ScaleFilter.removeAllDownStream();
        this.mI420ToNv12Filter.removeAllDownStream();
        this.mTextureReaderPreviewFilter.removeAllDownStream();
        this.mTextureCallbackFilter.removeAllDownStream();
        this.mI420WaterMarkFilter.removeAllDownStream();
        this.mOesToTexture2DFilter.removeAllDownStream();
        this.mNv21ToTextureFilter.removeAllDownStream();
    }

    private void initFilters(boolean useGpu) {
        this.resetFilters();
        if (useGpu) {
            if (!this.mFilterContext.isEmulator()) {
                this.mStartFilter.addDownStream(this.mOesToTexture2DFilter);
                this.mOesToTexture2DFilter.addDownStream(this.mTextureCallbackFilter);
            } else {
                this.mStartFilter.addDownStream(this.mNv21ToTextureFilter);
                this.mNv21ToTextureFilter.addDownStream(this.mTextureCallbackFilter);
            }
            if (YYVideoSDK.getInstance().isUseGLSurfaceView()) {
                this.mTextureCallbackFilter.addDownStream(this.mTextureReaderPreviewFilter);
                if (this.mPreviewFilter != null) {
                    this.mTextureReaderPreviewFilter.addDownStream(this.mPreviewFilter);
                }
            }
            this.mTextureCallbackFilter.addDownStream(this.mPaletteFilter);
        } else {
            this.mStartFilter.addDownStream(this.mNv21ToI420Filter);
            if (this.mPreviewFilter != null) {
                this.mNv21ToI420Filter.addDownStream(this.mPreviewFilter);
            }
            this.mNv21ToI420Filter.addDownStream(this.mI420ScaleFilter);
            this.mI420ScaleFilter.addDownStream(this.mI420WaterMarkFilter);
            if (this.mFilterContext.getVideoEncoderConfig().mEncodeType != VideoEncoderType.SOFT_ENCODER_X264) {
                int colorFormat = MediaCodecUtil.instance().getColorFormat(this.mFilterContext.getVideoEncoderConfig().mEncodeType);
                if (colorFormat > 0) {
                    if (MediaCodecUtil.isSemiPlanar(colorFormat)) {
                        this.mI420WaterMarkFilter.addDownStream(this.mI420ToNv12Filter);
                    }
                } else {
                    YMFLog.warn(this, "[Encoder ]", "mediacodec do not support YUV420 input, need load YUV to surface .");
                }
            }
        }
        this.mEncodeType = this.mFilterContext.getVideoEncoderConfig().mEncodeType;
        YMFLog.info(this, "[Procedur]", "initFilters finish. useGpu:" + useGpu);
    }

    @Override
    public boolean processMediaSample(YYMediaSample sample, Object upstream) {
        sample.addRef();
        if (this.mUseGpu != sample.mUseGPUBeauty || this.mFilterContext.getVideoEncoderConfig().mEncodeType != this.mEncodeType) {
            this.mUseGpu = sample.mUseGPUBeauty;
            this.initFilters(this.mUseGpu);
        }
        this.mStartFilter.processMediaSample(sample, this);
        this.deliverToDownStream(sample);
        sample.decRef();
        return false;
    }

    @Override
    public void deInit() {
        super.deInit();
    }
}

