/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.filters;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import com.yy.mediaframework.filters.AbstractYYMediaFilter;
import com.yy.mediaframework.filters.VideoLiveFilterContext;
import com.yy.mediaframework.model.YYMediaSample;

public class YMFPaletteFilter
extends AbstractYYMediaFilter {
    VideoLiveFilterContext mFilterContext;
    private boolean mColorPaletteInited = false;
    private Bitmap mColorPaletteBitmap = null;
    private Canvas mColorPaletteCanvas = null;
    private RectF mRect = null;
    private Paint mPaint = null;
    private Typeface mTypeface = null;
    private int[] mColors = new int[]{-16777216, -7829368, -1, -65536, -16711936, -16776961, -256, -16711681, -65281};

    public YMFPaletteFilter(VideoLiveFilterContext context) {
        this.mFilterContext = context;
    }

    private void initColorPaletteTools(int width, int height) {
        if (this.mColorPaletteBitmap == null) {
            this.mColorPaletteBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        if (this.mColorPaletteCanvas == null) {
            this.mColorPaletteCanvas = new Canvas(this.mColorPaletteBitmap);
        }
        if (this.mTypeface == null) {
            String fontType = "sans";
            this.mTypeface = Typeface.create((String)fontType, (int)1);
        }
        if (this.mPaint == null) {
            this.mPaint = new Paint();
            this.mPaint.setAntiAlias(true);
            this.mPaint.setTypeface(this.mTypeface);
            this.mPaint.setTextSize(20.0f);
        }
        if (this.mRect == null) {
            this.mRect = new RectF();
        }
    }

    private void drawColorPaletteToSample(YYMediaSample sample) {
        if (sample.mTextureTarget != 3553) {
            return;
        }
        if (!this.mColorPaletteInited) {
            this.initColorPaletteTools(sample.mWidth, sample.mHeight);
        }
        int mRowCnt = this.mColors.length;
        int left = 0;
        int right = sample.mWidth;
        int top = 0;
        int bottom = sample.mHeight / mRowCnt;
        int x_offset = left + sample.mWidth / 2;
        int y_offset = sample.mHeight / mRowCnt / 2;
        for (int i = 0; i < mRowCnt; ++i) {
            this.mPaint.setColor(this.mColors[i]);
            this.mRect.set((float)left, (float)top, (float)right, (float)bottom);
            this.mColorPaletteCanvas.drawRect(this.mRect, this.mPaint);
            if (i + 1 < mRowCnt) {
                this.mPaint.setColor(this.mColors[i + 1]);
            }
            if (i + 1 == mRowCnt) {
                this.mPaint.setColor(this.mColors[0]);
            }
            this.mColorPaletteCanvas.drawText("0x" + Integer.toHexString(this.mColors[i]).toUpperCase(), (float)x_offset, (float)(top + y_offset), this.mPaint);
            top += sample.mHeight / mRowCnt;
            bottom += sample.mHeight / mRowCnt;
        }
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)sample.mMasterTextureId);
        GLUtils.texImage2D((int)3553, (int)0, (Bitmap)this.mColorPaletteBitmap, (int)0);
    }

    @Override
    public boolean processMediaSample(YYMediaSample sample, Object upstream) {
        sample.addRef();
        if (this.mFilterContext.getColorChartLiveEnable()) {
            this.drawColorPaletteToSample(sample);
        }
        this.deliverToDownStream(sample);
        sample.decRef();
        return false;
    }

    @Override
    public void deInit() {
        super.deInit();
        if (this.mColorPaletteInited) {
            if (this.mColorPaletteBitmap != null) {
                this.mColorPaletteBitmap.recycle();
            }
            this.mColorPaletteBitmap = null;
            this.mColorPaletteCanvas = null;
            this.mRect = null;
            this.mPaint = null;
            this.mColorPaletteInited = false;
        }
    }
}

