/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.filters;

import android.opengl.GLES20;
import android.opengl.Matrix;
import com.yy.mediaframework.filters.AbstractYYMediaFilter;
import com.yy.mediaframework.filters.VideoLiveFilterContext;
import com.yy.mediaframework.gles.GlUtil;
import com.yy.mediaframework.model.YMFImageBuffer;
import com.yy.mediaframework.model.YYMediaSample;
import com.yy.mediaframework.opengles.IRender;
import com.yy.mediaframework.opengles.YMFRender;
import com.yy.mediaframework.opengles.YMFTexture;
import com.yy.mediaframework.utils.YMFLog;

public class YMFNV21ToTextureFilter
extends AbstractYYMediaFilter {
    private static final String TAG = "YMFNV21ToTextureFilter";
    private int mCameraFacing;
    private int mRotateAngle;
    private boolean mInited;
    private IRender mNv21Render;
    private YMFImageBuffer mNv21Buffer;
    private YMFTexture mYuvTargetTexture;
    private VideoLiveFilterContext mFilterContext;

    public YMFNV21ToTextureFilter(VideoLiveFilterContext ctx) {
        this.mFilterContext = ctx;
    }

    private void init(int width, int height, int format, int angle, int facing, boolean swap) {
        this.mImageWidth = width;
        this.mImageHeight = height;
        this.mNv21Render = new YMFRender(YMFRender.imageFormatToProgramType(format));
        this.setRenderParam(facing, angle, width, height);
        this.mYuvTargetTexture = swap ? new YMFTexture(3553, height, width, 6408, 33984) : new YMFTexture(3553, width, height, 6408, 33984);
        this.mInited = true;
    }

    private void setRenderParam(int facing, int angle, int w, int h) {
        int rotateAngle = facing == 1 ? (360 - angle) % 360 : angle % 360;
        this.mNv21Render.rotate(rotateAngle);
        this.mRotateAngle = angle;
        this.mCameraFacing = facing;
        this.mNv21Render.flipReset();
        if (facing == 1) {
            if (w > h) {
                this.mNv21Render.flipVertical();
            } else {
                this.mNv21Render.flipHorizontal();
            }
        }
    }

    private void checkUpdate(YYMediaSample sample) {
        if (this.mCameraFacing != sample.mCameraFacing || this.mRotateAngle != sample.mCameraRotate) {
            this.setRenderParam(sample.mCameraFacing, sample.mCameraRotate, sample.mWidth, sample.mHeight);
        }
        if (this.mImageWidth != sample.mWidth || this.mImageHeight != sample.mHeight) {
            this.mImageWidth = sample.mWidth;
            this.mImageHeight = sample.mHeight;
            if (this.mYuvTargetTexture != null) {
                this.mYuvTargetTexture.release();
                this.mYuvTargetTexture = null;
            }
            this.mYuvTargetTexture = sample.mSwapWidthHeight ? new YMFTexture(3553, this.mImageHeight, this.mImageWidth, 6408, 33984) : new YMFTexture(3553, this.mImageWidth, this.mImageHeight, 6408, 33984);
        }
    }

    @Override
    public boolean processMediaSample(YYMediaSample sample, Object upstream) {
        sample.addRef();
        if (!this.mInited) {
            this.init(sample.mWidth, sample.mHeight, sample.mImageFormat, sample.mCameraRotate, sample.mCameraFacing, sample.mSwapWidthHeight);
        }
        this.checkUpdate(sample);
        if (this.renderNv21ToTexture(sample)) {
            this.deliverToDownStream(sample);
        }
        sample.decRef();
        return true;
    }

    private boolean renderNv21ToTexture(YYMediaSample sample) {
        if (sample.mDataBytes == null || sample.mImageFormat != 0) {
            YMFLog.error((Object)this, "[Preproce]", " need NV21 input. ");
            return false;
        }
        GlUtil.checkGlError("YMFNV21ToTextureFilter renderNv21ToTexture enter ");
        if (sample.mSwapWidthHeight) {
            GLES20.glViewport((int)0, (int)0, (int)sample.mHeight, (int)sample.mWidth);
        } else {
            GLES20.glViewport((int)0, (int)0, (int)sample.mWidth, (int)sample.mHeight);
        }
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GLES20.glClear((int)16384);
        if (this.mNv21Buffer == null || this.mNv21Buffer.mWidth != sample.mWidth || this.mNv21Buffer.mHeight != sample.mHeight) {
            this.mNv21Buffer = new YMFImageBuffer(sample.mWidth, sample.mHeight, 0, true);
        }
        System.arraycopy(sample.mDataBytes, 0, this.mNv21Buffer.mData.array(), this.mNv21Buffer.mData.arrayOffset(), sample.mDataBytes.length);
        if (this.mNv21Render.prepareInputImageData(this.mNv21Buffer) && this.mNv21Render.prepareOutputTexture(this.mYuvTargetTexture)) {
            this.mNv21Render.render();
            sample.mMasterTextureId = this.mYuvTargetTexture.getTextureId();
            sample.mTextureTarget = 3553;
            sample.mImageFormat = 69;
            Matrix.setIdentityM((float[])sample.mMainTransformer, (int)0);
            if (sample.mSwapWidthHeight) {
                sample.mWidth = this.mNv21Buffer.mHeight;
                sample.mHeight = this.mNv21Buffer.mWidth;
                int tmp = sample.mClipWidth;
                sample.mClipWidth = sample.mClipHeight;
                sample.mClipHeight = tmp;
                sample.mSwapWidthHeight = false;
            }
            if (sample.mCameraFacing == 1) {
                sample.mIsPreviewMirrorEnable = !sample.mIsPreviewMirrorEnable;
            }
        }
        GlUtil.checkGlError("YMFNV21ToTextureFilter renderNv21ToTexture out");
        return true;
    }

    @Override
    public void deInit() {
        YMFLog.info(this, "[Preproce]", "deInit start.");
        super.deInit();
        if (this.mNv21Buffer != null) {
            this.mNv21Buffer = null;
        }
        if (this.mYuvTargetTexture != null) {
            this.mYuvTargetTexture.release();
            this.mYuvTargetTexture = null;
        }
        if (this.mNv21Render != null) {
            this.mNv21Render.release();
        }
        YMFLog.info(this, "[Preproce]", "deInit done.");
    }
}

