/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.filters;

import com.yy.mediaframework.filters.AbstractYYMediaFilter;
import com.yy.mediaframework.filters.VideoLiveFilterContext;
import com.yy.mediaframework.model.YMFImageBuffer;
import com.yy.mediaframework.model.YYMediaSample;
import com.yy.mediaframework.utils.ImageUtil;
import com.yy.mediaframework.utils.YMFLog;

public class YMFNV21ToI420Filter
extends AbstractYYMediaFilter {
    private static final String TAG = "YMFNV21ToI420Filter";
    private YMFImageBuffer mI420;
    private VideoLiveFilterContext mFilterContext;

    public YMFNV21ToI420Filter(VideoLiveFilterContext ctx) {
        this.mFilterContext = ctx;
    }

    @Override
    public boolean processMediaSample(YYMediaSample sample, Object upstream) {
        sample.addRef();
        if (!sample.mUseGPUBeauty && sample.mIsYUVBuffer && sample.mDataBytes != null && !this.cpuConvertCropRotate(sample)) {
            sample.decRef();
            return false;
        }
        this.deliverToDownStream(sample);
        sample.decRef();
        return true;
    }

    private boolean cpuConvertCropRotate(YYMediaSample sample) {
        if (sample.mImageFormat != 0) {
            YMFLog.error((Object)this, "[Preproce]", "invalid YUVFormat, need NV21.");
            return false;
        }
        int clipWidth = sample.mClipWidth;
        int clipHeight = sample.mClipHeight;
        if (sample.mSwapWidthHeight) {
            clipWidth = sample.mClipHeight;
            clipHeight = sample.mClipWidth;
        }
        if (this.mI420 == null || this.mI420.mWidth != clipWidth || this.mI420.mHeight != clipHeight) {
            this.mI420 = new YMFImageBuffer(clipWidth, clipHeight, 2, true);
        }
        int rotateAngle = sample.mCameraFacing == 1 ? 360 - sample.mCameraRotate : sample.mCameraRotate;
        int ret = ImageUtil.ConvertToI420Ex(sample.mDataBytes, sample.mDataBytes.length, this.mI420.mData.array(), this.mI420.mData.arrayOffset(), sample.mClipX, sample.mClipY, sample.mWidth, sample.mHeight, sample.mClipWidth, sample.mClipHeight, rotateAngle, 0);
        if (ret != 0) {
            YMFLog.error((Object)this, "[Preproce]", "ConvertToI420Ex failed, return " + ret);
            return false;
        }
        sample.mWidth = clipWidth;
        sample.mHeight = clipHeight;
        sample.mCliped = true;
        sample.mI420 = this.mI420;
        sample.mImageFormat = 2;
        return true;
    }
}

