/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.filters;

import android.annotation.SuppressLint;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.yy.mediaframework.base.VideoEncoderConfig;
import com.yy.mediaframework.base.VideoEncoderType;
import com.yy.mediaframework.encoder.X264SoftEncoder;
import com.yy.mediaframework.filters.AbstractEncoderFilter;
import com.yy.mediaframework.filters.LiveSessionType;
import com.yy.mediaframework.filters.VideoLiveFilterContext;
import com.yy.mediaframework.gpuimage.adapter.GlTextureBlender;
import com.yy.mediaframework.gpuimage.adapter.GlTextureImageReader;
import com.yy.mediaframework.model.ImageBufferPool;
import com.yy.mediaframework.model.JVideoEncodedData;
import com.yy.mediaframework.model.YUVImageBuffer;
import com.yy.mediaframework.model.YYMediaSample;
import com.yy.mediaframework.stat.VideoDataStat;
import com.yy.mediaframework.stat.YMFLiveExceptionStat;
import com.yy.mediaframework.stat.YMFLiveExceptionType;
import com.yy.mediaframework.stat.YMFLiveStatisticManager;
import com.yy.mediaframework.stat.YMFLiveUsrBehaviorStat;
import com.yy.mediaframework.utils.ImageUtil;
import com.yy.mediaframework.utils.YMFLog;
import java.lang.ref.WeakReference;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;

@SuppressLint(value={"NewApi"})
public class X264SoftEncoderFilter
extends AbstractEncoderFilter
implements Runnable {
    private static final int MSG_FRAME_AVAILABLE = 1;
    private static final int MSG_QUIT = 2;
    private static final int MSG_CHECK_IDLE = 3;
    private AtomicInteger mBitRateReqInKbps = new AtomicInteger(0);
    private String mConfigStr = "preset=yyveryfast:bframes=2:b-pyramid=none:threads=2:sliced-threads=0:rc-lookahead=0:sync-lookahead=1:mbtree=0:force-cfr=0:me=dia:chroma_me=0:psy=0:b-adapt=0:";
    private String mLowDelayConfigStr = "preset=yyveryfast:scenecut=0:bframes=0:b-adapt=0:b-pyramid=none:threads=2:sliced-threads=0:ref=2:subme=3:me=dia:analyse=i4x4,i8x8,p8x8,b8x8:direct=spatial:weightp=0:weightb=0:8x8dct=1:cabac=1:deblock=0,0:psy=0:trellis=0:aq-mode=0:rc-lookahead=0:sync-lookahead=0:mbtree=0:force-cfr=1:";
    private String mLowSteadyBitrateConfigStr = "preset=yy:scenecut=0:bframes=0:b-adapt=0:b-pyramid=none:threads=2:sliced-threads=0:ref=2:subme=6:me=hex:analyse=i4x4,i8x8,p8x8,p4x4,b8x8:direct=spatial:weightp=1:weightb=1:8x8dct=1:cabac=1:deblock=0,0:psy=0:trellis=0:aq-mode=0:rc-lookahead=0:sync-lookahead=0:mbtree=0:force-cfr=0:strict-vfr=1:strict-vfr-tol=0.1:strict-vfr-imar=1";
    private String mHeightSteadyBitrateConfigStr = "preset=yyveryfast:scenecut=0:bframes=0:b-adapt=0:b-pyramid=none:threads=2:sliced-threads=0:ref=1:subme=2:me=dia:analyse=i4x4,i8x8,p8x8,b8x8:direct=spatial:weightp=1:weightb=0:8x8dct=1:cabac=1:deblock=0,0:psy=0:trellis=0:aq-mode=0:rc-lookahead=0:sync-lookahead=0:mbtree=0:force-cfr=0:strict-vfr=1:strict-vfr-tol=0.1:strict-vfr-imar=1";
    private String mGopParamStr = "";
    private boolean mFirstFrameEncode = false;
    private ImageBufferPool mYUVImagePool = null;
    private X264SoftEncoder mEncoder = null;
    private static String mEncoderNameCurrent;
    private int mEncodeWidth = 0;
    private int mEncodeHeight = 0;
    private volatile EncoderHandler mHandler;
    private Object mReadyFence = new Object();
    private boolean mReady;
    private boolean mRunning = false;
    private GlTextureImageReader mGlImageReader = null;
    private GlTextureBlender mGLBlender = null;
    private long encodeTime = 0L;
    private long readPixelTime = 0L;
    private AtomicInteger mSyncFrameCnt = new AtomicInteger(0);
    private int mCameraFacing = -1;
    private String mSvcConfigStr = "temporalnum=2:spatialid=1:annexg=1:";
    public YYMediaSample mSpsSample = new YYMediaSample();
    public YYMediaSample mPpsSample = new YYMediaSample();
    private boolean mUseColorChart = false;

    public X264SoftEncoderFilter(VideoLiveFilterContext filterContext) {
        this.mFilterContext = filterContext;
        YMFLog.info(this, "[Encoder ]", "X264SoftEncoderFilter construct!!");
    }

    private String genGopParamStr(int fps) {
        String gopParamStr = "keyint=" + fps + ":min-keyint=" + fps + ":";
        return gopParamStr;
    }

    @Override
    public VideoEncoderType getEncoderFilterType() {
        return VideoEncoderType.SOFT_ENCODER_X264;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean startEncode() {
        Object object = this.mReadyFence;
        synchronized (object) {
            if (this.mRunning) {
                YMFLog.warn(this, "[Encoder ]", "X264 Encoder thread already running");
                return true;
            }
            this.setEncodeCfg(this.mFilterContext.getVideoEncoderConfig());
            this.mGopParamStr = this.genGopParamStr(this.mFilterContext.getVideoEncoderConfig().getFrameRate());
            this.mSyncFrameCnt.set(0);
            this.mRunning = true;
            this.mGlImageReader = new GlTextureImageReader(this.mFilterContext.getAndroidContext(), this.mFilterContext.getVideoEncoderConfig().getEncodeWidth(), this.mFilterContext.getVideoEncoderConfig().getEncodeHeight());
            this.mFilterContext.mUsedPbo = this.mGlImageReader.mGlPboSupported ? Boolean.valueOf(true) : Boolean.valueOf(false);
            this.mGLBlender = new GlTextureBlender(this.mFilterContext);
            this.mYUVImagePool = new ImageBufferPool<YUVImageBuffer>(this.mEncoderConfig.getEncodeWidth(), this.mEncoderConfig.getEncodeHeight(), 6, 35, YUVImageBuffer.class, 0);
            YMFLog.info(this, "[Encoder ]", "startEncode width:" + this.mEncoderConfig.getEncodeWidth() + " height:" + this.mEncoderConfig.getEncodeHeight() + " bitRate:" + this.mEncoderConfig.mBitRate + " mFrameCnt:" + this.mEncoderConfig.mFrameRate);
            this.mBitRateReqInKbps.set(this.mEncoderConfig.mBitRate / 1000);
            Object object2 = this.mReadyFence;
            synchronized (object2) {
                if (this.mEncoderConfig.mEncodeParameter == null || this.mEncoderConfig.mEncodeParameter.isEmpty()) {
                    this.mFilterContext.getVideoEncoderConfig().mEncodeParameter = this.mEncoderConfig.mEncodeParameter = this.mConfigStr;
                }
                if (this.mEncoderConfig.mEncodeParameter.contains("bframes=2") && this.mEncoderConfig.mLowDelay) {
                    this.mEncoderConfig.mEncodeParameter = this.mEncoderConfig.mEncodeParameter.contains("annexg") ? this.mLowDelayConfigStr + this.mSvcConfigStr + this.mGopParamStr : this.mLowDelayConfigStr + this.mGopParamStr;
                    YMFLog.info(this, "[Encoder ]", "X264 startEncode lowDelay:" + this.mEncoderConfig.mEncodeParameter);
                }
                this.mEncodeParam = this.mEncoderConfig.toString();
            }
            this.mEncoder = X264SoftEncoder.createEncoder();
            this.mEncoder.setSteadyBitrateControl(false);
            this.mEncoder.initEncoder(this.mEncoderConfig);
            new Thread((Runnable)this, "YY_yyvideolib_TextureMovieEncoder_Thread").start();
            while (!this.mReady) {
                try {
                    YMFLog.info(this, "[Encoder ]", "ready fence waitting");
                    this.mReadyFence.wait();
                    YMFLog.info(this, "[Encoder ]", "got ready fence ");
                }
                catch (InterruptedException interruptedException) {}
            }
            this.mFilterContext.getEncodeParamTipsMgr().setEncoderParam(this.mFilterContext.getVideoEncoderConfig().toString() + ", localConfig:" + this.mEncodeParam);
        }
        this.mFirstEncoderDataOut.set(false);
        VideoDataStat.getInstance().setVideoEncodingState(true);
        YMFLog.info(this, "[Encoder ]", "X264SoftEncoderFilter startEncode done");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopEncode() {
        Object object = this.mReadyFence;
        synchronized (object) {
            YMFLog.info(this, "[Encoder ]", "X264 stopEncode begin");
            VideoDataStat.getInstance().setVideoEncodingState(false);
            this.mCameraFacing = -1;
            if (this.mGlImageReader != null) {
                this.mGlImageReader.destroy();
                this.mGlImageReader = null;
            }
            if (this.mGLBlender != null) {
                this.mGLBlender.destroy();
                this.mGLBlender = null;
            }
            if (this.mEncoder != null) {
                X264SoftEncoder.destroyEncoder(this.mEncoder);
                this.mEncoder = null;
            }
            YMFLog.info(this, "[Encoder ]", "X264 stopEncode done");
        }
        this.mFilterContext.getEncodeParamTipsMgr().setNoEncoder();
        YMFLiveUsrBehaviorStat.getInstance().notifyVideoEncoderState(VideoEncoderType.SOFT_ENCODER_X264, false);
        this.mSyncFrameCnt.set(0);
        if (this.mHandler != null) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleFrameAvailable(YUVImageBuffer inputData) {
        Object object = this.mReadyFence;
        synchronized (object) {
            int i;
            if (this.mEncoder == null) {
                YMFLog.error((Object)this, "[Encoder ]", "handleFrameAvailable encoder is null!");
                return;
            }
            if (this.mEncodeWidth != inputData.mWidth || this.mEncodeHeight != inputData.mHeight) {
                this.handleEncodeResolution(inputData.mWidth, inputData.mHeight);
                this.mEncodeWidth = inputData.mWidth;
                this.mEncodeHeight = inputData.mHeight;
            }
            if (this.mFilterContext.getLiveMode() == LiveSessionType.LIVE_MODE_NORMAL && !this.mFilterContext.getColorChartLiveEnable() && this.checkEncoderSwitch()) {
                this.handleEncoderSwitch();
                return;
            }
            if (this.checkEncodeUpdate(inputData.mWidth, inputData.mHeight, inputData.mLowDelay, inputData.mFrameRate, inputData.mBitRate, inputData.mEncodeParameter, this.mInputMode)) {
                Object object2 = this.mReadyFence;
                synchronized (object2) {
                    if (this.mEncoderConfig.mEncodeParameter == null || this.mEncoderConfig.mEncodeParameter.isEmpty()) {
                        this.mEncoderConfig.mEncodeParameter = this.mConfigStr;
                        this.mFilterContext.getGlManager().post(new Runnable(){

                            @Override
                            public void run() {
                                X264SoftEncoderFilter.this.mFilterContext.getVideoEncoderConfig().mEncodeParameter = X264SoftEncoderFilter.this.mEncoderConfig.mEncodeParameter;
                            }
                        });
                    }
                    if (this.mEncoderConfig.mLowDelay) {
                        this.mEncoderConfig.mEncodeParameter = this.mEncoderConfig.mEncodeParameter.contains("annexg") ? this.mLowDelayConfigStr + this.mSvcConfigStr + this.mGopParamStr : this.mLowDelayConfigStr + this.mGopParamStr;
                        YMFLog.info(this, "[Encoder ]", "X264 handleFrame lowDelay, config:" + this.mEncoderConfig.mEncodeParameter);
                    }
                    YMFLog.info(this, "[Encoder ]", "config changed, restart the encoder!! config:" + this.mEncoderConfig.toString());
                    this.mBitRateReqInKbps.set(this.mEncoderConfig.mBitRate / 1000);
                    X264SoftEncoder.destroyEncoder(this.mEncoder);
                    this.mEncoder = X264SoftEncoder.createEncoder();
                    this.mEncoder.setSteadyBitrateControl(false);
                    this.mEncoder.initEncoder(this.mEncoderConfig);
                    this.mEncodeParam = this.mEncoderConfig.toString();
                }
                this.mFilterContext.getEncodeParamTipsMgr().setEncoderParam(this.mFilterContext.getVideoEncoderConfig().toString() + ", localConfig:" + this.mEncodeParam);
            }
            long begin = System.currentTimeMillis();
            JVideoEncodedData[] outputVideoArray = null;
            if (this.mSyncFrameCnt.get() > 0) {
                outputVideoArray = this.mEncoder.encode(inputData.mDataBuffer, inputData.mPts, 0);
                this.mSyncFrameCnt.decrementAndGet();
            } else {
                outputVideoArray = this.mEncoder.encode(inputData.mDataBuffer, inputData.mPts, 255);
            }
            if (!this.mFirstFrameEncode) {
                YMFLiveUsrBehaviorStat.getInstance().notifyFirstFrameEncode(inputData.mPts);
                this.mFirstFrameEncode = true;
            }
            long end = System.currentTimeMillis();
            if (System.currentTimeMillis() - this.encodeTime >= 3000L) {
                YMFLog.info(this, "[Encoder ]", "processMediaSample encode time:" + (end - begin));
                this.encodeTime = System.currentTimeMillis();
            }
            if (outputVideoArray == null) {
                if (this.encodedCallBack != null && !this.mFirstEncoderDataOut.get()) {
                    this.encodedCallBack.onNoEncodedDataOut();
                    YMFLog.info(this, "[Encoder ]", "encodedCallBack onNoEncodedDataOut!");
                } else {
                    YMFLog.error((Object)this, "[Encoder ]", "outputVideoArray null!");
                }
                this.mYUVImagePool.freeBuffer(inputData);
                return;
            }
            if (!this.mFirstEncoderDataOut.get()) {
                this.mFirstEncoderDataOut.set(true);
                if (this.encodedCallBack != null) {
                    this.encodedCallBack.onFirstEncodedDataOut();
                    YMFLog.info(this, "[Encoder ]", "encodedCallBack onFirstEncodedDataOut!");
                }
            }
            YMFLiveStatisticManager.getInstance().endEncode(0, inputData.mPts);
            for (i = 0; i < outputVideoArray.length; ++i) {
                outputVideoArray[i].mEncodeType = VideoEncoderType.SOFT_ENCODER_X264;
                YYMediaSample sample = outputVideoArray[i].toYYMediaSample();
                if (sample.mFrameType == 5) {
                    this.mSpsSample.assigne(sample);
                } else if (sample.mFrameType == 6) {
                    this.mPpsSample.assigne(sample);
                }
                this.deliverToDownStream(sample);
                this.handleEncodedFrameStats(outputVideoArray[i].mDataLen, inputData.mDataBuffer.array().length, sample.mFrameType);
                sample.decRef();
            }
            for (i = 0; i < outputVideoArray.length; ++i) {
                outputVideoArray[i].releaseVideoByteBuffer();
            }
            this.mYUVImagePool.freeBuffer(inputData);
        }
    }

    public void stopRecording() {
        this.mSyncFrameCnt.set(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processMediaSampleEx(YYMediaSample sample, Object upstream) {
        YMFLiveStatisticManager.getInstance().beginEncode(sample.mYYPtsMillions);
        Object object = this.mReadyFence;
        synchronized (object) {
            YUVImageBuffer imageBuf = (YUVImageBuffer)this.mYUVImagePool.newBuffer(sample.mEncodeWidth, sample.mEncodeHeight);
            if (imageBuf == null) {
                YMFLog.warn(this, "[Encoder ]", "ByteBufferPool is empty!");
                return false;
            }
            System.arraycopy(sample.mI420.mData.array(), 0, imageBuf.mDataBuffer.array(), 0, imageBuf.mDataBuffer.array().length);
            imageBuf.mPts = sample.mYYPtsMillions;
            imageBuf.mFrameRate = this.mFilterContext.getVideoEncoderConfig().mFrameRate;
            imageBuf.mBitRate = this.mFilterContext.getVideoEncoderConfig().mBitRate;
            imageBuf.mLowDelay = this.mFilterContext.getVideoEncoderConfig().mLowDelay;
            imageBuf.mEncodeParameter = this.mFilterContext.getVideoEncoderConfig().mEncodeParameter;
            this.mHandler.sendMessage(this.mHandler.obtainMessage(1, imageBuf));
        }
        this.handleCaptureFrameStats();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processMediaSample(YYMediaSample sample, Object upstream) {
        Object object = this.mReadyFence;
        synchronized (object) {
            if (!this.mReady) {
                return false;
            }
        }
        if (sample.mImageFormat == 2) {
            return this.processMediaSampleEx(sample, upstream);
        }
        YMFLiveStatisticManager.getInstance().beginEncode(sample.mYYPtsMillions);
        long begin = System.currentTimeMillis();
        VideoEncoderConfig vEncoderCfg = this.mFilterContext.getVideoEncoderConfig();
        int texId = sample.mMasterTextureId;
        if (this.mGLBlender != null) {
            sample.mBlenderTextureId = texId = this.mGLBlender.blend(sample, this.mFilterContext.getWatermarkTextureID(), this.mFilterContext.getDynamicTextureID(), this.mFilterContext.getPictureInPictureFlag() && this.mFilterContext.getSwithPictureFlag());
        }
        byte[] pixBuf = null;
        if (this.mGlImageReader == null) {
            this.mGlImageReader = new GlTextureImageReader(this.mFilterContext.getAndroidContext(), this.mFilterContext.getVideoEncoderConfig().getEncodeWidth(), this.mFilterContext.getVideoEncoderConfig().getEncodeHeight());
            this.mFilterContext.mUsedPbo = this.mGlImageReader.mGlPboSupported ? Boolean.valueOf(true) : Boolean.valueOf(false);
            YMFLog.info(this, "[Encoder ]", "new GlTextureImageReader OK!");
        }
        if ((pixBuf = this.mGlImageReader.read(texId, sample.mEncodeWidth, sample.mEncodeHeight)) == null) {
            return false;
        }
        long end = System.currentTimeMillis();
        long transBegin = 0L;
        long transEnd = 0L;
        Object object2 = this.mReadyFence;
        synchronized (object2) {
            YUVImageBuffer imageBuf = (YUVImageBuffer)this.mYUVImagePool.newBuffer(sample.mEncodeWidth, sample.mEncodeHeight);
            if (imageBuf == null) {
                YMFLog.warn(this, "[Encoder ]", "ByteBufferPool is empty!");
                return false;
            }
            transBegin = System.currentTimeMillis();
            ImageUtil.RBGAtoYUV(pixBuf, sample.mEncodeWidth, sample.mEncodeHeight, imageBuf.mDataBuffer.array());
            transEnd = System.currentTimeMillis();
            imageBuf.mPts = sample.mYYPtsMillions;
            imageBuf.mFrameRate = this.mFilterContext.getVideoEncoderConfig().mFrameRate;
            imageBuf.mBitRate = this.mFilterContext.getVideoEncoderConfig().mBitRate;
            imageBuf.mLowDelay = this.mFilterContext.getVideoEncoderConfig().mLowDelay;
            imageBuf.mEncodeParameter = this.mFilterContext.getVideoEncoderConfig().mEncodeParameter;
            this.mHandler.sendMessage(this.mHandler.obtainMessage(1, imageBuf));
        }
        if (System.currentTimeMillis() - this.readPixelTime >= 3000L) {
            YMFLog.info(this, "[Encoder ]", "processMediaSample read pixel buffer time:" + (end - begin));
            YMFLog.info(this, "[Encoder ]", "processMediaSample trans rgb2yuv time:" + (transEnd - transBegin));
            this.readPixelTime = System.currentTimeMillis();
        }
        this.handleCaptureFrameStats();
        return true;
    }

    @Override
    public void requestSyncFrame() {
        YMFLog.info(this, "[Encoder ]", "requestSyncFrame");
        this.mSyncFrameCnt.addAndGet(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRecording() {
        Object object = this.mReadyFence;
        synchronized (object) {
            return this.mRunning;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object;
        YMFLog.info(this, "[Encoder ]", "run before prepare");
        Looper.prepare();
        try {
            object = this.mReadyFence;
            synchronized (object) {
                this.mHandler = new EncoderHandler(this);
                this.mReady = true;
                this.mReadyFence.notify();
                YMFLog.info(this, "[Encoder ]", "run notify ready");
            }
            Looper.loop();
        }
        catch (Throwable t) {
            YMFLog.error((Object)this, "[Encoder ]", "x264 encoder thread run exception:" + t.getMessage());
            YMFLiveExceptionStat.getInstance().notifyException(YMFLiveExceptionType.AnchorStatus_ENCODE_ERROR);
            this.mbEncodingState = false;
        }
        finally {
            YMFLog.info(this, "[Encoder ]", "x264 encoder thread exiting");
            object = this.mReadyFence;
            synchronized (object) {
                this.mFilterContext.mUsedPbo = false;
                this.mRunning = false;
                this.mReady = false;
                this.mHandler = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void adjustBitRate(int bitRateInKbps) {
        int targetBiteRateInKbps = bitRateInKbps;
        if (this.mBitRateReqInKbps.get() == targetBiteRateInKbps) {
            YMFLog.info(this, "[Encoder ]", "original bitrate is" + targetBiteRateInKbps + " already");
            return;
        }
        YMFLog.info(this, "[Encoder ]", "adjustBitRate, target bitRate:" + targetBiteRateInKbps);
        this.mBitRateReqInKbps.set(targetBiteRateInKbps);
        Object object = this.mReadyFence;
        synchronized (object) {
            if (this.mEncoder != null) {
                this.mEncoder.adjustBitRate(this.mBitRateReqInKbps.get());
            }
        }
    }

    public static String getEncoderName() {
        return mEncoderNameCurrent;
    }

    @Override
    public boolean getCacheEncodedData() {
        CountDownLatch syncFlag = new CountDownLatch(1);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(3, syncFlag));
        try {
            syncFlag.await();
        }
        catch (InterruptedException e) {
            YMFLog.error((Object)this, "[Encoder ]", "getCacheEncodedData exception:" + e.toString());
        }
        if (this.mEncoder != null) {
            int i;
            JVideoEncodedData[] outputVideoArray = null;
            outputVideoArray = this.mEncoder.getCacheEncodedData();
            if (outputVideoArray == null) {
                YMFLog.warn(this, "[Encoder ]", "getCacheEncodedData no cache Encoded Data!");
                return false;
            }
            for (i = 0; i < outputVideoArray.length; ++i) {
                outputVideoArray[i].mEncodeType = VideoEncoderType.SOFT_ENCODER_X264;
                YYMediaSample sample = outputVideoArray[i].toYYMediaSample();
                YMFLog.info(this, "[Encoder ]", "getCacheEncodedData pts:" + sample.mYYPtsMillions + " dts:" + sample.mDtsMillions + " gap:" + (sample.mYYPtsMillions - sample.mDtsMillions) + " frameType:" + sample.mFrameType);
                if (sample.mFrameType == 5) {
                    this.mSpsSample.assigne(sample);
                } else if (sample.mFrameType == 6) {
                    this.mPpsSample.assigne(sample);
                }
                this.deliverToDownStream(sample);
                this.handleEncodedFrameStats(outputVideoArray[i].mDataLen, 0, sample.mFrameType);
                sample.decRef();
            }
            for (i = 0; i < outputVideoArray.length; ++i) {
                outputVideoArray[i].releaseVideoByteBuffer();
            }
            return true;
        }
        return false;
    }

    @Override
    public void destoryGlElementEnvOnly() {
        final CountDownLatch barrier = new CountDownLatch(1);
        if (!this.mFilterContext.getGLManager().checkSameThread()) {
            this.mFilterContext.getGLManager().getHandler().post(new Runnable(){

                @Override
                public void run() {
                    X264SoftEncoderFilter.this.destroyGlElementEnv();
                    barrier.countDown();
                }
            });
            try {
                barrier.await();
            }
            catch (InterruptedException e) {
                YMFLog.error((Object)this, "[Encoder ]", "stopEncoderAsyenc  .barrier.await exception:" + e.toString());
            }
        } else {
            this.destroyGlElementEnv();
        }
    }

    @Override
    public void createGlElementEnvOnly() {
        long timeBegin = System.currentTimeMillis();
        this.mGlImageReader = new GlTextureImageReader(this.mFilterContext.getAndroidContext(), this.mFilterContext.getVideoEncoderConfig().getEncodeWidth(), this.mFilterContext.getVideoEncoderConfig().getEncodeHeight());
        this.mFilterContext.mUsedPbo = this.mGlImageReader.mGlPboSupported ? Boolean.valueOf(true) : Boolean.valueOf(false);
        this.mGLBlender = new GlTextureBlender(this.mFilterContext);
        YMFLog.info(this, "[Encoder ]", "createGlElementEnv success, cost time :" + (System.currentTimeMillis() - timeBegin));
    }

    private void destroyGlElementEnv() {
        if (this.mGlImageReader != null) {
            this.mGlImageReader.destroy();
            this.mGlImageReader = null;
        }
        if (this.mGLBlender != null) {
            this.mGLBlender.destroy();
            this.mGLBlender = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean stopEncoderAsync() {
        Object object = this.mReadyFence;
        synchronized (object) {
            if (this.mEncoder == null) {
                YMFLog.info(this, "[Encoder ]", "X264 stopEncoderAsyenc has realeased");
                return true;
            }
            YMFLog.info(this, "[Encoder ]", "X264 stopEncoderAsyenc begin");
            this.mCameraFacing = -1;
            if (this.mEncoder != null) {
                X264SoftEncoder.destroyEncoder(this.mEncoder);
                this.mEncoder = null;
            }
            YMFLog.info(this, "[Encoder ]", "X264 stopEncoderAsyenc done");
        }
        this.mFilterContext.getEncodeParamTipsMgr().setNoEncoder();
        this.mSyncFrameCnt.set(0);
        if (this.mHandler != null) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(2));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean startEncoderOnly(VideoEncoderConfig newConfig) {
        Object object = this.mReadyFence;
        synchronized (object) {
            if (this.mRunning) {
                YMFLog.warn(this, "[Encoder ]", "X264 Encoder thread already running");
                return true;
            }
            this.setEncodeCfg(newConfig);
            this.mGopParamStr = this.genGopParamStr(newConfig.getFrameRate());
            this.mSyncFrameCnt.set(0);
            this.mRunning = true;
            this.mYUVImagePool = new ImageBufferPool<YUVImageBuffer>(this.mEncoderConfig.getEncodeWidth(), this.mEncoderConfig.getEncodeHeight(), 6, 35, YUVImageBuffer.class, 0);
            YMFLog.info(this, "[Encoder ]", "X264SoftEncoderFilter startEncoderOnly width:" + this.mEncoderConfig.getEncodeWidth() + " height:" + this.mEncoderConfig.getEncodeHeight() + " bitRate:" + this.mEncoderConfig.mBitRate + " mFrameCnt " + this.mEncoderConfig.mFrameRate);
            this.mBitRateReqInKbps.set(this.mEncoderConfig.mBitRate / 1000);
            String steadyBitrateConfigStr = this.mLowSteadyBitrateConfigStr;
            if (newConfig.mEncodeHeight * newConfig.mEncodeWidth >= 235520) {
                steadyBitrateConfigStr = this.mHeightSteadyBitrateConfigStr;
            }
            Object object2 = this.mReadyFence;
            synchronized (object2) {
                if (this.mEncoderConfig.mEncodeParameter == null || this.mEncoderConfig.mEncodeParameter.isEmpty()) {
                    this.mEncoderConfig.mEncodeParameter = steadyBitrateConfigStr;
                }
                if (this.mEncoderConfig.mEncodeParameter.contains("bframes=2") && this.mEncoderConfig.mLowDelay) {
                    this.mEncoderConfig.mEncodeParameter = this.mEncoderConfig.mEncodeParameter.contains("annexg") ? steadyBitrateConfigStr + this.mSvcConfigStr + this.mGopParamStr : steadyBitrateConfigStr + this.mGopParamStr;
                    YMFLog.info(this, "[Encoder ]", "X264 startEncoderOnly lowDelay:" + this.mEncoderConfig.mEncodeParameter);
                }
                this.mEncodeParam = this.mEncoderConfig.toString();
            }
            this.mEncoder = X264SoftEncoder.createEncoder();
            this.mEncoder.setSteadyBitrateControl(true);
            this.mEncoder.initEncoder(this.mEncoderConfig);
            new Thread((Runnable)this, "YY_yyvideolib_TextureMovieEncoder_Thread").start();
            while (!this.mReady) {
                try {
                    YMFLog.info(this, "[Encoder ]", "ready fence waitting");
                    this.mReadyFence.wait();
                    YMFLog.info(this, "[Encoder ]", "got ready fence ");
                }
                catch (InterruptedException interruptedException) {}
            }
            this.mFilterContext.getEncodeParamTipsMgr().setEncoderParam(this.mFilterContext.getVideoEncoderConfig().toString() + ", localConfig:" + this.mEncodeParam);
        }
        this.mFirstEncoderDataOut.set(false);
        YMFLog.info(this, "[Encoder ]", "X264SoftEncoderFilter startEncoderOnly done!");
        return true;
    }

    static {
        JVideoEncodedData.nativeClassInit();
        mEncoderNameCurrent = "X264Soft";
    }

    private static class EncoderHandler
    extends Handler {
        private WeakReference<X264SoftEncoderFilter> mWeakEncoder;

        public EncoderHandler(X264SoftEncoderFilter encoder) {
            this.mWeakEncoder = new WeakReference<X264SoftEncoderFilter>(encoder);
        }

        public void handleMessage(Message inputMessage) {
            int what = inputMessage.what;
            X264SoftEncoderFilter encoder = (X264SoftEncoderFilter)this.mWeakEncoder.get();
            if (encoder == null) {
                YMFLog.warn((Object)this, "[Encoder ]", "handleMessage: encoder is null");
                return;
            }
            switch (what) {
                case 1: {
                    encoder.handleFrameAvailable((YUVImageBuffer)inputMessage.obj);
                    break;
                }
                case 2: {
                    if (Looper.myLooper() == null) break;
                    Looper.myLooper().quit();
                    break;
                }
                case 3: {
                    CountDownLatch sync = (CountDownLatch)inputMessage.obj;
                    sync.countDown();
                    YMFLog.info((Object)this, "[Encoder ]", "mHandler MSG_CHECK_IDLE !");
                    break;
                }
                default: {
                    throw new RuntimeException("Unhandled msg what=" + what);
                }
            }
        }
    }
}

