/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.filters;

import android.graphics.ImageFormat;
import android.graphics.Rect;
import android.media.Image;
import android.opengl.GLES20;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import com.yy.mediaframework.base.VideoEncoderType;
import com.yy.mediaframework.decoder.BaseHardwareDecoder;
import com.yy.mediaframework.decoder.H264HardwareDecoder;
import com.yy.mediaframework.decoder.H265HardwareDecoder;
import com.yy.mediaframework.filters.AbstractEncoderFilter;
import com.yy.mediaframework.filters.AbstractYYMediaFilter;
import com.yy.mediaframework.filters.H264HardwareEncoderFilter;
import com.yy.mediaframework.filters.H265HardwareEncoderFilter;
import com.yy.mediaframework.filters.VideoEncoderGroupFilter;
import com.yy.mediaframework.filters.VideoLiveFilterContext;
import com.yy.mediaframework.filters.X264SoftEncoderFilter;
import com.yy.mediaframework.gles.EglFactory;
import com.yy.mediaframework.gles.GlUtil;
import com.yy.mediaframework.gles.IEglCore;
import com.yy.mediaframework.gles.IEglSurfaceBase;
import com.yy.mediaframework.gpuimage.adapter.GlTextureBlender;
import com.yy.mediaframework.model.ByteVector;
import com.yy.mediaframework.model.DecodeVideoConfig;
import com.yy.mediaframework.model.YYMediaSample;
import com.yy.mediaframework.model.YYMediaSampleAlloc;
import com.yy.mediaframework.stat.UploadStatManager;
import com.yy.mediaframework.utils.ImageUtil;
import com.yy.mediaframework.utils.YMFLog;
import java.lang.ref.WeakReference;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class VideoQoeFilter
extends AbstractYYMediaFilter
implements BaseHardwareDecoder.OnDecoderYUVListener {
    private static final String TAG = "VideoPsnrFilter";
    private static final int MAX_DECODE_SIZE = 100;
    private static final int CACHE_BEGIN_INDEX = 4;
    private static final int CACHE_YUV_CONVERTER_INDEX = 3;
    private static final int CACHE_SPS_INDEX = 0;
    private static final int CACHE_PPS_INDEX = 1;
    private static final int CACHE_DECODER_HEADER_INDEX = 2;
    public VideoLiveFilterContext mFilterContext;
    private Handler mWorkerHandler;
    private HandlerThread mHandlerThread;
    private DecodeVideoConfig mDecoderConfig;
    private BaseHardwareDecoder mHardwareDecoder;
    private VideoEncoderType mDecodeType = VideoEncoderType.HARD_ENCODER_H264;
    private int mWidth;
    private int mHeight;
    private IEglCore mShotEglCore;
    private IEglSurfaceBase mShotEnvSurface;
    private int mCopyTextureId = -1;
    private AtomicBoolean mPsnrStatisticsFlag = new AtomicBoolean(false);
    public AtomicBoolean mDecodingFlag = new AtomicBoolean(false);
    private AtomicBoolean mUsedBlender = new AtomicBoolean(false);
    private GlTextureBlender mGLBlender;
    private YYMediaSample spsSample;
    private YYMediaSample ppsSample;
    private YYMediaSample mDecoderHeader;
    private ByteBuffer mOriginalByteBuffer = null;
    private ByteVector[] mDataCacheBlock = new ByteVector[100];
    private int mDataCacheIndex = 4;
    private static final int MSG_QUIT = 0;
    private static final int MSG_INIT = 1;
    private static final int MSG_ALLOW_PSNR_STATISTICS = 2;
    private static final int MSG_PSNR_COEF = 3;
    private static final int MSG_REESET_DECODER = 4;
    private static final int MSG_DECODER_HEADER = 5;
    private static final int MSG_DECODER_FRAME = 6;
    private static final int MSG_READ_ORIGINAL_YUV = 7;
    private static final int MSG_RESET_TEXTURE_CHANGE_SIZE = 8;
    private static final byte[] StartCode = new byte[]{0, 0, 0, 1};
    public AtomicBoolean mStartCaptureFlag = new AtomicBoolean(false);
    public AtomicBoolean mHasCaptureFlag = new AtomicBoolean(false);
    private int mDecodedFrameFormat;
    private int mRealTexture = -1;
    private String mDecodedPts = "";
    private ConcurrentHashMap<Long, Integer> mTextureIdMap = new ConcurrentHashMap();
    private ConcurrentHashMap<Long, byte[]> mOriginalDataMap = new ConcurrentHashMap();
    private ConcurrentHashMap<Long, byte[]> mDecodeDataMap = new ConcurrentHashMap();
    private int mCaptureNum = 1;
    private ConcurrentLinkedQueue<byte[]> mOriginalYuvDataList = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<byte[]> mDecodedYuvDataList = new ConcurrentLinkedQueue();
    private Boolean mStreamHeaderFeeding = false;
    private int[] mCopyOriginalFrameBuffer;
    private TextureStruct mTextureStruct = null;
    private int mTotalDecodingFrames = 0;
    private static boolean mDisable = false;

    public VideoQoeFilter(VideoLiveFilterContext mFilterContext) {
        this.mFilterContext = mFilterContext;
        this.mDecoderConfig = new DecodeVideoConfig();
        this.spsSample = YYMediaSampleAlloc.instance().alloc();
        this.ppsSample = YYMediaSampleAlloc.instance().alloc();
        this.mDecoderHeader = YYMediaSampleAlloc.instance().alloc();
        this.mTextureStruct = new TextureStruct(this.mCaptureNum);
        this.mDataCacheBlock = new ByteVector[100];
        for (int index = 0; index < 100; ++index) {
            this.mDataCacheBlock[index] = new ByteVector(0);
            this.mDataCacheBlock[index].clear();
        }
        this.mDataCacheIndex = 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getDataCacheByteArray(int size) {
        ByteVector vector;
        if (this.mDataCacheIndex >= 96) {
            YMFLog.info(this, "[Decoder ]", " decode data too mach");
            this.resetAllFlag();
        }
        VideoQoeFilter videoQoeFilter = this;
        synchronized (videoQoeFilter) {
            vector = this.mDataCacheBlock[this.mDataCacheIndex++];
        }
        vector.clear();
        vector.reserve(size);
        return vector.getBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getDataCacheByteArrayByteIndex(int index, int size) {
        ByteVector vector;
        VideoQoeFilter videoQoeFilter = this;
        synchronized (videoQoeFilter) {
            vector = this.mDataCacheBlock[index];
        }
        vector.clear();
        vector.reserve(size);
        return vector.getBytes();
    }

    private void release(CountDownLatch lock) {
        YMFLog.info(this, "[Decoder ]", " handler release");
        this.deInitDecoder();
        this.deInitEgl();
        lock.countDown();
        Thread.currentThread().interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetAllFlag() {
        VideoQoeFilter videoQoeFilter = this;
        synchronized (videoQoeFilter) {
            this.mTextureIdMap.clear();
            this.mOriginalDataMap.clear();
            this.mDecodeDataMap.clear();
            this.mPsnrStatisticsFlag.set(false);
            this.mDecodingFlag.set(false);
            this.mStartCaptureFlag.set(false);
            this.mHasCaptureFlag.set(false);
            this.mStreamHeaderFeeding = false;
            this.mTotalDecodingFrames = 0;
            this.mDecodedPts = "";
            this.mRealTexture = -1;
            for (int i = 0; i < this.mTextureStruct.IsUsed.length; ++i) {
                this.mTextureStruct.IsUsed[i] = false;
            }
            YMFLog.info(this, "[Decoder ]", "resetAllFlag  mDataCacheIndex:" + this.mDataCacheIndex);
            this.mDataCacheIndex = 4;
        }
    }

    private void createBlender(VideoEncoderType encodeType) {
        if (encodeType != VideoEncoderType.SOFT_ENCODER_X264) {
            this.mUsedBlender.set(true);
        } else {
            this.mUsedBlender.set(false);
        }
        if (this.mUsedBlender.get() && this.mGLBlender == null) {
            long begin = System.currentTimeMillis();
            this.mGLBlender = new GlTextureBlender(this.mFilterContext);
            YMFLog.info(this, "[Decoder ]", " createBlender cost:" + (System.currentTimeMillis() - begin));
        }
    }

    @Override
    public boolean processMediaSample(YYMediaSample sample, Object upstream) {
        if (mDisable) {
            return false;
        }
        try {
            if (upstream instanceof AbstractEncoderFilter) {
                this.processEncodedMediaSample(sample, upstream);
            } else if (upstream instanceof VideoEncoderGroupFilter) {
                this.processMutilOriginalMediaSample(sample, upstream);
            }
        }
        catch (Exception e) {
            YMFLog.warn(TAG, "[Encoder ]", "processMediaSample exception:" + e.toString());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processMutilOriginalMediaSample(YYMediaSample sample, Object upstream) {
        if (this.mPsnrStatisticsFlag.get() && this.mStartCaptureFlag.get()) {
            if (!this.mTextureStruct.checkImageSize(sample.mEncodeWidth, sample.mEncodeHeight)) {
                this.mWorkerHandler.sendMessage(this.mWorkerHandler.obtainMessage(8));
                return false;
            }
            long beginTime = System.currentTimeMillis();
            this.mCopyTextureId = !this.mUsedBlender.get() ? sample.mBlenderTextureId : this.mGLBlender.blend(sample, this.mFilterContext.getWatermarkTextureID(), this.mFilterContext.getDynamicTextureID(), this.mFilterContext.getPictureInPictureFlag() && this.mFilterContext.getSwithPictureFlag());
            int texture = -1;
            for (int i = 0; i < this.mTextureStruct.textures.length; ++i) {
                if (this.mTextureStruct.IsUsed[i].booleanValue()) continue;
                texture = this.mTextureStruct.textures[i];
                this.mTextureStruct.IsUsed[i] = true;
                break;
            }
            if (texture != -1) {
                YMFLog.info(this, "[CCapture]", "capture last texture:" + texture);
                GLES20.glBindTexture((int)3553, (int)0);
                GLES20.glBindFramebuffer((int)36160, (int)this.mCopyOriginalFrameBuffer[0]);
                GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.mCopyTextureId, (int)0);
                GLES20.glBindTexture((int)3553, (int)texture);
                GlUtil.checkGlError("processOriginalMediaSample bind");
                GLES20.glCopyTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)0, (int)0, (int)sample.mEncodeWidth, (int)sample.mEncodeHeight);
                GlUtil.checkGlError("processOriginalMediaSample copy");
                GLES20.glBindFramebuffer((int)36160, (int)0);
                GLES20.glBindTexture((int)3553, (int)0);
            }
            if (this.mFilterContext.mUsedPbo.booleanValue() && this.mRealTexture == -1) {
                YMFLog.info(this, "[Procedur]", "used pbo will used the last pts");
                this.mRealTexture = texture;
                return false;
            }
            if (!this.mFilterContext.mUsedPbo.booleanValue()) {
                YMFLog.info(this, "[Procedur]", "unused pbo");
                this.mRealTexture = texture;
            }
            this.mTextureIdMap.put(sample.mYYPtsMillions, new Integer(this.mRealTexture));
            this.mRealTexture = texture;
            GlUtil.checkGlError("processOriginalMediaSample over");
            if (this.mTextureIdMap.size() == this.mCaptureNum) {
                VideoQoeFilter videoQoeFilter = this;
                synchronized (videoQoeFilter) {
                    this.mStartCaptureFlag.set(false);
                    this.mHasCaptureFlag.set(true);
                    YMFLog.info(this, "[CCapture]", "capture  texture " + this.mCaptureNum);
                }
                this.mWorkerHandler.sendMessageDelayed(this.mWorkerHandler.obtainMessage(7), 500L);
            }
            YMFLog.info(this, "[Encoder ]", "copy texture OK, pts:" + sample.mYYPtsMillions + "," + sample.mEncodeWidth + "*" + sample.mEncodeHeight + " cost:" + (System.currentTimeMillis() - beginTime));
        } else if (this.mTextureIdMap.size() != 0 && this.mTextureIdMap.size() != this.mCaptureNum) {
            this.resetAllFlag();
        }
        return false;
    }

    private boolean processEncodedMediaSample(YYMediaSample sample, Object upstream) {
        this.createBlender(sample.mEncoderType);
        if (this.mWorkerHandler == null) {
            this.initWorkerHandler();
        }
        if (this.mWidth != this.mFilterContext.getVideoEncoderConfig().getEncodeWidth() || this.mHeight != this.mFilterContext.getVideoEncoderConfig().getEncodeHeight() || this.mDecodeType != sample.mEncoderType) {
            this.mWorkerHandler.sendMessage(this.mWorkerHandler.obtainMessage(4));
        }
        if (!this.mPsnrStatisticsFlag.get()) {
            return false;
        }
        if (sample.mEncoderType != VideoEncoderType.HARD_ENCODER_H265 && sample.mFrameType == 4 || sample.mFrameFlag == 1) {
            this.getStreamHeader(upstream);
            byte[] data = this.getDataCacheByteArray(sample.mBufferSize);
            sample.mDataByteBuffer.rewind();
            sample.mDataByteBuffer.get(data, 0, sample.mBufferSize);
            this.checkAndRecoverStartCode(data, sample.mBufferSize);
            long pts = sample.mYYPtsMillions;
            FrameStruct frameStruct = new FrameStruct(data, sample.mBufferSize, pts, sample.mEncoderType);
            if (!this.mStreamHeaderFeeding.booleanValue()) {
                this.mWorkerHandler.sendMessage(this.mWorkerHandler.obtainMessage(5, (Object)frameStruct));
                this.mStreamHeaderFeeding = true;
            } else {
                this.mWorkerHandler.sendMessage(this.mWorkerHandler.obtainMessage(6, (Object)frameStruct));
            }
            this.mDecodingFlag.set(true);
        } else if (this.mDecodingFlag.get()) {
            byte[] data = this.getDataCacheByteArray(sample.mBufferSize);
            sample.mDataByteBuffer.rewind();
            sample.mDataByteBuffer.get(data, 0, sample.mBufferSize);
            this.checkAndRecoverStartCode(data, sample.mBufferSize);
            long pts = sample.mYYPtsMillions;
            FrameStruct frameStruct = new FrameStruct(data, sample.mBufferSize, pts, sample.mEncoderType);
            this.mWorkerHandler.sendMessage(this.mWorkerHandler.obtainMessage(6, (Object)frameStruct));
        } else {
            return false;
        }
        return false;
    }

    private void checkAndRecoverStartCode(byte[] data, int len) {
        if (len > 4 && (data[0] != 0 || data[1] != 0 || data[2] != 0 || data[3] != 1)) {
            int size = 0;
            while (size + 4 < len) {
                int naluSize = data[size] << 24 | data[size + 1] << 16 | data[size + 2] << 8 | data[size + 3];
                data[size] = 0;
                data[size + 1] = 0;
                data[size + 2] = 0;
                data[size + 3] = 1;
                size += naluSize + 4;
            }
        }
    }

    private void addStartCode(YYMediaSample sampler) {
        byte[] sps = this.getDataCacheByteArrayByteIndex(sampler.mFrameType == 5 ? 0 : 1, sampler.mBufferSize + 4);
        sps[3] = 1;
        byte[] tmpSps = this.getDataCacheByteArrayByteIndex(2, sampler.mBufferSize);
        sampler.mDataByteBuffer.rewind();
        sampler.mDataByteBuffer.get(tmpSps, 0, sampler.mBufferSize);
        System.arraycopy(tmpSps, 0, sps, 4, sampler.mBufferSize);
        sampler.mDataByteBuffer = ByteBuffer.wrap(sps);
        sampler.mBufferSize += 4;
    }

    private void jointSpsPPs(YYMediaSample sps, YYMediaSample pps) {
        byte[] header = this.getDataCacheByteArrayByteIndex(2, sps.mBufferSize + pps.mBufferSize);
        byte[] spsData = this.getDataCacheByteArrayByteIndex(0, sps.mBufferSize);
        byte[] ppsData = this.getDataCacheByteArrayByteIndex(1, pps.mBufferSize);
        sps.mDataByteBuffer.get(spsData, 0, sps.mBufferSize);
        pps.mDataByteBuffer.get(ppsData, 0, pps.mBufferSize);
        System.arraycopy(spsData, 0, header, 0, sps.mBufferSize);
        System.arraycopy(ppsData, 0, header, sps.mBufferSize, pps.mBufferSize);
        this.mDecoderHeader.mDataByteBuffer = ByteBuffer.wrap(header);
        this.mDecoderHeader.mBufferSize = sps.mBufferSize + pps.mBufferSize;
    }

    private void getStreamHeader(Object upStream) {
        if (upStream instanceof H265HardwareEncoderFilter) {
            this.mDecoderHeader.assigne(((H265HardwareEncoderFilter)upStream).mSpsSample);
        } else if (upStream instanceof H264HardwareEncoderFilter) {
            this.spsSample.assigne(((H264HardwareEncoderFilter)upStream).mSpsSample);
            this.ppsSample.assigne(((H264HardwareEncoderFilter)upStream).mPpsSample);
            this.mDecoderHeader.assigne(((H264HardwareEncoderFilter)upStream).mSpsSample);
            this.addStartCode(this.spsSample);
            this.addStartCode(this.ppsSample);
            this.jointSpsPPs(this.spsSample, this.ppsSample);
            YMFLog.info(this, "[Encoder ]", "SPS and pps is OK");
        } else if (upStream instanceof X264SoftEncoderFilter) {
            this.spsSample.assigne(((X264SoftEncoderFilter)upStream).mSpsSample);
            this.ppsSample.assigne(((X264SoftEncoderFilter)upStream).mPpsSample);
            this.mDecoderHeader.assigne(((X264SoftEncoderFilter)upStream).mSpsSample);
            this.addStartCode(this.spsSample);
            this.addStartCode(this.ppsSample);
            this.jointSpsPPs(this.spsSample, this.ppsSample);
            YMFLog.info(this, "[Encoder ]", "SPS and pps is OK");
        } else {
            YMFLog.warn(this, "[Encoder ]", "getStreamHeader someThing wrong");
        }
    }

    private void readYuvFromTextureFromTexture(Long pts, int texture) {
        if (texture == -1) {
            YMFLog.error((Object)this, "[Encoder ]", "readYuvFromTextureFromTexture:" + texture);
            return;
        }
        GLES20.glBindFramebuffer((int)36160, (int)this.mCopyOriginalFrameBuffer[1]);
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)texture, (int)0);
        byte[] originalData = this.mOriginalYuvDataList.poll();
        if (originalData == null) {
            originalData = new byte[this.mWidth * this.mHeight * 4];
        }
        if (originalData != null && originalData.length != this.mWidth * this.mHeight * 4) {
            originalData = new byte[this.mWidth * this.mHeight * 4];
        }
        if (this.mOriginalByteBuffer == null || this.mOriginalByteBuffer.limit() != originalData.length) {
            this.mOriginalByteBuffer = ByteBuffer.allocate(this.mWidth * this.mHeight * 4);
            this.mOriginalByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        GLES20.glFinish();
        this.mOriginalByteBuffer.rewind();
        GLES20.glReadPixels((int)0, (int)0, (int)this.mWidth, (int)this.mHeight, (int)6408, (int)5121, (Buffer)this.mOriginalByteBuffer);
        this.mOriginalByteBuffer.rewind();
        this.mOriginalByteBuffer.get(originalData);
        GLES20.glBindFramebuffer((int)36160, (int)0);
        YMFLog.info(this, "[Encoder ]", "readYuvFromTextureFromTexture:" + texture);
        GlUtil.checkGlError("readYuvFromTextureFromTexture error");
        this.mOriginalDataMap.put(pts, originalData);
    }

    private void InitEgl() {
        YMFLog.info(this, "[Procedur]", "InitEgl begin");
        int flag = 1;
        if ((Build.MODEL.equalsIgnoreCase("M355") || Build.MODEL.equalsIgnoreCase("M351") || Build.MODEL.equalsIgnoreCase("GT-I9500")) && Build.VERSION.SDK_INT == 19 || Build.MODEL.equalsIgnoreCase("vivo X3t") || Build.MODEL.equalsIgnoreCase("2013023") || Build.MODEL.equalsIgnoreCase("Lenovo K900")) {
            flag = 0;
        }
        this.mShotEglCore = EglFactory.createEGL(this.mFilterContext.getGLManager().getEglCore().getEGLContext(), flag);
        this.mShotEnvSurface = this.mShotEglCore.createSurfaceBase();
        this.mShotEnvSurface.createOffscreenSurface(this.mWidth, this.mHeight);
        this.mShotEglCore.makeCurrent(this.mShotEnvSurface);
        this.mTextureStruct.textures = new int[this.mCaptureNum];
        GLES20.glGenTextures((int)this.mCaptureNum, (int[])this.mTextureStruct.textures, (int)0);
        this.mTextureStruct.height = 1280;
        this.mTextureStruct.width = 1280;
        for (int i = 0; i < this.mTextureStruct.textures.length; ++i) {
            GLES20.glBindTexture((int)3553, (int)this.mTextureStruct.textures[i]);
            GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
            GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
            GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
            GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
            GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)this.mTextureStruct.width, (int)this.mTextureStruct.height, (int)0, (int)6408, (int)5121, null);
            this.mTextureStruct.IsUsed[i] = false;
            this.mTextureStruct.psts[i] = 0L;
        }
        this.mCopyOriginalFrameBuffer = new int[2];
        GLES20.glGenFramebuffers((int)2, (int[])this.mCopyOriginalFrameBuffer, (int)0);
        YMFLog.info(this, "[Procedur]", "InitEgl done");
    }

    private void deInitEgl() {
        YMFLog.info(this, "[Procedur]", "deInitEgl begin");
        if (this.mTextureStruct.textures.length > 0) {
            GLES20.glDeleteTextures((int)this.mTextureStruct.textures.length, (int[])this.mTextureStruct.textures, (int)0);
            this.mTextureStruct = null;
        }
        GLES20.glDeleteBuffers((int)this.mCopyOriginalFrameBuffer.length, (int[])this.mCopyOriginalFrameBuffer, (int)0);
        if (this.mGLBlender != null) {
            this.mGLBlender.destroy();
            this.mGLBlender = null;
        }
        if (this.mShotEnvSurface != null) {
            this.mShotEglCore.makeNothingCurrent();
            this.mShotEnvSurface.releaseEglSurface();
            this.mShotEnvSurface = null;
        }
        if (this.mShotEglCore != null) {
            this.mShotEglCore = null;
        }
        YMFLog.info(this, "[Procedur]", "deInitEgl done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void InitDecoder() {
        if (this.mFilterContext.mVideoEncoderConfig != null) {
            this.mDecodeType = this.mFilterContext.mVideoEncoderConfig.mEncodeType;
            this.mWidth = this.mFilterContext.mVideoEncoderConfig.mEncodeWidth;
            this.mHeight = this.mFilterContext.mVideoEncoderConfig.mEncodeHeight;
            this.mDecoderConfig.width = this.mWidth;
            this.mDecoderConfig.height = this.mHeight;
        }
        if (this.mHeight <= 0 || this.mWidth <= 0) {
            YMFLog.info(this, "[Decoder ]", "InitOrResetDecoder error, width:" + this.mHeight + ", height:" + this.mWidth);
            return;
        }
        VideoQoeFilter videoQoeFilter = this;
        synchronized (videoQoeFilter) {
            if (this.mDecodeType == VideoEncoderType.HARD_ENCODER_H264 || this.mDecodeType == VideoEncoderType.SOFT_ENCODER_X264) {
                this.mHardwareDecoder = new H264HardwareDecoder(this.mWidth, this.mHeight);
                this.mDecoderConfig.mCodecType = "video/avc";
            } else if (this.mDecodeType == VideoEncoderType.HARD_ENCODER_H265) {
                this.mHardwareDecoder = new H265HardwareDecoder(this.mWidth, this.mHeight);
                this.mDecoderConfig.mCodecType = "video/hevc";
            }
            this.mHardwareDecoder.setOnDecoderYUVListener(this);
            this.mHardwareDecoder.initDecoder(this.mDecoderConfig);
            YMFLog.info(this, "[Decoder ]", "InitDecoder done, type:" + (Object)((Object)this.mDecodeType) + " width:" + this.mWidth + " height:" + this.mHeight);
        }
    }

    private void deInitDecoder() {
        YMFLog.info(this, "[Decoder ]", "deInitDecoder begin");
        if (this.mHardwareDecoder != null) {
            this.mHardwareDecoder.release();
            this.mHardwareDecoder = null;
        }
    }

    private void resetDecoder() {
        if (this.mWidth == this.mFilterContext.getVideoEncoderConfig().getEncodeWidth() && this.mHeight == this.mFilterContext.getVideoEncoderConfig().getEncodeHeight() && this.mDecodeType == this.mFilterContext.getVideoEncoderConfig().mEncodeType) {
            YMFLog.info(this, "[Decoder ]", "no need resetDecoder");
            return;
        }
        this.deInitDecoder();
        this.InitDecoder();
        this.resetAllFlag();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetTexture() {
        VideoQoeFilter videoQoeFilter = this;
        synchronized (videoQoeFilter) {
            if ((this.mTextureStruct.width < this.mFilterContext.mVideoEncoderConfig.mEncodeWidth || this.mTextureStruct.height < this.mFilterContext.mVideoEncoderConfig.mEncodeHeight) && this.mTextureStruct.textures.length > 0) {
                GLES20.glDeleteTextures((int)this.mTextureStruct.textures.length, (int[])this.mTextureStruct.textures, (int)0);
                this.mTextureStruct.width = Math.max(this.mTextureStruct.width, this.mFilterContext.mVideoEncoderConfig.mEncodeWidth);
                this.mTextureStruct.height = Math.max(this.mTextureStruct.height, this.mFilterContext.mVideoEncoderConfig.mEncodeHeight);
                GLES20.glGenTextures((int)this.mCaptureNum, (int[])this.mTextureStruct.textures, (int)0);
                for (int i = 0; i < this.mTextureStruct.textures.length; ++i) {
                    GLES20.glBindTexture((int)3553, (int)this.mTextureStruct.textures[i]);
                    GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
                    GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
                    GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
                    GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
                    GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)this.mTextureStruct.width, (int)this.mTextureStruct.height, (int)0, (int)6408, (int)5121, null);
                    this.mTextureStruct.IsUsed[i] = false;
                    this.mTextureStruct.psts[i] = 0L;
                }
                YMFLog.info(this, "[Procedur]", " resetTexture:" + this.mTextureStruct.width + "*" + this.mTextureStruct.height);
            }
        }
    }

    private void initWorkerEnv() {
        YMFLog.info(this, "[Procedur]", "initWorkerEnv begin");
        this.InitDecoder();
        this.InitEgl();
        YMFLog.info(this, "[Procedur]", "initWorkerEnv end");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deInit() {
        super.deInit();
        VideoQoeFilter videoQoeFilter = this;
        synchronized (videoQoeFilter) {
            if (this.mGLBlender != null) {
                this.mGLBlender.destroy();
                this.mGLBlender = null;
            }
            this.mOriginalYuvDataList.clear();
            this.mDecodedYuvDataList.clear();
            this.spsSample.decRef();
            this.ppsSample.decRef();
            if (this.mWorkerHandler != null) {
                this.mWorkerHandler.removeCallbacksAndMessages(null);
                CountDownLatch releaseDone = new CountDownLatch(1);
                this.mWorkerHandler.sendMessage(this.mWorkerHandler.obtainMessage(0, (Object)releaseDone));
                try {
                    releaseDone.await(500L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    YMFLog.error((Object)this, "[Procedur]", "deInit await exception:" + e.toString());
                }
            }
            YMFLog.info(this, "[Procedur]", "deInit done ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getYUVFromShotSurface() {
        if (this.mTextureIdMap.size() == this.mCaptureNum) {
            VideoQoeFilter videoQoeFilter = this;
            synchronized (videoQoeFilter) {
                for (Long pts : this.mTextureIdMap.keySet()) {
                    this.readYuvFromTextureFromTexture(pts, this.mTextureIdMap.get(pts));
                }
            }
            if (this.mDecodeDataMap.size() == this.mCaptureNum && this.mOriginalDataMap.size() == this.mCaptureNum) {
                this.mPsnrStatisticsFlag.set(false);
                this.processPsnrCoefs();
            }
        }
    }

    private void processPsnrCoefs() {
        if (this.mDecodeDataMap.size() == this.mCaptureNum && this.mOriginalDataMap.size() == this.mCaptureNum) {
            double result = 0.0;
            Iterator iterator = this.mOriginalDataMap.keySet().iterator();
            while (iterator.hasNext()) {
                long pts = (Long)iterator.next();
                if (this.mOriginalDataMap.get(pts) == null || this.mDecodeDataMap.get(pts) == null) {
                    YMFLog.error((Object)this, "[Decoder ]", "processPsnrCoef data error!");
                    return;
                }
                double psnr = 0.0;
                byte[] converter = this.getDataCacheByteArrayByteIndex(3, this.mWidth * this.mHeight + (this.mWidth + 1) / 2 * ((this.mHeight + 1) / 2) * 2);
                psnr = this.mDecodedFrameFormat == 35 ? ImageUtil.psnrCoefRGBA2I420(this.mOriginalDataMap.get(pts), this.mDecodeDataMap.get(pts), converter, this.mWidth, this.mHeight) : ImageUtil.psnrCoefRGBA2NV12(this.mOriginalDataMap.get(pts), this.mDecodeDataMap.get(pts), converter, this.mWidth, this.mHeight);
                YMFLog.info(this, "[Decoder ]", "processPsnrCoef  PTS:" + pts + " psnr:" + psnr);
                result += psnr;
                this.mDecodedYuvDataList.add(this.mDecodeDataMap.get(pts));
                this.mOriginalYuvDataList.add(this.mOriginalDataMap.get(pts));
            }
            YMFLog.info(this, "[Decoder ]", "processPsnrCoef:" + result / (double)this.mCaptureNum);
            UploadStatManager.getInstance().putVideoPsnr(result / (double)this.mCaptureNum);
            this.resetAllFlag();
        }
    }

    private void initWorkerHandler() {
        if (this.mWorkerHandler != null) {
            YMFLog.info(this, "[Procedur]", "workder handle has already been inited.");
            return;
        }
        this.mHandlerThread = new HandlerThread("YY_yyvideolib_psnr_Thread");
        this.mHandlerThread.start();
        this.mWorkerHandler = new WorkerHandler(this, this.mHandlerThread.getLooper());
        this.mWorkerHandler.sendMessage(this.mWorkerHandler.obtainMessage(1));
        this.mWorkerHandler.sendMessageDelayed(this.mWorkerHandler.obtainMessage(2), (long)this.mFilterContext.mLoopTime);
        YMFLog.info(this, "[Procedur]", "initWorkerHandler");
    }

    private void allowPsnrStatisticsFlag() {
        this.mPsnrStatisticsFlag.set(true);
        YMFLog.info(this, "[Procedur]", "allowPsnrStatisticsFlag");
        this.mWorkerHandler.sendMessageDelayed(this.mWorkerHandler.obtainMessage(2), (long)this.mFilterContext.mLoopTime);
    }

    @Override
    public boolean onVerifyPts(long pts) {
        this.mDecodedPts = this.mDecodedPts + "," + pts;
        return this.mTextureIdMap.get(pts) != null;
    }

    private byte[] getYUVFormImage(Image image, byte[] data) {
        Rect crop = image.getCropRect();
        int format = image.getFormat();
        int width = crop.width();
        int height = crop.height();
        Image.Plane[] planes = image.getPlanes();
        ByteBuffer buffer = null;
        int offset = 0;
        byte[] rowData = new byte[planes[0].getRowStride()];
        for (int i = 0; i < planes.length; ++i) {
            int shift = i == 0 ? 0 : 1;
            buffer = planes[i].getBuffer();
            int rowStride = planes[i].getRowStride();
            int pixelStride = planes[i].getPixelStride();
            YMFLog.info(this, "[Decoder ]", " pixelStride:" + pixelStride);
            YMFLog.info(this, "[Decoder ]", " rowStride:" + rowStride);
            YMFLog.info(this, "[Decoder ]", " width:" + width);
            YMFLog.info(this, "[Decoder ]", " height:" + height);
            int w = crop.width() >> shift;
            int h = crop.height() >> shift;
            buffer.position(rowStride * (crop.top >> shift) + pixelStride * (crop.left >> shift));
            for (int row = 0; row < h; ++row) {
                int length;
                int bytesPerPixel = ImageFormat.getBitsPerPixel((int)format) / 8;
                if (pixelStride == bytesPerPixel) {
                    length = w * bytesPerPixel;
                    buffer.get(data, offset, length);
                    offset += length;
                } else {
                    length = (w - 1) * pixelStride + bytesPerPixel;
                    buffer.get(rowData, 0, length);
                    for (int col = 0; col < w; ++col) {
                        data[offset++] = rowData[col * pixelStride];
                    }
                }
                if (row >= h - 1) continue;
                buffer.position(buffer.position() + rowStride - length);
            }
        }
        return data;
    }

    @Override
    public void OnDecoderError() {
        mDisable = true;
        YMFLog.error((Object)this, "[Decoder ]", "Mediacodec Error!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void OnDecoderYUVListener(int width, int height, ByteBuffer data, Image image, int dataLen, long pts, int flag) {
        if (this.mTextureIdMap.get(pts) != null) {
            if (flag == 1) {
                VideoQoeFilter videoQoeFilter = this;
                synchronized (videoQoeFilter) {
                    this.resetAllFlag();
                    this.mPsnrStatisticsFlag.set(true);
                    YMFLog.info(this, "[Decoder ]", " capture IDR frame, begin reSample");
                }
                return;
            }
            if (width != this.mWidth || height != this.mHeight) {
                YMFLog.error((Object)this, "[Decoder ]", "OnDecoderYUVListener decode res:" + width + "*" + height + ", src:" + this.mWidth + "*" + this.mHeight);
                return;
            }
            VideoQoeFilter videoQoeFilter = this;
            synchronized (videoQoeFilter) {
                byte[] decodeData = this.mDecodedYuvDataList.poll();
                if (decodeData == null) {
                    decodeData = new byte[dataLen];
                }
                if (decodeData != null && decodeData.length != dataLen) {
                    decodeData = new byte[dataLen];
                }
                if (data != null) {
                    data.rewind();
                    data.get(decodeData);
                    this.mDecodedFrameFormat = 17;
                } else {
                    decodeData = this.getYUVFormImage(image, decodeData);
                    this.mDecodedFrameFormat = 35;
                }
                this.mDecodeDataMap.put(pts, decodeData);
                if (this.mDecodeDataMap.size() == this.mCaptureNum) {
                    this.mPsnrStatisticsFlag.set(false);
                }
            }
            YMFLog.info(this, "[Decoder ]", "OnDecoderYUVListener decoded data OK, dataLen:" + dataLen + " pts:" + pts);
            if (this.mOriginalDataMap.size() != this.mCaptureNum || this.mDecodeDataMap.size() != this.mCaptureNum) {
                return;
            }
            this.mWorkerHandler.sendMessage(this.mWorkerHandler.obtainMessage(3));
            return;
        }
    }

    public class FrameStruct {
        public byte[] data;
        public int dataLen;
        public long pts;
        public VideoEncoderType encoderType;

        public FrameStruct(byte[] data, int len, long pts, VideoEncoderType encoderType) {
            this.encoderType = encoderType;
            this.data = data;
            this.pts = pts;
            this.dataLen = len;
        }
    }

    private static class WorkerHandler
    extends Handler {
        private WeakReference<VideoQoeFilter> mWeakFilter;

        public WorkerHandler(VideoQoeFilter filter, Looper looper) {
            super(looper);
            this.mWeakFilter = new WeakReference<VideoQoeFilter>(filter);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            int what = msg.what;
            VideoQoeFilter videoQoeFilter = (VideoQoeFilter)this.mWeakFilter.get();
            if (videoQoeFilter == null) {
                YMFLog.warn((Object)this, "[Decoder ]", "handleMessage: VideoQoeFilter is null");
                return;
            }
            VideoQoeFilter videoQoeFilter2 = videoQoeFilter;
            synchronized (videoQoeFilter2) {
                block18: {
                    try {
                        switch (what) {
                            case 1: {
                                videoQoeFilter.initWorkerEnv();
                                break;
                            }
                            case 0: {
                                CountDownLatch lock = (CountDownLatch)msg.obj;
                                videoQoeFilter.release(lock);
                                break;
                            }
                            case 2: {
                                videoQoeFilter.allowPsnrStatisticsFlag();
                                break;
                            }
                            case 3: {
                                videoQoeFilter.processPsnrCoefs();
                                break;
                            }
                            case 4: {
                                videoQoeFilter.resetDecoder();
                                break;
                            }
                            case 5: {
                                FrameStruct frameStruct = (FrameStruct)msg.obj;
                                boolean change = videoQoeFilter.mHardwareDecoder.decoderHeaderChange(((VideoQoeFilter)videoQoeFilter).mDecoderHeader.mDataByteBuffer.array(), ((VideoQoeFilter)videoQoeFilter).mDecoderHeader.mBufferSize);
                                if (change) {
                                    videoQoeFilter.mHardwareDecoder.drainDecoder(((VideoQoeFilter)videoQoeFilter).mDecoderHeader.mDataByteBuffer.array(), ((VideoQoeFilter)videoQoeFilter).mDecoderHeader.mBufferSize, true, ((VideoQoeFilter)videoQoeFilter).mDecoderHeader.mYYPtsMillions);
                                }
                                videoQoeFilter.mHardwareDecoder.drainDecoder(frameStruct.data, frameStruct.dataLen, false, frameStruct.pts);
                                if (videoQoeFilter.mStartCaptureFlag.get() || videoQoeFilter.mHasCaptureFlag.get()) break;
                                videoQoeFilter.mStartCaptureFlag.set(true);
                                YMFLog.info((Object)this, "[Decoder ]", " mHardwareDecoder drainDecoder header and key frame:" + frameStruct.pts);
                                break;
                            }
                            case 6: {
                                FrameStruct frame = (FrameStruct)msg.obj;
                                videoQoeFilter.mHardwareDecoder.drainDecoder(frame.data, frame.dataLen, false, frame.pts);
                                videoQoeFilter.mTotalDecodingFrames++;
                                if (videoQoeFilter.mTotalDecodingFrames <= 91) break;
                                YMFLog.info((Object)this, "[Decoder ]", "drainDecoder 100 frames pts:" + videoQoeFilter.mDecodedPts);
                                videoQoeFilter.resetAllFlag();
                                break;
                            }
                            case 7: {
                                videoQoeFilter.getYUVFromShotSurface();
                                break;
                            }
                            case 8: {
                                videoQoeFilter.resetTexture();
                                break;
                            }
                        }
                    }
                    catch (Exception e) {
                        YMFLog.error((Object)this, "[Decoder ]", " handleMessage exception:" + YMFLog.stackTraceOf(e));
                        if (videoQoeFilter == null) break block18;
                        videoQoeFilter.resetAllFlag();
                    }
                }
            }
        }
    }

    public class TextureStruct {
        public long[] psts;
        public int[] textures;
        public Boolean[] IsUsed;
        public int width;
        public int height;

        public TextureStruct(int num) {
            this.psts = new long[num];
            this.IsUsed = new Boolean[num];
        }

        private boolean checkImageSize(int w, int h) {
            return w <= this.width && h <= this.height;
        }
    }
}

