/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.filters;

import android.os.Build;
import com.yy.mediaframework.ILiveSession;
import com.yy.mediaframework.base.VideoEncoderConfig;
import com.yy.mediaframework.base.VideoEncoderType;
import com.yy.mediaframework.filters.AbstractVideoLiveQualityFilter;
import com.yy.mediaframework.filters.VideoLiveFilterContext;
import com.yy.mediaframework.inteligence.coderate.DefaultCodeRateByFrame;
import com.yy.mediaframework.inteligence.coderate.ICodeRateByFrame;
import com.yy.mediaframework.inteligence.common.ResolutionModifyConfig;
import com.yy.mediaframework.inteligence.common.ResolutionModifyNotFoundException;
import com.yy.mediaframework.inteligence.framerate.AdjustFrameRateModify;
import com.yy.mediaframework.inteligence.framerate.CaptureSyncEncodeFrameRateModify;
import com.yy.mediaframework.inteligence.framerate.IFrameRateModify;
import com.yy.mediaframework.inteligence.resolution.DefaultResolutionModify;
import com.yy.mediaframework.inteligence.resolution.IResolutionModify;
import com.yy.mediaframework.inteligence.resolution.ResolutionModifyListener;
import com.yy.mediaframework.model.YYMediaSample;
import com.yy.mediaframework.utils.YMFLog;
import java.util.List;

public class VideoLiveQualityFilter
extends AbstractVideoLiveQualityFilter {
    VideoLiveFilterContext mFilterContext = null;
    protected static final int mCodeRateNotifyInterval = 3000;
    protected ICodeRateByFrame mCodeRateByFrame = null;
    protected IFrameRateModify mFrameRateModify = null;
    protected ILiveSession mLiveSession = null;
    protected List<ResolutionModifyConfig> mResolutionModifyConfigs = null;
    protected int mResolutionModifyInterval = 0;
    protected IResolutionModify mResolutionModify = null;
    protected boolean mHasAdaptor = false;
    protected int mSuggestCodeRate = 0;
    protected AbstractVideoLiveQualityFilter.IWeakerNetworkCallback mCallBack = null;
    protected boolean mUsedNewStrategy = true;
    protected ResolutionModifyListener mResolutionModifyListener = new ResolutionModifyListener(){

        public void onReceiveSuggestResolution2(int width, int height, int framerate, String encoderParams, VideoEncoderType type, int currentCodeRate) {
            VideoEncoderConfig encoderConfig = new VideoEncoderConfig(width, height, framerate, currentCodeRate, type, encoderParams);
            YMFLog.info(this, "[Encoder ]", "onReceiveSuggestResolution2:%dx%d -> %dx%d, frameRate:%d -> %d, suggest codeRate:%d, current codeRate:%d, VideoEncoderType:%s -> %s", new Object[]{encoderConfig.getEncodeWidth(), encoderConfig.getEncodeHeight(), width, height, encoderConfig.mFrameRate, framerate, VideoLiveQualityFilter.this.mSuggestCodeRate, currentCodeRate, VideoLiveQualityFilter.this.mFilterContext.mVideoEncoderConfig.mEncodeType, type});
            YMFLog.info(this, "[Encoder ]", "onReceiveSuggestResolution2 encode param:" + encoderConfig.mEncodeParameter + " -> " + encoderParams);
            if (VideoLiveQualityFilter.this.mCallBack != null) {
                VideoLiveQualityFilter.this.mCallBack.onReCreateEncoder(encoderConfig);
                VideoLiveQualityFilter.this.mCallBack.notifyInitEncoderParams(0, 0);
            }
        }

        @Override
        public void onReceiveSuggestResolution(int width, int height, int framerate, String encoderParams, VideoEncoderType type, int currentCodeRate) {
            if (VideoLiveQualityFilter.this.mUsedNewStrategy) {
                this.onReceiveSuggestResolution2(width, height, framerate, encoderParams, type, currentCodeRate);
                return;
            }
            VideoEncoderConfig encoderConfig = VideoLiveQualityFilter.this.mFilterContext.getVideoEncoderConfig();
            YMFLog.info(this, "[Encoder ]", "onReceiveSuggestResolution:%dx%d -> %dx%d, frameRate:%d -> %d, suggest codeRate:%d, current codeRate:%d, VideoEncoderType:%s -> %s", new Object[]{encoderConfig.getEncodeWidth(), encoderConfig.getEncodeHeight(), width, height, encoderConfig.mFrameRate, framerate, VideoLiveQualityFilter.this.mSuggestCodeRate, currentCodeRate, VideoLiveQualityFilter.this.mFilterContext.mVideoEncoderConfig.mEncodeType, type});
            YMFLog.info(this, "[Encoder ]", "onReceiveSuggestResolution encode param:" + encoderConfig.mEncodeParameter + " -> " + encoderParams);
            if (width == encoderConfig.getEncodeWidth() && height == encoderConfig.getEncodeHeight() && encoderParams.equals(encoderConfig.mEncodeParameter) && type == encoderConfig.mEncodeType) {
                return;
            }
            encoderConfig.setEncodeParam(encoderParams != null && !encoderParams.isEmpty() ? encoderParams : VideoLiveQualityFilter.this.mFilterContext.getDefaultVideoEncoderConfig().mEncodeParameter);
            if (width > 0 && height > 0) {
                encoderConfig.setEncodeSize(width, height);
                VideoLiveQualityFilter.this.mFilterContext.mVideoEncoderConfig.setEncodeSize(width, height);
            }
            if (framerate > 0) {
                encoderConfig.setFrameRate(framerate);
                VideoLiveQualityFilter.this.mFilterContext.mVideoEncoderConfig.setFrameRate(framerate);
            }
            encoderConfig.setBitRate(currentCodeRate);
            VideoLiveQualityFilter.this.mFilterContext.mVideoEncoderConfig.setBitRate(currentCodeRate);
            try {
                if (VideoLiveQualityFilter.this.mCodeRateByFrame != null) {
                    VideoLiveQualityFilter.this.mCodeRateByFrame.init(VideoLiveQualityFilter.this.mSuggestCodeRate, encoderConfig.mFrameRate, 3000, VideoLiveQualityFilter.this.mFilterContext.mGlManager.getHandler());
                }
                if (VideoLiveQualityFilter.this.mFrameRateModify instanceof AdjustFrameRateModify) {
                    try {
                        ((AdjustFrameRateModify)VideoLiveQualityFilter.this.mFrameRateModify).init(encoderConfig.mFrameRate, currentCodeRate, encoderConfig.getEncodeWidth(), encoderConfig.getEncodeHeight(), VideoLiveQualityFilter.this.mResolutionModifyConfigs);
                    }
                    catch (ResolutionModifyNotFoundException e) {
                        YMFLog.error(this, "[Encoder ]", "init FrameRateModify exception:%s", e.toString());
                        VideoLiveQualityFilter.this.mFrameRateModify = null;
                    }
                } else if (VideoLiveQualityFilter.this.mFrameRateModify instanceof CaptureSyncEncodeFrameRateModify) {
                    ((CaptureSyncEncodeFrameRateModify)VideoLiveQualityFilter.this.mFrameRateModify).reInit(encoderConfig.mFrameRate, currentCodeRate, encoderConfig.getEncodeWidth(), encoderConfig.getEncodeHeight(), VideoLiveQualityFilter.this.mResolutionModifyConfigs);
                }
            }
            catch (Throwable t) {
                YMFLog.info(this, "[Encoder ]", "onReceiveSuggestResolution exception:" + t);
            }
            if (!VideoLiveQualityFilter.this.mFilterContext.mVideoEncoderConfig.mEncodeType.equals((Object)type)) {
                YMFLog.info(this, "[Encoder ]", "encoder switch, set new encoder:%s", new Object[]{type});
                VideoLiveQualityFilter.this.mFilterContext.mVideoEncoderConfig.mEncodeType = type;
                encoderConfig.setEncodeType(type);
            }
        }
    };

    public VideoLiveQualityFilter(VideoLiveFilterContext filterContext, ILiveSession liveSession) {
        this.mFilterContext = filterContext;
        this.mLiveSession = liveSession;
        VideoEncoderConfig config = this.mFilterContext.getVideoEncoderConfig();
        if (config != null) {
            this.mSuggestCodeRate = config.mBitRate;
            this.mLastEncoderInitBitrate = 0;
            this.mLastEncoderInitFrameRate = 0;
        }
    }

    @Override
    public void setWeakNetworkCallback(AbstractVideoLiveQualityFilter.IWeakerNetworkCallback callback) {
        this.mCallBack = callback;
    }

    @Override
    public boolean processMediaSample(YYMediaSample sample, Object upstream) {
        if (this.mHasAdaptor && this.mFrameRateModify != null) {
            this.mFrameRateModify.onInterceptDoFrame(sample.mAndoridPtsNanos);
        }
        this.deliverToDownStream(sample);
        return super.processMediaSample(sample, upstream);
    }

    @Deprecated
    public void adjustEncoderBitrate(int suggestCodeRate) {
        YMFLog.info(this, "[Encoder ]", "adjustEncoderBitrate suggestCodeRate:%d", suggestCodeRate);
        this.mSuggestCodeRate = suggestCodeRate;
        this.mLiveSession.adjustEncoderBitrate(suggestCodeRate);
    }

    @Override
    public boolean setNetworkBitrateSuggest(int bitrate) {
        YMFLog.info(this, "[Encoder ]", "setNetworkBitrateSuggest:" + bitrate);
        boolean ret = false;
        if (this.mFrameRateModify != null) {
            this.mFrameRateModify.publishNetworkCodeRate(bitrate);
            if (this.mLastEncoderInitBitrate == 0 || bitrate < this.mLastEncoderInitBitrate) {
                this.mFilterContext.getVideoEncoderConfig().setBitRate(bitrate);
            }
            ret = true;
        }
        if (this.mResolutionModify != null) {
            this.mResolutionModify.publishNetworkCodeRate(bitrate);
            ret = true;
        }
        VideoEncoderConfig encoderConfig = this.mFilterContext.getVideoEncoderConfig();
        YMFLog.info(this, "[Encoder ]", "setNetworkBitrateSuggest:" + bitrate + " resolution:(%d x %d)", encoderConfig.getEncodeWidth(), encoderConfig.getEncodeHeight());
        if (this.mFrameRateModify != null) {
            this.mFrameRateModify.publishCurrentResolution(encoderConfig.getEncodeWidth(), encoderConfig.getEncodeHeight(), bitrate);
        }
        this.mSuggestCodeRate = bitrate;
        return ret;
    }

    private void estimateEncoderParamsAndReboot(int bitRate) {
        int framerate = 0;
        int configIdx = 0;
        ResolutionModifyConfig config = null;
        try {
            configIdx = ((CaptureSyncEncodeFrameRateModify)this.mFrameRateModify).mAjustFRModify.findConfigIdx(0, 0, bitRate);
            config = this.mResolutionModifyConfigs.get(configIdx);
            try {
                double diffCodeRate = config.maxCodeRate - config.minCodeRate;
                double ratioCodeRate = (double)(bitRate - config.minCodeRate) / diffCodeRate;
                int diffFrameRate = config.maxFrameRate - config.minFrameRate;
                framerate = (int)((float)diffFrameRate * (float)ratioCodeRate + (float)config.minFrameRate);
            }
            catch (Exception e) {
                YMFLog.error((Object)this, "[Encoder ]", e.toString());
            }
            if (framerate < 4) {
                framerate = 4;
            }
        }
        catch (Exception e) {
            YMFLog.error((Object)this, "[Encoder ]", " estimateRebootEncoder findConfigIdx error");
            return;
        }
        if (this.mResolutionModify != null && this.mResolutionModify instanceof DefaultResolutionModify) {
            ((DefaultResolutionModify)this.mResolutionModify).setLastTimestampNanos();
        }
        if (this.mResolutionModifyListener != null && config != null) {
            YMFLog.info(this, "[Encoder ]", "%d  %d  %d restart Encoder", configIdx, framerate, bitRate);
            this.mResolutionModifyListener.onReceiveSuggestResolution(config.width, config.height, framerate, config.encoderParams, config.videoEncoderType, bitRate);
            this.mCallBack.notifyInitEncoderParams(framerate, bitRate);
        }
    }

    @Override
    public void estimateRebootEncoder(int bitRate, int frameRate) {
        long now = System.nanoTime();
        long lastChangeResolutionTime = this.mResolutionModify == null ? now : ((DefaultResolutionModify)this.mResolutionModify).getLastTimestampNanos();
        lastChangeResolutionTime = lastChangeResolutionTime == 0L ? now : lastChangeResolutionTime;
        int expectFps = (int)this.getLastFrameRate();
        if (bitRate < this.mSuggestCodeRate / 2 && (double)(now - lastChangeResolutionTime) >= 1.2E9 && frameRate > expectFps - 3 && this.mFilterContext.mEnableUnderflowStrategy) {
            YMFLog.info(this, "[Encoder ]", "%d < %d / 2 in %d, underflow force reboot encoder", bitRate, frameRate, this.mSuggestCodeRate);
            if (this.mFrameRateModify != null && this.mFrameRateModify instanceof CaptureSyncEncodeFrameRateModify) {
                this.estimateEncoderParamsAndReboot(this.mSuggestCodeRate);
            }
        } else if ((double)bitRate > (double)this.mLastEncoderInitBitrate * 1.2 && frameRate > this.mLastEncoderInitFrameRate && this.mLastEncoderInitBitrate != 0 && this.mLastEncoderInitFrameRate != 0 && (double)(now - lastChangeResolutionTime) >= 1.2E9 && frameRate >= 4) {
            YMFLog.info(this, "[Encoder ]", "%d __ %d > %d ,%d > %d ,overflow so force reboot encoder", this.mSuggestCodeRate, bitRate, this.mLastEncoderInitBitrate, frameRate, this.mLastEncoderInitFrameRate);
            this.estimateEncoderParamsAndReboot(this.mSuggestCodeRate);
        }
    }

    @Override
    public void deInit() {
        this.mHasAdaptor = false;
        if (this.mCodeRateByFrame != null) {
            this.mCodeRateByFrame.release();
            this.mCodeRateByFrame = null;
        }
        if (this.mFrameRateModify != null) {
            this.mFrameRateModify.release();
            this.mFrameRateModify = null;
        }
        if (this.mResolutionModify != null) {
            this.mResolutionModify.release();
            this.mResolutionModify = null;
        }
    }

    @Override
    public boolean hasAdapator() {
        return this.mHasAdaptor;
    }

    @Override
    @Deprecated
    public void setEncodeStats(int bitRate, int frameRate) {
        if (this.mCodeRateByFrame != null) {
            this.mCodeRateByFrame.publishCurrentFrameRate(frameRate, bitRate);
            int suggestcode = this.mCodeRateByFrame.getSuggestCodeRate();
            this.adjustEncoderBitrate(suggestcode);
            YMFLog.info(this, "[Encoder ]", "Send SuggestCodeRate:" + suggestcode);
        } else {
            this.adjustEncoderBitrate(this.mSuggestCodeRate);
            YMFLog.info(this, "[Encoder ]", "Send SuggestCodeRate:" + this.mSuggestCodeRate);
        }
    }

    @Override
    public void installAdaptor() {
        if (this.mHasAdaptor) {
            return;
        }
        VideoEncoderConfig encoderConfig = this.mFilterContext.getVideoEncoderConfig();
        if (Build.VERSION.SDK_INT >= 19) {
            this.mCodeRateByFrame = new DefaultCodeRateByFrame();
            this.mCodeRateByFrame.init(encoderConfig.mBitRate, encoderConfig.mFrameRate, 3000, this.mFilterContext.mGlManager.getHandler());
        }
        if (this.mResolutionModifyConfigs != null && this.mResolutionModifyConfigs.size() > 0) {
            this.mFrameRateModify = new AdjustFrameRateModify();
            try {
                ((AdjustFrameRateModify)this.mFrameRateModify).init(encoderConfig.mFrameRate, encoderConfig.mBitRate, encoderConfig.getEncodeWidth(), encoderConfig.getEncodeHeight(), this.mResolutionModifyConfigs);
            }
            catch (ResolutionModifyNotFoundException e) {
                YMFLog.error(this, "[Encoder ]", "init FrameRateModify exception:%s", e.toString());
                this.mFrameRateModify = null;
            }
            try {
                this.mResolutionModify = new DefaultResolutionModify();
                ((DefaultResolutionModify)this.mResolutionModify).init(encoderConfig.mFrameRate, encoderConfig.mBitRate, encoderConfig.getEncodeWidth(), encoderConfig.getEncodeHeight(), this.mResolutionModifyInterval, this.mResolutionModifyConfigs, this.mResolutionModifyListener);
            }
            catch (ResolutionModifyNotFoundException e) {
                YMFLog.error(this, "[Encoder ]", "init ResolutinModify exception:%s", e.toString());
                this.mResolutionModify = null;
            }
        }
        this.mHasAdaptor = true;
    }

    @Override
    public void setResolutionModifyConfigs(List<ResolutionModifyConfig> configs, int intervalSecs) {
        YMFLog.info(this, "[Encoder ]", "setResolutionModifyConfigs, config.size:" + (configs == null ? 0 : configs.size()) + " intervalSecs:" + intervalSecs);
        if (null == configs) {
            YMFLog.error((Object)this, "[Encoder ]", "setResolutionModifyConfigs config == null");
            return;
        }
        for (int i = 0; i < configs.size(); ++i) {
            ResolutionModifyConfig config = configs.get(i);
            YMFLog.info(this, "[Encoder ]", "setResolutionModifyConfigs, config.part" + i + ":" + config.toString());
        }
        this.mResolutionModifyConfigs = configs;
        this.mResolutionModifyInterval = intervalSecs;
    }

    @Override
    public float getLastFrameRate() {
        if (this.mFrameRateModify != null) {
            return this.mFrameRateModify.getLastFrameRate();
        }
        return 0.0f;
    }

    @Override
    public void setLastFrameRate(float frameRate) {
        if (this.mFrameRateModify != null) {
            this.mFrameRateModify.setLastFrameRate(frameRate);
        }
    }

    @Override
    public void setLastNetWorkBitrate(int bitrate) {
        this.mSuggestCodeRate = bitrate;
        if (this.mFrameRateModify != null) {
            YMFLog.info(this, "[Encoder ]", "reboot setLastNetWorkBitrate=" + bitrate);
            this.mFrameRateModify.publishNetworkCodeRate(bitrate);
        }
    }
}

