/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.filters;

import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.yy.mediaframework.filters.AbstractYYMediaFilter;
import com.yy.mediaframework.model.YYMediaSample;
import com.yy.mediaframework.utils.YMFLog;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;

public class VideoFileRecordFilter
extends AbstractYYMediaFilter
implements Runnable {
    public static int mFileIndex = 1;
    public static final String sVideoDir = "YYVideo";
    private static final int MSG_FRAME_AVAIL = 1;
    private static final int MSG_QUIT = 2;
    public Thread mTaskThread = null;
    private Object mReadyFence = new Object();
    private boolean mReady = false;
    private Handler mHandler = null;
    DataOutputStream mDataOutput = null;
    private int mCnt = 0;

    public static String getVideoFileName() {
        String logFileName = null;
        String videoPath = null;
        File path = Environment.getExternalStorageDirectory();
        videoPath = path.toString();
        File file = new File(videoPath = videoPath + File.separator + sVideoDir);
        if (!file.exists() && !file.isDirectory()) {
            file.mkdir();
        }
        logFileName = videoPath + File.separator + "yyvideo-" + Thread.currentThread().getId() + mFileIndex++;
        return logFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        this.mTaskThread = new Thread((Runnable)this, "YY_yyvideolib_H264FileStore_Thread");
        this.mTaskThread.start();
        Object object = this.mReadyFence;
        synchronized (object) {
            while (!this.mReady) {
                try {
                    YMFLog.info(this, "[Encoder ]", "ready fence waitting");
                    this.mReadyFence.wait();
                    YMFLog.info(this, "[Encoder ]", "got ready fence ");
                }
                catch (InterruptedException ie) {
                    YMFLog.info(this, "[Encoder ]", "init exception:" + ie.getMessage());
                }
            }
        }
    }

    @Override
    public void deInit() {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                Looper loop = Looper.myLooper();
                if (null != loop) {
                    if (Build.VERSION.SDK_INT >= 18) {
                        loop.quitSafely();
                    } else {
                        loop.quit();
                    }
                }
            }
        });
        try {
            this.mTaskThread.join();
        }
        catch (InterruptedException e) {
            YMFLog.info(this, "[Encoder ]", "deinit exception:" + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        YMFLog.info(this, "[Encoder ]", "run before prepare");
        Looper.prepare();
        try {
            Object object = this.mReadyFence;
            synchronized (object) {
                this.mReady = true;
                this.mReadyFence.notify();
                YMFLog.info(this, "[Encoder ]", "run notify ready");
            }
            this.mHandler = new OutputStreamHandler(this);
            this.mDataOutput = new DataOutputStream(new FileOutputStream(VideoFileRecordFilter.getVideoFileName()));
            Looper.loop();
        }
        catch (Throwable t) {
            YMFLog.error((Object)this, "[Encoder ]", "encoder thread run exception:" + t.getMessage());
        }
        finally {
            YMFLog.info(this, "[Encoder ]", "encoder thread exiting");
            try {
                this.mDataOutput.flush();
                this.mDataOutput.close();
            }
            catch (IOException e) {
                YMFLog.error((Object)this, "[Encoder ]", "encoder thread exception:" + e.getMessage());
            }
            Object e = this.mReadyFence;
            synchronized (e) {
                this.mReady = false;
                this.mHandler = null;
            }
        }
    }

    @Override
    public boolean processMediaSample(YYMediaSample sample, Object upstream) {
        if (this.mHandler == null || sample.mBufferSize <= 0 || this.mCnt > 14400) {
            return false;
        }
        ++this.mCnt;
        byte[] data = new byte[sample.mBufferSize];
        sample.mDataByteBuffer.position(sample.mBufferOffset);
        sample.mDataByteBuffer.get(data, 0, sample.mBufferSize);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1, (Object)data));
        return false;
    }

    public boolean processMediaData(ByteBuffer buffer, int offset, int bufsize) {
        if (this.mHandler == null || buffer == null || bufsize <= 0 || this.mCnt > 14400) {
            return false;
        }
        ++this.mCnt;
        byte[] data = new byte[bufsize];
        int pos = buffer.position();
        buffer.position(offset);
        buffer.get(data, 0, bufsize);
        buffer.position(pos);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1, (Object)data));
        return false;
    }

    public void OutputStreamToFile(byte[] data) {
        try {
            this.mDataOutput.write(data, 0, data.length);
            this.mDataOutput.flush();
        }
        catch (IOException e) {
            YMFLog.error((Object)this, "[Encoder ]", "OutputStreamToFile exception:" + e.getMessage());
        }
    }

    private static class OutputStreamHandler
    extends Handler {
        private WeakReference<VideoFileRecordFilter> mWeakRecorder;

        public OutputStreamHandler(VideoFileRecordFilter recorder) {
            this.mWeakRecorder = new WeakReference<VideoFileRecordFilter>(recorder);
        }

        public void handleMessage(Message inputMessage) {
            int what = inputMessage.what;
            VideoFileRecordFilter recorder = (VideoFileRecordFilter)this.mWeakRecorder.get();
            if (recorder == null) {
                YMFLog.warn((Object)this, "[Encoder ]", "OutputStreamHandler handleMessage:encoder is null");
                return;
            }
            switch (what) {
                case 1: {
                    recorder.OutputStreamToFile((byte[])inputMessage.obj);
                    break;
                }
                case 2: {
                    if (Looper.myLooper() == null) break;
                    Looper.myLooper().quit();
                    break;
                }
                default: {
                    throw new RuntimeException("Unhandled msg what=" + what);
                }
            }
        }
    }
}

