/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.filters;

import com.yy.mediaframework.ILiveSession;
import com.yy.mediaframework.base.VideoEncoderConfig;
import com.yy.mediaframework.filters.VideoLiveFilterContext;
import com.yy.mediaframework.filters.VideoLiveQualityFilter;
import com.yy.mediaframework.inteligence.common.ResolutionModifyNotFoundException;
import com.yy.mediaframework.inteligence.framerate.AdjustFrameRateModify;
import com.yy.mediaframework.inteligence.resolution.DefaultResolutionModify;
import com.yy.mediaframework.utils.YMFLog;

public class SoftEncodeVideoLiveQualityFilter
extends VideoLiveQualityFilter {
    public SoftEncodeVideoLiveQualityFilter(VideoLiveFilterContext filterContext, ILiveSession liveSession) {
        super(filterContext, liveSession);
        YMFLog.info(this, "[Encoder ]", "SoftEncodeVideoLiveQualityFilter construct");
    }

    @Override
    public void installAdaptor() {
        if (this.mHasAdaptor) {
            return;
        }
        VideoEncoderConfig encoderConfig = this.mFilterContext.getVideoEncoderConfig();
        if (this.mResolutionModifyConfigs != null && this.mResolutionModifyConfigs.size() > 0) {
            this.mFrameRateModify = new AdjustFrameRateModify();
            try {
                ((AdjustFrameRateModify)this.mFrameRateModify).init(encoderConfig.mFrameRate, encoderConfig.mBitRate, encoderConfig.getEncodeWidth(), encoderConfig.getEncodeHeight(), this.mResolutionModifyConfigs);
            }
            catch (ResolutionModifyNotFoundException e) {
                YMFLog.error(this, "[Encoder ]", "init FrameRateModify exception:%s", e.toString());
                this.mFrameRateModify = null;
            }
            try {
                this.mResolutionModify = new DefaultResolutionModify();
                ((DefaultResolutionModify)this.mResolutionModify).init(encoderConfig.mFrameRate, encoderConfig.mBitRate, encoderConfig.getEncodeWidth(), encoderConfig.getEncodeHeight(), this.mResolutionModifyInterval, this.mResolutionModifyConfigs, this.mResolutionModifyListener);
            }
            catch (ResolutionModifyNotFoundException e) {
                YMFLog.error(this, "[Encoder ]", "init ResolutinModify exception:%s", e.toString());
                this.mResolutionModify = null;
            }
        }
        this.mHasAdaptor = true;
    }

    public void forceRebootEncoder(VideoEncoderConfig config) {
        config.mEncodeParameter = "";
        YMFLog.info(this, "soft forceRebootEncoder: %s", config.toString());
        this.mCallBack.onReCreateEncoder(config);
    }
}

