/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.filters;

import android.annotation.TargetApi;
import android.content.Context;
import android.view.Surface;
import com.yy.mediaframework.filters.AbstractSurfaceTextureCaptureFilter;
import com.yy.mediaframework.filters.VideoLiveFilterContext;
import com.yy.mediaframework.screenlive.ScreenSurfaceCallback;
import com.yy.mediaframework.utils.YMFLog;

public class ScreenCaptureFilter
extends AbstractSurfaceTextureCaptureFilter {
    protected Surface mScreenSurface = null;
    private ScreenSurfaceCallback mScreenSurfaceCallback = null;

    public ScreenCaptureFilter(VideoLiveFilterContext filterContext, Context context) {
        super(filterContext);
        this.mContext = context;
        YMFLog.info(this, "[SCapture]", "ScreenCaptureFilter construct");
    }

    @Override
    @TargetApi(value=15)
    protected void doInit() {
        super.doInit();
        this.mScreenSurface = new Surface(this.mCaptureSurfaceTexture);
        YMFLog.info(this, "[SCapture]", "create surface " + (this.mScreenSurface.isValid() ? "success" : " fail"));
        this.surfaceCreated(this.mScreenSurface);
    }

    public void init() {
        YMFLog.info(this, "[SCapture]", "ScreenCaptureFilter init begin");
        if (this.mFilterContext.getGlManager().checkSameThread()) {
            this.doInit();
        } else {
            this.mFilterContext.getGlManager().post(new Runnable(){

                @Override
                public void run() {
                    ScreenCaptureFilter.this.doInit();
                }
            });
        }
        YMFLog.info(this, "[SCapture]", "ScreenCaptureFilter init done");
    }

    @Override
    public void deInit() {
        YMFLog.info(this, "[SCapture]", "ScreenCaptureFilter deInit begin");
        this.surfaceDestroyed(this.mScreenSurface);
        if (this.mScreenSurface != null) {
            this.mScreenSurface.release();
            this.mScreenSurface = null;
        }
        if (this.mFilterContext.getGlManager().checkSameThread()) {
            this.doDeInit();
        } else {
            this.mFilterContext.getGlManager().post(new Runnable(){

                @Override
                public void run() {
                    ScreenCaptureFilter.this.doDeInit();
                }
            });
        }
        YMFLog.info(this, "[SCapture]", "ScreenCaptureFilter deInit done");
    }

    @Override
    @TargetApi(value=16)
    protected void doDeInit() {
        super.doDeInit();
    }

    @Override
    public void updateScreenSize() {
        super.updateScreenSize();
        if (this.mScreenSurfaceCallback != null && this.mScreenSurface != null) {
            YMFLog.info(this, "[SCapture]", "updateScreenSize notify");
            if (this.mScreenSurfaceCallback != null) {
                this.mScreenSurfaceCallback.detachSurface();
            }
            if (this.mScreenSurface != null) {
                this.mScreenSurface.release();
            }
            this.mScreenSurface = new Surface(this.mCaptureSurfaceTexture);
            if (this.mScreenSurfaceCallback != null) {
                this.mScreenSurfaceCallback.attachSurface(this.mScreenSurface);
            }
            this.mScreenSurfaceCallback.surfaceChange(this.mScreenSurface);
        }
        YMFLog.info(this, "[SCapture]", "updateScreenSize done");
    }

    public void addScreenSurfaceCallback(ScreenSurfaceCallback callback) {
        YMFLog.info(this, "[SCapture]", "addScreenSurfaceCallback:" + callback);
        this.mScreenSurfaceCallback = callback;
        if (this.mScreenSurface != null) {
            this.surfaceCreated(this.mScreenSurface);
        }
    }

    private void surfaceCreated(Surface sf) {
        YMFLog.info(this, "[SCapture]", "surfaceCreated mScreenSurfaceCallback:" + this.mScreenSurfaceCallback);
        if (this.mScreenSurfaceCallback != null) {
            YMFLog.info(this, "[SCapture]", "surfaceCreated notify");
            this.mScreenSurfaceCallback.surfaceCreated(sf);
        }
    }

    private void surfaceDestroyed(Surface sf) {
        YMFLog.info(this, "[SCapture]", "surfaceDestroyed");
        if (this.mScreenSurfaceCallback != null) {
            YMFLog.info(this, "[SCapture]", "surfaceDestroyed notify");
            this.mScreenSurfaceCallback.surfaceDestroyed(sf);
        }
    }
}

