/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.filters;

import android.annotation.TargetApi;
import com.yy.mediaframework.filters.AbstractYYMediaFilter;
import com.yy.mediaframework.filters.VideoLiveFilterContext;
import com.yy.mediaframework.model.ImageBuffer;
import com.yy.mediaframework.model.ImageBufferPool;
import com.yy.mediaframework.model.YYMediaSample;
import com.yy.mediaframework.model.YYMediaSampleAlloc;
import com.yy.mediaframework.utils.TimeUtil;
import com.yy.mediaframework.utils.YMFLog;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;

public class ImageCaptureFilter
extends AbstractYYMediaFilter {
    AtomicBoolean mInited = new AtomicBoolean(false);
    VideoLiveFilterContext mFilterContext = null;
    private int mCacheCnt = 0;
    private ConcurrentLinkedQueue<ImageAvailbleRunnable> mImageRunnableQueue = null;
    private ImageBufferPool<ImageBuffer> mImageBufferPool = null;

    @TargetApi(value=21)
    public ImageCaptureFilter(VideoLiveFilterContext filterContext, int cacheCnt) {
        this.mFilterContext = filterContext;
        this.mCacheCnt = cacheCnt;
        this.mImageRunnableQueue = new ConcurrentLinkedQueue();
        for (int i = 0; i < this.mCacheCnt; ++i) {
            ImageAvailbleRunnable r = new ImageAvailbleRunnable(null, this);
            this.mImageRunnableQueue.add(r);
        }
        YMFLog.info(this, "[SCapture]", "ImageCaptureFilter construct");
    }

    public void onImageAvailable(ByteBuffer buffer, int width, int height, int imageFormat) {
        ImageBuffer imageBuf;
        if (this.mImageBufferPool == null) {
            this.mImageBufferPool = new ImageBufferPool<ImageBuffer>(width, height, this.mCacheCnt, imageFormat, ImageBuffer.class, buffer.remaining());
        }
        if ((imageBuf = this.mImageBufferPool.newBuffer(width, height)) == null) {
            return;
        }
        int min = buffer.remaining() > imageBuf.imageSize() ? imageBuf.mDataBuffer.capacity() : buffer.remaining();
        int position = buffer.position();
        buffer.get(imageBuf.mDataBuffer.array(), 0, min);
        buffer.position(position);
        imageBuf.mDataBuffer.position(0);
        if (this.mFilterContext.getGlManager().checkSameThread()) {
            this.handleImageAvaible(imageBuf);
        } else {
            ImageAvailbleRunnable task = this.mImageRunnableQueue.poll();
            if (task == null) {
                YMFLog.error((Object)this, "[SCapture]", "onImageAvailable poll runnable return null, so discard capture.");
                this.mImageBufferPool.freeBuffer(imageBuf);
                return;
            }
            task.mImageBuffer = imageBuf;
            this.mFilterContext.getGlManager().post(task);
        }
    }

    protected void handleImageAvaible(ImageBuffer imageBuf) {
        if (!this.mInited.get()) {
            YMFLog.error((Object)this, "[SCapture]", "handleFrameAvailble, not same surfaceTexture or not initialized");
            return;
        }
        YYMediaSample sample = YYMediaSampleAlloc.instance().alloc();
        sample.mWidth = imageBuf.mWidth;
        sample.mHeight = imageBuf.mHeight;
        long nowMs = TimeUtil.getTickCountLong();
        sample.mAndoridPtsNanos = nowMs * 1000000L;
        sample.mYYPtsMillions = nowMs;
        sample.mResMode = this.mFilterContext.getCameraPreviewConfig().getResMode();
        sample.mImageFormat = imageBuf.mImageFormat;
        sample.mDataByteBuffer = imageBuf.mDataBuffer;
        sample.mBufferOffset = imageBuf.mDataBuffer.position();
        sample.mBufferSize = imageBuf.mDataBuffer.remaining();
        sample.mCameraFacing = 0;
        sample.mOrientation = this.mFilterContext.getCameraPreviewConfig().getOrientation();
        sample.mEncodeWidth = this.mFilterContext.getVideoEncoderConfig().getEncodeWidth();
        sample.mEncodeHeight = this.mFilterContext.getVideoEncoderConfig().getEncodeHeight();
        sample.mEncoderType = this.mFilterContext.getVideoEncoderConfig().mEncodeType;
        this.deliverToDownStream(sample);
        sample.decRef();
    }

    @TargetApi(value=15)
    protected void doInit() {
        this.mInited.set(true);
    }

    public void init() {
        YMFLog.info(this, "[SCapture]", "ImageCaptureFilter init begin");
        if (this.mFilterContext.getGlManager().checkSameThread()) {
            this.doInit();
        } else {
            this.mFilterContext.getGlManager().post(new Runnable(){

                @Override
                public void run() {
                    ImageCaptureFilter.this.doInit();
                }
            });
        }
        YMFLog.info(this, "[SCapture]", "ImageCaptureFilter init done");
    }

    @Override
    public void deInit() {
        YMFLog.info(this, "[SCapture]", "ImageCaptureFilter deInit begin");
        if (this.mFilterContext.getGlManager().checkSameThread()) {
            this.doDeInit();
        } else {
            this.mFilterContext.getGlManager().post(new Runnable(){

                @Override
                public void run() {
                    ImageCaptureFilter.this.doDeInit();
                }
            });
        }
        YMFLog.info(this, "[SCapture]", "ImageCaptureFilter deInit done");
    }

    @TargetApi(value=16)
    protected void doDeInit() {
        if (this.mInited.getAndSet(false) && this.mImageBufferPool != null) {
            this.mImageBufferPool = null;
        }
    }

    public static class ImageAvailbleRunnable
    implements Runnable {
        ImageBuffer mImageBuffer = null;
        ImageCaptureFilter mHandler = null;

        public ImageAvailbleRunnable(ImageBuffer buffer, ImageCaptureFilter handler) {
            this.mImageBuffer = buffer;
            this.mHandler = handler;
        }

        @Override
        public void run() {
            this.mHandler.handleImageAvaible(this.mImageBuffer);
            if (this.mHandler.mImageBufferPool != null) {
                this.mHandler.mImageBufferPool.freeBuffer(this.mImageBuffer);
            }
            this.mImageBuffer = null;
            if (this.mHandler.mImageRunnableQueue != null) {
                this.mHandler.mImageRunnableQueue.add(this);
            }
        }
    }
}

