/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.filters;

import android.opengl.GLES20;
import com.yy.mediaframework.Constant;
import com.yy.mediaframework.filters.AbstractYYMediaFilter;
import com.yy.mediaframework.model.YYMediaSample;
import com.yy.mediaframework.utils.GLUtil;
import com.yy.mediaframework.utils.YMFLog;
import java.nio.Buffer;

public class GlLoadImageFilter
extends AbstractYYMediaFilter {
    private boolean mbPBOSupport = false;
    private boolean mInited = false;
    private int mTextureId = -1;

    private void init(int width, int height, Buffer imageBuf) {
        this.mImageWidth = width;
        this.mImageHeight = height;
        YMFLog.info(this, "[Util    ]", "GlLoadImageFilter init");
        this.mTextureId = GLUtil.genTexture(3553, this.mImageWidth, this.mImageHeight);
        GLES20.glBindTexture((int)3553, (int)this.mTextureId);
        GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)this.mImageWidth, (int)this.mImageHeight, (int)0, (int)6408, (int)5121, (Buffer)imageBuf);
        GLES20.glBindTexture((int)3553, (int)0);
        this.mInited = true;
    }

    @Override
    public void deInit() {
        YMFLog.info(this, "[Util    ]", "GlLoadImageFilter deInit");
        if (this.mTextureId > 0) {
            int[] textures = new int[]{this.mTextureId};
            GLES20.glDeleteTextures((int)1, (int[])textures, (int)0);
            this.mTextureId = -1;
        }
        this.mInited = false;
    }

    @Override
    public boolean processMediaSample(YYMediaSample sample, Object upstream) {
        if (sample.mDataByteBuffer == null || sample.mDataByteBuffer.remaining() == 0) {
            return false;
        }
        if (sample.mWidth != this.mImageWidth || sample.mHeight != this.mImageHeight) {
            YMFLog.info(this, "[Util    ]", "GlLoadImageFilter image size update, origWidth:" + this.mImageWidth + " origHeight:" + this.mImageHeight + " newWidth:" + sample.mWidth + " newHeight:" + sample.mHeight + " imageDataSize:" + sample.mDataByteBuffer.remaining());
            this.mImageWidth = sample.mWidth;
            this.mImageHeight = sample.mHeight;
            this.deInit();
            this.init(this.mImageWidth, this.mImageHeight, sample.mDataByteBuffer);
        } else if (!this.mbPBOSupport) {
            GLES20.glBindTexture((int)3553, (int)this.mTextureId);
            GLES20.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)this.mImageWidth, (int)this.mImageHeight, (int)6408, (int)5121, (Buffer)sample.mDataByteBuffer);
            GLES20.glBindTexture((int)3553, (int)0);
        }
        sample.mMasterTextureId = this.mTextureId;
        sample.mTextureTarget = 3553;
        System.arraycopy(Constant.mtxIdentity, 0, sample.mMainTransformer, 0, sample.mMainTransformer.length);
        sample.mDataByteBuffer = null;
        this.deliverToDownStream(sample);
        return false;
    }
}

