/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.filters;

import com.yy.mediaframework.filters.AbstractYYMediaFilter;
import com.yy.mediaframework.filters.VideoLiveFilterContext;
import com.yy.mediaframework.model.YYMediaSample;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;

public class FPSFlowCtrlFilter
extends AbstractYYMediaFilter {
    private Timer mFPSTimer = null;
    private VideoLiveFilterContext mFilterContext;
    private AtomicBoolean mInited = new AtomicBoolean(false);
    private long mLastSampleYYPtsMS = 0L;
    private YYMediaSample mCurrentMediaSample = null;

    FPSFlowCtrlFilter(VideoLiveFilterContext filterContext) {
        this.mFilterContext = filterContext;
    }

    public void init() {
        this.mFPSTimer = new Timer();
        this.mFPSTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                FPSFlowCtrlFilter.this.mFilterContext.getGlManager().post(new Runnable(){

                    @Override
                    public void run() {
                        FPSFlowCtrlFilter.this.onEncodeFrame();
                    }
                });
            }
        }, 0L, (long)(1000 / this.mFilterContext.getVideoEncoderConfig().mFrameRate));
        this.mInited.set(true);
    }

    @Override
    public void deInit() {
        this.mInited.set(false);
        this.mFPSTimer.cancel();
        if (this.mCurrentMediaSample != null) {
            this.mCurrentMediaSample.decRef();
            this.mCurrentMediaSample = null;
        }
    }

    private void onEncodeFrame() {
        if (this.mCurrentMediaSample == null || this.mLastSampleYYPtsMS == this.mCurrentMediaSample.mYYPtsMillions || !this.mInited.get()) {
            return;
        }
        this.mLastSampleYYPtsMS = this.mCurrentMediaSample.mYYPtsMillions;
        this.deliverToDownStream(this.mCurrentMediaSample);
        this.mCurrentMediaSample.decRef();
        this.mCurrentMediaSample = null;
    }

    @Override
    public boolean processMediaSample(YYMediaSample sample, Object upstream) {
        if (this.mCurrentMediaSample != null) {
            this.mCurrentMediaSample.decRef();
        }
        this.mCurrentMediaSample = sample;
        this.mCurrentMediaSample.addRef();
        return false;
    }
}

