/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.filters;

import android.annotation.SuppressLint;
import android.graphics.ImageFormat;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.opengl.GLES20;
import com.yy.mediaframework.CameraInterface;
import com.yy.mediaframework.Constant;
import com.yy.mediaframework.facedetection.PreviewFrameCallback;
import com.yy.mediaframework.filters.AbstractYYMediaFilter;
import com.yy.mediaframework.filters.LiveSessionType;
import com.yy.mediaframework.filters.VideoLiveFilterContext;
import com.yy.mediaframework.gles.GlUtil;
import com.yy.mediaframework.model.YYMediaSample;
import com.yy.mediaframework.model.YYMediaSampleAlloc;
import com.yy.mediaframework.stat.YMFLiveStatisticManager;
import com.yy.mediaframework.utils.TimeUtil;
import com.yy.mediaframework.utils.YMFLog;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

@SuppressLint(value={"NewApi"})
public class CameraCaptureFilter
extends AbstractYYMediaFilter
implements SurfaceTexture.OnFrameAvailableListener,
PreviewFrameCallback {
    private static final String TAG = "CameraCaptureFilter";
    public int[] mCaptureTexturesIds;
    public SurfaceTexture[] mCaptureSurfaceTextures;
    public long mTextureCreatedThreadId = -1L;
    AtomicBoolean mInited = new AtomicBoolean(false);
    VideoLiveFilterContext mFilterContext = null;
    private long mCurrentFrameTimeDeltaTickcountNanos = 0L;
    public float[] mSlaveTransformer = new float[16];
    private int mExpectDataLen;
    private long feedFrameCounter = 0L;
    private long feedCurrentTime = 0L;
    private long lastPrintTime = 0L;
    private List<Long> mCaptureRateList = new ArrayList<Long>();
    private long maxDealTime = 0L;
    private long averageDealTime = 0L;
    private long mDropCount = 0L;
    private long mLastTick = 0L;
    private List<Long> mDropCountList = new ArrayList<Long>();
    private List<Long> mCaptureAverageDealTimeList = new ArrayList<Long>();
    private List<Long> mCaptureMaxDealTimeList = new ArrayList<Long>();
    private byte[] mCameraNV21Data = null;
    private AtomicBoolean mCameraNV21DataUsed = new AtomicBoolean(true);

    public CameraCaptureFilter(VideoLiveFilterContext filterContext) {
        this.mFilterContext = filterContext;
        YMFLog.info(this, "[CCapture]", "CameraCaptureFilter construct");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInit() {
        YMFLog.info(this, "[CCapture]", "CameraCaptureFilter doInit begin");
        AtomicBoolean atomicBoolean = this.mInited;
        synchronized (atomicBoolean) {
            if (this.mInited.get()) {
                return;
            }
            if (CameraInterface.getInstance().isDualCameraSupported()) {
                this.mCaptureTexturesIds = new int[2];
                this.mCaptureSurfaceTextures = new SurfaceTexture[2];
            } else {
                this.mCaptureTexturesIds = new int[1];
                this.mCaptureSurfaceTextures = new SurfaceTexture[1];
            }
            GLES20.glGenTextures((int)this.mCaptureSurfaceTextures.length, (int[])this.mCaptureTexturesIds, (int)0);
            for (int i = 0; i < this.mCaptureTexturesIds.length; ++i) {
                GLES20.glBindTexture((int)36197, (int)this.mCaptureTexturesIds[i]);
                GLES20.glTexParameterf((int)36197, (int)10241, (float)9729.0f);
                GLES20.glTexParameterf((int)36197, (int)10240, (float)9729.0f);
                GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
                GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
                this.mCaptureSurfaceTextures[i] = new SurfaceTexture(this.mCaptureTexturesIds[i]);
                this.mCaptureSurfaceTextures[i].setDefaultBufferSize(this.mFilterContext.getCameraPreviewConfig().getWidth(), this.mFilterContext.getCameraPreviewConfig().getHeight());
                YMFLog.info(this, "[CCapture]", "setDefaultBufferSize:" + this.mFilterContext.getCameraPreviewConfig().getWidth() + "*" + this.mFilterContext.getCameraPreviewConfig().getHeight() + " texture:" + this.mCaptureSurfaceTextures[i]);
                this.mCaptureSurfaceTextures[i].setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
            }
            this.mTextureCreatedThreadId = Thread.currentThread().getId();
            YMFLiveStatisticManager.getInstance().setGpuDeviceName(GlUtil.getGpuVendor());
            this.mInited.set(true);
            this.mInited.notifyAll();
        }
        YMFLog.info(this, "[CCapture]", "CameraCaptureFilter doInit done");
    }

    public void init() {
        YMFLog.info(this, "[CCapture]", "CameraCaptureFilter init begin");
        if (this.mFilterContext.getGlManager().checkSameThread()) {
            this.doInit();
        } else {
            this.mFilterContext.getGlManager().post(new Runnable(){

                @Override
                public void run() {
                    CameraCaptureFilter.this.doInit();
                }
            });
        }
        YMFLog.info(this, "[CCapture]", "CameraCaptureFilter init done");
    }

    @Override
    public void deInit() {
        if (this.mFilterContext.getGlManager().checkSameThread()) {
            this.doDeInit();
        } else {
            this.mFilterContext.getGlManager().post(new Runnable(){

                @Override
                public void run() {
                    CameraCaptureFilter.this.doDeInit();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDeInit() {
        AtomicBoolean atomicBoolean = this.mInited;
        synchronized (atomicBoolean) {
            if (!this.mInited.get()) {
                YMFLog.info(this, "[CCapture]", "doDeInit: no Initalized state, so return");
                return;
            }
            YMFLog.info(this, "[CCapture]", "doDeInit begin");
            CameraInterface.getInstance().reSetPreviewSurfaceTexture(this.mCaptureSurfaceTextures);
            for (SurfaceTexture surfaceTexture : this.mCaptureSurfaceTextures) {
                surfaceTexture.release();
                surfaceTexture = null;
            }
            if (this.mCaptureTexturesIds.length > 0) {
                GLES20.glDeleteTextures((int)this.mCaptureSurfaceTextures.length, (int[])this.mCaptureTexturesIds, (int)0);
            }
            this.mInited.set(false);
            this.mInited.notifyAll();
            YMFLog.info(this, "[CCapture]", "doDeInit done");
        }
    }

    public SurfaceTexture[] getCaptureSurfaceTextures() {
        return this.mCaptureSurfaceTextures;
    }

    @Override
    public boolean processMediaSample(YYMediaSample sammple, Object upstream) {
        return false;
    }

    private void handleFrameAvailable(SurfaceTexture surfaceTexture) {
        long time_start = System.currentTimeMillis();
        if (!this.mInited.get() || !surfaceTexture.equals(this.mCaptureSurfaceTextures[0]) && !surfaceTexture.equals(this.mCaptureSurfaceTextures[1])) {
            YMFLog.error((Object)this, "[CCapture]", "handleFrameAvailble, not same surfaceTexture or not initialized");
            return;
        }
        surfaceTexture.updateTexImage();
        if (this.mFilterContext.getPictureInPictureFlag() && this.mCaptureSurfaceTextures.length > 1 && this.mCaptureSurfaceTextures[1].equals(surfaceTexture)) {
            surfaceTexture.getTransformMatrix(this.mSlaveTransformer);
            return;
        }
        if (this.mCurrentFrameTimeDeltaTickcountNanos == 0L && surfaceTexture.getTimestamp() != 0L) {
            this.mCurrentFrameTimeDeltaTickcountNanos = surfaceTexture.getTimestamp() - TimeUtil.getTickCountLong() * 1000000L;
            YMFLog.info(this, "[CCapture]", "onFrameAvailable timestamp:" + surfaceTexture.getTimestamp() + " tickcount:" + TimeUtil.getTickCountLong() + " delta:" + this.mCurrentFrameTimeDeltaTickcountNanos);
        }
        YYMediaSample sample = YYMediaSampleAlloc.instance().alloc();
        sample.mWidth = this.mFilterContext.getCameraPreviewConfig().getWidth();
        sample.mHeight = this.mFilterContext.getCameraPreviewConfig().getHeight();
        sample.mAndoridPtsNanos = surfaceTexture.getTimestamp();
        sample.mYYPtsMillions = this.mCurrentFrameTimeDeltaTickcountNanos == 0L ? TimeUtil.getTickCountLong() : (sample.mAndoridPtsNanos - this.mCurrentFrameTimeDeltaTickcountNanos) / 1000000L;
        sample.mResMode = this.mFilterContext.getCameraPreviewConfig().getResMode();
        sample.mPictureInPictureDisplayInfo = CameraInterface.getInstance().getPictureInPictureDisplayInfo();
        sample.mImageFormat = 17;
        sample.mCameraFacing = CameraInterface.getInstance().getAndroidCameraFacing();
        sample.mOrginalCameraFacing = CameraInterface.getInstance().getOrginalCameraFacing();
        sample.mOrientation = this.mFilterContext.mAndroidContext.getResources().getConfiguration().orientation;
        sample.mVideoStabilization = this.mFilterContext.getVideoEncoderConfig().videoStabilization;
        surfaceTexture.getTransformMatrix(sample.mMainTransformer);
        if (this.mFilterContext.getPictureInPictureFlag()) {
            if (sample.mOrginalCameraFacing == sample.mCameraFacing) {
                sample.mMasterTextureId = this.mCaptureTexturesIds[0];
                sample.mSlaveTextureId = this.mCaptureTexturesIds[1];
            } else {
                sample.mMasterTextureId = this.mCaptureTexturesIds[1];
                sample.mSlaveTextureId = this.mCaptureTexturesIds[0];
            }
            this.mFilterContext.setLiveMode(LiveSessionType.LIVE_MODE_DUALCAMERA);
            sample.mSlaveTransformer = this.mSlaveTransformer;
        } else {
            sample.mMasterTextureId = this.mCaptureTexturesIds[0];
            sample.mSlaveTextureId = -1;
            sample.mSlaveTransformer = null;
        }
        sample.mIsMirrorEnable = this.mFilterContext.getMirrorFlag();
        sample.mIsPreviewMirrorEnable = this.mFilterContext.getPreviwMirrorFlag();
        sample.mTextureTarget = 36197;
        sample.mTextureCreatedThreadId = this.mTextureCreatedThreadId;
        sample.mEncodeWidth = this.mFilterContext.getVideoEncoderConfig().getEncodeWidth();
        sample.mEncodeHeight = this.mFilterContext.getVideoEncoderConfig().getEncodeHeight();
        sample.mEncoderType = this.mFilterContext.getVideoEncoderConfig().mEncodeType;
        sample.mScreenCropArea = null;
        sample.mImageFormat = 70;
        sample.mEncoderInputMode = Constant.EncoderInputMode.SURFACE;
        sample.mUseGPUBeauty = this.mFilterContext.mUseGPUBeauty;
        YMFLiveStatisticManager.getInstance().setCameraCaptureFrameRate();
        YMFLiveStatisticManager.getInstance().beginCapture2Encode(sample.mYYPtsMillions);
        YMFLiveStatisticManager.getInstance().setVideoPtsMaxDiff(0, sample.mYYPtsMillions);
        this.deliverToDownStream(sample);
        sample.decRef();
        this.printCameraCaptureFrameRate(System.currentTimeMillis() - time_start);
    }

    private boolean checkDataValidataion(byte[] data, long timeStart) {
        int previewFormat = CameraInterface.getInstance().getPreviewFormat();
        this.mExpectDataLen = CameraInterface.getInstance().getCurrentPreviewBufferSize();
        if (previewFormat != 17 || data.length < this.mExpectDataLen) {
            YMFLog.error((Object)this, "[CCapture]", "checkDataValidataion mImageFormat != NV21 or data length error.");
            return false;
        }
        long gap = timeStart - this.mLastTick;
        if ((float)gap < 1000.0f / (float)this.mFilterContext.getVideoEncoderConfig().getFrameRate() - 10.0f) {
            ++this.mDropCount;
            return false;
        }
        this.mLastTick = timeStart;
        return true;
    }

    private void handleFrameAvaliable() {
        if (!this.mInited.get() || this.mCameraNV21DataUsed.get()) {
            return;
        }
        long time_start = System.currentTimeMillis();
        YYMediaSample sample = YYMediaSampleAlloc.instance().alloc();
        sample.mDataBytes = this.mCameraNV21Data;
        sample.mIsYUVBuffer = true;
        sample.mMasterTextureId = -1;
        sample.mSlaveTextureId = -1;
        sample.mTextureTarget = -1;
        sample.mScreenCropArea = null;
        sample.mUseGPUBeauty = this.mFilterContext.mUseGPUBeauty;
        sample.mIsMirrorEnable = this.mFilterContext.getMirrorFlag();
        sample.mImageFormat = 0;
        sample.mResMode = this.mFilterContext.getCameraPreviewConfig().getResMode();
        sample.mYYPtsMillions = TimeUtil.getTickCountLong();
        sample.mCameraFacing = CameraInterface.getInstance().getAndroidCameraFacing();
        sample.mOrientation = this.mFilterContext.mAndroidContext.getResources().getConfiguration().orientation;
        sample.mEncodeWidth = this.mFilterContext.getVideoEncoderConfig().getEncodeWidth();
        sample.mEncodeHeight = this.mFilterContext.getVideoEncoderConfig().getEncodeHeight();
        sample.mEncoderType = this.mFilterContext.getVideoEncoderConfig().mEncodeType;
        sample.mEncoderInputMode = Constant.EncoderInputMode.BUFFER;
        sample.mIsPreviewMirrorEnable = this.mFilterContext.getPreviwMirrorFlag();
        if (sample.mCameraFacing == 0) {
            sample.mIsMirrorEnable = false;
            sample.mIsPreviewMirrorEnable = false;
        }
        CameraInterface cam = CameraInterface.getInstance();
        sample.mWidth = cam.getPreviewYuvSize().width;
        sample.mHeight = cam.getPreviewYuvSize().height;
        sample.mCameraRotate = cam.getRotation();
        sample.mSwapWidthHeight = sample.mCameraRotate == 90 || sample.mCameraRotate == 270;
        this.deliverToDownStream(sample);
        sample.decRef();
        this.mCameraNV21DataUsed.set(true);
        YMFLiveStatisticManager.getInstance().setCameraCaptureFrameRate();
        this.printCameraCaptureFrameRate(System.currentTimeMillis() - time_start);
    }

    private String transform2String(float[] transform) {
        StringBuilder builder = new StringBuilder();
        for (float f : transform) {
            builder.append(String.valueOf(f));
            builder.append("_");
        }
        return builder.toString();
    }

    public void onFrameAvailable(final SurfaceTexture surfaceTexture) {
        if (!this.mFilterContext.useYUVCapture()) {
            if (this.mFilterContext.getGlManager().checkSameThread()) {
                this.handleFrameAvailable(surfaceTexture);
            } else {
                this.mFilterContext.getGlManager().post(new Runnable(){

                    @Override
                    public void run() {
                        CameraCaptureFilter.this.handleFrameAvailable(surfaceTexture);
                    }
                });
            }
        } else {
            this.mFilterContext.getGlManager().post(new Runnable(){

                @Override
                public void run() {
                    surfaceTexture.updateTexImage();
                }
            });
        }
    }

    private void requireDealCameraFrame() {
        if (this.mFilterContext.getGLManager().checkSameThread()) {
            this.handleFrameAvaliable();
        } else {
            this.mFilterContext.getGlManager().post(new Runnable(){

                @Override
                public void run() {
                    CameraCaptureFilter.this.handleFrameAvaliable();
                }
            });
        }
    }

    @Override
    public void onPreviewFrameAvailable(int imageFormat, byte[] data, int previewWidth, int previewHeight, Camera camera) {
        if (this.mFilterContext.useYUVCapture()) {
            if (this.mCameraNV21DataUsed.get()) {
                if (this.mCameraNV21Data == null || this.mCameraNV21Data.length != data.length) {
                    int width = this.mFilterContext.mCameraPreviewConfig.getWidth();
                    int height = this.mFilterContext.mCameraPreviewConfig.getHeight();
                    int buffSize = width * height * ImageFormat.getBitsPerPixel((int)17) / 8;
                    this.mCameraNV21Data = new byte[buffSize];
                }
                System.arraycopy(data, 0, this.mCameraNV21Data, 0, data.length);
                this.mCameraNV21DataUsed.set(false);
            }
            this.requireDealCameraFrame();
        }
    }

    private void printCameraCaptureFrameRate(long dealTime) {
        try {
            ++this.feedFrameCounter;
            this.feedCurrentTime = System.currentTimeMillis();
            this.maxDealTime = this.maxDealTime < dealTime ? dealTime : this.maxDealTime;
            this.averageDealTime += dealTime;
            if (this.feedCurrentTime - this.lastPrintTime >= 1000L) {
                this.mCaptureRateList.add(this.feedFrameCounter);
                this.mCaptureAverageDealTimeList.add(this.averageDealTime / this.feedFrameCounter);
                this.mCaptureMaxDealTimeList.add(this.maxDealTime);
                this.mDropCountList.add(this.mDropCount);
                if (this.mCaptureRateList.size() >= 5) {
                    this.printFrameRate("CameraCapture", this.mCaptureRateList, this.mCaptureAverageDealTimeList, this.mCaptureMaxDealTimeList, this.mDropCountList);
                    this.mCaptureRateList.clear();
                    this.mCaptureMaxDealTimeList.clear();
                    this.mCaptureAverageDealTimeList.clear();
                    this.mDropCountList.clear();
                }
                this.feedFrameCounter = 0L;
                this.lastPrintTime = this.feedCurrentTime;
                this.maxDealTime = 0L;
                this.averageDealTime = 0L;
                this.mDropCount = 0L;
            }
        }
        catch (Exception e) {
            YMFLog.error((Object)this, "[CCapture]", "printCameraCaptureFrameRate exception:" + e.toString());
        }
    }

    private void printFrameRate(String type, List<Long> list, List<Long> list2, List<Long> list3, List<Long> list4) {
        if (null == list) {
            return;
        }
        String str = " ";
        for (int i = 0; i < list.size(); ++i) {
            str = str + list.get(i) + ":" + list2.get(i) + ":" + list3.get(i) + ":" + list4.get(i) + ", ";
        }
        YMFLog.info(this, "[CCapture]", "handleFrameAvailable feed data frame rate::[" + str + "] type:" + type);
    }
}

