/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.facedetection;

import android.hardware.Camera;
import com.yy.mediaframework.CameraInterface;
import com.yy.mediaframework.YYCamera;
import com.yy.mediaframework.facedetection.PreviewFrameCallback;
import com.yy.mediaframework.utils.YMFLog;
import java.util.ArrayList;

public class CameraPreviewCallbackHost
implements Camera.PreviewCallback {
    private static final String TAG = "CameraPreviewCallbackHost";
    private ArrayList<PreviewFrameCallback> mCameraPreviewClientList = new ArrayList();
    private Object syncLock = new Object();
    private int previewWidth;
    private int previewHeight;

    public void updatePreviewSize(int width, int height) {
        this.previewHeight = height;
        this.previewWidth = width;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCallback(PreviewFrameCallback callback) {
        Object object = this.syncLock;
        synchronized (object) {
            if (!this.mCameraPreviewClientList.contains(callback)) {
                this.mCameraPreviewClientList.add(callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterCallback(PreviewFrameCallback callback) {
        Object object = this.syncLock;
        synchronized (object) {
            if (this.mCameraPreviewClientList.contains(callback)) {
                this.mCameraPreviewClientList.remove(callback);
            }
        }
    }

    public void setPreviewCallbackWithBuffer() {
        YMFLog.info(this, "[Preview ]", "CameraPreviewCallbackHost setPreviewCallbackWithBuffer");
        YYCamera.getInstance().setPreviewCallbackWithBuffer(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPreviewFrame(byte[] data, Camera camera) {
        Object object = this.syncLock;
        synchronized (object) {
            if (this.mCameraPreviewClientList != null && this.mCameraPreviewClientList.size() > 0) {
                try {
                    for (PreviewFrameCallback cameraPreviewFrame : this.mCameraPreviewClientList) {
                        if (cameraPreviewFrame == null) continue;
                        cameraPreviewFrame.onPreviewFrameAvailable(17, data, camera.getParameters().getPreviewSize().width, camera.getParameters().getPreviewSize().height, camera);
                    }
                }
                catch (Exception e) {
                    YMFLog.error((Object)this, "[Preview ]", " ui code error " + e.toString());
                }
            }
        }
        CameraInterface.getInstance().addCallbackBuffer(data);
    }
}

