/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.encoder;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.yy.mediaframework.GlManager;
import com.yy.mediaframework.encoder.AbstractTextureMoiveEncoder;
import com.yy.mediaframework.encoder.HardEncodeListner;
import com.yy.mediaframework.filters.VideoLiveFilterContext;
import com.yy.mediaframework.utils.YMFLog;
import java.lang.ref.WeakReference;

public class TextureMoiveEncoderAsync
extends AbstractTextureMoiveEncoder
implements Runnable {
    private static final boolean VERBOSE = false;
    private static final int MSG_STOP_RECORDING = 1;
    private static final int MSG_FRAME_AVAILABLE = 2;
    private volatile EncoderHandler mHandler;
    private Object mReadyFence = new Object();
    private boolean mReady;
    private boolean mRunning;
    private Thread mEncodeThread = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextureMoiveEncoderAsync(VideoLiveFilterContext context, GlManager glMgr, HardEncodeListner listner) {
        super(context, glMgr, listner);
        Object object = this.mReadyFence;
        synchronized (object) {
            if (this.mRunning) {
                YMFLog.warn(this, "[Encoder ]", "Encoder thread already running");
                return;
            }
            this.mRunning = true;
            this.mEncodeThread = new Thread((Runnable)this, "YY_yyvideolib_TextureMovieEncoder_Thread");
            this.mEncodeThread.start();
            while (!this.mReady) {
                try {
                    this.mReadyFence.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEncodedFrameFinished(long pts) {
        Object object = this.mReadyFence;
        synchronized (object) {
            if (!this.mReady) {
                return;
            }
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(2, pts));
    }

    @Override
    public void stopEncoder() {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1));
    }

    @Override
    public void releaseEncoder() {
        if (this.mInputWindowSurface != null) {
            this.mInputWindowSurface.release();
            this.mInputWindowSurface = null;
        }
        if (this.mFullScreen != null) {
            this.mFullScreen.release(true);
            this.mFullScreen = null;
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1));
        if (this.mEncodeThread != null) {
            try {
                this.mEncodeThread.join();
            }
            catch (InterruptedException e) {
                YMFLog.error((Object)this, "[Encoder ]", "releaseEncoder exception:" + e.toString());
            }
            this.mEncodeThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        YMFLog.info(this, "[Encoder ]", "run before prepare");
        Looper.prepare();
        Object object = this.mReadyFence;
        synchronized (object) {
            this.mHandler = new EncoderHandler(this);
            this.mReady = true;
            this.mReadyFence.notify();
            YMFLog.info(this, "[Encoder ]", "run notify ready");
        }
        Looper.loop();
        YMFLog.info(this, "[Encoder ]", "Encoder thread exiting");
        object = this.mReadyFence;
        synchronized (object) {
            this.mRunning = false;
            this.mReady = false;
            this.mHandler = null;
        }
    }

    public void handleFrameAvailable(int pts) {
        this.mVideoEncoderImpl.drainEncoder(pts, false);
    }

    public void handleStopRecording() {
        YMFLog.info(this, "[Encoder ]", "handleStopRecording");
        if (this.mVideoEncoderImpl != null) {
            this.mVideoEncoderImpl.drainEncoder(0L, true);
            this.mVideoEncoderImpl.deInit();
            this.mVideoEncoderImpl = null;
        }
    }

    private static class EncoderHandler
    extends Handler {
        private WeakReference<TextureMoiveEncoderAsync> mWeakEncoder;

        public EncoderHandler(TextureMoiveEncoderAsync encoder) {
            this.mWeakEncoder = new WeakReference<TextureMoiveEncoderAsync>(encoder);
        }

        public void handleMessage(Message inputMessage) {
            int what = inputMessage.what;
            Object obj = inputMessage.obj;
            TextureMoiveEncoderAsync encoder = (TextureMoiveEncoderAsync)this.mWeakEncoder.get();
            if (encoder == null) {
                YMFLog.warn((Object)this, "[Encoder ]", "handleMessage: encoder is null");
                return;
            }
            switch (what) {
                case 1: {
                    encoder.handleStopRecording();
                    if (Looper.myLooper() == null) break;
                    Looper.myLooper().quit();
                    break;
                }
                case 2: {
                    encoder.handleFrameAvailable(inputMessage.arg1);
                    break;
                }
                default: {
                    throw new RuntimeException("Unhandled msg what=" + what);
                }
            }
        }
    }
}

