/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.encoder;

import com.yy.mediaframework.base.VideoEncoderConfig;
import com.yy.mediaframework.base.VideoEncoderType;
import com.yy.mediaframework.utils.YMFLog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class HardEncoderFrameRateAdaptor {
    private boolean mEnableSyncFps = true;
    private int mSampleEncFpsDiff = 3;
    private int mSyncFpsInterval = 15;
    private int mFrameCount = 0;
    private int mModifiedEncFps = 0;
    private long mLastCountTime = 0L;
    private long mNewTurnTime = 0L;
    private long mStatInterval = 5L;
    private List<Integer> mLastFps = new ArrayList<Integer>();
    private String mConfigStr = null;

    public boolean checkFrameRate(VideoEncoderConfig cfg) {
        this.updateSyncFpsParam(cfg.mEncodeParameter);
        if (this.mEnableSyncFps && (cfg.mEncodeType == VideoEncoderType.HARD_ENCODER_H264 || cfg.mEncodeType == VideoEncoderType.HARD_ENCODER_H265)) {
            return this.checkSyncFps(cfg);
        }
        return false;
    }

    private void updateSyncFpsParam(String configStr) {
        if (configStr == null) {
            return;
        }
        if (this.mConfigStr != null && this.mConfigStr.equals(configStr)) {
            return;
        }
        try {
            String itemDelim = ":";
            String[] tokens = configStr.split(itemDelim);
            String valueDelim = "=";
            for (int i = 0; i < tokens.length; ++i) {
                YMFLog.info(this, "[Encoder ]", "updateSyncFpsParam parse:" + tokens[i]);
                Object[] keyValue = tokens[i].split(valueDelim);
                if (keyValue.length == 2) {
                    YMFLog.info(this, "[Encoder ]", "updateSyncFpsParam param item, name:" + (String)keyValue[0] + ", value:" + (String)keyValue[1]);
                    this.setSyncSampleEncParams((String)keyValue[0], (String)keyValue[1]);
                    continue;
                }
                YMFLog.info(this, "[Encoder ]", "updateSyncFpsParam invalid param item:" + Arrays.toString(keyValue));
            }
            this.mConfigStr = configStr;
        }
        catch (Exception e) {
            YMFLog.info(this, "[Encoder ]", "updateSyncFpsParam parse exception:" + e);
        }
    }

    private void setSyncSampleEncParams(String key, String value) {
        switch (key) {
            case "fpsDiff": {
                this.mSampleEncFpsDiff = Integer.parseInt(value);
                YMFLog.info(this, "[Encoder ]", "setSyncSampleEncParams fpsDiff:" + this.mSampleEncFpsDiff);
                break;
            }
            case "syncFpsInterval": {
                this.mSyncFpsInterval = Integer.parseInt(value);
                YMFLog.info(this, "[Encoder ]", "setSyncSampleEncParams syncFpsInterval:" + this.mSyncFpsInterval);
                break;
            }
            case "enableSyncFps": {
                this.mEnableSyncFps = Boolean.parseBoolean(value);
                YMFLog.info(this, "[Encoder ]", "setSyncSampleEncParams enableSyncFps:" + this.mEnableSyncFps);
                break;
            }
        }
    }

    private boolean checkSyncFps(VideoEncoderConfig cfg) {
        ++this.mFrameCount;
        long now = System.currentTimeMillis();
        if (this.mNewTurnTime == 0L) {
            this.mNewTurnTime = now;
            this.mLastCountTime = now;
            this.mLastFps.clear();
            return false;
        }
        long inteval = now - this.mLastCountTime;
        if (inteval >= this.mStatInterval * 1000L) {
            this.mLastFps.add((int)((float)this.mFrameCount / ((float)inteval / 1000.0f)));
            if (this.mLastFps.size() > 100) {
                this.mLastFps.remove(0);
            }
            this.mLastCountTime = now;
            this.mFrameCount = 0;
        }
        if (now - this.mNewTurnTime < (long)(this.mSyncFpsInterval * 1000)) {
            return false;
        }
        if (this.mFrameCount != 0 && inteval > 0L) {
            this.mLastFps.add((int)((float)this.mFrameCount / ((float)inteval / 1000.0f)));
        }
        this.mNewTurnTime = now;
        if (this.mLastFps.isEmpty()) {
            return false;
        }
        int sum = 0;
        int lastFps = 0;
        int vibratAmp = 3;
        int vibratCount = 0;
        int len = this.mLastFps.size();
        for (int i = 0; i < len; ++i) {
            int currFps = this.mLastFps.get(i);
            if (i > 0 && Math.abs(currFps - lastFps) > vibratAmp) {
                ++vibratCount;
            }
            lastFps = currFps;
            sum += currFps;
        }
        int fps = sum / len;
        int encFps = cfg.mFrameRate;
        int minEncFps = 7;
        if (vibratCount <= len / 2 && fps > minEncFps && (fps < encFps - this.mSampleEncFpsDiff || fps > encFps + this.mSampleEncFpsDiff)) {
            YMFLog.info(this, "[Encoder ]", "checkSyncFps, sample len:" + len + ", vibratCount:" + vibratCount + ", sync camera fps:" + fps + ", old enc fps:" + encFps);
            cfg.mFrameRate = this.mModifiedEncFps = fps;
            this.mLastCountTime = 0L;
            this.mFrameCount = 0;
            this.mNewTurnTime = 0L;
            return true;
        }
        YMFLog.info(this, "[Encoder ]", "checkSyncFps, sample len:" + len + ", vibratCount:" + vibratCount + ", camera fps:" + fps + ", enc fps:" + encFps);
        this.mLastFps.clear();
        return false;
    }
}

