/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.encoder;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Point;
import android.graphics.RectF;
import android.opengl.GLES20;
import android.os.Build;
import android.view.Display;
import android.view.WindowManager;
import com.yy.mediaframework.Constant;
import com.yy.mediaframework.GlManager;
import com.yy.mediaframework.base.VideoEncoderConfig;
import com.yy.mediaframework.base.VideoEncoderType;
import com.yy.mediaframework.encoder.H264SurfaceEncoder;
import com.yy.mediaframework.encoder.H265SurfaceEncoder;
import com.yy.mediaframework.encoder.HardEncodeListner;
import com.yy.mediaframework.encoder.HardSurfaceEncoder;
import com.yy.mediaframework.filters.LiveSessionType;
import com.yy.mediaframework.filters.VideoLiveFilterContext;
import com.yy.mediaframework.gles.Drawable2d;
import com.yy.mediaframework.gles.FullFrameRect;
import com.yy.mediaframework.gles.GlUtil;
import com.yy.mediaframework.gles.IEglCore;
import com.yy.mediaframework.gles.IWindowSurface;
import com.yy.mediaframework.gles.Texture2dProgram;
import com.yy.mediaframework.model.YYMediaSample;
import com.yy.mediaframework.stat.YMFLiveStatisticManager;
import com.yy.mediaframework.utils.GLUtil;
import com.yy.mediaframework.utils.YMFLog;
import java.nio.FloatBuffer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicLong;

public class AbstractTextureMoiveEncoder {
    private static final String TAG = "AbstractTextureMoiveEncoder";
    protected VideoLiveFilterContext mFilterContext;
    protected IEglCore mEglCore = null;
    protected HardEncodeListner mHardEncoderListener = null;
    protected HardSurfaceEncoder mVideoEncoderImpl = null;
    protected static AtomicLong sEncodeIds = new AtomicLong(1L);
    protected IWindowSurface mInputWindowSurface = null;
    protected FullFrameRect mFullScreen = null;
    VideoEncoderConfig mVideoEncoderConfig = null;
    GlManager mGlManager = null;
    private int mEncodeWidth = 0;
    private int mEncodeHeight = 0;
    private int mInputWidth = 0;
    private int mInputHeight = 0;
    private int mClipWidth = 0;
    private int mClipHeight = 0;
    private int mScreenWidth = 0;
    private int mScreenHeight = 0;
    private RectF mLastScreenCropArea = new RectF();
    private Constant.EncoderInputMode mInputMode;

    public AbstractTextureMoiveEncoder(VideoLiveFilterContext context, GlManager glMgr, HardEncodeListner listener) {
        this.mFilterContext = context;
        this.mGlManager = glMgr;
        this.mEglCore = this.mGlManager.getEglCore();
        this.mHardEncoderListener = listener;
        Context context2 = this.mFilterContext.getAndroidContext();
        this.mFilterContext.getAndroidContext();
        WindowManager wm = (WindowManager)context2.getSystemService("window");
        if (Build.VERSION.SDK_INT >= 17) {
            Point point = new Point();
            Display display = wm.getDefaultDisplay();
            display.getRealSize(point);
            this.mScreenWidth = point.x;
            this.mScreenHeight = point.y;
        }
    }

    public void setEncoderInputMode(Constant.EncoderInputMode inputMode) {
        this.mInputMode = inputMode;
    }

    public long startEncode(VideoEncoderConfig config) {
        long eid = sEncodeIds.incrementAndGet();
        this.mVideoEncoderConfig = config;
        try {
            this.mVideoEncoderImpl = this.mVideoEncoderConfig.mEncodeType == VideoEncoderType.HARD_ENCODER_H264 ? new H264SurfaceEncoder(eid) : new H265SurfaceEncoder(eid);
            if (this.mVideoEncoderImpl.init(config, this.mHardEncoderListener, this.mInputMode)) {
                if (this.mInputMode == Constant.EncoderInputMode.SURFACE) {
                    this.mFullScreen = new FullFrameRect(new Texture2dProgram(Texture2dProgram.ProgramType.TEXTURE_2D_WITH_EXTRA_TXT_2), Drawable2d.Prefab.FULL_RECTANGLE, GlUtil.createFloatBuffer(Drawable2d.FULL_RECTANGLE_TEX_COORDS), GlUtil.createFloatBuffer(Drawable2d.FULL_RECTANGLE_TEX_COORDS));
                    this.setEncoderFlipY();
                    this.mInputWindowSurface = this.mEglCore.createWindowSurface(this.mVideoEncoderImpl.getInputSurface(), true);
                }
                YMFLog.info(this, "[Encoder ]", "start video encoder success");
                return eid;
            }
            YMFLog.error((Object)this, "[Encoder ]", "videocodec init fail");
            this.releaseEncoder();
            return -1L;
        }
        catch (Throwable t) {
            this.releaseEncoder();
            YMFLog.error((Object)this, "[Encoder ]", "start video encoder fail, exception: " + t.getMessage());
            return -1L;
        }
    }

    @TargetApi(value=8)
    public void encodeFrame(YYMediaSample sample, int extraTextureID1, int extraTextureID2) {
        this.encodeFrame(sample, extraTextureID1, extraTextureID2, -1, null);
    }

    public void encodeFrame(YYMediaSample sample) {
        if (this.mVideoEncoderImpl != null) {
            this.mVideoEncoderImpl.feedEncoder(sample);
            this.onEncodedFrameFinished(sample.mYYPtsMillions);
        }
    }

    @TargetApi(value=8)
    public void encodeFrame(YYMediaSample sample, int waterMarkTextureId, int stickerTextureId, int slavePicTextureId, FloatBuffer slavePicVertexBuffer) {
        YMFLiveStatisticManager.getInstance().beginEncode(sample.mYYPtsMillions);
        if (this.mFilterContext != null) {
            try {
                this.mInputWindowSurface.makeCurrent();
                GLES20.glViewport((int)0, (int)0, (int)this.mVideoEncoderConfig.getEncodeWidth(), (int)this.mVideoEncoderConfig.getEncodeHeight());
                GLES20.glClear((int)16640);
                if (sample.mScreenCropArea != null && !sample.mScreenCropArea.equals((Object)this.mLastScreenCropArea)) {
                    YMFLog.info(this, "[Encoder ]", "hard-ScreenLiveSession sample.mScreenCropArea:" + sample.mScreenCropArea);
                    this.mLastScreenCropArea.set(sample.mScreenCropArea);
                    if (this.mEncodeWidth != sample.mEncodeWidth && this.mEncodeHeight != sample.mEncodeHeight) {
                        YMFLog.info(this, "[Encoder ]", "hard-ScreenLiveSession adjustTextureArea...");
                        this.mFullScreen.adjustTextureArea(sample.mScreenCropArea, this.mScreenWidth, this.mScreenHeight, false);
                    } else {
                        YMFLog.warn(this, "[Encoder ]", "hard-screen clip ratio and encode ratio not change at the same time...");
                    }
                } else if (sample.mScreenCropArea == null && this.checkClipRatioChanged(sample.mWidth, sample.mHeight, sample.mClipWidth, sample.mClipHeight)) {
                    YMFLog.info(this, "[Encoder ]", "hard-VideoLiveSession adjustTexture...");
                    this.mFullScreen.adjustTexture(sample.mWidth, sample.mHeight, sample.mClipWidth, sample.mClipHeight);
                }
                if (this.mFilterContext.getLiveMode() == LiveSessionType.LIVE_MODE_DUALCAMERA) {
                    this.flip(sample);
                    GLUtil.updateVertexBuffer(slavePicVertexBuffer, sample.mPictureInPictureDisplayInfo);
                    this.mFullScreen.drawFrame(sample.mMasterTextureId, sample.mMainTransformer, this.mFilterContext.getWatermarkTextureID(), this.mFilterContext.getDynamicTextureID(), sample.mSlaveTextureId, sample.mSlaveTransformer, slavePicVertexBuffer, GlUtil.adjustDualCameraSlaveTexture(sample, this.mFilterContext.mCameraPreviewConfig.getWidth(), this.mFilterContext.mCameraPreviewConfig.getHeight()));
                } else if (this.mFilterContext.getLiveMode() == LiveSessionType.LIVE_MODE_NORMAL || this.mFilterContext.getLiveMode() == LiveSessionType.LIVE_MODE_SCREEN_RECORD || this.mFilterContext.getLiveMode() == LiveSessionType.LIVE_MODE_EXTERNAL) {
                    this.flip(sample);
                    this.mFullScreen.drawFrame(sample.mMasterTextureId, sample.mMainTransformer, waterMarkTextureId, stickerTextureId, -1, null, null);
                } else if (this.mFilterContext.getLiveMode() == LiveSessionType.LIVE_MODE_PERIPHERALS) {
                    this.drawPeripherals(sample);
                }
                this.mInputWindowSurface.setPresentationTime(sample.mYYPtsMillions * 1000L * 1000L);
                this.mInputWindowSurface.swapBuffers();
            }
            catch (Throwable t) {
                YMFLog.error((Object)this, "[Encoder ]", "encodeFrame exception:" + t.getMessage());
            }
        }
        this.onEncodedFrameFinished(sample.mYYPtsMillions);
    }

    private void drawPeripherals(YYMediaSample sample) {
        FloatBuffer peripheralsVertexCoord = this.mFilterContext.mPeripheralsPosition.getPositionBuffer(false);
        FloatBuffer peripheralsTexCoord = GlUtil.setFlipY(this.mFilterContext.mPeripheralsPosition.getDefaultTextureBuffer());
        if (this.mFilterContext.mPeripheralsPosition.fillMode == 1) {
            peripheralsVertexCoord = this.mFilterContext.mPeripheralsPosition.convertPositionBuffer(sample.mEncodeWidth, sample.mEncodeHeight, this.mFilterContext.mPeripheralsPosition.srcWidth, this.mFilterContext.mPeripheralsPosition.srcHeight);
            peripheralsTexCoord = this.mFilterContext.mPeripheralsPosition.getDefaultTextureBuffer();
        }
        this.mFullScreen.drawFrame(this.mFilterContext.getBackgroundTextureId(), sample.mMainTransformer, this.mFilterContext.getWatermarkTextureID(), this.mFilterContext.getDynamicTextureID(), sample.mSlaveTextureId, sample.mSlaveTransformer, peripheralsVertexCoord, peripheralsTexCoord);
        if (this.mFilterContext.mPeripheralsOrientation != 1) {
            GLES20.glEnable((int)3042);
            GLES20.glBlendFunc((int)770, (int)771);
            this.mFullScreen.drawFrame(this.mFilterContext.getWatermarkTextureID(), this.mFilterContext.mCameraPostion.getDefaultVertexBuffer(), this.mFilterContext.mCameraPostion.getDefaultTextureBuffer(), sample.mMainTransformer, -1, -1, -1, null, null, null);
            GLES20.glDisable((int)3042);
        }
        FloatBuffer textureBuffer = this.mFilterContext.mCameraPostion.getDefaultTextureBuffer();
        if (this.mFilterContext.mCameraPostion.fillMode == 2) {
            int dstWidth = 1;
            int dstHeight = 1;
            if (this.mFilterContext.mCameraPostion.dstWidth != 0 && this.mFilterContext.mCameraPostion.dstHeight != 0) {
                dstWidth = this.mFilterContext.mCameraPostion.dstWidth;
                dstHeight = this.mFilterContext.mCameraPostion.dstHeight;
            }
            textureBuffer = GlUtil.setFlipY(this.mFilterContext.mCameraPostion.convertTextureBuffer(dstWidth, dstHeight, this.mFilterContext.mCameraPostion.srcWidth, this.mFilterContext.mCameraPostion.srcHeight));
        }
        if (sample.mCameraFacing == 1 && !sample.mIsMirrorEnable) {
            textureBuffer = GlUtil.setFlipX(textureBuffer);
        }
        this.mFullScreen.drawFrame(sample.mMasterTextureId, this.mFilterContext.mCameraPostion.getPositionBuffer(false), textureBuffer, sample.mMainTransformer, -1, -1, -1, null, null, null);
    }

    public void flip(YYMediaSample sample) {
        this.resetFlip();
        if (this.mFilterContext.getLiveMode() == LiveSessionType.LIVE_MODE_DUALCAMERA) {
            if (sample.mCameraFacing == 1) {
                if (sample.mOrientation == 2) {
                    if (sample.mOrginalCameraFacing == sample.mCameraFacing) {
                        if (!sample.mIsMirrorEnable) {
                            this.flipXMasterPicture();
                        }
                    } else if (!sample.mIsMirrorEnable) {
                        this.flipXSlavePicture();
                    } else {
                        this.flipXScreen();
                    }
                } else if (sample.mOrginalCameraFacing != sample.mCameraFacing) {
                    if (!sample.mIsMirrorEnable) {
                        this.flipYScreenXMaster();
                    } else {
                        this.flipYScreen();
                    }
                } else if (!sample.mIsMirrorEnable) {
                    this.flipXMasterPicture();
                }
            } else if (sample.mOrientation == 2) {
                if (sample.mOrginalCameraFacing == sample.mCameraFacing) {
                    if (!sample.mIsMirrorEnable) {
                        this.flipXSlavePicture();
                    }
                } else if (!sample.mIsMirrorEnable) {
                    this.flipXMasterPicture();
                } else {
                    this.flipXScreen();
                }
            } else if (sample.mOrginalCameraFacing != sample.mCameraFacing) {
                if (!sample.mIsMirrorEnable) {
                    this.flipYScreenXSlave();
                } else {
                    this.flipYScreen();
                }
            } else if (!sample.mIsMirrorEnable) {
                this.flipXSlavePicture();
            }
        } else if (sample.mCameraFacing == 1 && !sample.mIsMirrorEnable) {
            this.flipXMasterPicture();
        }
    }

    private boolean checkClipRatioChanged(int inputWidth, int inputHeight, int clipWidth, int clipHeight) {
        boolean ret = false;
        if (this.mInputWidth != inputWidth || this.mInputHeight != inputHeight || this.mClipWidth != clipWidth || this.mClipHeight != clipHeight) {
            YMFLog.info(this, "[Encoder ]", "inputWidth:" + inputWidth + " inputHeight:" + inputHeight + " clipWidth:" + clipWidth + " clipHeight:" + clipHeight);
            this.mInputWidth = inputWidth;
            this.mInputHeight = inputHeight;
            this.mClipWidth = clipWidth;
            this.mClipHeight = clipHeight;
            ret = true;
        }
        return ret;
    }

    public void stopEncoder() {
    }

    public void releaseEncoder() {
        if (this.mVideoEncoderImpl != null) {
            this.mVideoEncoderImpl.drainEncoder(0L, true);
            this.mVideoEncoderImpl.deInit();
            this.mVideoEncoderImpl = null;
        }
        if (this.mInputWindowSurface != null) {
            this.mGlManager.resetContext();
            this.mInputWindowSurface.release();
            this.mInputWindowSurface = null;
        }
        if (this.mFullScreen != null) {
            this.mFullScreen.release(true);
            this.mFullScreen = null;
        }
        this.mInputWidth = 0;
        this.mInputHeight = 0;
        this.mClipWidth = 0;
        this.mClipHeight = 0;
    }

    public void resetFlip() {
        this.mFullScreen.resetFlip();
    }

    public void flipXMasterPicture() {
        this.mFullScreen.flipXMasterPicture();
    }

    public void flipXSlavePicture() {
        this.mFullScreen.flipXSlavePicture();
    }

    public void flipYScreen() {
        this.mFullScreen.flipYScreen();
    }

    public void flipYScreenXMaster() {
        this.mFullScreen.flipYScreenXMaster();
    }

    public void flipYScreenXSlave() {
        this.mFullScreen.flipYScreenXSlave();
    }

    public void flipXScreen() {
        this.mFullScreen.flipXScreen();
    }

    public void setEncoderFlipX(int type) {
        if (this.mFullScreen != null) {
            YMFLog.info(this, "[Encoder ]", "encoder setEncoderFlipX");
            this.mFullScreen.setTextureFlipX(0);
        }
    }

    private void setEncoderFlipY() {
        if (this.mFullScreen != null) {
            YMFLog.info(this, "[Encoder ]", "encoder setEncoderFlipY");
            this.mFullScreen.setTextureFlipY(0);
            this.mFullScreen.setTextureFlipY(1);
            this.mFullScreen.setTextureFlipY(2);
        }
    }

    public void adjustBitRate(int bitRateInKbps) {
        if (this.mVideoEncoderImpl != null) {
            this.mVideoEncoderImpl.adjustBitRate(bitRateInKbps);
        }
    }

    public void requestSyncFrame() {
        if (this.mVideoEncoderImpl != null) {
            this.mVideoEncoderImpl.requestSyncFrame();
        }
    }

    public void onEncodedFrameFinished(long pts) {
        if (this.mVideoEncoderImpl != null) {
            this.mVideoEncoderImpl.drainEncoder(pts, false);
        }
    }

    public String getMediaFormat() {
        if (this.mVideoEncoderImpl != null) {
            return this.mVideoEncoderImpl.getFormat();
        }
        return "";
    }

    public void recoverCachedPtsList(long dts) {
        if (this.mVideoEncoderImpl != null) {
            this.mVideoEncoderImpl.recoverCachedPtsList(dts);
        }
    }

    public void createGlElementEnv() {
        if (this.mInputMode != Constant.EncoderInputMode.SURFACE) {
            YMFLog.info(this, "[Encoder ]", "createGlElementEnv nothing  buffer encoder ");
            return;
        }
        long timeBegin = System.currentTimeMillis();
        this.mFullScreen = new FullFrameRect(new Texture2dProgram(Texture2dProgram.ProgramType.TEXTURE_2D_WITH_EXTRA_TXT_2), Drawable2d.Prefab.FULL_RECTANGLE, GlUtil.createFloatBuffer(Drawable2d.FULL_RECTANGLE_TEX_COORDS), GlUtil.createFloatBuffer(Drawable2d.FULL_RECTANGLE_TEX_COORDS));
        this.setEncoderFlipY();
        this.mInputWindowSurface = this.mEglCore.createWindowSurface(this.mVideoEncoderImpl.getInputSurface(), true);
        YMFLog.info(this, "[Encoder ]", "createGlElementEnv success, cost time:" + (System.currentTimeMillis() - timeBegin));
    }

    public void destoryGlElementEnvOnly() {
        YMFLog.info(this, "[Encoder ]", "destoryGlElementEnvOnly  begin");
        final CountDownLatch barrier = new CountDownLatch(1);
        if (!this.mFilterContext.getGLManager().checkSameThread()) {
            this.mFilterContext.getGLManager().getHandler().post(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (AbstractTextureMoiveEncoder.this.mInputWindowSurface != null) {
                            AbstractTextureMoiveEncoder.this.mGlManager.resetContext();
                            AbstractTextureMoiveEncoder.this.mInputWindowSurface.release();
                            AbstractTextureMoiveEncoder.this.mInputWindowSurface = null;
                        }
                        if (AbstractTextureMoiveEncoder.this.mFullScreen != null) {
                            AbstractTextureMoiveEncoder.this.mFullScreen.release(true);
                            AbstractTextureMoiveEncoder.this.mFullScreen = null;
                        }
                        barrier.countDown();
                    }
                    catch (Exception e) {
                        YMFLog.error((Object)this, "[Encoder ]", "destoryGlElementEnvOnly exception:" + e.toString());
                    }
                }
            });
            try {
                barrier.await();
            }
            catch (InterruptedException e) {
                YMFLog.error((Object)this, "[Encoder ]", "destoryGlElementEnvOnly  .barrier.await exception:" + e.toString());
            }
        } else {
            try {
                if (this.mInputWindowSurface != null) {
                    this.mGlManager.resetContext();
                    this.mInputWindowSurface.release();
                    this.mInputWindowSurface = null;
                }
                if (this.mFullScreen != null) {
                    this.mFullScreen.release(true);
                    this.mFullScreen = null;
                }
            }
            catch (Exception e) {
                YMFLog.error((Object)this, "[Encoder ]", "releaseEncoderAsync exception:" + e.toString());
            }
        }
        YMFLog.info(this, "[Encoder ]", "destoryGlElementEnvOnly success");
    }

    public long startEncoerAsync(VideoEncoderConfig config) {
        long eid = sEncodeIds.incrementAndGet();
        this.mVideoEncoderConfig = config;
        try {
            this.mVideoEncoderImpl = this.mVideoEncoderConfig.mEncodeType == VideoEncoderType.HARD_ENCODER_H264 ? new H264SurfaceEncoder(eid) : new H265SurfaceEncoder(eid);
            if (this.mVideoEncoderImpl.init(config, this.mHardEncoderListener, this.mInputMode)) {
                return eid;
            }
            YMFLog.error((Object)this, "[Encoder ]", "videocodec init fail");
            this.releaseEncoderAsync();
            return -1L;
        }
        catch (Throwable t) {
            this.releaseEncoderAsync();
            YMFLog.error((Object)this, "[Encoder ]", "start video encoder exception:" + t.getMessage());
            return -1L;
        }
    }

    public void releaseEncoderAsync() {
        if (this.mVideoEncoderImpl != null) {
            this.mVideoEncoderImpl.deInit();
            this.mVideoEncoderImpl = null;
        }
        this.mInputWidth = 0;
        this.mInputHeight = 0;
        this.mClipWidth = 0;
        this.mClipHeight = 0;
        YMFLog.info(this, "[Encoder ]", "releaseEncoderAsync done");
    }

    public boolean getCacheEncodedData() {
        if (this.mVideoEncoderImpl != null) {
            return this.mVideoEncoderImpl.getCacheEncodedData();
        }
        YMFLog.info(this, "[Encoder ]", "getCacheEncodedData mVideoEncoderImpl == null!");
        return false;
    }
}

