/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.decoder;

import android.annotation.TargetApi;
import android.graphics.ImageFormat;
import android.graphics.Rect;
import android.media.Image;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaFormat;
import android.os.Build;
import android.support.annotation.NonNull;
import com.yy.mediaframework.decoder.BaseDecoder;
import com.yy.mediaframework.model.DecodeVideoConfig;
import com.yy.mediaframework.model.DecodeVideoSample;
import com.yy.mediaframework.model.YYPeripheralsVideoSampleAllocator;
import com.yy.mediaframework.utils.YMFLog;
import java.io.IOException;
import java.nio.ByteBuffer;

@TargetApi(value=16)
public class BaseHardwareDecoder
extends BaseDecoder {
    protected MediaCodec mDecoder;
    protected MediaFormat mDecoderFormat;
    protected ByteBuffer[] mInputBuffers;
    protected ByteBuffer[] mOutputBuffers;
    protected MediaCodec.BufferInfo mBufferInfo;
    protected boolean isInited = false;
    private static final byte[] SYNC_FLAG = new byte[1];
    private int mNoFrameCnt = 0;
    private OnDecoderSizeChangeListener mOnDecoderSizeChangeListener;
    private OnDecoderYUVListener mOnDecoderYUVListener;
    private Boolean mSupportFlexible = false;
    private byte[] mHeader = null;

    public BaseHardwareDecoder(@NonNull int width, @NonNull int height, @NonNull String codeName, @NonNull String codecType) {
        super(width, height, codeName, codecType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TargetApi(value=18)
    public int initDecoder(DecodeVideoConfig config) {
        YMFLog.info(this, "[Decoder ]", "init decoder.");
        boolean createCoderSuccessfully = true;
        byte[] byArray = SYNC_FLAG;
        synchronized (SYNC_FLAG) {
            this.mDecodeVideoConfig = config;
            this.mDecoderFormat = MediaFormat.createVideoFormat((String)this.mCodecType, (int)this.mDecodeWidth, (int)this.mDecodeHeight);
            String spsppsString = String.valueOf(config.spspps);
            if (this.mDecodeVideoConfig.mCodecType == null || this.mDecodeVideoConfig.mCodecType.isEmpty()) {
                this.mDecodeVideoConfig.mCodecType = "video/avc";
            }
            this.mDecoderFormat.setString("mime", config.mCodecType);
            if (this.mDecodeVideoConfig.sps != null && this.mDecodeVideoConfig.pps != null) {
                this.mDecoderFormat.setByteBuffer("csd-0", ByteBuffer.wrap(this.mDecodeVideoConfig.sps));
                this.mDecoderFormat.setByteBuffer("csd-1", ByteBuffer.wrap(this.mDecodeVideoConfig.pps));
            }
            try {
                if (this.mCodecName == null || this.mCodecName.isEmpty()) {
                    YMFLog.info(this, "[Decoder ]", "mCodecName:null mCodeType:" + config.mCodecType);
                    this.mDecoder = MediaCodec.createDecoderByType((String)config.mCodecType);
                } else {
                    this.mDecoder = MediaCodec.createByCodecName((String)this.mCodecName);
                }
                if (Build.VERSION.SDK_INT >= 21 && this.mDecodeVideoConfig.mRenderSurface == null) {
                    MediaCodecInfo.CodecCapabilities codecCapabilities = this.mDecoder.getCodecInfo().getCapabilitiesForType(this.mCodecType);
                    int colorFormat = 21;
                    for (int c : codecCapabilities.colorFormats) {
                        if (c != 2135033992) continue;
                        colorFormat = 2135033992;
                        this.mSupportFlexible = true;
                        break;
                    }
                    this.mDecoderFormat.setInteger("color-format", colorFormat);
                    YMFLog.info(this, "[Decoder ]", "color-format:" + colorFormat);
                }
                YMFLog.info(this, "[Decoder ]", "init decoder, name:" + this.mDecoder.getName() + " type:" + this.mDecodeVideoConfig.mCodecType);
                this.mDecoder.configure(this.mDecoderFormat, this.mDecodeVideoConfig.mRenderSurface, null, 0);
                this.mDecoder.start();
            }
            catch (IOException e) {
                createCoderSuccessfully = false;
                YMFLog.info(this, "[Decoder ]", "init decoder IOException:" + e.toString());
            }
            catch (IllegalStateException e) {
                YMFLog.info(this, "[Decoder ]", "init decoder IllegalStateException:" + e.toString());
                createCoderSuccessfully = false;
            }
            catch (IllegalArgumentException e) {
                YMFLog.info(this, "[Decoder ]", "init decoder IllegalArgumentException:" + e.toString());
                createCoderSuccessfully = false;
            }
            finally {
                if (!createCoderSuccessfully) {
                    if (this.mDecoder != null) {
                        this.mDecoder.stop();
                        this.mDecoder.release();
                        this.mDecoder = null;
                    }
                } else {
                    this.mInputBuffers = this.mDecoder.getInputBuffers();
                    this.mBufferInfo = new MediaCodec.BufferInfo();
                    this.mNoFrameCnt = 0;
                    this.isInited = true;
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return createCoderSuccessfully ? 0 : -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        YMFLog.info(this, "[Decoder ]", "release decoder.");
        byte[] byArray = SYNC_FLAG;
        synchronized (SYNC_FLAG) {
            if (this.mDecoder == null) {
                YMFLog.info(this, "[Decoder ]", "decoder has already released.");
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            try {
                if (Build.VERSION.SDK_INT > 18 && this.mDecodeVideoConfig.mRenderSurface != null) {
                    this.mDecoder.signalEndOfInputStream();
                }
                this.mDecoder.flush();
                this.mDecoder.stop();
            }
            catch (IllegalStateException e) {
                YMFLog.info(this, "[Decoder ]", "release decoder exception:" + e.getMessage());
            }
            finally {
                this.mDecoder.release();
                this.mDecoder = null;
                this.isInited = false;
                this.mSupportFlexible = false;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void resetDecoder() {
        this.release();
        this.initDecoder(this.mDecodeVideoConfig);
    }

    public void resetDecoder(DecodeVideoConfig config) {
        YMFLog.info(this, "[Decoder ]", "resetDecoder, config:" + config.toString());
        this.release();
        this.initDecoder(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long drainDecoder(DecodeVideoSample sample) {
        long outpts = 0L;
        byte[] byArray = SYNC_FLAG;
        synchronized (SYNC_FLAG) {
            if (!this.isInited || sample == null) {
                YMFLog.info(this, "[Decoder ]", "decoder not inited or invalid sample data.");
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return -1L;
            }
            if (this.mDecoder == null) {
                YMFLog.info(this, "[Decoder ]", "decoder not init yet.");
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return -1L;
            }
            int inputIndex = -1;
            int outputIndex = -1;
            try {
                inputIndex = this.mDecoder.dequeueInputBuffer(200000L);
                if (inputIndex >= 0) {
                    ByteBuffer buffer = null;
                    if (Build.VERSION.SDK_INT < 21) {
                        buffer = this.mInputBuffers[inputIndex];
                        buffer.clear();
                    } else {
                        buffer = this.mDecoder.getInputBuffer(inputIndex);
                    }
                    if (buffer != null) {
                        buffer.rewind();
                        buffer.put(sample.data, 0, sample.dataLenght);
                    }
                    switch (sample.frameType) {
                        case 4: {
                            this.mDecoder.queueInputBuffer(inputIndex, 0, sample.dataLenght, sample.pts * 1000L, 1);
                            break;
                        }
                        case 5: 
                        case 6: {
                            this.mDecoder.queueInputBuffer(inputIndex, 0, sample.dataLenght, sample.pts * 1000L, 2);
                            break;
                        }
                        default: {
                            this.mDecoder.queueInputBuffer(inputIndex, 0, sample.dataLenght, sample.pts * 1000L, 0);
                        }
                    }
                }
            }
            catch (IllegalStateException e) {
                YMFLog.error((Object)this, "[Decoder ]", "drain decoder exception:" + e.toString());
            }
            while (true) {
                try {
                    outputIndex = this.mDecoder.dequeueOutputBuffer(this.mBufferInfo, 0L);
                    continue;
                }
                catch (IllegalStateException e) {
                    YMFLog.error((Object)this, "[Decoder ]", "dequeueOutputBuffer exception:" + e.toString());
                }
                finally {
                    if (outputIndex >= 0) {
                        this.mDecoder.releaseOutputBuffer(outputIndex, true);
                        outpts = this.mBufferInfo.presentationTimeUs / 1000L;
                        try {
                            this.mDecoderFormat = this.mDecoder.getOutputFormat();
                        }
                        catch (IllegalStateException e) {
                            YMFLog.error((Object)this, "[Decoder ]", "getOutputFormat exception:" + e.toString());
                            continue;
                        }
                        int width = this.mDecoderFormat.getInteger("width");
                        int height = this.mDecoderFormat.getInteger("height");
                        if (this.mOnDecoderSizeChangeListener != null) {
                            this.mOnDecoderSizeChangeListener.onDecoderSizeChanged(width, height);
                        }
                        this.mNoFrameCnt = 0;
                        continue;
                    }
                    if (outputIndex == -3) {
                        YMFLog.info(this, "[Decoder ]", "HardDecRender PushFrame INFO_OUTPUT_BUFFERS_CHANGED");
                        continue;
                    }
                    if (outputIndex == -2) {
                        this.mDecoderFormat = this.mDecoder.getOutputFormat();
                        this.mDecodeWidth = this.mDecoderFormat.getInteger("width");
                        this.mDecodeHeight = this.mDecoderFormat.getInteger("height");
                        YMFLog.debug((Object)this, "[Decoder ]", "HardDecRender PushFrame INFO_OUTPUT_FORMAT_CHANGED format:" + this.mDecoder.getOutputFormat() + " width:" + this.mDecodeWidth + " height:" + this.mDecodeHeight);
                        continue;
                    }
                    if (outputIndex != -1) continue;
                    ++this.mNoFrameCnt;
                    if (this.mNoFrameCnt % 150 == 0) {
                        this.resetDecoder();
                        YMFLog.error((Object)this, "[Decoder ]", "HardDecRender PushFrame noFrameCnt:" + this.mNoFrameCnt);
                    }
                    YMFLog.debug((Object)this, "[Decoder ]", "HardDecRender PushFrame INFO_TRY_AGAIN_LATER, no frame count:" + this.mNoFrameCnt);
                    continue;
                }
                break;
            }
            YYPeripheralsVideoSampleAllocator.instance().free(sample);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return outpts;
        }
    }

    public boolean isInited() {
        return this.isInited;
    }

    public void setOnDecoderSizeChangeListener(OnDecoderSizeChangeListener listener) {
        this.mOnDecoderSizeChangeListener = listener;
    }

    private String byte2hex(byte[] buffer) {
        if (buffer == null || buffer.length <= 0) {
            YMFLog.info(this, "[Decoder ]", "invalid buffer");
            return "";
        }
        String h = "";
        for (int i = 0; i < buffer.length; ++i) {
            String temp = Integer.toHexString(buffer[i] & 0xFF);
            if (temp.length() == 1) {
                temp = "0" + temp;
            }
            h = h + " " + temp;
        }
        return h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long drainDecoder(@NonNull byte[] data, int dataLen, boolean header, long pts) {
        long outpts = 0L;
        byte[] byArray = SYNC_FLAG;
        synchronized (SYNC_FLAG) {
            if (!this.isInited || data == null) {
                YMFLog.info(this, "[Decoder ]", "decoder not inited or invalid data.");
                // ** MonitorExit[var8_6] (shouldn't be in output)
                return -1L;
            }
            if (this.mDecoder == null) {
                YMFLog.info(this, "[Decoder ]", "decoder not init yet.");
                // ** MonitorExit[var8_6] (shouldn't be in output)
                return -1L;
            }
            int inputIndex = -1;
            int outputIndex = -1;
            try {
                inputIndex = this.mDecoder.dequeueInputBuffer(200000L);
                if (inputIndex >= 0) {
                    ByteBuffer buffer = null;
                    if (Build.VERSION.SDK_INT < 21) {
                        buffer = this.mInputBuffers[inputIndex];
                        buffer.clear();
                    } else {
                        buffer = this.mDecoder.getInputBuffer(inputIndex);
                    }
                    if (buffer != null) {
                        buffer.rewind();
                        buffer.put(data, 0, dataLen);
                    }
                    if (header) {
                        this.mDecoder.queueInputBuffer(inputIndex, 0, dataLen, pts * 1000L, 2);
                        this.mHeader = new byte[dataLen];
                        System.arraycopy(data, 0, this.mHeader, 0, dataLen);
                        YMFLog.info(this, "[Decoder ]", "BUFFER_FLAG_CODEC_CONFIG");
                    } else {
                        this.mDecoder.queueInputBuffer(inputIndex, 0, dataLen, pts * 1000L, 0);
                    }
                }
            }
            catch (IllegalStateException e) {
                YMFLog.error((Object)this, "[Decoder ]", "drain decoder exception:" + e.toString());
            }
            while (true) {
                try {
                    outputIndex = this.mDecoder.dequeueOutputBuffer(this.mBufferInfo, 0L);
                    continue;
                }
                catch (IllegalStateException e) {
                    YMFLog.error((Object)this, "[Decoder ]", "dequeueOutputBuffer exception:" + e.toString());
                }
                finally {
                    if (outputIndex >= 0) {
                        outpts = this.mBufferInfo.presentationTimeUs / 1000L;
                        try {
                            this.mDecoderFormat = this.mDecoder.getOutputFormat();
                        }
                        catch (IllegalStateException e) {
                            YMFLog.error((Object)this, "[Decoder ]", "getOutputFormat exception:" + e.toString());
                            continue;
                        }
                        int width = this.mDecoderFormat.getInteger("width");
                        int height = this.mDecoderFormat.getInteger("height");
                        if (this.mOnDecoderSizeChangeListener != null) {
                            this.mOnDecoderSizeChangeListener.onDecoderSizeChanged(width, height);
                        }
                        if (this.mOnDecoderYUVListener != null && this.mBufferInfo.size > 0 && this.mOnDecoderYUVListener.onVerifyPts(outpts)) {
                            if (this.mSupportFlexible.booleanValue()) {
                                Image image = this.mDecoder.getOutputImage(outputIndex);
                                Rect crop = image.getCropRect();
                                width = crop.width();
                                height = crop.height();
                                int format = image.getFormat();
                                int dateLen = width * height * ImageFormat.getBitsPerPixel((int)format) / 8;
                                YMFLog.info(this, "[Decoder ]", "color format:" + format);
                                this.mOnDecoderYUVListener.OnDecoderYUVListener(width, height, null, image, dateLen, outpts, this.mBufferInfo.flags);
                                image.close();
                            } else {
                                ByteBuffer buffer = null;
                                if (Build.VERSION.SDK_INT < 21) {
                                    buffer = this.mOutputBuffers[outputIndex];
                                    buffer.clear();
                                } else {
                                    buffer = this.mDecoder.getOutputBuffer(outputIndex);
                                }
                                this.mOnDecoderYUVListener.OnDecoderYUVListener(width, height, buffer, null, this.mBufferInfo.size, outpts, this.mBufferInfo.flags);
                            }
                        }
                        this.mDecoder.releaseOutputBuffer(outputIndex, false);
                        this.mNoFrameCnt = 0;
                        continue;
                    }
                    if (outputIndex == -3) {
                        YMFLog.info(this, "[Decoder ]", "HardDecRender PushFrame INFO_OUTPUT_BUFFERS_CHANGED");
                        continue;
                    }
                    if (outputIndex == -2) {
                        this.mDecoderFormat = this.mDecoder.getOutputFormat();
                        this.mDecodeWidth = this.mDecoderFormat.getInteger("width");
                        this.mDecodeHeight = this.mDecoderFormat.getInteger("height");
                        YMFLog.debug((Object)this, "[Decoder ]", "HardDecRender PushFrame INFO_OUTPUT_FORMAT_CHANGED format:" + this.mDecoder.getOutputFormat() + " width:" + this.mDecodeWidth + " height:" + this.mDecodeHeight);
                        continue;
                    }
                    if (outputIndex != -1) continue;
                    ++this.mNoFrameCnt;
                    if (this.mNoFrameCnt % 150 != 0) continue;
                    if (this.mOnDecoderYUVListener != null) {
                        this.mOnDecoderYUVListener.OnDecoderError();
                    }
                    this.resetDecoder();
                    YMFLog.error((Object)this, "[Decoder ]", "HardDecRender PushFrame noFrameCnt:" + this.mNoFrameCnt);
                    continue;
                }
                break;
            }
            if (inputIndex < 0) {
                YMFLog.error((Object)this, "[Decoder ]", "HardDecRender drainDecoder data err input block");
            }
            // ** MonitorExit[var8_6] (shouldn't be in output)
            return outpts;
        }
    }

    public boolean decoderHeaderChange(byte[] header, int headerLen) {
        if (this.mHeader == null) {
            return true;
        }
        if (this.mHeader.length != headerLen) {
            return true;
        }
        for (int i = 0; i < headerLen; ++i) {
            if (this.mHeader[i] == header[i]) continue;
            return true;
        }
        return false;
    }

    public void setOnDecoderYUVListener(OnDecoderYUVListener listener) {
        this.mOnDecoderYUVListener = listener;
    }

    public static interface OnDecoderYUVListener {
        public void OnDecoderYUVListener(int var1, int var2, ByteBuffer var3, Image var4, int var5, long var6, int var8);

        public boolean onVerifyPts(long var1);

        public void OnDecoderError();
    }

    public static interface OnDecoderSizeChangeListener {
        public void onDecoderSizeChanged(int var1, int var2);
    }
}

