/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.cryptoutil;

import com.yy.mediaframework.cryptoutil.Crypto;
import com.yy.mediaframework.cryptoutil.FilterCrypto;
import com.yy.mediaframework.utils.YMFLog;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Arrays;
import javax.crypto.Cipher;

public class RSACrypto
implements Crypto {
    protected static final String TAG = FilterCrypto.class.getSimpleName();
    private PublicKey mPublicKey;
    private PrivateKey mPrivateKey;

    public static KeyPair generateRSAKeyPair(int keyLength) {
        try {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
            kpg.initialize(keyLength);
            KeyPair keyPair = kpg.genKeyPair();
            return keyPair;
        }
        catch (Exception e) {
            YMFLog.error(null, "[Util    ]", "Cannot generateRSAKeyPair:%d", keyLength);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Key createKeyFromObjectData(InputStream is) {
        ObjectInputStream ois = null;
        Key key = null;
        ois = new ObjectInputStream(is);
        key = (Key)ois.readObject();
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException e) {
            YMFLog.error(null, "[Util    ]", "close InputStream exception:%s", e);
        }
        finally {
            is = null;
        }
        try {
            if (ois == null) return key;
            ois.close();
            return key;
        }
        catch (IOException e) {
            YMFLog.error(null, "[Procedur]", "close ObjectInputStream exception:%s", e);
            return key;
        }
        finally {
            ois = null;
        }
        catch (Exception e) {
            try {
                YMFLog.error(null, "[Util    ]", "createKeyFromObjectData error:%s", e.toString());
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e2) {
                    YMFLog.error(null, "[Util    ]", "close InputStream exception:%s", e2);
                }
                finally {
                    is = null;
                }
                try {
                    if (ois == null) throw throwable;
                    ois.close();
                    throw throwable;
                }
                catch (IOException e3) {
                    YMFLog.error(null, "[Procedur]", "close ObjectInputStream exception:%s", e3);
                    throw throwable;
                }
                finally {
                    ois = null;
                }
            }
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e4) {
                YMFLog.error(null, "[Util    ]", "close InputStream exception:%s", e4);
            }
            finally {
                is = null;
            }
            try {
                if (ois == null) return key;
                ois.close();
                return key;
            }
            catch (IOException e5) {
                YMFLog.error(null, "[Procedur]", "close ObjectInputStream exception:%s", e5);
                return key;
            }
            finally {
                ois = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static byte[] keyPairToByteArray(Key key) {
        ByteArrayOutputStream os = null;
        ObjectOutputStream oos = null;
        os = new ByteArrayOutputStream();
        oos = new ObjectOutputStream(os);
        oos.writeObject(key);
        byte[] byArray = os.toByteArray();
        try {
            if (oos != null) {
                oos.close();
            }
        }
        catch (IOException e) {
            YMFLog.error(null, "[Util    ]", "close ObjectOutputStream exception:%s", e.toString());
        }
        finally {
            oos = null;
        }
        try {
            if (os != null) {
                os.close();
            }
        }
        catch (IOException e) {
            YMFLog.error(null, "[Util    ]", "close ByteArrayOutputStream exception:%s", e);
        }
        finally {
            os = null;
        }
        return byArray;
        catch (Exception e) {
            byte[] byArray2;
            try {
                YMFLog.error(null, "[Util    ]", "toByteArray error:%s", e.toString());
                byArray2 = null;
            }
            catch (Throwable throwable) {
                try {
                    if (oos != null) {
                        oos.close();
                    }
                }
                catch (IOException e2) {
                    YMFLog.error(null, "[Util    ]", "close ObjectOutputStream exception:%s", e2.toString());
                }
                finally {
                    oos = null;
                }
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException e3) {
                    YMFLog.error(null, "[Util    ]", "close ByteArrayOutputStream exception:%s", e3);
                }
                finally {
                    os = null;
                }
                throw throwable;
            }
            try {
                if (oos != null) {
                    oos.close();
                }
            }
            catch (IOException e4) {
                YMFLog.error(null, "[Util    ]", "close ObjectOutputStream exception:%s", e4.toString());
            }
            finally {
                oos = null;
            }
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException e5) {
                YMFLog.error(null, "[Util    ]", "close ByteArrayOutputStream exception:%s", e5);
            }
            finally {
                os = null;
            }
            return byArray2;
        }
    }

    public RSACrypto(PublicKey publicKey) {
        this.mPublicKey = publicKey;
    }

    public RSACrypto(PrivateKey privateKey) {
        this.mPrivateKey = privateKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public byte[] encode(byte[] rawData) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(1, this.mPublicKey);
        int inputLen = rawData.length;
        int offset = 0;
        int i = 0;
        while (inputLen - offset > 0) {
            byte[] cache = inputLen - offset > 32 ? cipher.doFinal(rawData, offset, 32) : cipher.doFinal(rawData, offset, inputLen - offset);
            bos.write(cache, 0, cache.length);
            offset = ++i * 32;
        }
        byte[] byArray = bos.toByteArray();
        try {
            bos.close();
        }
        catch (IOException e) {
            YMFLog.error(null, "[Util    ]", "close ByteArrayOutputStream exception:%s", e.toString());
        }
        finally {
            bos = null;
        }
        return byArray;
        catch (Exception e) {
            byte[] byArray2;
            try {
                YMFLog.error(null, "[Util    ]", "Cannot encode data:%s, exception:%s", Arrays.toString(rawData), e.toString());
                byArray2 = null;
            }
            catch (Throwable throwable) {
                try {
                    bos.close();
                }
                catch (IOException e2) {
                    YMFLog.error(null, "[Util    ]", "close ByteArrayOutputStream exception:%s", e2.toString());
                }
                finally {
                    bos = null;
                }
                throw throwable;
            }
            try {
                bos.close();
            }
            catch (IOException e3) {
                YMFLog.error(null, "[Util    ]", "close ByteArrayOutputStream exception:%s", e3.toString());
            }
            finally {
                bos = null;
            }
            return byArray2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public byte[] decode(byte[] encryptData) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, this.mPrivateKey);
        int inputLen = encryptData.length;
        int offset = 0;
        int i = 0;
        while (inputLen - offset > 0) {
            byte[] cache = inputLen - offset > 64 ? cipher.doFinal(encryptData, offset, 64) : cipher.doFinal(encryptData, offset, inputLen - offset);
            bos.write(cache, 0, cache.length);
            offset = ++i * 64;
        }
        byte[] byArray = bos.toByteArray();
        try {
            bos.close();
        }
        catch (IOException e) {
            YMFLog.error(null, "[Util    ]", "close ByteArrayOutputStream exception:%s", e);
        }
        finally {
            bos = null;
        }
        return byArray;
        catch (Exception e) {
            byte[] byArray2;
            try {
                YMFLog.error(null, "[Util    ]", "Cannot decode data:%s, exception:%s", Arrays.toString(encryptData), e.toString());
                byArray2 = null;
            }
            catch (Throwable throwable) {
                try {
                    bos.close();
                }
                catch (IOException e2) {
                    YMFLog.error(null, "[Util    ]", "close ByteArrayOutputStream exception:%s", e2);
                }
                finally {
                    bos = null;
                }
                throw throwable;
            }
            try {
                bos.close();
            }
            catch (IOException e3) {
                YMFLog.error(null, "[Util    ]", "close ByteArrayOutputStream exception:%s", e3);
            }
            finally {
                bos = null;
            }
            return byArray2;
        }
    }

    public static void createRSAKeyPairFile(String publicKeyPath, String privateKeyPath) {
        KeyPair keyPair = RSACrypto.generateRSAKeyPair(512);
        if (keyPair == null) {
            YMFLog.error(null, "[Procedur]", "generateRSAKeyPair failed.");
            return;
        }
        byte[] bytesPublic = RSACrypto.keyPairToByteArray(keyPair.getPublic());
        RSACrypto.makeKeyFile(publicKeyPath, bytesPublic);
        byte[] bytesPrivate = RSACrypto.keyPairToByteArray(keyPair.getPrivate());
        RSACrypto.makeKeyFile(privateKeyPath, bytesPrivate);
        if (bytesPrivate != null) {
            YMFLog.debug(null, "[Util    ]", "public len:" + bytesPublic.length + ",private len:" + bytesPrivate.length);
        }
    }

    public static void createFile(String filePath) {
        File f = new File(filePath);
        if (!f.exists()) {
            try {
                f.createNewFile();
            }
            catch (IOException e) {
                YMFLog.error(null, "[Util    ]", "createFile exception:%s" + e.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void makeKeyFile(String path, byte[] bytes) {
        RSACrypto.createFile(path);
        FileOutputStream fos = null;
        fos = new FileOutputStream(path);
        fos.write(bytes);
        fos.flush();
        try {
            if (fos == null) return;
            fos.close();
            return;
        }
        catch (IOException e) {
            YMFLog.error(null, "[Util    ]", "close FileOutputStream exception:%s", e.toString());
            return;
        }
        finally {
            fos = null;
        }
        catch (Exception e) {
            try {
                YMFLog.error(null, "[Util    ]", "makeKeyFile exception:%s", e.toString());
            }
            catch (Throwable throwable) {
                try {
                    if (fos == null) throw throwable;
                    fos.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    YMFLog.error(null, "[Util    ]", "close FileOutputStream exception:%s", e2.toString());
                    throw throwable;
                }
                finally {
                    fos = null;
                }
            }
            try {
                if (fos == null) return;
                fos.close();
                return;
            }
            catch (IOException e3) {
                YMFLog.error(null, "[Util    ]", "close FileOutputStream exception:%s", e3.toString());
                return;
            }
            finally {
                fos = null;
            }
        }
    }
}

