/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.cryptoutil;

import com.yy.mediaframework.cryptoutil.AESCrypto;
import com.yy.mediaframework.cryptoutil.Crypto;
import com.yy.mediaframework.cryptoutil.RSACrypto;
import com.yy.mediaframework.utils.YMFLog;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.SecretKey;

public class FilterCrypto
implements Crypto {
    protected static final String TAG = FilterCrypto.class.getSimpleName();
    protected RSACrypto mRSACrypto;
    protected AESCrypto mAESCrypto;
    protected byte[] mEncryptAESKey;
    private static final char[] UPPER_CASE_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};

    public static FilterCrypto newEncoder(PublicKey keyPair) {
        FilterCrypto filterCrypto = new FilterCrypto();
        filterCrypto.initEncoder(keyPair);
        return filterCrypto;
    }

    public static FilterCrypto newDecoder(PrivateKey keyPair) {
        FilterCrypto filterCrypto = new FilterCrypto();
        filterCrypto.initDecoder(keyPair);
        return filterCrypto;
    }

    private FilterCrypto() {
    }

    public boolean initEncoder(PublicKey publicKey) {
        long now = System.currentTimeMillis();
        byte[] bytes = new byte[]{(byte)(now >> 32), (byte)(now >> 16), (byte)(now >> 8), (byte)now};
        SecretKey secretKey = AESCrypto.generateAESKey(bytes, 128);
        this.mAESCrypto = new AESCrypto(secretKey);
        byte[] secretKeyBytes = AESCrypto.keyToByteArray(secretKey);
        if (secretKeyBytes == null) {
            YMFLog.error((Object)this, "[Util    ]", "Crypto failed: secretKeyBytes == null");
            return false;
        }
        YMFLog.info(this, "[Util    ]", "secretKeyBytes length:" + secretKeyBytes.length + "," + FilterCrypto.strToBinary(secretKeyBytes));
        this.mRSACrypto = new RSACrypto(publicKey);
        this.mEncryptAESKey = this.mRSACrypto.encode(secretKeyBytes);
        YMFLog.info(this, "[Util    ]", "mEncryptAESKey:" + FilterCrypto.strToBinary(this.mEncryptAESKey));
        return this.mEncryptAESKey != null;
    }

    @Override
    public byte[] encode(byte[] rawData) {
        byte[] result = this.mAESCrypto.encode(rawData);
        if (result != null && this.mEncryptAESKey != null) {
            int combileSize = this.mEncryptAESKey.length + result.length + 4;
            YMFLog.debug((Object)this, "[Util    ]", "combileSize 4+" + this.mEncryptAESKey.length + "+" + result.length + ":" + combileSize + ",result:" + FilterCrypto.strToBinary(result));
            ByteBuffer byteBuffer = ByteBuffer.allocate(combileSize);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.putInt(this.mEncryptAESKey.length);
            byteBuffer.put(this.mEncryptAESKey);
            byteBuffer.put(result);
            return byteBuffer.array();
        }
        return null;
    }

    public void initDecoder(PrivateKey privateKey) {
        this.mRSACrypto = new RSACrypto(privateKey);
    }

    @Override
    public byte[] decode(byte[] encryptData) {
        if (encryptData == null) {
            return null;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(encryptData);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        int aesKeyLength = byteBuffer.getInt();
        YMFLog.info(null, "[Util    ]", "decode aesKeyLength:%d", aesKeyLength);
        byte[] aesKeyBytes = new byte[aesKeyLength];
        byteBuffer.get(aesKeyBytes);
        YMFLog.info(null, "[Util    ]", "decode aesKeyBytes:" + FilterCrypto.strToBinary(aesKeyBytes));
        byte[] decryptAESKey = this.mRSACrypto.decode(aesKeyBytes);
        if (decryptAESKey != null) {
            YMFLog.info(null, "[Util    ]", "decode decryptAESKey:%s len:%d", FilterCrypto.strToBinary(decryptAESKey), decryptAESKey.length);
            Key aesKey = AESCrypto.createKeyFromObjectData(decryptAESKey);
            this.mAESCrypto = new AESCrypto(aesKey);
            byte[] result = new byte[encryptData.length - 4 - aesKeyLength];
            byteBuffer.get(result);
            byte[] decryptResult = this.mAESCrypto.decode(result);
            return decryptResult;
        }
        return null;
    }

    public static String strToBinary(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            sb.append(FilterCrypto.byteToHexString(bytes[i])).append(" ");
        }
        return sb.toString();
    }

    public static String byteToHexString(byte b) {
        char[] digits = UPPER_CASE_DIGITS;
        char[] buf = new char[]{digits[b >> 4 & 0xF], digits[b & 0xF]};
        return new String(buf);
    }
}

