/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.cryptoutil;

import com.yy.mediaframework.cryptoutil.Crypto;
import com.yy.mediaframework.utils.YMFLog;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

public class AESCrypto
implements Crypto {
    protected static final String TAG = AESCrypto.class.getSimpleName();
    protected Key mKey;

    public static SecretKey generateAESKey(byte[] seed, int keyLength) {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
            SecureRandom secureRandom = new SecureRandom();
            secureRandom.setSeed(seed);
            keyGenerator.init(keyLength, secureRandom);
            return keyGenerator.generateKey();
        }
        catch (Exception e) {
            YMFLog.error(null, "[Util    ]", "Cannot generateAESKey:%d", keyLength);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Key createKeyFromObjectData(byte[] data) {
        ByteArrayInputStream is = null;
        ObjectInputStream ois = null;
        Key key = null;
        is = new ByteArrayInputStream(data);
        ois = new ObjectInputStream(is);
        key = (Key)ois.readObject();
        try {
            if (is != null) {
                ((InputStream)is).close();
            }
        }
        catch (Exception e) {
            YMFLog.error(null, "[Util    ]", "ByteArrayInputStream exception:%s", e.toString());
        }
        finally {
            is = null;
        }
        try {
            if (ois == null) return key;
            ois.close();
            return key;
        }
        catch (Exception e) {
            YMFLog.error(null, "[Util    ]", "ObjectInputStream exception:" + e.toString());
            return key;
        }
        finally {
            ois = null;
        }
        catch (Exception e) {
            try {
                YMFLog.error(null, "[Util    ]", "createKeyFromObjectData exception:%s", e.toString());
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
                catch (Exception e2) {
                    YMFLog.error(null, "[Util    ]", "ByteArrayInputStream exception:%s", e2.toString());
                }
                finally {
                    is = null;
                }
                try {
                    if (ois == null) throw throwable;
                    ois.close();
                    throw throwable;
                }
                catch (Exception e3) {
                    YMFLog.error(null, "[Util    ]", "ObjectInputStream exception:" + e3.toString());
                    throw throwable;
                }
                finally {
                    ois = null;
                }
            }
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (Exception e4) {
                YMFLog.error(null, "[Util    ]", "ByteArrayInputStream exception:%s", e4.toString());
            }
            finally {
                is = null;
            }
            try {
                if (ois == null) return key;
                ois.close();
                return key;
            }
            catch (Exception e5) {
                YMFLog.error(null, "[Util    ]", "ObjectInputStream exception:" + e5.toString());
                return key;
            }
            finally {
                ois = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static byte[] keyToByteArray(Key key) {
        ByteArrayOutputStream os = null;
        ObjectOutputStream oos = null;
        os = new ByteArrayOutputStream();
        oos = new ObjectOutputStream(os);
        oos.writeObject(key);
        byte[] byArray = os.toByteArray();
        try {
            if (oos != null) {
                oos.close();
            }
        }
        catch (Exception e) {
            YMFLog.error(null, "[Util    ]", "ObjectOutputStream exception:%s", e);
        }
        finally {
            oos = null;
        }
        try {
            if (os != null) {
                os.close();
            }
        }
        catch (Exception e) {
            YMFLog.error(null, "[Util    ]", "ByteArrayOutputStream exception:%s:", e);
        }
        finally {
            os = null;
        }
        return byArray;
        catch (Exception e) {
            byte[] byArray2;
            try {
                YMFLog.error(null, "[Util    ]", "toByteArray exception:%s", e.toString());
                byArray2 = null;
            }
            catch (Throwable throwable) {
                try {
                    if (oos != null) {
                        oos.close();
                    }
                }
                catch (Exception e2) {
                    YMFLog.error(null, "[Util    ]", "ObjectOutputStream exception:%s", e2);
                }
                finally {
                    oos = null;
                }
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (Exception e3) {
                    YMFLog.error(null, "[Util    ]", "ByteArrayOutputStream exception:%s:", e3);
                }
                finally {
                    os = null;
                }
                throw throwable;
            }
            try {
                if (oos != null) {
                    oos.close();
                }
            }
            catch (Exception e4) {
                YMFLog.error(null, "[Util    ]", "ObjectOutputStream exception:%s", e4);
            }
            finally {
                oos = null;
            }
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (Exception e5) {
                YMFLog.error(null, "[Util    ]", "ByteArrayOutputStream exception:%s:", e5);
            }
            finally {
                os = null;
            }
            return byArray2;
        }
    }

    public AESCrypto(Key key) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        this.mKey = key;
    }

    public byte[] encode(byte[] src, int offset, int len) {
        try {
            Cipher cipher = Cipher.getInstance("AES");
            Key key = this.getKey();
            cipher.init(1, key);
            return cipher.doFinal(src, offset, len);
        }
        catch (Exception e) {
            YMFLog.error(null, "[Util    ]", "encrypt exception:%s", e.toString());
            return null;
        }
    }

    @Override
    public byte[] encode(byte[] src) {
        return this.encode(src, 0, src.length);
    }

    @Override
    public byte[] decode(byte[] src) {
        try {
            Cipher cipher = Cipher.getInstance("AES");
            Key key = this.getKey();
            cipher.init(2, key);
            return cipher.doFinal(src);
        }
        catch (Exception e) {
            YMFLog.error(null, "[Util    ]", "decrypt error, dataLen:%d, exception:%s", src.length, e.toString());
            return null;
        }
    }

    public Key getKey() {
        return this.mKey;
    }
}

