/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework;

import android.hardware.Camera;
import android.view.MotionEvent;
import com.yy.mediaframework.CameraInterface;
import com.yy.mediaframework.CameraUtils;
import com.yy.mediaframework.PictureInPictureDisplayInfo;
import com.yy.mediaframework.stat.YMFLiveStatisticManager;
import com.yy.mediaframework.stat.YMFLiveUsrBehaviorStat;
import com.yy.mediaframework.utils.YMFLog;
import java.util.concurrent.CountDownLatch;

public class YYCamera {
    private static final String TAG = "YYCamera";
    private static volatile YYCamera mInstance;
    private CameraInterface mCameraInterface = CameraInterface.getInstance();
    private static final byte[] SYNC_FLAG;
    private int mCameraState;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static YYCamera getInstance() {
        if (mInstance != null) return mInstance;
        byte[] byArray = SYNC_FLAG;
        synchronized (SYNC_FLAG) {
            if (mInstance != null) return mInstance;
            mInstance = new YYCamera();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    private YYCamera() {
    }

    public int startPreview(final int width, final int height, final int fps, final CameraUtils.CameraFacing cameraFacing, final boolean displayPortrait, final CameraInterface.CameraResolutionMode resMode) {
        final CountDownLatch barrier = new CountDownLatch(1);
        CameraInterface.getInstance().post(new Runnable(){

            @Override
            public void run() {
                YMFLog.info(this, "[Preview ]", "startPreview...");
                YMFLiveUsrBehaviorStat.getInstance().notifyCameraCaptureState(true);
                YMFLiveStatisticManager.getInstance().reset();
                YYCamera.this.mCameraState = YYCamera.this.mCameraInterface.openCamera(width, height, fps, cameraFacing, displayPortrait, resMode);
                barrier.countDown();
            }
        });
        try {
            barrier.await();
        }
        catch (InterruptedException e) {
            YMFLog.error((Object)this, "[Preview ]", "startpreview barrier.await exception:" + e.toString());
        }
        return this.mCameraState;
    }

    public int startDualCameraLive(final int width, final int height, final int fps, final PictureInPictureDisplayInfo info) {
        final CountDownLatch barrier = new CountDownLatch(1);
        CameraInterface.getInstance().post(new Runnable(){

            @Override
            public void run() {
                YMFLog.info(this, "[CCapture]", "startDualCameraLive, width:" + width + " ,height:" + height + " ,fps:" + fps);
                YYCamera.this.mCameraInterface.openDualCamera(width, height, fps, info);
                barrier.countDown();
            }
        });
        try {
            barrier.await();
        }
        catch (InterruptedException e) {
            YMFLog.error((Object)this, "[CCapture]", "startDualCameraLive exception:" + e.toString());
        }
        return 0;
    }

    public void changePreviewParameter(final int width, final int height, final int fps, final CameraUtils.CameraFacing currentFacing, final boolean displayPortrait, final CameraInterface.CameraResolutionMode resMode) {
        final CountDownLatch barrier = new CountDownLatch(1);
        CameraInterface.getInstance().post(new Runnable(){

            @Override
            public void run() {
                YMFLog.info(this, "[Preview ]", "changePreviewParameter...");
                YYCamera.this.mCameraInterface.restart(width, height, fps, currentFacing, displayPortrait, resMode);
                barrier.countDown();
            }
        });
        try {
            barrier.await();
        }
        catch (InterruptedException e) {
            YMFLog.error((Object)this, "[Preview ]", "changePreviewParameter exception:" + e.toString());
        }
    }

    public void changePreviewParameter(final int width, final int height, final int fps, final CameraUtils.CameraFacing currentFacing, final CameraInterface.CameraResolutionMode resMode) {
        final CountDownLatch barrier = new CountDownLatch(1);
        CameraInterface.getInstance().post(new Runnable(){

            @Override
            public void run() {
                YMFLog.info(this, "[Preview ]", "changePreviewParameter...");
                YYCamera.this.mCameraInterface.restart(width, height, fps, currentFacing, resMode);
                barrier.countDown();
            }
        });
        try {
            barrier.await();
        }
        catch (InterruptedException e) {
            YMFLog.error((Object)this, "[Preview ]", "changePreviewParameter exception:" + e.toString());
        }
    }

    public void setPreviewCallbackWithBuffer(final Camera.PreviewCallback previewCallback) {
        final CountDownLatch barrier = new CountDownLatch(1);
        CameraInterface.getInstance().post(new Runnable(){

            @Override
            public void run() {
                YMFLog.info(this, "[Preview ]", "setPreviewCallbackWithBuffer...");
                YYCamera.this.mCameraInterface.setPreviewCallbackWithBuffer(previewCallback);
                barrier.countDown();
            }
        });
        try {
            barrier.await();
        }
        catch (InterruptedException e) {
            YMFLog.error((Object)this, "[Preview ]", "setPreviewCallbackWithBuffer exception:" + e.toString());
        }
    }

    public void stopPreview() {
        final CountDownLatch barrier = new CountDownLatch(1);
        CameraInterface.getInstance().post(new Runnable(){

            @Override
            public void run() {
                YMFLog.info(this, "[Preview ]", "stopPreview...");
                YYCamera.this.mCameraInterface.releaseCamera();
                barrier.countDown();
            }
        });
        try {
            barrier.await();
        }
        catch (InterruptedException e) {
            YMFLog.error((Object)this, "[Preview ]", "stopPreview exception:" + e.toString());
        }
    }

    public void switchCamera() {
        final CountDownLatch barrier = new CountDownLatch(1);
        CameraInterface.getInstance().post(new Runnable(){

            @Override
            public void run() {
                YMFLog.info(this, "[CCapture]", "switchCamera...");
                YYCamera.this.mCameraInterface.switchCamera();
                barrier.countDown();
            }
        });
        try {
            barrier.await();
        }
        catch (InterruptedException e) {
            YMFLog.error((Object)this, "[CCapture]", "switchCamera exception:" + e.toString());
        }
    }

    public boolean isCameraOpen() {
        boolean ret = this.mCameraInterface.isCameraOpened();
        YMFLog.info(this, "[CCapture]", "isCameraOpen:" + ret);
        return ret;
    }

    public Camera.Size getPreviewSize() {
        final Camera.Size[] ret = new Camera.Size[1];
        final CountDownLatch barrier = new CountDownLatch(1);
        CameraInterface.getInstance().post(new Runnable(){

            @Override
            public void run() {
                ret[0] = YYCamera.this.mCameraInterface.getPreviewSize();
                barrier.countDown();
            }
        });
        try {
            barrier.await();
        }
        catch (InterruptedException e) {
            YMFLog.error((Object)this, "[Preview ]", "getPreviewSize exception:" + e.toString());
        }
        return ret[0];
    }

    public void setCameraFlashMode(final boolean enable) {
        final CountDownLatch barrier = new CountDownLatch(1);
        CameraInterface.getInstance().post(new Runnable(){

            @Override
            public void run() {
                YYCamera.this.mCameraInterface.setCameraFlashMode(enable);
                barrier.countDown();
            }
        });
        try {
            barrier.await();
        }
        catch (InterruptedException e) {
            YMFLog.error((Object)this, "[CCapture]", "setCameraFlashMode exception:" + e.toString());
        }
    }

    public void handleFocusMetering(final MotionEvent event) {
        final CountDownLatch barrier = new CountDownLatch(1);
        CameraInterface.getInstance().post(new Runnable(){

            @Override
            public void run() {
                YMFLog.info(this, "[CCapture]", "handleFocusMetering...");
                YYCamera.this.mCameraInterface.handleFocusMetering(event);
                barrier.countDown();
            }
        });
        try {
            barrier.await();
        }
        catch (InterruptedException e) {
            YMFLog.error((Object)this, "[CCapture]", "handleFocusMetering exception:" + e.toString());
        }
    }

    public boolean isCameraFront() {
        final boolean[] ret = new boolean[1];
        final CountDownLatch barrier = new CountDownLatch(1);
        CameraInterface.getInstance().post(new Runnable(){

            @Override
            public void run() {
                ret[0] = YYCamera.this.mCameraInterface.getCameraFacing() == CameraUtils.CameraFacing.FacingFront;
                barrier.countDown();
            }
        });
        try {
            barrier.await();
        }
        catch (InterruptedException e) {
            YMFLog.error((Object)this, "[CCapture]", "isCameraFront exception:" + e.toString());
        }
        return ret[0];
    }

    public int getMaxZoom() {
        final int[] ret = new int[1];
        final CountDownLatch barrier = new CountDownLatch(1);
        CameraInterface.getInstance().post(new Runnable(){

            @Override
            public void run() {
                ret[0] = YYCamera.this.mCameraInterface.getMaxZoom();
                barrier.countDown();
            }
        });
        try {
            barrier.await();
        }
        catch (InterruptedException e) {
            YMFLog.error((Object)this, "[CCapture]", "getMaxZoom exception:" + e.toString());
        }
        return ret[0];
    }

    public boolean isZoomSupport() {
        final boolean[] ret = new boolean[1];
        final CountDownLatch barrier = new CountDownLatch(1);
        CameraInterface.getInstance().post(new Runnable(){

            @Override
            public void run() {
                ret[0] = YYCamera.this.mCameraInterface.isZoomSupport();
                barrier.countDown();
            }
        });
        try {
            barrier.await();
        }
        catch (InterruptedException e) {
            YMFLog.error((Object)this, "[CCapture]", "isZoomSupport exception:" + e.toString());
        }
        return ret[0];
    }

    public float setZoom(final int zoom) {
        final float[] ret = new float[1];
        final CountDownLatch barrier = new CountDownLatch(1);
        CameraInterface.getInstance().post(new Runnable(){

            @Override
            public void run() {
                ret[0] = YYCamera.this.mCameraInterface.setZoom(zoom);
                barrier.countDown();
            }
        });
        try {
            barrier.await();
        }
        catch (InterruptedException e) {
            YMFLog.error((Object)this, "[CCapture]", "setZoom exception:" + e.toString());
        }
        return ret[0];
    }

    public void releaseCamera() {
        final CountDownLatch barrier = new CountDownLatch(1);
        CameraInterface.getInstance().post(new Runnable(){

            @Override
            public void run() {
                YMFLog.info(this, "[CCapture]", "releaseCamera...");
                YYCamera.this.mCameraInterface.releaseCamera();
                barrier.countDown();
            }
        });
        try {
            barrier.await();
        }
        catch (InterruptedException e) {
            YMFLog.error((Object)this, "[CCapture]", "releaseCamera exception:" + e.toString());
        }
    }

    public void closeDualCamera() {
        final CountDownLatch barrier = new CountDownLatch(1);
        CameraInterface.getInstance().post(new Runnable(){

            @Override
            public void run() {
                YMFLog.info(this, "[CCapture]", "closeDualCamera...");
                YYCamera.this.mCameraInterface.closeDualCamera();
                barrier.countDown();
            }
        });
        try {
            barrier.await();
        }
        catch (InterruptedException e) {
            YMFLog.error((Object)this, "[CCapture]", "closeDualCamera exception:" + e.toString());
        }
    }

    public CameraUtils.CameraFacing getCameraFacing() {
        final CameraUtils.CameraFacing[] ret = new CameraUtils.CameraFacing[1];
        final CountDownLatch barrier = new CountDownLatch(1);
        CameraInterface.getInstance().post(new Runnable(){

            @Override
            public void run() {
                ret[0] = YYCamera.this.mCameraInterface.getCameraFacing();
                barrier.countDown();
            }
        });
        try {
            barrier.await();
        }
        catch (InterruptedException e) {
            YMFLog.error((Object)this, "[CCapture]", "getCameraFacing exception:" + e.toString());
        }
        return ret[0];
    }

    static {
        SYNC_FLAG = new byte[1];
    }
}

