/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework;

import android.graphics.Bitmap;
import android.hardware.Camera;
import android.media.projection.MediaProjection;
import android.opengl.EGL14;
import android.os.Build;
import android.view.SurfaceView;
import com.yy.mediaframework.CameraInterface;
import com.yy.mediaframework.CameraPreviewConfig;
import com.yy.mediaframework.CameraUtils;
import com.yy.mediaframework.Constant;
import com.yy.mediaframework.IEncoderListener;
import com.yy.mediaframework.IPublishListener;
import com.yy.mediaframework.IYMFPreviewListener;
import com.yy.mediaframework.UploadStreamStateParams;
import com.yy.mediaframework.VideoLiveSessionYCloud;
import com.yy.mediaframework.YMFExternalTextureSessionYCloud;
import com.yy.mediaframework.YYCamera;
import com.yy.mediaframework.YYVideoSDK;
import com.yy.mediaframework.base.VideoEncoderConfig;
import com.yy.mediaframework.base.VideoEncoderType;
import com.yy.mediaframework.base.VideoPublisheParam;
import com.yy.mediaframework.facedetection.PreviewFrameCallback;
import com.yy.mediaframework.gpuimage.FilterType;
import com.yy.mediaframework.gpuimage.custom.IGPUProcess;
import com.yy.mediaframework.screenlive.ScreenLiveSessionYCloud;
import com.yy.mediaframework.stat.VideoDataStat;
import com.yy.mediaframework.stat.YMFLiveStatisticManager;
import com.yy.mediaframework.stat.YMFLiveUsrBehaviorStat;
import com.yy.mediaframework.utils.YMFLog;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLContext;

public class YMFLiveAPI
implements IEncoderListener,
IYMFPreviewListener {
    private static final String TAG = "[YMFLiveAPI]";
    private VideoPublisheParam mUploadParams;
    private static YMFLiveAPI mInstance;
    private IPublishListener mIPublishListener;
    private VideoLiveSessionYCloud mVideoLiveSessionYCloud = null;
    private ScreenLiveSessionYCloud mScreenLiveSessionYCloud = null;
    private YMFExternalTextureSessionYCloud mExternalVideoLiveSessionYCloud = null;
    private int mBitRate;
    private int mFrameRate;
    private int mWidth;
    private int mHeight;
    private int mNotifyResolutioWidth = 0;
    private int mNotifyResolutioHeight = 0;
    private VideoEncoderType mEncodeType = VideoEncoderType.DEFAULT;
    private VideoEncoderConfig mVideoEncoderConfig;
    private CameraPreviewConfig mCameraPreviewConfig;
    private SurfaceView mCameraSurfaceView = null;
    private boolean mNeedCheckCameraCfgFlag = false;
    private boolean mCameraOpened = false;
    private boolean mNeedRestartCaptureFlag = false;
    private boolean mNeedCheckEncoderCfgFlag = false;
    private boolean mNeedRestartEncoderFlag = false;
    private boolean mNeedLowDelayChangeFlag = false;
    private long mFrameCount = 0L;
    private EncodedStream mEncodedStreamFlag = EncodedStream.NoneStream;
    private boolean mCameraCapturePauseFlag = false;
    private boolean mScreenCaptureFlag = false;
    private boolean mOriginCaptureFlag = false;
    private boolean mOriginCaptureInputTexture = false;
    private long mOriginFrameLastTimeStamp = -1L;

    public static YMFLiveAPI getInstance() {
        if (mInstance == null) {
            mInstance = new YMFLiveAPI();
        }
        return mInstance;
    }

    private YMFLiveAPI() {
    }

    public void setPublishListener(IPublishListener listener) {
        YMFLog.info(this, "[Procedur]", "setPublishListener:" + listener);
        YMFLiveUsrBehaviorStat.getInstance().notifyCallApi("setPublishListener:" + (listener == null ? "0" : "1"));
        this.mIPublishListener = listener;
    }

    public void destory() {
        YMFLog.info(this, "[Encoder ]", "destory");
        if (this.mNeedCheckEncoderCfgFlag) {
            if (this.mEncodedStreamFlag == EncodedStream.ScreenStream) {
                this.stopEncodeScreen();
            } else if (this.mEncodedStreamFlag == EncodedStream.OriginStream) {
                this.stopEncodeOrigin();
            } else if (this.mEncodedStreamFlag == EncodedStream.CameraStream) {
                this.stopEncodeVideo();
            }
        }
        if (this.mNeedCheckCameraCfgFlag) {
            if (this.mScreenCaptureFlag) {
                this.stopScreenCapture();
            }
            if (this.mOriginCaptureFlag) {
                this.stopOriginCapture();
            }
            if (this.mNeedCheckCameraCfgFlag) {
                this.mVideoLiveSessionYCloud.setPreviewSurfaceView(null);
                this.stopVideoCapture();
            }
        }
        if (this.mVideoLiveSessionYCloud != null) {
            this.deInitVideoLiveSession();
        }
        if (this.mScreenLiveSessionYCloud != null) {
            this.deInitScreenSession();
        }
        if (this.mExternalVideoLiveSessionYCloud != null) {
            this.deInitOriginLiveSession();
        }
        this.resetUploadStreamParams();
    }

    public boolean updatePublisherConfig(VideoPublisheParam params) {
        YMFLog.info(this, "[Encoder ]", "updatePublisherConfig:" + params.toString());
        YMFLiveUsrBehaviorStat.getInstance().notifyUpdatePublisherConfig(params);
        if (this.mUploadParams == null) {
            this.mUploadParams = new VideoPublisheParam();
        }
        this.mUploadParams.assign(params);
        this.disassembleUploadParams();
        if (this.mNeedRestartEncoderFlag) {
            YMFLog.info(this, "[Encoder ]", "updatePublisherConfig restart encoder:" + this.mVideoEncoderConfig);
            if (this.mEncodedStreamFlag == EncodedStream.CameraStream) {
                this.mVideoLiveSessionYCloud.setEncoderListener(null);
                this.mVideoLiveSessionYCloud.stopEncoder();
                if (this.mNeedRestartCaptureFlag) {
                    this.mVideoLiveSessionYCloud.mTmpVideoEncoderConfig = this.mVideoEncoderConfig;
                    YYCamera.getInstance().changePreviewParameter(this.mCameraPreviewConfig.mCaptureResolutionWidth, this.mCameraPreviewConfig.mCaptureResolutionHeight, this.mCameraPreviewConfig.mCaptureFrameRate, this.mCameraPreviewConfig.mCameraPosition == 0 ? CameraUtils.CameraFacing.FacingFront : CameraUtils.CameraFacing.FacingBack, this.mCameraPreviewConfig.mCaptureOrientation == 0, CameraInterface.CameraResolutionMode.CAMERA_RESOLUTION_RANGE_MODE);
                    this.mVideoLiveSessionYCloud.enablePreviewMirror(UploadStreamStateParams.mPreviewMirror);
                    this.mNeedRestartCaptureFlag = false;
                } else {
                    this.mVideoLiveSessionYCloud.setEncoderConfig(this.mVideoEncoderConfig);
                }
                this.mVideoLiveSessionYCloud.setEncoderListener(this);
                this.mVideoLiveSessionYCloud.startEncoder();
                if (this.mVideoLiveSessionYCloud != null && UploadStreamStateParams.mWaterMarkBitmap != null) {
                    this.mVideoLiveSessionYCloud.setWaterMark(UploadStreamStateParams.mWaterMarkBitmap, UploadStreamStateParams.mOffsetX, UploadStreamStateParams.mOffsetY);
                }
                if (this.mUploadParams.weakNetConfigs != null && this.mUploadParams.weakNetConfigs.size() > 0) {
                    this.mVideoLiveSessionYCloud.setResolutionModifyConfigs(this.mUploadParams.weakNetConfigs, this.mUploadParams.weakNetConfigsIntervalSecs);
                    this.mVideoLiveSessionYCloud.setAbroadNetWorkStrategy(UploadStreamStateParams.mNetWorkStrategy);
                }
                this.mVideoLiveSessionYCloud.enableMirror(UploadStreamStateParams.mEncoderMirror);
            } else if (this.mEncodedStreamFlag == EncodedStream.ScreenStream) {
                this.mScreenLiveSessionYCloud.setEncoderListener(null);
                this.mScreenLiveSessionYCloud.stopEncoder();
                this.mScreenLiveSessionYCloud.setEncoderConfig(this.mVideoEncoderConfig);
                this.mScreenLiveSessionYCloud.setCaptureResolution(this.mVideoEncoderConfig.mEncodeWidth, this.mVideoEncoderConfig.mEncodeHeight);
                this.mScreenLiveSessionYCloud.setEncoderListener(this);
                this.mScreenLiveSessionYCloud.startEncoder();
                if (this.mScreenLiveSessionYCloud != null && UploadStreamStateParams.mWaterMarkBitmap != null) {
                    this.mScreenLiveSessionYCloud.setWaterMark(UploadStreamStateParams.mWaterMarkBitmap, UploadStreamStateParams.mOffsetX, UploadStreamStateParams.mOffsetY);
                }
                if (this.mUploadParams.weakNetConfigs != null && this.mUploadParams.weakNetConfigs.size() > 0) {
                    this.mScreenLiveSessionYCloud.setResolutionModifyConfigs(this.mUploadParams.weakNetConfigs, this.mUploadParams.weakNetConfigsIntervalSecs);
                    this.mScreenLiveSessionYCloud.setAbroadNetWorkStrategy(UploadStreamStateParams.mNetWorkStrategy);
                }
            } else if (this.mEncodedStreamFlag == EncodedStream.OriginStream && this.mExternalVideoLiveSessionYCloud != null) {
                this.mExternalVideoLiveSessionYCloud.setEncoderListener(null);
                this.mExternalVideoLiveSessionYCloud.stopEncoder();
                this.mExternalVideoLiveSessionYCloud.setEncoderConfig(this.mVideoEncoderConfig);
                this.mExternalVideoLiveSessionYCloud.setEncoderListener(this);
                this.mExternalVideoLiveSessionYCloud.startEncoder();
                if (this.mExternalVideoLiveSessionYCloud != null && UploadStreamStateParams.mWaterMarkBitmap != null) {
                    this.mExternalVideoLiveSessionYCloud.setWaterMark(UploadStreamStateParams.mWaterMarkBitmap, UploadStreamStateParams.mOffsetX, UploadStreamStateParams.mOffsetY);
                }
                if (this.mUploadParams.weakNetConfigs != null && this.mUploadParams.weakNetConfigs.size() > 0) {
                    this.mExternalVideoLiveSessionYCloud.setResolutionModifyConfigs(this.mUploadParams.weakNetConfigs, this.mUploadParams.weakNetConfigsIntervalSecs);
                    this.mExternalVideoLiveSessionYCloud.setAbroadNetWorkStrategy(UploadStreamStateParams.mNetWorkStrategy);
                }
            }
            this.mNeedRestartEncoderFlag = false;
        }
        if (this.mNeedRestartCaptureFlag) {
            this.mVideoLiveSessionYCloud.mTmpAssignVideoEncoderConfig = this.mVideoEncoderConfig;
            YYCamera.getInstance().changePreviewParameter(this.mCameraPreviewConfig.mCaptureResolutionWidth, this.mCameraPreviewConfig.mCaptureResolutionHeight, this.mCameraPreviewConfig.mCaptureFrameRate, this.mCameraPreviewConfig.mCameraPosition == 0 ? CameraUtils.CameraFacing.FacingFront : CameraUtils.CameraFacing.FacingBack, this.mCameraPreviewConfig.mCaptureOrientation == 0, CameraInterface.CameraResolutionMode.CAMERA_RESOLUTION_RANGE_MODE);
            this.mVideoLiveSessionYCloud.enablePreviewMirror(UploadStreamStateParams.mPreviewMirror);
            this.mVideoLiveSessionYCloud.assignEncoderConfig(this.mVideoEncoderConfig);
            if (UploadStreamStateParams.mWaterMarkBitmap != null) {
                this.mVideoLiveSessionYCloud.setWaterMark(UploadStreamStateParams.mWaterMarkBitmap, UploadStreamStateParams.mOffsetX, UploadStreamStateParams.mOffsetY);
            }
            this.mNeedRestartCaptureFlag = false;
        } else if (this.mEncodedStreamFlag == EncodedStream.NoneStream && this.mVideoLiveSessionYCloud != null) {
            this.mVideoLiveSessionYCloud.assignEncoderConfig(this.mVideoEncoderConfig);
            if (UploadStreamStateParams.mWaterMarkBitmap != null) {
                this.mVideoLiveSessionYCloud.setWaterMark(UploadStreamStateParams.mWaterMarkBitmap, UploadStreamStateParams.mOffsetX, UploadStreamStateParams.mOffsetY);
            }
        }
        if (this.mNeedLowDelayChangeFlag) {
            if (this.mEncodedStreamFlag == EncodedStream.CameraStream) {
                this.mVideoLiveSessionYCloud.setLowDelayMode(this.mVideoEncoderConfig.mLowDelay);
            } else if (this.mEncodedStreamFlag == EncodedStream.ScreenStream) {
                this.mScreenLiveSessionYCloud.setLowDelayMode(this.mVideoEncoderConfig.mLowDelay);
            } else if (this.mEncodedStreamFlag == EncodedStream.OriginStream && this.mExternalVideoLiveSessionYCloud != null) {
                this.mExternalVideoLiveSessionYCloud.setLowDelayMode(this.mVideoEncoderConfig.mLowDelay);
            }
            this.mNeedLowDelayChangeFlag = false;
        }
        return true;
    }

    public int startVideoCapture() {
        YMFLiveUsrBehaviorStat.getInstance().notifyCaptureState(0, true);
        YMFLiveStatisticManager.getInstance().setCaptureType(1);
        if (this.mCameraPreviewConfig == null) {
            YMFLog.error((Object)this, "[CCapture]", "startVideoCapture error: not set UploadParams");
            return -1;
        }
        if (this.mCameraOpened) {
            YMFLog.error((Object)this, "[CCapture]", "startVideoCapture camera is opened");
            return 0;
        }
        if (this.mVideoLiveSessionYCloud == null) {
            this.initVideoLiveSession();
        }
        int cameraStatue = YYCamera.getInstance().startPreview(this.mCameraPreviewConfig.mCaptureResolutionWidth, this.mCameraPreviewConfig.mCaptureResolutionHeight, this.mCameraPreviewConfig.mCaptureFrameRate, this.mCameraPreviewConfig.mCameraPosition == 0 ? CameraUtils.CameraFacing.FacingFront : CameraUtils.CameraFacing.FacingBack, this.mCameraPreviewConfig.mCaptureOrientation == 0, CameraInterface.CameraResolutionMode.CAMERA_RESOLUTION_RANGE_MODE);
        if (this.mVideoLiveSessionYCloud != null) {
            this.mVideoLiveSessionYCloud.enablePreviewMirror(UploadStreamStateParams.mPreviewMirror);
            this.mVideoLiveSessionYCloud.assignEncoderConfig(this.mVideoEncoderConfig);
            if (UploadStreamStateParams.mWaterMarkBitmap != null && !UploadStreamStateParams.mWaterMarkEffect) {
                this.mVideoLiveSessionYCloud.setWaterMark(UploadStreamStateParams.mWaterMarkBitmap, UploadStreamStateParams.mOffsetX, UploadStreamStateParams.mOffsetY);
            }
            this.mVideoLiveSessionYCloud.setScaleMode(UploadStreamStateParams.mScaleMode);
            this.mVideoLiveSessionYCloud.setPreviewSurfaceView(this.mCameraSurfaceView);
        }
        if (cameraStatue == 0) {
            this.mCameraOpened = true;
        }
        this.mNeedCheckCameraCfgFlag = true;
        this.mCameraCapturePauseFlag = false;
        return cameraStatue;
    }

    public int pauseVideoCapture(boolean bPauseCapture) {
        YMFLiveUsrBehaviorStat.getInstance().notifyPauseVideoCapture(bPauseCapture);
        YMFLog.info(this, "[CCapture]", "pauseVideoCapture:" + bPauseCapture + ":" + this.mNeedCheckCameraCfgFlag);
        if (!this.mNeedCheckCameraCfgFlag) {
            return -1;
        }
        this.mCameraCapturePauseFlag = bPauseCapture;
        int cameraStatue = 0;
        if (this.mCameraCapturePauseFlag) {
            CameraInterface.getInstance().releaseCamera();
            this.mCameraOpened = false;
            YMFLiveUsrBehaviorStat.getInstance().notifyCameraCaptureState(false);
        } else {
            cameraStatue = YYCamera.getInstance().startPreview(this.mCameraPreviewConfig.mCaptureResolutionWidth, this.mCameraPreviewConfig.mCaptureResolutionHeight, this.mCameraPreviewConfig.mCaptureFrameRate, this.mCameraPreviewConfig.mCameraPosition == 0 ? CameraUtils.CameraFacing.FacingFront : CameraUtils.CameraFacing.FacingBack, this.mCameraPreviewConfig.mCaptureOrientation == 0, CameraInterface.CameraResolutionMode.CAMERA_RESOLUTION_RANGE_MODE);
            if (this.mVideoLiveSessionYCloud != null) {
                this.mVideoLiveSessionYCloud.enablePreviewMirror(UploadStreamStateParams.mPreviewMirror);
                if (UploadStreamStateParams.mWaterMarkBitmap != null && !UploadStreamStateParams.mWaterMarkEffect) {
                    this.mVideoLiveSessionYCloud.setWaterMark(UploadStreamStateParams.mWaterMarkBitmap, UploadStreamStateParams.mOffsetX, UploadStreamStateParams.mOffsetY);
                }
                this.mVideoLiveSessionYCloud.setScaleMode(UploadStreamStateParams.mScaleMode);
                this.mVideoLiveSessionYCloud.setPreviewSurfaceView(this.mCameraSurfaceView);
            }
            if (cameraStatue == 0) {
                this.mCameraOpened = true;
            }
        }
        return cameraStatue;
    }

    public int stopVideoCapture() {
        YMFLiveUsrBehaviorStat.getInstance().notifyCaptureState(0, false);
        CameraInterface.getInstance().releaseCamera();
        YMFLiveUsrBehaviorStat.getInstance().notifyCameraCaptureState(false);
        this.mNeedCheckCameraCfgFlag = false;
        this.mCameraOpened = false;
        if (this.mVideoLiveSessionYCloud != null) {
            this.mVideoLiveSessionYCloud.reSetPreviewState();
        }
        if (!this.mNeedCheckEncoderCfgFlag && !this.mNeedCheckCameraCfgFlag) {
            this.deInitVideoLiveSession();
        }
        return 0;
    }

    public String checkCamera() {
        Camera camera;
        YMFLiveUsrBehaviorStat.getInstance().notifyCallApi("checkCamera");
        YMFLog.info(this, "[CCapture]", "startCheckCamera...");
        String res = "";
        if (CameraUtils.isCameraAvailable(1)) {
            res = res + "front camera is supported\n";
            camera = CameraUtils.openCamera(CameraUtils.CameraFacing.FacingFront);
            if (camera != null) {
                res = res + "front camera can be used\n";
                camera.release();
            } else {
                res = res + "front camera cannot be used\n";
            }
        } else {
            res = res + "front camera is not supported\n";
        }
        if (CameraUtils.isCameraAvailable(0)) {
            res = res + "back camera is supported\n";
            camera = CameraUtils.openCamera(CameraUtils.CameraFacing.FacingBack);
            if (camera != null) {
                res = res + "back camera can be used\n";
                camera.release();
            } else {
                res = res + "back camera cannot be used\n";
            }
        } else {
            res = res + "back camera is not supported\n";
        }
        return res;
    }

    public int startPreview(SurfaceView view, int renderMode) {
        YMFLiveUsrBehaviorStat.getInstance().notifyPreviewState(true, renderMode);
        YMFLog.info(this, "[Preview ]", "startPreview:" + view + "," + renderMode);
        this.setPreviewRenderMode(renderMode);
        this.mCameraSurfaceView = view;
        if (this.mVideoLiveSessionYCloud != null) {
            this.mVideoLiveSessionYCloud.setScaleMode(UploadStreamStateParams.mScaleMode);
            this.mVideoLiveSessionYCloud.setPreviewSurfaceView(view);
        }
        return 0;
    }

    public int stopPreview() {
        YMFLiveUsrBehaviorStat.getInstance().notifyPreviewState(false, -1);
        YMFLog.info(this, "[Preview ]", "stopPreview...");
        this.mCameraSurfaceView = null;
        if (this.mVideoLiveSessionYCloud != null) {
            this.mVideoLiveSessionYCloud.setPreviewSurfaceView(null);
            this.mVideoLiveSessionYCloud.reSetPreviewState();
        }
        return 0;
    }

    public int startEncodeVideo() {
        YMFLiveUsrBehaviorStat.getInstance().notifyEncodeState(0, true);
        YMFLog.info(this, "[Encoder ]", "startEncodeVideo...");
        if (this.mVideoEncoderConfig == null) {
            YMFLog.error((Object)this, "[CCapture]", "startVideoCapture error: not set UploadParams");
            return -1;
        }
        if (this.mVideoLiveSessionYCloud == null) {
            this.initVideoLiveSession();
        }
        this.mVideoLiveSessionYCloud.setDeltaYYPtsMillions(UploadStreamStateParams.mDeltaPtsDts);
        this.mVideoLiveSessionYCloud.setEncoderListener(this);
        this.mVideoLiveSessionYCloud.setEncoderConfig(this.mVideoEncoderConfig);
        if (UploadStreamStateParams.mWaterMarkBitmap != null && !UploadStreamStateParams.mWaterMarkEffect) {
            this.mVideoLiveSessionYCloud.setWaterMark(UploadStreamStateParams.mWaterMarkBitmap, UploadStreamStateParams.mOffsetX, UploadStreamStateParams.mOffsetY);
            UploadStreamStateParams.mWaterMarkEffect = true;
        }
        this.mVideoLiveSessionYCloud.startEncoder();
        this.mVideoLiveSessionYCloud.enableMirror(UploadStreamStateParams.mEncoderMirror);
        if (this.mUploadParams.weakNetConfigs != null && this.mUploadParams.weakNetConfigs.size() > 0) {
            this.mVideoLiveSessionYCloud.setResolutionModifyConfigs(this.mUploadParams.weakNetConfigs, this.mUploadParams.weakNetConfigsIntervalSecs);
            this.mVideoLiveSessionYCloud.setAbroadNetWorkStrategy(UploadStreamStateParams.mNetWorkStrategy);
        }
        this.mNeedCheckEncoderCfgFlag = true;
        if (this.mEncodedStreamFlag != EncodedStream.NoneStream) {
            YMFLog.warn(this, "[Encoder ]", "has anothre stream encoded " + (Object)((Object)this.mEncodedStreamFlag));
        }
        this.mEncodedStreamFlag = EncodedStream.CameraStream;
        return 0;
    }

    public int stopEncodeVideo() {
        YMFLiveUsrBehaviorStat.getInstance().notifyEncodeState(0, false);
        YMFLog.info(this, "[Encoder ]", "stopEncodeVideo..");
        if (this.mVideoLiveSessionYCloud == null) {
            return -1;
        }
        this.mVideoLiveSessionYCloud.setEncoderListener(null);
        this.mVideoLiveSessionYCloud.stopEncoder();
        this.mNeedCheckEncoderCfgFlag = false;
        UploadStreamStateParams.mWaterMarkEffect = false;
        this.mEncodedStreamFlag = EncodedStream.NoneStream;
        if (!this.mNeedCheckEncoderCfgFlag && !this.mNeedCheckCameraCfgFlag) {
            this.deInitVideoLiveSession();
        }
        this.mNotifyResolutioWidth = 0;
        this.mNotifyResolutioHeight = 0;
        return 0;
    }

    public int setLocalVideoMirrorMode(int mode) {
        YMFLiveUsrBehaviorStat.getInstance().notifySetVideoMirrorMode(mode);
        if (mode == 0) {
            UploadStreamStateParams.mPreviewMirror = true;
            UploadStreamStateParams.mEncoderMirror = false;
        } else if (mode == 1) {
            UploadStreamStateParams.mPreviewMirror = true;
            UploadStreamStateParams.mEncoderMirror = true;
        } else if (mode == 2) {
            UploadStreamStateParams.mPreviewMirror = false;
            UploadStreamStateParams.mEncoderMirror = false;
        } else if (mode == 3) {
            UploadStreamStateParams.mPreviewMirror = false;
            UploadStreamStateParams.mEncoderMirror = true;
        }
        YMFLog.info(this, "[Api     ]", " setLocalVideoMirrorMode:" + mode + " <" + UploadStreamStateParams.mPreviewMirror + ", " + UploadStreamStateParams.mEncoderMirror + ">");
        if (this.mVideoLiveSessionYCloud != null) {
            this.mVideoLiveSessionYCloud.enablePreviewMirror(UploadStreamStateParams.mPreviewMirror);
            this.mVideoLiveSessionYCloud.enableMirror(UploadStreamStateParams.mEncoderMirror);
        }
        return 0;
    }

    public int setCameraPosition(int position) {
        YMFLiveUsrBehaviorStat.getInstance().notifyCallApi("setCameraPosition:" + position);
        YMFLog.info(this, "[CCapture]", "setCameraPosition:" + position);
        UploadStreamStateParams.mCameraPosition = position;
        if (this.mCameraPreviewConfig != null) {
            this.mCameraPreviewConfig.mCameraPosition = UploadStreamStateParams.mCameraPosition;
        }
        if (this.mNeedCheckCameraCfgFlag && !this.mCameraCapturePauseFlag && (YYCamera.getInstance().isCameraFront() && UploadStreamStateParams.mCameraPosition != 0 || !YYCamera.getInstance().isCameraFront() && UploadStreamStateParams.mCameraPosition == 0)) {
            YYCamera.getInstance().switchCamera();
            YMFLiveUsrBehaviorStat.getInstance().notifySwitchCamera(true);
        }
        return 0;
    }

    @Deprecated
    public int setLocalVideoCanvas(SurfaceView view, int renderMode) {
        return 0;
    }

    public int setPreviewRenderMode(int renderMode) {
        if (renderMode == 0) {
            UploadStreamStateParams.mScaleMode = Constant.ScaleMode.ScacleToFill;
        } else if (renderMode == 1) {
            UploadStreamStateParams.mScaleMode = Constant.ScaleMode.AspectFit;
        } else if (renderMode == 2) {
            UploadStreamStateParams.mScaleMode = Constant.ScaleMode.AspectFill;
        }
        YMFLog.info(this, "[Preview ]", "setPreviewRenderMode " + renderMode + " :" + (Object)((Object)UploadStreamStateParams.mScaleMode));
        if (this.mVideoLiveSessionYCloud != null) {
            this.mVideoLiveSessionYCloud.setScaleMode(UploadStreamStateParams.mScaleMode);
        }
        return 0;
    }

    public void setDeltaYYPtsMillions(long deltaPtsDts) {
        YMFLiveUsrBehaviorStat.getInstance().notifyCallApi("setDeltaYYPtsMillions:" + deltaPtsDts);
        YMFLog.info(this, "[Api     ]", "setDeltaYYPtsMillions:" + deltaPtsDts);
        UploadStreamStateParams.mDeltaPtsDts = deltaPtsDts;
        if (this.mScreenLiveSessionYCloud != null) {
            this.mScreenLiveSessionYCloud.setDeltaYYPtsMillions(UploadStreamStateParams.mDeltaPtsDts);
        }
        if (this.mVideoLiveSessionYCloud != null) {
            this.mVideoLiveSessionYCloud.setDeltaYYPtsMillions(UploadStreamStateParams.mDeltaPtsDts);
        }
        if (this.mExternalVideoLiveSessionYCloud != null) {
            this.mExternalVideoLiveSessionYCloud.setDeltaYYPtsMillions(UploadStreamStateParams.mDeltaPtsDts);
        }
    }

    public int getCameraPosition() {
        YMFLiveUsrBehaviorStat.getInstance().notifyCallApi("getCameraPosition");
        return YYCamera.getInstance().getCameraFacing().ordinal();
    }

    public int setWatermark(Bitmap bitmap, int offsetX, int offsetY) {
        YMFLiveUsrBehaviorStat.getInstance().notifySetWaterMark(bitmap == null, offsetX, offsetY);
        YMFLog.info(this, "[Api     ]", "setWatermark " + bitmap + ":" + offsetX + "," + offsetY + ",status" + this.mNeedCheckEncoderCfgFlag);
        UploadStreamStateParams.mWaterMarkBitmap = bitmap;
        UploadStreamStateParams.mOffsetX = offsetX;
        UploadStreamStateParams.mOffsetY = offsetY;
        if (this.mVideoLiveSessionYCloud != null) {
            this.mVideoLiveSessionYCloud.setWaterMark(bitmap, offsetX, offsetY);
        }
        if (this.mScreenLiveSessionYCloud != null) {
            this.mScreenLiveSessionYCloud.setWaterMark(bitmap, offsetX, offsetY);
        }
        if (this.mExternalVideoLiveSessionYCloud != null) {
            this.mExternalVideoLiveSessionYCloud.setWaterMark(bitmap, offsetX, offsetY);
        }
        if (this.mNeedCheckEncoderCfgFlag) {
            UploadStreamStateParams.mWaterMarkEffect = true;
        }
        return 0;
    }

    public void requestEncodeIFrame() {
        if (this.mVideoLiveSessionYCloud != null) {
            this.mVideoLiveSessionYCloud.requestIFrame();
        }
        if (this.mScreenLiveSessionYCloud != null) {
            this.mScreenLiveSessionYCloud.requestIFrame();
        }
        if (this.mExternalVideoLiveSessionYCloud != null) {
            this.mExternalVideoLiveSessionYCloud.requestIFrame();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNetworkBitrateSuggest(int bitrate) {
        YMFLiveAPI yMFLiveAPI = this;
        synchronized (yMFLiveAPI) {
            YMFLog.info(this, "[Encoder ]", "live setNetworkBitrateSuggest outside:" + bitrate + " flag:" + this.mNeedCheckEncoderCfgFlag + "," + this.mCameraCapturePauseFlag + "," + this.mCameraOpened);
            if (this.mNeedCheckEncoderCfgFlag && !this.mCameraCapturePauseFlag && this.mCameraOpened) {
                if (this.mEncodedStreamFlag == EncodedStream.ScreenStream && this.mScreenLiveSessionYCloud != null) {
                    this.mScreenLiveSessionYCloud.setNetworkBitrateSuggest(bitrate);
                } else if (this.mEncodedStreamFlag == EncodedStream.OriginStream && this.mExternalVideoLiveSessionYCloud != null) {
                    this.mExternalVideoLiveSessionYCloud.setNetworkBitrateSuggest(bitrate);
                } else if (this.mEncodedStreamFlag == EncodedStream.CameraStream && this.mVideoLiveSessionYCloud != null) {
                    this.mVideoLiveSessionYCloud.setNetworkBitrateSuggest(bitrate);
                }
            }
        }
    }

    public int getVideoPublishInfo(VideoPublishInfoEnum infoEnum) {
        int videoPublishInfo = -1;
        if (infoEnum.ordinal() == VideoPublishInfoEnum.FRAME.ordinal()) {
            videoPublishInfo = this.mFrameRate;
        } else if (infoEnum.ordinal() == VideoPublishInfoEnum.BITRATE.ordinal()) {
            videoPublishInfo = this.mBitRate;
        } else if (infoEnum.ordinal() == VideoPublishInfoEnum.RESOLUTION.ordinal()) {
            videoPublishInfo = this.mWidth << 16 | this.mHeight;
        } else if (infoEnum.ordinal() == VideoPublishInfoEnum.DYNAMIC_ENC_FRAME_RATE.ordinal()) {
            videoPublishInfo = VideoDataStat.getInstance().getDynamicEncodeFrameRate();
        } else if (infoEnum.ordinal() == VideoPublishInfoEnum.PREVIEW_FRAME_RATE.ordinal()) {
            videoPublishInfo = VideoDataStat.getInstance().getPreviewFrameRate();
        } else if (infoEnum.ordinal() == VideoPublishInfoEnum.ENCODETYPE.ordinal()) {
            videoPublishInfo = this.mEncodeType.ordinal();
        }
        return videoPublishInfo;
    }

    public int setHardwareEncoderAvailable(boolean available) {
        YMFLiveUsrBehaviorStat.getInstance().notifyCallApi("setHardwareEncoderAvailable:" + (available ? "1" : "0"));
        YMFLog.info(this, "[Api     ]", "setHardwareEncoderAvailable:" + available);
        UploadStreamStateParams.mDisableHardEncoder.set(true);
        return 0;
    }

    public void changeScreenLiveMode(Boolean usedBitmap, Bitmap bitmap) {
        YMFLiveUsrBehaviorStat.getInstance().notifyCallApi("changeScreenLiveMode,usedBitmap:" + (usedBitmap != false ? "1" : "0") + ",bitmap:" + (bitmap == null ? "1" : "0"));
        if (this.mScreenLiveSessionYCloud != null) {
            this.mScreenLiveSessionYCloud.changeScreenLiveMode(usedBitmap, bitmap);
        }
    }

    public void setGPUImageBeautyFilter(IGPUProcess gpuImageProcess) {
        YMFLiveUsrBehaviorStat.getInstance().notifySetGPUImageBeautyFilter(gpuImageProcess != null);
        if (this.mVideoLiveSessionYCloud != null) {
            this.mVideoLiveSessionYCloud.setGPUImageBeautyFilter(gpuImageProcess);
        } else {
            YMFLog.error((Object)this, "[Api     ]", "setGPUImageBeautyFilter failed");
        }
    }

    public void addPreviewFrameCallback(PreviewFrameCallback callback) {
        YMFLiveUsrBehaviorStat.getInstance().notifyCallApi("addPreviewFrameCallback");
        if (this.mVideoLiveSessionYCloud != null) {
            this.mVideoLiveSessionYCloud.registerCallback(callback);
        }
    }

    public void removePreviewFrameCallback(PreviewFrameCallback callback) {
        YMFLiveUsrBehaviorStat.getInstance().notifyCallApi("removePreviewFrameCallback");
        if (this.mVideoLiveSessionYCloud != null) {
            this.mVideoLiveSessionYCloud.unregisterCallback(callback);
        }
    }

    public int startOriginCapture(boolean useTexture) {
        this.mOriginCaptureInputTexture = useTexture;
        YMFLiveUsrBehaviorStat.getInstance().notifyCaptureState(2, true);
        YMFLiveStatisticManager.getInstance().setCaptureType(3);
        YMFLog.info(this, "[Api     ]", "startOriginCapture..." + this.mOriginCaptureInputTexture);
        if (!useTexture && this.mExternalVideoLiveSessionYCloud == null) {
            this.initOriginLiveSession(null);
        }
        this.mOriginCaptureFlag = true;
        return 0;
    }

    public int stopOriginCapture() {
        YMFLiveUsrBehaviorStat.getInstance().notifyCaptureState(2, false);
        YMFLog.info(this, "[CCapture]", "stopOriginCapture...");
        this.mFrameCount = 0L;
        this.mOriginCaptureFlag = false;
        if (this.mEncodedStreamFlag != EncodedStream.OriginStream) {
            this.deInitOriginLiveSession();
        }
        return 0;
    }

    private void realStartEncodeOrigin() {
        YMFLog.info(this, "[Encoder ]", "realStartEncodeOrigin...");
        this.mExternalVideoLiveSessionYCloud.setDeltaYYPtsMillions(UploadStreamStateParams.mDeltaPtsDts);
        this.mExternalVideoLiveSessionYCloud.setEncoderListener(this);
        this.mExternalVideoLiveSessionYCloud.setEncoderConfig(this.mVideoEncoderConfig);
        if (UploadStreamStateParams.mWaterMarkBitmap != null && !UploadStreamStateParams.mWaterMarkEffect) {
            this.mExternalVideoLiveSessionYCloud.setWaterMark(UploadStreamStateParams.mWaterMarkBitmap, UploadStreamStateParams.mOffsetX, UploadStreamStateParams.mOffsetY);
            UploadStreamStateParams.mWaterMarkEffect = true;
        }
        this.mExternalVideoLiveSessionYCloud.startEncoder();
        if (this.mUploadParams.weakNetConfigs != null && this.mUploadParams.weakNetConfigs.size() > 0) {
            this.mExternalVideoLiveSessionYCloud.setResolutionModifyConfigs(this.mUploadParams.weakNetConfigs, this.mUploadParams.weakNetConfigsIntervalSecs);
            this.mExternalVideoLiveSessionYCloud.setAbroadNetWorkStrategy(UploadStreamStateParams.mNetWorkStrategy);
        }
        this.mExternalVideoLiveSessionYCloud.setEnableUnderflowStrategy(false);
    }

    public int startEncodeOrigin() {
        YMFLiveUsrBehaviorStat.getInstance().notifyEncodeState(2, true);
        if (!this.mOriginCaptureInputTexture) {
            if (this.mExternalVideoLiveSessionYCloud == null) {
                this.initOriginLiveSession(null);
            }
            this.realStartEncodeOrigin();
        }
        this.mNeedCheckEncoderCfgFlag = true;
        this.mEncodedStreamFlag = EncodedStream.OriginStream;
        return 0;
    }

    public int stopEncodeOrigin() {
        YMFLiveUsrBehaviorStat.getInstance().notifyEncodeState(2, false);
        YMFLog.info(this, "[Encoder ]", "stopEncodeOrigin...");
        if (this.mExternalVideoLiveSessionYCloud != null) {
            this.mExternalVideoLiveSessionYCloud.setEncoderListener(null);
            this.mExternalVideoLiveSessionYCloud.stopEncoder();
            UploadStreamStateParams.mWaterMarkEffect = false;
        }
        this.mEncodedStreamFlag = EncodedStream.NoneStream;
        this.mNeedCheckEncoderCfgFlag = false;
        this.mNotifyResolutioWidth = 0;
        this.mNotifyResolutioHeight = 0;
        this.mOriginFrameLastTimeStamp = -1L;
        return 0;
    }

    public int startScreenCapture(MediaProjection mediaProjection) {
        YMFLiveUsrBehaviorStat.getInstance().notifyCaptureState(1, true);
        YMFLiveStatisticManager.getInstance().setCaptureType(2);
        YMFLog.info(this, "[SCapture]", "startScreenCapture..." + mediaProjection);
        if (this.mScreenLiveSessionYCloud == null) {
            this.initScreenSession();
        }
        this.mScreenLiveSessionYCloud.setCaptureResolution(this.mVideoEncoderConfig.mEncodeWidth, this.mVideoEncoderConfig.mEncodeHeight);
        this.mScreenLiveSessionYCloud.startCapture(mediaProjection);
        this.mScreenCaptureFlag = true;
        return 0;
    }

    public int stopScreenCapture() {
        YMFLiveUsrBehaviorStat.getInstance().notifyCaptureState(1, false);
        YMFLog.info(this, "[SCapture]", "stopScreenCapture...");
        if (this.mScreenLiveSessionYCloud != null) {
            this.mScreenLiveSessionYCloud.stopCapture();
        }
        this.mScreenCaptureFlag = false;
        if (this.mEncodedStreamFlag != EncodedStream.ScreenStream) {
            this.deInitScreenSession();
        }
        return 0;
    }

    public int startEncodeScreen() {
        YMFLiveUsrBehaviorStat.getInstance().notifyEncodeState(1, true);
        YMFLog.info(this, "[Encoder ]", "startEncodeScreen...");
        if (this.mScreenLiveSessionYCloud == null) {
            this.initScreenSession();
        }
        this.mScreenLiveSessionYCloud.setDeltaYYPtsMillions(UploadStreamStateParams.mDeltaPtsDts);
        this.mScreenLiveSessionYCloud.setEncoderListener(this);
        this.mScreenLiveSessionYCloud.setEncoderConfig(this.mVideoEncoderConfig);
        if (UploadStreamStateParams.mWaterMarkBitmap != null && !UploadStreamStateParams.mWaterMarkEffect) {
            this.mScreenLiveSessionYCloud.setWaterMark(UploadStreamStateParams.mWaterMarkBitmap, UploadStreamStateParams.mOffsetX, UploadStreamStateParams.mOffsetY);
            UploadStreamStateParams.mWaterMarkEffect = true;
        }
        this.mScreenLiveSessionYCloud.startEncoder();
        if (this.mUploadParams.weakNetConfigs != null && this.mUploadParams.weakNetConfigs.size() > 0) {
            this.mScreenLiveSessionYCloud.setResolutionModifyConfigs(this.mUploadParams.weakNetConfigs, this.mUploadParams.weakNetConfigsIntervalSecs);
            this.mScreenLiveSessionYCloud.setAbroadNetWorkStrategy(false);
        }
        this.mNeedCheckEncoderCfgFlag = true;
        if (this.mEncodedStreamFlag != EncodedStream.NoneStream) {
            YMFLog.warn(this, "[Encoder ]", "current has anothre stream encoded " + (Object)((Object)this.mEncodedStreamFlag));
        }
        this.mEncodedStreamFlag = EncodedStream.ScreenStream;
        return 0;
    }

    public int stopEncodeScreen() {
        YMFLiveUsrBehaviorStat.getInstance().notifyEncodeState(1, false);
        YMFLog.info(this, "[Encoder ]", "stopPublishScreenVideo");
        if (this.mScreenLiveSessionYCloud != null) {
            this.mScreenLiveSessionYCloud.setEncoderListener(null);
            this.mScreenLiveSessionYCloud.stopEncoder();
            UploadStreamStateParams.mWaterMarkEffect = false;
        }
        this.mEncodedStreamFlag = EncodedStream.NoneStream;
        this.mNotifyResolutioWidth = 0;
        this.mNotifyResolutioHeight = 0;
        if (!this.mScreenCaptureFlag) {
            this.deInitScreenSession();
        }
        return 0;
    }

    private int initScreenSession() {
        YMFLog.info(this, "[Procedur]", "initScreenLiveSession...");
        if (this.mScreenLiveSessionYCloud != null) {
            this.deInitScreenSession();
        }
        this.mScreenLiveSessionYCloud = new ScreenLiveSessionYCloud(YYVideoSDK.getInstance().getAppContext(), 1);
        this.mScreenLiveSessionYCloud.setEncoderListener(this);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int deInitScreenSession() {
        YMFLog.info(this, "[Procedur]", "deInitScreenSession....");
        YMFLiveAPI yMFLiveAPI = this;
        synchronized (yMFLiveAPI) {
            if (this.mExternalVideoLiveSessionYCloud != null) {
                this.mExternalVideoLiveSessionYCloud.setEncoderListener(null);
                this.mExternalVideoLiveSessionYCloud.stopAndRelease();
                this.mExternalVideoLiveSessionYCloud = null;
            }
        }
        return 0;
    }

    private int initOriginLiveSession(Object sharedContext) {
        YMFLog.info(this, "[Procedur]", "initOriginLiveSession...");
        if (this.mExternalVideoLiveSessionYCloud != null) {
            this.deInitOriginLiveSession();
        }
        this.mExternalVideoLiveSessionYCloud = new YMFExternalTextureSessionYCloud(YYVideoSDK.getInstance().getAppContext(), 2, sharedContext);
        this.mExternalVideoLiveSessionYCloud.initOriginDataFilter();
        this.mExternalVideoLiveSessionYCloud.setEncoderListener(this);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int deInitOriginLiveSession() {
        YMFLog.info(this, "[Procedur]", "deInitOriginLiveSession....");
        YMFLiveAPI yMFLiveAPI = this;
        synchronized (yMFLiveAPI) {
            if (this.mExternalVideoLiveSessionYCloud != null) {
                this.mExternalVideoLiveSessionYCloud.setEncoderListener(null);
                this.mExternalVideoLiveSessionYCloud.stopAndRelease();
                this.mExternalVideoLiveSessionYCloud = null;
            }
        }
        return 0;
    }

    public void setOriginFrameToEncode(byte[] data, int format, int width, int height, int rotation, long timestamp) {
        if (this.mFrameCount++ % 300L == 0L) {
            YMFLiveUsrBehaviorStat.getInstance().notifyCallApi("setOriginFrameToEncode,format:" + format + ",width:" + width + ",height:" + height + ",rotation:" + rotation + ",timeStamp:" + timestamp);
        }
        if (!this.mOriginCaptureFlag || this.mOriginCaptureInputTexture || width > 1920 || height > 1920 || width * height <= 0) {
            YMFLog.warn(this, "[Api     ]", "setOriginFrameToEncode not startcapture or params error");
            return;
        }
        if (this.mOriginFrameLastTimeStamp > 0L && timestamp < this.mOriginFrameLastTimeStamp) {
            YMFLog.warn(this, "[Api     ]", "setOriginFrameToEncode pts error " + timestamp + " < " + this.mOriginFrameLastTimeStamp);
        }
        if (this.mExternalVideoLiveSessionYCloud != null) {
            this.mExternalVideoLiveSessionYCloud.setOriginFrameToEncode(data, format, width, height, rotation, timestamp);
        }
        this.mOriginFrameLastTimeStamp = timestamp;
    }

    public void setOriginTextureToEncode(int inputTexture, int textureTarget, int width, int height, int rotation, long timestamp, float[] transformer) {
        if (this.mFrameCount++ % 300L == 0L) {
            YMFLiveUsrBehaviorStat.getInstance().notifyCallApi("setOriginTextureToEncode,inputTexture :" + inputTexture + ",transformer:" + transformer + "," + timestamp + "," + rotation);
        }
        if (!this.mOriginCaptureFlag || !this.mOriginCaptureInputTexture || inputTexture < 0) {
            YMFLog.warn(this, "[Api     ]", "setOriginTextureToEncode not startcapture or params error");
            return;
        }
        if (this.mExternalVideoLiveSessionYCloud == null) {
            android.opengl.EGLContext eglContext = null;
            if (Build.VERSION.SDK_INT >= 17) {
                try {
                    eglContext = EGL14.eglGetCurrentContext();
                    if (eglContext == null) {
                        EGL10 mEgl = (EGL10)EGLContext.getEGL();
                        if (mEgl == null) {
                            YMFLog.error((Object)this, "[Api     ]", "EGL10 mEgl == null");
                        }
                        eglContext = mEgl.eglGetCurrentContext();
                    }
                }
                catch (Exception e) {
                    YMFLog.error((Object)this, "[Api     ]", "eglGetCurrentContext error " + e.toString());
                }
            } else {
                EGL10 mEgl = (EGL10)EGLContext.getEGL();
                if (mEgl == null) {
                    YMFLog.error((Object)this, "[Api     ]", "EGL10 mEgl == null");
                    return;
                }
                eglContext = mEgl.eglGetCurrentContext();
            }
            if (eglContext == null) {
                YMFLog.error((Object)this, "[Api     ]", "eglContext == null");
                return;
            }
            this.initOriginLiveSession(eglContext);
            if (this.mNeedCheckEncoderCfgFlag && this.mEncodedStreamFlag == EncodedStream.OriginStream) {
                this.realStartEncodeOrigin();
            }
        }
        if (this.mOriginFrameLastTimeStamp > 0L && timestamp < this.mOriginFrameLastTimeStamp) {
            YMFLog.warn(this, "[Api     ]", "setOriginFrameToEncode pts error " + timestamp + " < " + this.mOriginFrameLastTimeStamp);
        }
        if (this.mExternalVideoLiveSessionYCloud != null) {
            this.mExternalVideoLiveSessionYCloud.setOriginTextureToEncode(inputTexture, textureTarget, transformer, width, height, timestamp, rotation);
        }
        this.mOriginFrameLastTimeStamp = timestamp;
    }

    private void initVideoLiveSession() {
        YMFLog.info(this, "[Procedur]", "initLiveSession...");
        if (this.mVideoLiveSessionYCloud != null) {
            this.deInitVideoLiveSession();
        }
        this.mVideoLiveSessionYCloud = new VideoLiveSessionYCloud(YYVideoSDK.getInstance().getAppContext(), 0);
        CameraInterface.getInstance().setCameraListener(this.mVideoLiveSessionYCloud);
        this.mVideoLiveSessionYCloud.setPreviewListener(this);
        this.mVideoLiveSessionYCloud.setEncoderListener(this);
        this.mVideoLiveSessionYCloud.setFilterType(FilterType.BeautyFace);
    }

    private void deInitVideoLiveSession() {
        YMFLog.info(this, "[Procedur]", "deInitLiveSession...");
        if (this.mVideoLiveSessionYCloud != null) {
            this.mVideoLiveSessionYCloud.setEncoderListener(null);
            this.mVideoLiveSessionYCloud.setPreviewListener(null);
            this.mVideoLiveSessionYCloud.setPreviewSurfaceView(null);
            this.mVideoLiveSessionYCloud.stopAndRelease();
            this.mVideoLiveSessionYCloud = null;
        }
    }

    private void disassembleUploadParams() {
        if (this.mCameraPreviewConfig == null) {
            this.mCameraPreviewConfig = new CameraPreviewConfig();
        }
        if (this.mNeedCheckCameraCfgFlag) {
            this.mNeedRestartCaptureFlag = (this.mCameraPreviewConfig.mCaptureResolutionWidth != this.mUploadParams.captureResolutionWidth || this.mCameraPreviewConfig.mCaptureResolutionHeight != this.mUploadParams.captureResolutionHeight) && !this.mCameraCapturePauseFlag;
        }
        this.mCameraPreviewConfig.mCaptureOrientation = this.mUploadParams.screenOrientation;
        this.mCameraPreviewConfig.mCameraPosition = UploadStreamStateParams.mCameraPosition;
        this.mCameraPreviewConfig.mCaptureResolutionWidth = this.mUploadParams.captureResolutionWidth;
        this.mCameraPreviewConfig.mCaptureResolutionHeight = this.mUploadParams.captureResolutionHeight;
        this.mCameraPreviewConfig.mCaptureFrameRate = this.mUploadParams.captureFrameRate;
        if (this.mVideoEncoderConfig == null) {
            this.mVideoEncoderConfig = new VideoEncoderConfig();
        }
        if (this.mNeedCheckEncoderCfgFlag) {
            this.mNeedRestartEncoderFlag = this.mVideoEncoderConfig.mEncodeWidth != this.mUploadParams.encodeResolutionWidth || this.mVideoEncoderConfig.mEncodeHeight != this.mUploadParams.encodeResolutionHeight || this.mVideoEncoderConfig.mEncodeType != this.mUploadParams.encodeType;
        }
        this.mVideoEncoderConfig.mEncodeWidth = this.mUploadParams.encodeResolutionWidth;
        this.mVideoEncoderConfig.mEncodeHeight = this.mUploadParams.encodeResolutionHeight;
        this.mVideoEncoderConfig.mEncodeType = this.mUploadParams.encodeType;
        this.mVideoEncoderConfig.mEncodeParameter = this.mUploadParams.encoderParam;
        this.mVideoEncoderConfig.mFrameRate = this.mUploadParams.encodeFrameRate;
        this.mVideoEncoderConfig.mBitRate = this.mUploadParams.encodeBitrate;
        boolean newLowDelay = false;
        newLowDelay = this.mUploadParams.bLowLatency || this.mUploadParams.bWebSdkCompatibility;
        if (!this.mNeedRestartEncoderFlag && newLowDelay != this.mVideoEncoderConfig.mLowDelay) {
            YMFLiveUsrBehaviorStat.getInstance().notifyLowDelayFlagChange(this.mVideoEncoderConfig.mLowDelay, newLowDelay);
            this.mNeedLowDelayChangeFlag = true;
        }
        this.mVideoEncoderConfig.mLowDelay = newLowDelay;
    }

    private void resetUploadStreamParams() {
        UploadStreamStateParams.reset();
        this.mUploadParams = null;
        this.mVideoEncoderConfig = null;
        this.mCameraPreviewConfig = null;
        this.mCameraSurfaceView = null;
        this.mCameraCapturePauseFlag = false;
        this.mNeedCheckCameraCfgFlag = false;
        this.mNeedCheckEncoderCfgFlag = false;
        this.mNeedLowDelayChangeFlag = false;
        this.mNeedRestartCaptureFlag = false;
        this.mNeedRestartEncoderFlag = false;
        this.mEncodedStreamFlag = EncodedStream.NoneStream;
        this.mNotifyResolutioWidth = 0;
        this.mNotifyResolutioHeight = 0;
        this.mOriginCaptureFlag = false;
        this.mScreenCaptureFlag = false;
    }

    @Override
    public void onEncodeStat(int bitRate, int frameRate) {
        this.mBitRate = bitRate;
        this.mFrameRate = frameRate;
    }

    @Override
    public void onEncodeResolution(int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
        if (this.mIPublishListener != null && (width != this.mNotifyResolutioWidth || height != this.mNotifyResolutioHeight)) {
            this.mIPublishListener.onUpdateVideoSizeChanged(0L, width, height);
            this.mNotifyResolutioWidth = width;
            this.mNotifyResolutioHeight = height;
        }
    }

    @Override
    public void onEncodeFirstFrame() {
        if (this.mIPublishListener != null) {
            this.mIPublishListener.onVideoAnchorStatus(Constant.AnchorStatus.AnchorStatus_Encoding);
        }
    }

    @Override
    public void onRenderFirstFrame() {
        if (this.mIPublishListener != null) {
            this.mIPublishListener.onVideoAnchorStatus(Constant.AnchorStatus.AnchorStatus_Previewing);
        }
    }

    @Override
    public void onEncodeFrameData(byte[] data, int len, long pts, long dts, int frameType, VideoEncoderType encodeType, int svcTid, int svcSid) {
        this.mEncodeType = encodeType;
        if (this.mIPublishListener != null) {
            this.mIPublishListener.onEncodeFrameData(data, len, pts, dts, frameType, encodeType, svcTid, svcSid);
        }
    }

    @Override
    public void onEncodeEncParam(String param) {
    }

    @Override
    public void onHardEncoderError() {
        YMFLiveUsrBehaviorStat.getInstance().notifyCallApi("onHardEncoderError");
        YMFLog.warn(this, "[Encoder ]", "onEncoderSwitch change to softEncoder");
        UploadStreamStateParams.mDisableHardEncoder.set(true);
    }

    @Override
    public void onEncoderSwitch() {
    }

    @Override
    public void onWaterMarkSizeChange(int w, int h) {
    }

    public VideoEncoderType getVideoPublishEncodeInfo() {
        return this.mEncodeType;
    }

    public void setAbroadNetWorkStrategy(boolean flag) {
        UploadStreamStateParams.mNetWorkStrategy = flag;
        YMFLog.info(this, "[Encoder ]", "setAbroadNetWorkStrategy " + flag);
        if (this.mVideoLiveSessionYCloud != null) {
            this.mVideoLiveSessionYCloud.setAbroadNetWorkStrategy(flag);
        }
        if (this.mExternalVideoLiveSessionYCloud != null) {
            this.mExternalVideoLiveSessionYCloud.setAbroadNetWorkStrategy(flag);
        }
        if (this.mScreenLiveSessionYCloud != null) {
            this.mScreenLiveSessionYCloud.setAbroadNetWorkStrategy(flag);
        }
    }

    public static enum VideoPublishInfoEnum {
        FRAME,
        BITRATE,
        RESOLUTION,
        DYNAMIC_ENC_FRAME_RATE,
        PREVIEW_FRAME_RATE,
        ENCODETYPE;

    }

    private static enum EncodedStream {
        NoneStream,
        CameraStream,
        ScreenStream,
        OriginStream;

    }
}

