/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework;

import android.os.SystemClock;
import com.yy.mediaframework.GlManager;
import com.yy.mediaframework.stat.YMFLiveUsrBehaviorStat;
import com.yy.mediaframework.utils.YMFLog;
import java.text.MessageFormat;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class YMFGlManagerTest
implements Runnable {
    public Thread mLooperThread;
    GlManager mGlManager = null;
    boolean mContinueTest = true;

    public YMFGlManagerTest(GlManager glManager) {
        this.mGlManager = glManager;
        this.mLooperThread = new Thread((Runnable)this, "YY_yyvideolib_GlManagerTest_Thread");
        this.mLooperThread.start();
    }

    @Override
    public void run() {
        while (this.mContinueTest) {
            final CountDownLatch barrier = new CountDownLatch(1);
            this.mGlManager.post(new Runnable(){

                @Override
                public void run() {
                    barrier.countDown();
                }
            });
            if (!YMFGlManagerTest.awaitUninterruptibly(barrier, 3000L)) {
                StackTraceElement[] st = this.mGlManager.getHandler().getLooper().getThread().getStackTrace();
                if (st == null) {
                    YMFLog.error((Object)this, "[Procedur]", "GlManager PostRunnable exeception:null");
                    return;
                }
                StringBuffer sbf = new StringBuffer();
                for (StackTraceElement e : st) {
                    if (sbf.length() > 0) {
                        sbf.append(" <- ");
                        sbf.append(System.getProperty("line.separator"));
                    }
                    sbf.append(MessageFormat.format("{0}.{1}() {2}", e.getClassName(), e.getMethodName(), e.getLineNumber()));
                }
                YMFLog.error((Object)this, "[Procedur]", "GlManager PostRunnable " + sbf.toString());
                YMFLiveUsrBehaviorStat.getInstance().notifyGlManagerCheck(sbf + "");
            }
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean awaitUninterruptibly(CountDownLatch barrier, long timeoutMs) {
        long startTimeMs = SystemClock.elapsedRealtime();
        long timeRemainingMs = timeoutMs;
        boolean wasInterrupted = false;
        boolean result = false;
        while (true) {
            try {
                result = barrier.await(timeRemainingMs, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                long elapsedTimeMs;
                wasInterrupted = true;
                if ((timeRemainingMs = timeoutMs - (elapsedTimeMs = SystemClock.elapsedRealtime() - startTimeMs)) > 0L) continue;
            }
            break;
        }
        if (wasInterrupted) {
            Thread.currentThread().interrupt();
        }
        return result;
    }

    public void quit() {
        this.mContinueTest = false;
    }
}

