/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.os.Build;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import com.yy.mediaframework.CameraInterface;
import com.yy.mediaframework.CameraListener;
import com.yy.mediaframework.Constant;
import com.yy.mediaframework.ExternalInterface;
import com.yy.mediaframework.GetAnchorStatInfoInterface;
import com.yy.mediaframework.IEncoderListener;
import com.yy.mediaframework.ILiveSession;
import com.yy.mediaframework.IMediaCodecUpload;
import com.yy.mediaframework.ITextureListener;
import com.yy.mediaframework.IYMFPreviewListener;
import com.yy.mediaframework.IYYVideoSurfaceInfoListener;
import com.yy.mediaframework.VideoRenderPosition;
import com.yy.mediaframework.YYCamera;
import com.yy.mediaframework.YYVideoSDK;
import com.yy.mediaframework.background.Background;
import com.yy.mediaframework.base.VideoEncoderConfig;
import com.yy.mediaframework.base.VideoEncoderType;
import com.yy.mediaframework.base.YYUserLiveConfig;
import com.yy.mediaframework.facedetection.CameraPreviewCallbackHost;
import com.yy.mediaframework.facedetection.PreviewFrameCallback;
import com.yy.mediaframework.filters.CameraCaptureFilter;
import com.yy.mediaframework.filters.ClipFilter;
import com.yy.mediaframework.filters.ExternalDecoderFilter;
import com.yy.mediaframework.filters.GPUPreprocessFilter;
import com.yy.mediaframework.filters.LiveSessionType;
import com.yy.mediaframework.filters.OriginDataEntryFilter;
import com.yy.mediaframework.filters.PeripheralsDecoderFilter;
import com.yy.mediaframework.filters.PreviewFilter;
import com.yy.mediaframework.filters.VideoEncoderGroupFilter;
import com.yy.mediaframework.filters.VideoEndPointFilter;
import com.yy.mediaframework.filters.VideoLiveFilterContext;
import com.yy.mediaframework.filters.YMFProcessGroupFilter;
import com.yy.mediaframework.gles.EglFactory;
import com.yy.mediaframework.gpuimage.FilterType;
import com.yy.mediaframework.gpuimage.custom.IGPUProcess;
import com.yy.mediaframework.inteligence.common.ResolutionModifyConfig;
import com.yy.mediaframework.inteligence.dynamictexture.IDynamicTexture;
import com.yy.mediaframework.model.AbstractSurfaceInfo;
import com.yy.mediaframework.model.DecodeVideoConfig;
import com.yy.mediaframework.model.DecodeVideoSample;
import com.yy.mediaframework.model.ExternalDecodeInfo;
import com.yy.mediaframework.model.ExternalYYMediaSample;
import com.yy.mediaframework.model.YYMediaSample;
import com.yy.mediaframework.screenshot.ScreenShot;
import com.yy.mediaframework.screenshot.ScreenShotCallback;
import com.yy.mediaframework.sensor.RotationVectorSensor;
import com.yy.mediaframework.stat.UploadStatManager;
import com.yy.mediaframework.stat.VideoDataStatUtil;
import com.yy.mediaframework.stat.YMFLiveUsrBehaviorStat;
import com.yy.mediaframework.utils.TimeUtil;
import com.yy.mediaframework.utils.YMFLog;
import com.yy.mediaframework.watermark.WaterMark;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class VideoLiveSessionYCloud
implements IYYVideoSurfaceInfoListener,
IEncoderListener,
IYMFPreviewListener,
ILiveSession,
SurfaceHolder.Callback,
CameraListener,
IMediaCodecUpload,
GetAnchorStatInfoInterface.IGetCurrentCameraEncodeStatInfo,
GetAnchorStatInfoInterface.IGetImageFilterInfo {
    private static final String TAG = "[VideoLiveSessionYCloud]";
    public PeripheralsDecoderFilter mPeripheralsDecoderFilter;
    public ExternalDecoderFilter mExternalDecoderFilter;
    public CameraCaptureFilter mCaptureFilter = null;
    public GPUPreprocessFilter mPreprocessFilter = null;
    public YMFProcessGroupFilter mProcessGroupFilter = null;
    public ClipFilter mCliperFilter = null;
    public PreviewFilter mPreviewFilter = null;
    public VideoEncoderGroupFilter mEncoderGroupFilter = null;
    public VideoLiveFilterContext mFilterContext = null;
    public VideoEndPointFilter mEndPointFilter = null;
    private WeakReference<IEncoderListener> mEncoderListener = new WeakReference<Object>(null);
    private WeakReference<IYMFPreviewListener> mPreviewListener = new WeakReference<Object>(null);
    private AtomicBoolean mHardwareEncoderAvailable = new AtomicBoolean(true);
    private RotationVectorSensor mRotationVectorSensor = null;
    private SurfaceView mCameraSurfaceView = null;
    private ScreenShot mScreenShot = null;
    private FilterType mFilterType = FilterType.Normal;
    private VideoEncoderConfig mVideoEncoderConfig = new VideoEncoderConfig();
    private float mBeautyIntensity;
    private IDynamicTexture mDynamicTexture = null;
    private Object mSurfaceSync = new Object();
    private int mSurfaceWidth = 0;
    private int mSurfaceHeight = 0;
    private float mWaterMakeW = 0.0f;
    private float mWaterMakeH = 0.0f;
    private float mWaterMakeX = 0.0f;
    private float mWaterMakeY = 0.0f;
    private Bitmap mWaterMarkBitmap;
    private CameraPreviewCallbackHost mPreviewCallbackHost = new CameraPreviewCallbackHost();
    private OriginDataEntryFilter mOriginDataFilter = null;
    public VideoEncoderConfig mTmpVideoEncoderConfig = null;
    public VideoEncoderConfig mTmpAssignVideoEncoderConfig = null;

    public void setScaleMode(Constant.ScaleMode scaleMode) {
        if (!YYVideoSDK.getInstance().isUseGLSurfaceView()) {
            if (this.mPreviewFilter != null) {
                this.mPreviewFilter.setScaleMode(scaleMode);
            }
        } else if (this.mProcessGroupFilter != null) {
            this.mProcessGroupFilter.setScaleMode(scaleMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VideoLiveSessionYCloud(Context context, int type) {
        Object object = this.mSurfaceSync;
        synchronized (object) {
            this.mFilterContext = new VideoLiveFilterContext(context, type);
            this.mFilterContext.setLiveMode(LiveSessionType.LIVE_MODE_NORMAL);
            this.mFilterContext.setAndroidContext(context);
            this.mRotationVectorSensor = new RotationVectorSensor(context);
            this.mFilterContext.setRvSensor(this.mRotationVectorSensor);
            this.mScreenShot = new ScreenShot(context, this.mFilterContext);
            this.mFilterContext.setScreenShot(this.mScreenShot);
            this.mPeripheralsDecoderFilter = new PeripheralsDecoderFilter(this.mFilterContext);
            this.mExternalDecoderFilter = new ExternalDecoderFilter(this.mFilterContext);
            this.mCaptureFilter = new CameraCaptureFilter(this.mFilterContext);
            if (YYVideoSDK.getInstance().isUseGPUImage()) {
                this.mPreprocessFilter = new GPUPreprocessFilter(this.mFilterContext);
            }
            this.mProcessGroupFilter = new YMFProcessGroupFilter(this.mFilterContext);
            this.mCliperFilter = new ClipFilter();
            if (!YYVideoSDK.getInstance().isUseGLSurfaceView()) {
                this.mPreviewFilter = new PreviewFilter(this.mFilterContext);
            }
            this.mEncoderGroupFilter = new VideoEncoderGroupFilter(this.mFilterContext, this);
            this.mEndPointFilter = new VideoEndPointFilter(this.mFilterContext);
            this.mEncoderGroupFilter.setEncoderListener(this);
        }
        this.mPeripheralsDecoderFilter.addDownStream(this.mPreprocessFilter);
        this.mExternalDecoderFilter.addDownStream(this.mPreprocessFilter);
        if (!YYVideoSDK.getInstance().isUseGLSurfaceView()) {
            if (YYVideoSDK.getInstance().isUseGPUImage()) {
                this.mCaptureFilter.addDownStream(this.mPreprocessFilter.addDownStream(this.mCliperFilter.addDownStream(this.mEncoderGroupFilter).addDownStream(this.mPreviewFilter)).addDownStream(this.mEndPointFilter));
            } else {
                this.mFilterContext.mUseGPUBeauty = true;
                this.mCaptureFilter.addDownStream(this.mCliperFilter.addDownStream(this.mProcessGroupFilter.addDownStream(this.mEncoderGroupFilter).addDownStream(this.mPreviewFilter)).addDownStream(this.mEndPointFilter));
            }
        } else {
            this.mCaptureFilter.addDownStream(this.mCliperFilter.addDownStream(this.mProcessGroupFilter.addDownStream(this.mEncoderGroupFilter)).addDownStream(this.mEndPointFilter));
        }
        this.mFilterContext.getGlManager().registerFilter(this.mPeripheralsDecoderFilter);
        this.mFilterContext.getGlManager().registerFilter(this.mExternalDecoderFilter);
        this.mFilterContext.getGlManager().registerFilter(this.mCaptureFilter);
        if (!YYVideoSDK.getInstance().isUseGLSurfaceView()) {
            this.mFilterContext.getGlManager().registerFilter(this.mPreprocessFilter);
        } else {
            this.mFilterContext.getGlManager().registerFilter(this.mProcessGroupFilter);
        }
        this.mFilterContext.getGlManager().registerFilter(this.mCliperFilter);
        if (!YYVideoSDK.getInstance().isUseGLSurfaceView()) {
            this.mFilterContext.getGlManager().registerFilter(this.mPreviewFilter);
        }
        this.mFilterContext.getGlManager().registerFilter(this.mEncoderGroupFilter);
        this.mFilterContext.getGlManager().registerFilter(this.mEndPointFilter);
        if (this.mPreviewFilter != null) {
            this.mPreviewFilter.setPreviewListener(this);
        }
        UploadStatManager.getInstance().setIGetCurrentCameraStatInfo(this);
        UploadStatManager.getInstance().setIGetImageFilterInfo(this);
        YMFLog.info(this, "[Procedur]", "videoLiveSession #### use GLSurfaceView:" + YYVideoSDK.getInstance().isUseGLSurfaceView() + " isEmulator:" + this.mFilterContext.isEmulator());
    }

    private void startPreview(final int previewWidth, final int previewHeight, final int cameraFacing, final CameraInterface.CameraResolutionMode resMode) {
        this.mFilterContext.getGLManager().post(new Runnable(){

            @Override
            public void run() {
                VideoLiveSessionYCloud.this.mFilterContext.updateCameraPreviewConfig(previewWidth, previewHeight, cameraFacing, resMode);
                YMFLog.info(this, "[Preview ]", "startPreview, previewWidth:" + VideoLiveSessionYCloud.this.mFilterContext.getCameraPreviewConfig().getWidth() + " previewHeight:" + VideoLiveSessionYCloud.this.mFilterContext.getCameraPreviewConfig().getHeight());
                VideoLiveSessionYCloud.this.mCaptureFilter.init();
                if (!YYVideoSDK.getInstance().isUseGLSurfaceView()) {
                    if (YYVideoSDK.getInstance().isUseGPUImage()) {
                        VideoLiveSessionYCloud.this.mPreprocessFilter.init(previewWidth, previewHeight);
                    }
                    VideoLiveSessionYCloud.this.mPreviewFilter.init(previewWidth, previewHeight);
                }
                VideoLiveSessionYCloud.this.mPreviewCallbackHost.setPreviewCallbackWithBuffer();
                VideoLiveSessionYCloud.this.mPreviewCallbackHost.updatePreviewSize(previewWidth, previewHeight);
                if (VideoLiveSessionYCloud.this.mFilterContext.useYUVCapture()) {
                    VideoLiveSessionYCloud.this.mPreviewCallbackHost.registerCallback(VideoLiveSessionYCloud.this.mCaptureFilter);
                }
                if (VideoLiveSessionYCloud.this.mTmpVideoEncoderConfig != null) {
                    VideoLiveSessionYCloud.this.setEncoderConfig(VideoLiveSessionYCloud.this.mTmpVideoEncoderConfig);
                    VideoLiveSessionYCloud.this.mTmpVideoEncoderConfig = null;
                } else if (VideoLiveSessionYCloud.this.mTmpAssignVideoEncoderConfig != null) {
                    VideoLiveSessionYCloud.this.assignEncoderConfig(VideoLiveSessionYCloud.this.mTmpAssignVideoEncoderConfig);
                    VideoLiveSessionYCloud.this.mTmpAssignVideoEncoderConfig = null;
                }
                CameraInterface.getInstance().post(new Runnable(){

                    @Override
                    public void run() {
                        CameraInterface.getInstance().startPreviewWithSurfaceTexture(VideoLiveSessionYCloud.this.mCaptureFilter.getCaptureSurfaceTextures(), VideoLiveSessionYCloud.this.mCaptureFilter);
                    }
                });
            }
        });
    }

    @Override
    public void stopAndRelease() {
        YMFLog.info(this, "[Procedur]", "VideoLiveSession stopAndRelease begin");
        UploadStatManager.getInstance().setIGetCurrentCameraStatInfo(null);
        UploadStatManager.getInstance().setIGetImageFilterInfo(null);
        final CountDownLatch barrier = new CountDownLatch(1);
        this.mFilterContext.getGLManager().post(new Runnable(){

            @Override
            public void run() {
                if (VideoLiveSessionYCloud.this.mFilterContext.getScreenShot() != null) {
                    VideoLiveSessionYCloud.this.mFilterContext.getScreenShot().deInit();
                }
                if (VideoLiveSessionYCloud.this.mFilterContext.getDynamicTexture() != null) {
                    VideoLiveSessionYCloud.this.mFilterContext.getDynamicTexture().onRelease();
                    VideoLiveSessionYCloud.this.mFilterContext.setDynamicTexture(null);
                }
                if (VideoLiveSessionYCloud.this.mFilterContext.getWaterMarkTexture() != null) {
                    VideoLiveSessionYCloud.this.mFilterContext.getWaterMarkTexture().destroy();
                    VideoLiveSessionYCloud.this.mFilterContext.setWaterMarkTexture(null);
                }
                if (VideoLiveSessionYCloud.this.mFilterContext.getBackgroundTexture() != null) {
                    VideoLiveSessionYCloud.this.mFilterContext.getBackgroundTexture().destroy();
                    VideoLiveSessionYCloud.this.mFilterContext.setBackgroundTexture(null);
                }
                UploadStatManager.getInstance().stopStat();
                VideoLiveSessionYCloud.this.mFilterContext.getGLManager().quit();
                barrier.countDown();
            }
        });
        try {
            barrier.await(1500L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            YMFLog.error((Object)this, "[Preview ]", "stopAndRelease timeout exception:" + e.toString());
        }
        this.stopRvSensor();
        this.mCameraSurfaceView = null;
        this.mRotationVectorSensor = null;
        YMFLog.info(this, "[Procedur]", "VideoLiveSession stopAndRelease done");
        VideoDataStatUtil.clearPtsTimes(1001L);
    }

    public void updateSurfaceViewInfo() {
        if (this.mCameraSurfaceView != null) {
            YMFLog.info(this, "[Preview ]", "updateSurfaceViewInfo:" + this.mCameraSurfaceView.getWidth() + "x" + this.mCameraSurfaceView.getHeight() + ":" + (Build.VERSION.SDK_INT >= 19 ? (Comparable<Boolean>)Boolean.valueOf(this.mCameraSurfaceView.isAttachedToWindow()) : (Comparable<Boolean>)Integer.valueOf(this.mCameraSurfaceView.getVisibility())));
            if (this.mCameraSurfaceView.getWidth() != 0 || this.mCameraSurfaceView.getHeight() != 0) {
                YMFLiveUsrBehaviorStat.getInstance().notifyPreviewViewOnSurfaceState(true, this.mCameraSurfaceView.getWidth(), this.mCameraSurfaceView.getHeight());
                this.onSurfaceInfoEvent(2, EglFactory.newSurfaceInfo(this.mCameraSurfaceView.getHolder(), this.mCameraSurfaceView.getWidth(), this.mCameraSurfaceView.getHeight()));
            }
        }
    }

    public void setDeltaYYPtsMillions(final long deltaPtsDts) {
        YMFLog.info(this, "[Encoder ]", "setDeltaYYPtsMillions:" + deltaPtsDts);
        this.mFilterContext.getGlManager().post(new Runnable(){

            @Override
            public void run() {
                YYVideoSDK.getInstance().setDeltaYYPtsMillions(deltaPtsDts);
            }
        });
    }

    @Override
    public void reSetEncodingState() {
        this.mFilterContext.getGlManager().postDelayed(new Runnable(){

            @Override
            public void run() {
                if (VideoLiveSessionYCloud.this.mEncoderGroupFilter != null) {
                    VideoLiveSessionYCloud.this.mEncoderGroupFilter.reSetEncodingState();
                }
            }
        }, 300);
    }

    public void reSetPreviewState() {
        YMFLog.info(this, "[Preview ]", "reSetPreviewState...");
        if (this.mPreviewFilter != null) {
            this.mPreviewFilter.reSetPreviewState();
        }
    }

    public void setPreviewSurfaceView(SurfaceView view) {
        YMFLog.info(this, "[Preview ]", "setPreviewSurfaceView:" + view);
        if (view != null) {
            YMFLiveUsrBehaviorStat.getInstance().notifyVideoPreviewViewState(true);
        } else {
            YMFLiveUsrBehaviorStat.getInstance().notifyVideoPreviewViewState(false);
        }
        if (YYVideoSDK.getInstance().isUseGLSurfaceView()) {
            this.mProcessGroupFilter.setPreviewView(view);
            return;
        }
        this.mPreviewFilter.drawBlackScreen(view == null);
        try {
            if (this.mCameraSurfaceView != null && this.mCameraSurfaceView != view) {
                this.mCameraSurfaceView.getHolder().removeCallback((SurfaceHolder.Callback)this);
                this.mCameraSurfaceView = null;
            }
        }
        catch (Exception e) {
            YMFLog.warn(this, "[Preview ]", "old mCameraSurfaceView remove exception:" + e.toString());
        }
        this.mCameraSurfaceView = view;
        if (this.mCameraSurfaceView != null) {
            this.mCameraSurfaceView.getHolder().addCallback((SurfaceHolder.Callback)this);
        }
        this.updateSurfaceViewInfo();
    }

    @Override
    public void setWaterMark(final WaterMark waterMark) {
        YMFLog.info(this, "[Beauty  ]", "setWaterMark, waterMark==null? " + (waterMark == null ? "y" : "n"));
        this.mFilterContext.getGLManager().post(new Runnable(){

            @Override
            public void run() {
                VideoLiveSessionYCloud.this.mFilterContext.setWaterMarkTexture(waterMark);
            }
        });
    }

    @Override
    public void startEncoder() {
        this.mFilterContext.getGLManager().post(new Runnable(){

            @Override
            public void run() {
                YYUserLiveConfig userLiveConfig = VideoLiveSessionYCloud.this.mFilterContext.getUserLiveConfig();
                if (!VideoLiveSessionYCloud.this.isHardwareEncoderAvailable()) {
                    VideoLiveSessionYCloud.this.mFilterContext.mVideoEncoderConfig.mEncodeType = VideoEncoderType.SOFT_ENCODER_X264;
                }
                if (VideoLiveSessionYCloud.this.mEncoderGroupFilter.isEnable()) {
                    YMFLog.info(this, "[Encoder ]", "encoder is started already!!");
                } else {
                    try {
                        boolean res = VideoLiveSessionYCloud.this.mEncoderGroupFilter.startEncode(VideoLiveSessionYCloud.this.mFilterContext.getVideoEncoderConfig());
                        if (res) {
                            UploadStatManager.getInstance().startStat();
                        }
                    }
                    catch (Exception e) {
                        YMFLog.error((Object)this, "[Encoder ]", "startEncode exception:" + e);
                    }
                }
            }
        });
    }

    @Override
    public void stopEncoder() {
        this.mFilterContext.getGLManager().post(new Runnable(){

            @Override
            public void run() {
                UploadStatManager.getInstance().stopStat();
                if (VideoLiveSessionYCloud.this.mEncoderGroupFilter.isEnable()) {
                    VideoLiveSessionYCloud.this.mEncoderGroupFilter.stopEncode();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSurfaceInfoEvent(int evtType, final AbstractSurfaceInfo surfaceInfo) {
        if (!YYVideoSDK.getInstance().isUseGLSurfaceView()) {
            if (surfaceInfo != null) {
                YMFLog.info(this, "[Preview ]", "onSurfaceInfoEvent evtType:" + evtType + " width:" + surfaceInfo.mWidth + " height:" + surfaceInfo.mHeight);
            } else {
                YMFLog.info(this, "[Preview ]", "onSurfaceInfoEvent evtType:" + evtType);
            }
            switch (evtType) {
                case 1: 
                case 2: {
                    Object object = this.mSurfaceSync;
                    synchronized (object) {
                        this.mFilterContext.getGLManager().post(new Runnable(){

                            @Override
                            public void run() {
                                if (VideoLiveSessionYCloud.this.mPreviewFilter != null) {
                                    VideoLiveSessionYCloud.this.mPreviewFilter.onSurfaceChanged(surfaceInfo);
                                    VideoLiveSessionYCloud.this.mSurfaceWidth = surfaceInfo.mWidth;
                                    VideoLiveSessionYCloud.this.mSurfaceHeight = surfaceInfo.mHeight;
                                    VideoLiveSessionYCloud.this.mFilterContext.mSurfaceDestoryStateLock.lock();
                                    VideoLiveSessionYCloud.this.mFilterContext.mSurfaceDestoryState.set(false);
                                    VideoLiveSessionYCloud.this.mFilterContext.mSurfaceDestoryStateLock.unlock();
                                }
                            }
                        });
                        break;
                    }
                }
                case 3: {
                    if (this.mPreviewFilter != null) {
                        this.mFilterContext.mSurfaceDestoryStateLock.lock();
                        this.mFilterContext.mSurfaceDestoryState.set(true);
                        this.mFilterContext.mSurfaceDestoryStateLock.unlock();
                    }
                    this.mFilterContext.getGLManager().post(new Runnable(){

                        @Override
                        public void run() {
                            if (VideoLiveSessionYCloud.this.mPreviewFilter != null) {
                                VideoLiveSessionYCloud.this.mPreviewFilter.onSurfaceDestroy();
                            }
                        }
                    });
                    break;
                }
            }
        }
    }

    public void setFilterInfo(final FilterType filterType, final Map<String, String> params) {
        this.mFilterContext.getGlManager().post(new Runnable(){

            @Override
            public void run() {
                if (VideoLiveSessionYCloud.this.mPreprocessFilter != null) {
                    VideoLiveSessionYCloud.this.mPreprocessFilter.setFilterInfo(filterType, params);
                }
            }
        });
    }

    public void setFilterType(final FilterType filterType) {
        this.mFilterContext.getGlManager().post(new Runnable(){

            @Override
            public void run() {
                if (VideoLiveSessionYCloud.this.mPreprocessFilter != null) {
                    VideoLiveSessionYCloud.this.mPreprocessFilter.setFilterType(filterType);
                }
            }
        });
    }

    public FilterType getFilterType() {
        return this.mFilterType;
    }

    @Override
    public void setWaterMark(Bitmap bitmap, int offsetX, int offsetY) {
        if (this.mVideoEncoderConfig == null) {
            return;
        }
        YMFLog.info(this, "[Beauty  ]", "setWaterMark, bitmap==null? " + (bitmap == null ? "y" : "n") + "<" + offsetX + "." + offsetY + ">");
        this.mWaterMarkBitmap = bitmap;
        if (bitmap == null) {
            this.setWaterMark(null);
            return;
        }
        if (bitmap != null && bitmap != null && (bitmap.getWidth() + offsetX > this.mVideoEncoderConfig.mEncodeWidth || bitmap.getHeight() + offsetY > this.mVideoEncoderConfig.mEncodeHeight)) {
            YMFLog.error((Object)this, "[Beauty  ]", "setWaterMark error:" + bitmap.getWidth() + "(bitmapWigth)+" + offsetX + "(offestX)>" + this.mVideoEncoderConfig.mEncodeWidth + "(encodeWidth) OR " + bitmap.getHeight() + "(bitmapHeight)+" + offsetY + "(offsetY)>" + this.mVideoEncoderConfig.mEncodeHeight + "(encodeHeight)");
            this.setWaterMark(null);
            return;
        }
        this.mWaterMakeX = (float)offsetX / (float)this.mVideoEncoderConfig.mEncodeWidth;
        this.mWaterMakeY = (float)offsetY / (float)this.mVideoEncoderConfig.mEncodeHeight;
        this.mWaterMakeW = (float)bitmap.getWidth() / (float)this.mVideoEncoderConfig.mEncodeWidth;
        this.mWaterMakeH = (float)bitmap.getHeight() / (float)this.mVideoEncoderConfig.mEncodeHeight;
        int X = (int)((float)this.mVideoEncoderConfig.mEncodeWidth * this.mWaterMakeX);
        int Y = (int)((float)this.mVideoEncoderConfig.mEncodeHeight * this.mWaterMakeY);
        int W = (int)((float)this.mVideoEncoderConfig.mEncodeWidth * this.mWaterMakeW);
        int H = (int)((float)this.mVideoEncoderConfig.mEncodeHeight * this.mWaterMakeH);
        float scaleWidth = (float)W / (float)this.mWaterMarkBitmap.getWidth();
        float scaleHeight = (float)H / (float)this.mWaterMarkBitmap.getHeight();
        Matrix matrix = new Matrix();
        matrix.postScale(scaleWidth, scaleHeight);
        Bitmap newBM = Bitmap.createBitmap((Bitmap)this.mWaterMarkBitmap, (int)0, (int)0, (int)this.mWaterMarkBitmap.getWidth(), (int)this.mWaterMarkBitmap.getHeight(), (Matrix)matrix, (boolean)false);
        WaterMark waterMark = new WaterMark(newBM, this.mVideoEncoderConfig.mEncodeWidth, this.mVideoEncoderConfig.mEncodeHeight, X, Y, WaterMark.Align.LeftTop);
        this.setWaterMark(waterMark);
    }

    @Override
    public void setBackground(final Background background) {
        YMFLog.info(this, "[Preview ]", "setBackground, background ==null? " + (background == null ? "y" : "n"));
        this.mFilterContext.getGLManager().post(new Runnable(){

            @Override
            public void run() {
                VideoLiveSessionYCloud.this.mFilterContext.setBackgroundTexture(background);
            }
        });
    }

    @Override
    public void setDynamicTexture(final IDynamicTexture dynamicTexture) {
        this.mDynamicTexture = dynamicTexture;
        this.mFilterContext.getGLManager().post(new Runnable(){

            @Override
            public void run() {
                YMFLog.info(this, "[Beauty  ]", "setDynamicTexture");
                VideoLiveSessionYCloud.this.mFilterContext.setDynamicTexture(dynamicTexture);
            }
        });
    }

    @Override
    public void takeScreenShot(ScreenShotCallback callback) {
        this.mScreenShot.setCallback(callback);
    }

    @Override
    public void setNetworkBitrateSuggest(final int bitrate) {
        YMFLog.info(this, "[Encoder ]", "setNetworkBitrateSuggest:" + bitrate);
        this.mFilterContext.getGLManager().post(new Runnable(){

            @Override
            public void run() {
                VideoLiveSessionYCloud.this.mEncoderGroupFilter.setNetworkBitrateSuggest(bitrate);
            }
        });
    }

    @Override
    public void setResolutionModifyConfigs(final List<ResolutionModifyConfig> configs, final int intervalSecs) {
        this.mFilterContext.getGlManager().post(new Runnable(){

            @Override
            public void run() {
                if (VideoLiveSessionYCloud.this.mFilterContext.isEmulator()) {
                    for (ResolutionModifyConfig config : configs) {
                        config.videoEncoderType = VideoEncoderType.SOFT_ENCODER_X264;
                        config.encoderParams = "";
                    }
                }
                VideoLiveSessionYCloud.this.mEncoderGroupFilter.setResolutionModifyConfigs(configs, intervalSecs);
            }
        });
    }

    public void setPreviewListener(IYMFPreviewListener listener) {
        this.mPreviewListener = new WeakReference<IYMFPreviewListener>(listener);
    }

    @Override
    public void setEncoderListener(final IEncoderListener listener) {
        if (listener == null) {
            YMFLog.info(this, "[Encoder ]", "setEncoderlistener:" + listener);
            this.mEncoderListener = new WeakReference<IEncoderListener>(listener);
            if (listener != null) {
                listener.onEncodeEncParam(this.mFilterContext.getEncodeParamTipsMgr().getParam());
            }
        } else {
            this.mFilterContext.getGLManager().post(new Runnable(){

                @Override
                public void run() {
                    YMFLog.info(this, "[Encoder ]", "setEncoderlistener:" + listener);
                    VideoLiveSessionYCloud.this.mEncoderListener = new WeakReference<IEncoderListener>(listener);
                    if (listener != null) {
                        listener.onEncodeEncParam(VideoLiveSessionYCloud.this.mFilterContext.getEncodeParamTipsMgr().getParam());
                    }
                }
            });
        }
    }

    public void assignEncoderConfig(VideoEncoderConfig config) {
        YMFLog.info(this, "[Encoder ]", "setEncoderconfig:" + config.toString());
        this.mVideoEncoderConfig = config;
        if (this.mFilterContext.isEmulator()) {
            this.mVideoEncoderConfig.mEncodeType = VideoEncoderType.SOFT_ENCODER_X264;
        }
        if (!this.mFilterContext.getGLManager().checkSameThread()) {
            this.mFilterContext.getGLManager().post(new Runnable(){

                @Override
                public void run() {
                    VideoLiveSessionYCloud.this.mFilterContext.getVideoEncoderConfig().assign(VideoLiveSessionYCloud.this.mVideoEncoderConfig);
                    if (VideoLiveSessionYCloud.this.mFilterContext.mChangeEncoderFlag.get() && VideoLiveSessionYCloud.this.mEncoderGroupFilter.isEnable()) {
                        VideoLiveSessionYCloud.this.mEncoderGroupFilter.stopEncode();
                        VideoLiveSessionYCloud.this.mEncoderGroupFilter.startEncode(VideoLiveSessionYCloud.this.mVideoEncoderConfig);
                    }
                }
            });
        } else {
            this.mFilterContext.getVideoEncoderConfig().assign(this.mVideoEncoderConfig);
            if (this.mFilterContext.mChangeEncoderFlag.get() && this.mEncoderGroupFilter.isEnable()) {
                this.mEncoderGroupFilter.stopEncode();
                this.mEncoderGroupFilter.startEncode(this.mVideoEncoderConfig);
            }
        }
    }

    @Override
    public void setEncoderConfig(final VideoEncoderConfig config) {
        YMFLog.info(this, "[Encoder ]", "setEncoderconfig:" + config.toString());
        this.mVideoEncoderConfig = config;
        if (this.mFilterContext.isEmulator()) {
            this.mVideoEncoderConfig.mEncodeType = VideoEncoderType.SOFT_ENCODER_X264;
        }
        if (!this.mFilterContext.getGLManager().checkSameThread()) {
            this.mFilterContext.getGLManager().post(new Runnable(){

                @Override
                public void run() {
                    VideoLiveSessionYCloud.this.mFilterContext.getVideoEncoderConfig().assign(VideoLiveSessionYCloud.this.mVideoEncoderConfig);
                    YMFLog.info(this, "[Encoder ]", "setEncoderConfig:" + VideoLiveSessionYCloud.this.mFilterContext.getVideoEncoderConfig().toString());
                    VideoLiveSessionYCloud.this.mFilterContext.getDefaultVideoEncoderConfig().assign(VideoLiveSessionYCloud.this.mVideoEncoderConfig);
                    if (!YYVideoSDK.getInstance().isUseGLSurfaceView() && YYVideoSDK.getInstance().isUseGPUImage()) {
                        VideoLiveSessionYCloud.this.mPreprocessFilter.init(VideoLiveSessionYCloud.this.mVideoEncoderConfig.getEncodeWidth(), VideoLiveSessionYCloud.this.mVideoEncoderConfig.getEncodeHeight());
                    }
                    VideoLiveSessionYCloud.this.mEncoderGroupFilter.init();
                    if (!YYVideoSDK.getInstance().isUseGLSurfaceView()) {
                        VideoLiveSessionYCloud.this.mPreviewFilter.init(config.getEncodeWidth(), config.getEncodeHeight());
                    }
                    if (VideoLiveSessionYCloud.this.mFilterContext.mChangeEncoderFlag.get() && VideoLiveSessionYCloud.this.mEncoderGroupFilter.isEnable()) {
                        VideoLiveSessionYCloud.this.mEncoderGroupFilter.stopEncode();
                        VideoLiveSessionYCloud.this.mEncoderGroupFilter.startEncode(VideoLiveSessionYCloud.this.mVideoEncoderConfig);
                    }
                    UploadStatManager.getInstance().putSettingBitRate(config.getBitRate());
                    UploadStatManager.getInstance().putSettingDPI(config.getRealDPI());
                    UploadStatManager.getInstance().putSettingFrameRate(config.getFrameRate());
                }
            });
        } else {
            this.mFilterContext.getVideoEncoderConfig().assign(this.mVideoEncoderConfig);
            YMFLog.info(this, "[Encoder ]", "setEncoderConfig:" + this.mFilterContext.getVideoEncoderConfig().toString());
            this.mFilterContext.getDefaultVideoEncoderConfig().assign(this.mVideoEncoderConfig);
            if (!YYVideoSDK.getInstance().isUseGLSurfaceView() && YYVideoSDK.getInstance().isUseGPUImage()) {
                this.mPreprocessFilter.init(this.mVideoEncoderConfig.getEncodeWidth(), this.mVideoEncoderConfig.getEncodeHeight());
            }
            this.mEncoderGroupFilter.init();
            if (!YYVideoSDK.getInstance().isUseGLSurfaceView()) {
                this.mPreviewFilter.init(config.getEncodeWidth(), config.getEncodeHeight());
            }
            if (this.mFilterContext.mChangeEncoderFlag.get() && this.mEncoderGroupFilter.isEnable()) {
                this.mEncoderGroupFilter.stopEncode();
                this.mEncoderGroupFilter.startEncode(this.mVideoEncoderConfig);
            }
            UploadStatManager.getInstance().putSettingBitRate(config.getBitRate());
            UploadStatManager.getInstance().putSettingDPI(config.getRealDPI());
            UploadStatManager.getInstance().putSettingFrameRate(config.getFrameRate());
        }
    }

    @Override
    public void setLowDelayMode(final boolean enable) {
        this.mFilterContext.getGLManager().post(new Runnable(){

            @Override
            public void run() {
                VideoLiveSessionYCloud.this.mFilterContext.getVideoEncoderConfig().mLowDelay = enable;
                YMFLog.info(this, "[Encoder ]", "setLowDelayMode:" + enable + " config:" + VideoLiveSessionYCloud.this.mFilterContext.getVideoEncoderConfig().toString());
                if (VideoLiveSessionYCloud.this.mFilterContext.mChangeEncoderFlag.get() && VideoLiveSessionYCloud.this.mEncoderGroupFilter.isEnable()) {
                    VideoLiveSessionYCloud.this.mEncoderGroupFilter.stopEncode();
                    VideoLiveSessionYCloud.this.mEncoderGroupFilter.startEncode(VideoLiveSessionYCloud.this.mVideoEncoderConfig);
                }
            }
        });
    }

    @Override
    public void adjustEncoderBitrate(int bitRate) {
        if (this.mEncoderGroupFilter != null) {
            YMFLog.info(this, "[Encoder ]", "setNetworkBitrateSuggest:" + bitRate);
            this.mEncoderGroupFilter.adjustBitRate((bitRate + 999) / 1000);
        }
    }

    @Override
    public void onEncodeStat(int bitRate, int frameRate) {
        IEncoderListener listener = (IEncoderListener)this.mEncoderListener.get();
        if (listener != null) {
            listener.onEncodeStat(bitRate, frameRate);
        }
    }

    @Override
    public void onEncodeResolution(int width, int height) {
        IEncoderListener listener = (IEncoderListener)this.mEncoderListener.get();
        if (listener != null) {
            listener.onEncodeResolution(width, height);
        }
    }

    @Override
    public void onEncodeFirstFrame() {
        IEncoderListener listener = (IEncoderListener)this.mEncoderListener.get();
        if (listener != null) {
            listener.onEncodeFirstFrame();
        }
    }

    @Override
    public void onRenderFirstFrame() {
        IYMFPreviewListener listener = (IYMFPreviewListener)this.mPreviewListener.get();
        if (listener != null) {
            listener.onRenderFirstFrame();
        }
    }

    @Override
    public void onEncodeFrameData(byte[] data, int len, long pts, long dts, int frameType, VideoEncoderType encodeType, int svcTid, int svcSid) {
        IEncoderListener listener = (IEncoderListener)this.mEncoderListener.get();
        if (listener != null) {
            listener.onEncodeFrameData(data, len, pts, dts, frameType, encodeType, svcTid, svcSid);
        }
    }

    @Override
    public void onEncodeEncParam(String param) {
        IEncoderListener listener = (IEncoderListener)this.mEncoderListener.get();
        if (listener != null) {
            listener.onEncodeEncParam(param);
        }
    }

    @Override
    public void onHardEncoderError() {
        IEncoderListener listener = (IEncoderListener)this.mEncoderListener.get();
        if (listener != null) {
            listener.onHardEncoderError();
        }
    }

    @Override
    public void onEncoderSwitch() {
    }

    @Override
    public void onWaterMarkSizeChange(int w, int h) {
        YMFLog.info(this, "[Beauty  ]", "onWaterMarkSizeChange w:" + w + " h:" + h + "(" + this.mWaterMakeX + "," + this.mWaterMakeY + "," + this.mWaterMakeW + "," + this.mWaterMakeH + ")");
        if ((double)this.mWaterMakeH == 0.0 || (double)this.mWaterMakeW == 0.0 || this.mWaterMarkBitmap == null) {
            return;
        }
        int X = (int)((float)w * this.mWaterMakeX);
        int Y = (int)((float)h * this.mWaterMakeY);
        int W = (int)((float)w * this.mWaterMakeW);
        int H = (int)((float)h * this.mWaterMakeH);
        float scaleWidth = (float)W / (float)this.mWaterMarkBitmap.getWidth();
        float scaleHeight = (float)H / (float)this.mWaterMarkBitmap.getHeight();
        Matrix matrix = new Matrix();
        matrix.postScale(scaleWidth, scaleHeight);
        Bitmap newBM = Bitmap.createBitmap((Bitmap)this.mWaterMarkBitmap, (int)0, (int)0, (int)this.mWaterMarkBitmap.getWidth(), (int)this.mWaterMarkBitmap.getHeight(), (Matrix)matrix, (boolean)false);
        WaterMark waterMark = new WaterMark(newBM, w, h, X, Y, WaterMark.Align.LeftTop);
        this.setWaterMark(waterMark);
    }

    @Override
    public void requestIFrame() {
        YMFLog.info(this, "[Encoder ]", "requestIFrame");
        this.mFilterContext.getGLManager().post(new Runnable(){

            @Override
            public void run() {
                if (VideoLiveSessionYCloud.this.mEncoderGroupFilter != null) {
                    VideoLiveSessionYCloud.this.mEncoderGroupFilter.requestSyncFrame();
                }
            }
        });
    }

    public void setUserLiveConfig(final YYUserLiveConfig userLiveConfig) {
        this.mFilterContext.getGLManager().post(new Runnable(){

            @Override
            public void run() {
                VideoLiveSessionYCloud.this.mFilterContext.setUserLiveConfig(userLiveConfig);
            }
        });
    }

    public void enableColorChartLive(final boolean enable) {
        YMFLog.info(this, "[Encoder ]", "enableColorChartLive:" + enable);
        this.mFilterContext.getGlManager().post(new Runnable(){

            @Override
            public void run() {
                VideoLiveSessionYCloud.this.mFilterContext.setColorChartLiveEnable(enable);
            }
        });
    }

    @Override
    public void notifyCameraPreviewParameter(int width, int height, int facing, CameraInterface.CameraResolutionMode resMode) {
        YMFLog.info(this, "[Preview ]", "notifyCameraPreviewParameter, width:" + width + " height:" + height + " facing:" + facing);
        this.startPreview(width, height, facing, resMode);
    }

    @Override
    public void notifyCameraOpenSuccess() {
    }

    @Override
    public void notifyCameraOpenFail(String reason) {
    }

    @Override
    public void onDualOpen(boolean flag) {
        this.mFilterContext.setPictureInPictureFlag(flag);
    }

    @Override
    public void onDualPictureSwitch() {
        this.mFilterContext.setSwitchPicture();
    }

    public void enableMirror(boolean enable) {
        YMFLog.info(this, "[Encoder ]", "enableEncodeMirror:" + enable);
        if (this.mFilterContext != null) {
            this.mFilterContext.setMirrorFlag(enable);
        }
    }

    public void enablePreviewMirror(boolean enable) {
        YMFLog.info(this, "[Preview ]", "enablePreviewMirror:" + enable);
        if (this.mFilterContext != null) {
            this.mFilterContext.setPreviewMirrorFlag(enable);
        }
    }

    @Override
    public void setHardwareEncoderAvailable(boolean available) {
        YMFLog.info(this, "[Encoder ]", "HardwareEncoderAvailable set status:" + available);
        this.mHardwareEncoderAvailable.set(available);
    }

    @Override
    public boolean isHardwareEncoderAvailable() {
        YMFLog.info(this, "[Encoder ]", "HardwareEncoderAvailable get status:" + this.mHardwareEncoderAvailable.get());
        return this.mHardwareEncoderAvailable.get();
    }

    @Override
    public void onPeripheralsVideoDataReceived(DecodeVideoSample sample) {
        this.mPeripheralsDecoderFilter.handlePeripheralsVideoData(sample);
    }

    @Override
    public void onPeripheralsVideoConfigReceived(DecodeVideoConfig config) {
        this.mPeripheralsDecoderFilter.handlePeripheralsVideoConfig(config, this.mPeripheralsDecoderFilter);
    }

    @Override
    public void onPeripheralsVideoEnd() {
        YMFLog.info(this, "[Decoder ]", "onPeripheralsVideoEnd");
        this.mPeripheralsDecoderFilter.handlePerpheralsVideoEnd();
        this.mPeripheralsDecoderFilter.deInit();
        this.mFilterContext.setLiveMode(LiveSessionType.LIVE_MODE_NORMAL);
        this.mPreprocessFilter.onPeripheralsVideoEnd();
    }

    @Override
    public void setVideoRenderPosition(final VideoRenderPosition position) {
        if (position == null) {
            YMFLog.error((Object)this, "[Decoder ]", "invalid VideoRenderPositon, return");
            return;
        }
        this.mFilterContext.getGlManager().post(new Runnable(){

            @Override
            public void run() {
                VideoLiveSessionYCloud.this.mFilterContext.setVideoRenderPostion(position);
            }
        });
    }

    public void startRvSensor() {
        YMFLog.info(this, "[Preview ]", "RotationVectorSensor startRvSensor");
        if (this.mRotationVectorSensor != null) {
            this.mRotationVectorSensor.registerSensor();
        }
    }

    public void stopRvSensor() {
        YMFLog.info(this, "[Preview ]", "RotationVectorSensor stopRvSensor");
        if (this.mRotationVectorSensor != null) {
            this.mRotationVectorSensor.unregisterSensor();
        }
    }

    public void onTouch(MotionEvent event) {
        YYCamera.getInstance().handleFocusMetering(event);
    }

    public void setTextureListener(final ITextureListener listener) {
        this.mFilterContext.getGlManager().post(new Runnable(){

            @Override
            public void run() {
                if (VideoLiveSessionYCloud.this.mPreprocessFilter != null) {
                    VideoLiveSessionYCloud.this.mPreprocessFilter.setTextureListener(listener);
                }
            }
        });
    }

    public void surfaceCreated(SurfaceHolder holder) {
        YMFLog.info(this, "[Preview ]", "surfaceCreated...");
        this.onSurfaceInfoEvent(1, EglFactory.newSurfaceInfo(holder, 0, 0));
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        YMFLog.info(this, "[Preview ]", "surfaceChanged...");
        YMFLiveUsrBehaviorStat.getInstance().notifyPreviewViewOnSurfaceState(true, width, height);
        this.onSurfaceInfoEvent(2, EglFactory.newSurfaceInfo(holder, width, height));
        CameraInterface.getInstance().setSurfaceViewSize(width, height);
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        YMFLog.info(this, "[Preview ]", "surfaceDestroyed...");
        YMFLiveUsrBehaviorStat.getInstance().notifyPreviewViewOnSurfaceState(false, 0, 0);
        this.onSurfaceInfoEvent(3, null);
    }

    @Override
    public boolean onGetHasBeauty() {
        return this.isUse(this.mBeautyIntensity);
    }

    @Override
    public boolean onGetHasFaceLift() {
        return false;
    }

    @Override
    public float onGetBeautyLevel() {
        return this.mBeautyIntensity;
    }

    @Override
    public float onGetFaceLiftLevel() {
        return 0.0f;
    }

    @Override
    public boolean onGetHasSticker() {
        boolean mIsUseSticker = false;
        return mIsUseSticker;
    }

    @Override
    public boolean onGetHasDynamicSticker() {
        boolean mIsUseDynamicSticker = false;
        if (this.mDynamicTexture != null) {
            mIsUseDynamicSticker = true;
        }
        return mIsUseDynamicSticker;
    }

    @Override
    public int onGetAnchorCurrentBitRate() {
        int bitRate = 0;
        if (this.mVideoEncoderConfig != null) {
            bitRate = this.mVideoEncoderConfig.getBitRate();
        }
        return bitRate;
    }

    @Override
    public int onGetAnchorCurrentFrameRate() {
        int frameRate = 0;
        if (this.mVideoEncoderConfig != null) {
            frameRate = this.mVideoEncoderConfig.getFrameRate();
        }
        return frameRate;
    }

    @Override
    public String onGetAnchorCurrentDIPRate() {
        String realDPI = "";
        if (this.mVideoEncoderConfig != null) {
            realDPI = this.mVideoEncoderConfig.getRealDPI();
        }
        return realDPI;
    }

    private boolean isUse(float val) {
        boolean isUse = false;
        if (val > 1.0E-5f) {
            isUse = true;
        }
        return isUse;
    }

    @Override
    public void setExternalDecodeInterface(ExternalInterface.IExternalDecode IExternalDecode2) {
        if (this.mFilterContext != null && IExternalDecode2 != null) {
            this.mFilterContext.setLiveMode(LiveSessionType.LIVE_MODE_EXTERNAL);
        }
        if (this.mEncoderGroupFilter != null) {
            this.mEncoderGroupFilter.setExternalDecodeCallback(IExternalDecode2);
        }
    }

    @Override
    public void setExternalVideoInterface(ExternalInterface.IExternalCameraData IExternalCameraData2) {
        if (this.mFilterContext != null && IExternalCameraData2 != null) {
            this.mFilterContext.setLiveMode(LiveSessionType.LIVE_MODE_EXTERNAL);
        }
        if (this.mEncoderGroupFilter != null) {
            this.mEncoderGroupFilter.setExternalCameraDataCallback(IExternalCameraData2);
        }
    }

    @Override
    public void pushEncodeExternalData(ExternalYYMediaSample externalYYMediaSample) {
        YYMediaSample sample = null;
        Object object = externalYYMediaSample.mSample;
        if (object instanceof YYMediaSample) {
            sample = (YYMediaSample)object;
            sample.mMasterTextureId = externalYYMediaSample.mMasterTextureId;
            sample.mYYPtsMillions = externalYYMediaSample.mPts;
        }
        if (this.mEncoderGroupFilter != null) {
            this.mEncoderGroupFilter.setIsExternalEncode(true);
            this.mEncoderGroupFilter.processMediaSample(sample, null);
        }
    }

    @Override
    public void setGLManagerRunnable(Runnable runnable) {
        if (this.mFilterContext != null) {
            this.mFilterContext.getGLManager().post(runnable);
        }
    }

    @Override
    public void pushExternalVideoDecodeInfo(ExternalDecodeInfo decodeInfo) {
        if (this.mExternalDecoderFilter == null || decodeInfo == null) {
            YMFLog.error((Object)this, "[Decoder ]", "invalid VideoLiveSession or sample is null");
            return;
        }
        this.mExternalDecoderFilter.handleOutdoorVideoConfig(decodeInfo.convertToConfig(), this.mExternalDecoderFilter);
        this.mExternalDecoderFilter.handleOutdoorVideoData(decodeInfo.convertToStreamInfo());
    }

    @Override
    public void onExternalVideoEnd() {
        YMFLog.info(this, "[Decoder ]", "onPeripheralsVideoEnd");
        this.mExternalDecoderFilter.handleExternalVideoEnd();
        this.mExternalDecoderFilter.deInit();
        this.mFilterContext.setLiveMode(LiveSessionType.LIVE_MODE_NORMAL);
        this.mEncoderGroupFilter.onExternalVideoEnd();
    }

    public void setGPUImageBeautyFilter(IGPUProcess gpuImageProcess) {
        if (YYVideoSDK.getInstance().isUseGLSurfaceView()) {
            if (this.mProcessGroupFilter != null) {
                this.mProcessGroupFilter.setGpuProcess(gpuImageProcess);
                this.mFilterContext.mUseGPUBeauty = gpuImageProcess != null;
            }
        } else if (YYVideoSDK.getInstance().isUseGPUImage()) {
            if (this.mPreprocessFilter != null) {
                this.mPreprocessFilter.setGPUImageBeautyFilter(gpuImageProcess);
            } else {
                YMFLog.error((Object)this, "[Beauty  ]", "setGPUImageBeautyFilter failed");
            }
        } else if (this.mProcessGroupFilter != null) {
            this.mProcessGroupFilter.setGpuProcess(gpuImageProcess);
        }
    }

    public void registerCallback(PreviewFrameCallback callback) {
        if (this.mPreviewCallbackHost != null) {
            this.mPreviewCallbackHost.registerCallback(callback);
        }
    }

    public void unregisterCallback(PreviewFrameCallback callback) {
        if (this.mPreviewCallbackHost != null) {
            this.mPreviewCallbackHost.unregisterCallback(callback);
        }
    }

    public void initOriginDataFilter() {
        if (this.mOriginDataFilter == null) {
            this.mOriginDataFilter = new OriginDataEntryFilter(this.mFilterContext);
            this.mOriginDataFilter.addDownStream(this.mCliperFilter.addDownStream(this.mEncoderGroupFilter).addDownStream(this.mPreviewFilter)).addDownStream(this.mEndPointFilter);
            YMFLog.error((Object)this, "[Encoder ]", "initOriginDataFilter success!");
        } else {
            YMFLog.error((Object)this, "[Encoder ]", "initOriginDataFilter is not null");
        }
    }

    public void setOriginFrameToEncode(byte[] data, int format, int width, int height, int rotation, long timestamp) {
        if (this.mOriginDataFilter != null) {
            long stamp = timestamp;
            if (timestamp == 0L) {
                stamp = TimeUtil.getTickCountLong();
            }
            this.mOriginDataFilter.setOriginFrameToEncode(data, format, width, height, rotation, stamp);
        } else {
            YMFLog.error((Object)this, "[Encoder ]", "OriginDataFilter not init!");
        }
    }

    public void setUsedTexture(boolean used) {
        if (this.mFilterContext != null) {
            this.mFilterContext.mUseGPUBeauty = used;
            YMFLog.error((Object)this, "[Beauty  ]", "setUsedTexture" + used);
        }
    }

    public void setAbroadNetWorkStrategy(boolean flag) {
        if (this.mFilterContext != null) {
            this.mFilterContext.setAbroadNetWorkStrategy(flag);
        }
    }
}

