/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import com.yy.mediaframework.CameraInterface;
import com.yy.mediaframework.CameraListener;
import com.yy.mediaframework.Constant;
import com.yy.mediaframework.ExternalInterface;
import com.yy.mediaframework.GetAnchorStatInfoInterface;
import com.yy.mediaframework.IEncoderListener;
import com.yy.mediaframework.IMediaCodecUpload;
import com.yy.mediaframework.VideoLiveSession;
import com.yy.mediaframework.VideoRenderPosition;
import com.yy.mediaframework.YYCamera;
import com.yy.mediaframework.background.Background;
import com.yy.mediaframework.base.VideoEncoderConfig;
import com.yy.mediaframework.base.YYUserLiveConfig;
import com.yy.mediaframework.facedetection.PreviewFrameCallback;
import com.yy.mediaframework.gles.EglFactory;
import com.yy.mediaframework.gpuimage.FilterType;
import com.yy.mediaframework.gpuimage.custom.IGPUProcess;
import com.yy.mediaframework.inteligence.common.ResolutionModifyConfig;
import com.yy.mediaframework.inteligence.dynamictexture.IDynamicTexture;
import com.yy.mediaframework.model.DecodeVideoConfig;
import com.yy.mediaframework.model.DecodeVideoSample;
import com.yy.mediaframework.model.ExternalDecodeInfo;
import com.yy.mediaframework.model.ExternalYYMediaSample;
import com.yy.mediaframework.model.YYMediaSample;
import com.yy.mediaframework.screenshot.ScreenShotCallback;
import com.yy.mediaframework.stat.UploadStatManager;
import com.yy.mediaframework.utils.YMFLog;
import com.yy.mediaframework.watermark.WaterMark;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class CameraSurfaceView
extends SurfaceView
implements SurfaceHolder.Callback,
IMediaCodecUpload,
CameraListener,
GetAnchorStatInfoInterface.IGetCurrentCameraEncodeStatInfo,
GetAnchorStatInfoInterface.IGetImageFilterInfo {
    private static final String TAG = "CameraSurfaceView";
    private VideoLiveSession mLiveSession;
    private FilterType mFilterType = FilterType.Normal;
    private Map<String, String> mFilterParams = null;
    private boolean mEncoderEnabled = false;
    private VideoEncoderConfig mEncoderConfig = null;
    private IEncoderListener mEncoderListener;
    private WaterMark mWaterMark;
    private IDynamicTexture mDynamicTexture;
    private Background mBackground;
    private List<ResolutionModifyConfig> mResolutionModifyConfigs;
    private int mResolutionModifyInterval;
    public Context mContext;
    public CameraInterface.CameraResolutionMode mResMode;
    public YYUserLiveConfig mUserLiveConfig = new YYUserLiveConfig();
    private float mThinFaceParam;
    private float mStickerEffectParam;
    private float mBeautyIntensity;
    private String mStickerEffectPath = null;
    private String mStickerLutEffect = null;
    private String mStickerEffect = null;
    private String mGiftEffectPath = null;
    private String mFilterEffectPath = null;
    private String mWitnessFilterPath = null;
    private String mBeauty5EffectPath = null;
    private String mSearchingPortraitEffectPath = null;
    private String mLockingPortraitEffectPath = null;
    private String mLockedPortraitEffectPath = null;
    private String mSearchingLandScapeEffectPath = null;
    private String mLockingLandScapeEffectPath = null;
    private String mLockedLandScapeEffectPath = null;
    private String m3dArEffectPath = null;
    private String mArJoyPKEffect = null;
    private int mArJoyPKIndex;
    private String mArJoyPKTag = null;
    private long mDeltaPts = 0L;
    private boolean mIsFadeOutEffect = false;
    private PreviewFrameCallback mPreviewCallback;
    private boolean mLiveSessionAutoMode = true;
    private boolean onDualCameraOpened = false;
    private boolean mHardwareEncoderAvailable = false;
    private boolean mEnableColorChartLive = false;
    DecodeVideoConfig mPeripheralsVideoConfig;
    DecodeVideoConfig mOutdoorVideoConfig;
    VideoRenderPosition mCameraPostion;
    VideoRenderPosition mPeripheralsPosition;
    private boolean mEnableMirror = false;
    private boolean mIsNeedLimitFaceNum = false;
    private boolean mIsGifFadeOutEffect = false;
    private float mFaceLigtVal;
    private Map<Integer, Float> mFaceLiftValue = new HashMap<Integer, Float>();
    ExternalInterface.IExternalCameraData mIExternalCameraData;
    ExternalInterface.IExternalDecode mIExternalDecode;
    private boolean mPnasFlagOn = false;
    private int mPnasPeriod = 20000;
    private String[] mVenusModelPath = null;
    private IGPUProcess mGPUImageProcess;
    private boolean bEnableFaceDetected = false;

    public CameraSurfaceView(Context context) {
        this(context, null);
    }

    public CameraSurfaceView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context.getApplicationContext();
        this.init();
    }

    private void init() {
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
        CameraInterface.getInstance().setCameraListener(this);
    }

    public void onResume() {
        this.setKeepScreenOn(true);
    }

    @Override
    public void reSetEncodingState() {
    }

    public void onPause() {
        this.setKeepScreenOn(false);
    }

    public void setSurfaceSizeChange(int w, int h) {
        YMFLog.info(this, "[Preview ]", "setSurfaceSizeChange:" + w + "*" + h);
        if (this.mLiveSession != null) {
            this.mLiveSession.setSurfaceChanged(w, h);
        }
    }

    public void setLiveSessionAutoMode(boolean enable) {
        this.mLiveSessionAutoMode = enable;
    }

    public void destroyLiveSession() {
        UploadStatManager.getInstance().setIGetCurrentCameraStatInfo(null);
        UploadStatManager.getInstance().setIGetImageFilterInfo(null);
        YMFLog.info(this, "[Preview ]", "stopLiveSession");
        if (this.mLiveSession != null) {
            if (this.getHolder() != null) {
                this.notifySurfaceDestroyed(this.getHolder());
            }
            this.mLiveSession.stopAndRelease();
            this.mLiveSession = null;
        }
    }

    public void setupLiveSession() {
        UploadStatManager.getInstance().setIGetCurrentCameraStatInfo(this);
        UploadStatManager.getInstance().setIGetImageFilterInfo(this);
        YMFLog.info(this, "[Preview ]", "setupLiveSession");
        if (this.mLiveSession != null) {
            this.destroyLiveSession();
        }
        this.mLiveSession = new VideoLiveSession(this.mContext);
        if (CameraInterface.getInstance().isCameraOpened() && CameraInterface.getInstance().getPreviewSize() != null) {
            this.mResMode = CameraInterface.getInstance().getResolutionMode();
            this.mLiveSession.startPreview(CameraInterface.getInstance().getPreviewSize().width, CameraInterface.getInstance().getPreviewSize().height, CameraInterface.getInstance().getAndroidCameraFacing(), this.mResMode);
        }
        if (this.getHolder() != null) {
            this.notifySurfaceCreate(this.getHolder());
        }
        this.mLiveSession.setFilterInfo(this.mFilterType, this.mFilterParams);
        this.mLiveSession.setEncoderListener(this.mEncoderListener);
        this.mLiveSession.setWaterMark(this.mWaterMark);
        this.mLiveSession.setBackground(this.mBackground);
        this.mLiveSession.setDynamicTexture(this.mDynamicTexture);
        this.mLiveSession.setResolutionModifyConfigs(this.mResolutionModifyConfigs, this.mResolutionModifyInterval);
        this.mLiveSession.setDeltaYYPtsMillions(this.mDeltaPts);
        this.mLiveSession.setExternalDecodeInterface(this.mIExternalDecode);
        this.mLiveSession.setExternalCameraDataCallback(this.mIExternalCameraData);
        if (this.mGPUImageProcess != null) {
            this.mLiveSession.setGPUImageBeautyFilter(this.mGPUImageProcess);
        }
        if (this.m3dArEffectPath != null) {
            this.mLiveSession.startRvSensor();
        }
        if (this.mEncoderConfig != null) {
            this.mLiveSession.setEncoderConfig(this.mEncoderConfig);
            this.mLiveSession.setLowDelayMode(this.mEncoderConfig.mLowDelay);
        }
        if (this.mUserLiveConfig != null) {
            this.mLiveSession.setUserLiveConfig(this.mUserLiveConfig);
        }
        if (this.mEncoderEnabled) {
            this.mLiveSession.startEncoder();
        }
        this.mLiveSession.onDualOpen(this.onDualCameraOpened);
        this.mLiveSession.setHardwareEncoderAvailable(this.mHardwareEncoderAvailable);
        this.mLiveSession.enableColorChartLive(this.mEnableColorChartLive);
        this.mLiveSession.enableMirror(this.mEnableMirror);
        if (this.mPeripheralsVideoConfig != null) {
            this.mLiveSession.onPeripheralsVideoConfigReceived(this.mPeripheralsVideoConfig);
        }
        if (this.mOutdoorVideoConfig != null) {
            this.mLiveSession.onOutdoorVideoConfigReceived(this.mOutdoorVideoConfig);
        }
        if (this.mCameraPostion != null) {
            this.mLiveSession.setVideoRenderPostion(this.mCameraPostion);
        }
        if (this.mPeripheralsPosition != null) {
            this.mLiveSession.setVideoRenderPostion(this.mPeripheralsPosition);
        }
        if (this.mPnasFlagOn) {
            this.mLiveSession.setExtraPerformance(Constant.ExtraPerformance.PsnrMode, this.mPnasFlagOn, this.mPnasPeriod);
        }
    }

    private void fakeBackground() {
        if (this.mBackground == null) {
            this.mBackground = new Background(null, 960, 544, 0, 0, Background.Align.FullScreen);
        }
    }

    public void surfaceCreated(SurfaceHolder holder) {
        YMFLog.info(this, "[Preview ]", "surfaceCreated");
        if (this.mLiveSessionAutoMode) {
            this.setupLiveSession();
        }
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        YMFLog.info(this, "[Preview ]", "surfaceChanged format:" + format + ", width:" + width + ", height:" + height);
        this.notifySurfaceChanged(holder, format, width, height);
        CameraInterface.getInstance().setSurfaceViewSize(width, height);
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        if (this.mLiveSession != null && this.mLiveSession.mFilterContext != null) {
            this.mLiveSession.mFilterContext.mSurfaceDestoryStateLock.lock();
            this.mLiveSession.mFilterContext.mSurfaceDestoryState.set(true);
            this.mLiveSession.mFilterContext.mSurfaceDestoryStateLock.unlock();
        }
        YMFLog.info(this, "[Preview ]", "surfaceDestroyed");
        this.destroyLiveSession();
    }

    public void onTouch(MotionEvent event) {
        YYCamera.getInstance().handleFocusMetering(event);
    }

    @Override
    public void startEncoder() {
        this.mEncoderEnabled = true;
        if (this.mLiveSession != null) {
            this.mLiveSession.startEncoder();
        }
    }

    @Override
    public void stopEncoder() {
        this.mEncoderEnabled = false;
        if (this.mLiveSession != null) {
            this.mLiveSession.stopEncoder();
        }
    }

    public void setUserLiveConfig(YYUserLiveConfig userConfig) {
        this.mUserLiveConfig.assign(userConfig);
        if (this.mLiveSession != null) {
            this.mLiveSession.setUserLiveConfig(this.mUserLiveConfig);
        }
    }

    @Override
    public void setEncoderConfig(VideoEncoderConfig config) {
        YMFLog.info(this, "[Encoder ]", "setEncoderConfig:" + config);
        this.mEncoderConfig = config;
        if (this.mLiveSession != null) {
            this.mLiveSession.setEncoderConfig(config);
        }
    }

    @Override
    public void setEncoderListener(IEncoderListener listener) {
        YMFLog.info(this, "[Encoder ]", "setEncoderListener:" + listener);
        this.mEncoderListener = listener;
        if (this.mLiveSession != null) {
            this.mLiveSession.setEncoderListener(this.mEncoderListener);
        }
    }

    @Override
    public void setBackground(Background background) {
        this.mBackground = background;
        if (this.mLiveSession != null) {
            this.mLiveSession.setBackground(background);
        }
    }

    @Override
    public void onPeripheralsVideoDataReceived(DecodeVideoSample sample) {
        if (this.mLiveSession == null) {
            YMFLog.error((Object)this, "[Decoder ]", "onPeripheralsVideoDataReceived:invalid VideoLiveSession");
            return;
        }
        this.mLiveSession.onPeripheralsVideoDataReceived(sample);
    }

    @Override
    public void onPeripheralsVideoConfigReceived(DecodeVideoConfig config) {
        this.mPeripheralsVideoConfig = config;
        if (this.mLiveSession == null) {
            YMFLog.error((Object)this, "[Decoder ]", "onPeripheralsVideoConfigReceived:invalid VideoLiveSession");
            return;
        }
        this.mLiveSession.onPeripheralsVideoConfigReceived(config);
    }

    @Override
    public void setVideoRenderPosition(VideoRenderPosition position) {
        if (position == null) {
            YMFLog.error((Object)this, "[Decoder ]", "invalid VideoRenderPositon, return");
            return;
        }
        if (position.channalId < 1000) {
            this.mCameraPostion = position;
        } else if (position.channalId > 1000) {
            this.mPeripheralsPosition = position;
        }
        if (this.mLiveSession == null) {
            YMFLog.error((Object)this, "[Decoder ]", "onPeripheralsVideoConfigReceived:invalid VideoLiveSession");
            return;
        }
        this.mLiveSession.setVideoRenderPostion(position);
    }

    @Override
    public void onPeripheralsVideoEnd() {
        if (this.mLiveSession == null) {
            YMFLog.error((Object)this, "[Decoder ]", "onPeripheralsVideoConfigReceived:invalid VideoLiveSession");
            return;
        }
        this.mLiveSession.onPeripheralsVideoEnd();
    }

    @Override
    public void setWaterMark(WaterMark waterMark) {
        this.mWaterMark = waterMark;
        if (this.mLiveSession != null) {
            this.mLiveSession.setWaterMark(this.mWaterMark);
        }
    }

    @Override
    public void setDynamicTexture(IDynamicTexture dynamicTexture) {
        this.mDynamicTexture = dynamicTexture;
        if (this.mLiveSession != null) {
            this.mLiveSession.setDynamicTexture(this.mDynamicTexture);
        }
    }

    public IDynamicTexture getDynamicTexture() {
        return this.mDynamicTexture;
    }

    @Override
    public void takeScreenShot(ScreenShotCallback callback) {
        if (this.mLiveSession != null) {
            this.mLiveSession.takeScreenShot(callback);
        }
    }

    @Override
    public void setNetworkBitrateSuggest(int bitrate) {
        if (this.mLiveSession != null) {
            YMFLog.info(this, "[Encoder ]", "setNetworkBitrateSuggest outside:" + bitrate);
            this.mLiveSession.setNetworkBitrateSuggest(bitrate);
        }
    }

    public void setLowDelayMode(boolean enable) {
        this.mEncoderConfig.mLowDelay = enable;
        if (this.mLiveSession != null) {
            this.mLiveSession.setLowDelayMode(enable);
        }
    }

    @Override
    public void notifyCameraPreviewParameter(int width, int height, int facing, CameraInterface.CameraResolutionMode resMode) {
        CameraInterface.CameraResolutionMode mResMode = resMode;
        YMFLog.info(this, "[Preview ]", "notifyCameraPreviewParameter, width:" + width + " height:" + height + " facing:" + facing);
        if (this.mLiveSession != null) {
            this.mLiveSession.startPreview(width, height, facing, mResMode);
        }
    }

    @Override
    public void notifyCameraOpenSuccess() {
    }

    @Override
    public void notifyCameraOpenFail(String reason) {
    }

    @Override
    public void onDualOpen(boolean flag) {
        this.onDualCameraOpened = flag;
        if (this.mLiveSession != null) {
            this.mLiveSession.onDualOpen(flag);
        }
    }

    @Override
    public void onDualPictureSwitch() {
        if (this.mLiveSession != null) {
            this.mLiveSession.onDualPictureSwitch();
        }
    }

    public void setFilterInfo(FilterType filterType, Map<String, String> params) {
        this.mFilterType = filterType;
        this.mFilterParams = params;
        if (this.mLiveSession != null) {
            this.mLiveSession.setFilterInfo(filterType, this.mFilterParams);
        }
    }

    public void setFilterType(FilterType filterType) {
        this.mFilterType = filterType;
        if (this.mLiveSession != null) {
            this.mLiveSession.setFilterType(this.mFilterType);
        }
    }

    public FilterType getFilterType() {
        return this.mFilterType;
    }

    public void setResolutionModifyConfigs(List<ResolutionModifyConfig> configs, int intervalSecs) {
        this.mResolutionModifyConfigs = configs;
        this.mResolutionModifyInterval = intervalSecs;
        if (this.mLiveSession != null) {
            this.mLiveSession.setResolutionModifyConfigs(this.mResolutionModifyConfigs, this.mResolutionModifyInterval);
        }
    }

    public void requestEncodeIFrame() {
        if (this.mLiveSession != null) {
            this.mLiveSession.requestIFrame();
        }
    }

    private void notifySurfaceCreate(SurfaceHolder holder) {
        if (this.mLiveSession != null) {
            this.mLiveSession.onSurfaceInfoEvent(1, EglFactory.newSurfaceInfo(holder, 0, 0));
        }
    }

    private void notifySurfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        if (this.mLiveSession != null) {
            YMFLog.info(this, "[Preview ]", String.format(Locale.getDefault() + "notifySurfaceChanged width:%d, height:%d", width, height));
            this.mLiveSession.onSurfaceInfoEvent(2, EglFactory.newSurfaceInfo(holder, width, height));
        }
    }

    private void notifySurfaceDestroyed(SurfaceHolder holder) {
        if (this.mLiveSession != null) {
            this.mLiveSession.onSurfaceInfoEvent(3, null);
        }
    }

    public void setHardwareEncoderAvailable(boolean available) {
        if (this.mLiveSession != null) {
            this.mLiveSession.setHardwareEncoderAvailable(available);
        }
        this.mHardwareEncoderAvailable = available;
        YMFLog.info(this, "[Encoder ]", "setHardwareEncoderAvailable:" + this.mHardwareEncoderAvailable);
    }

    public void enableColorChartLive(boolean enable) {
        YMFLog.info(this, "[Encoder ]", "enableColorChartLive:" + enable);
        if (this.mLiveSession != null) {
            this.mLiveSession.enableColorChartLive(enable);
        }
        this.mEnableColorChartLive = enable;
    }

    public void enableMirror(boolean enable) {
        YMFLog.info(this, "[Encoder ]", "enableEncodeMirror:" + enable);
        if (this.mLiveSession != null) {
            this.mLiveSession.enableMirror(enable);
        }
        this.mEnableMirror = enable;
    }

    @Override
    public int onGetAnchorCurrentBitRate() {
        int bitRate = 0;
        if (this.mEncoderConfig != null) {
            bitRate = this.mEncoderConfig.getBitRate();
        }
        return bitRate;
    }

    @Override
    public int onGetAnchorCurrentFrameRate() {
        int frameRate = 0;
        if (this.mEncoderConfig != null) {
            frameRate = this.mEncoderConfig.getFrameRate();
        }
        return frameRate;
    }

    @Override
    public String onGetAnchorCurrentDIPRate() {
        String realDPI = "";
        if (this.mEncoderConfig != null) {
            realDPI = this.mEncoderConfig.getRealDPI();
        }
        return realDPI;
    }

    @Override
    public boolean onGetHasBeauty() {
        return this.isUse(this.mBeautyIntensity);
    }

    @Override
    public boolean onGetHasFaceLift() {
        return this.isUse(this.mThinFaceParam);
    }

    @Override
    public float onGetBeautyLevel() {
        return this.mBeautyIntensity;
    }

    @Override
    public float onGetFaceLiftLevel() {
        return this.mThinFaceParam;
    }

    @Override
    public boolean onGetHasSticker() {
        boolean mIsUseSticker = false;
        if (this.mStickerEffectPath != null && !this.mStickerEffectPath.equals("")) {
            mIsUseSticker = true;
        }
        return mIsUseSticker;
    }

    @Override
    public boolean onGetHasDynamicSticker() {
        boolean mIsUseDynamicSticker = false;
        if (this.mDynamicTexture != null) {
            mIsUseDynamicSticker = true;
        }
        return mIsUseDynamicSticker;
    }

    private boolean isUse(float val) {
        boolean isUse = false;
        if (val > 1.0E-5f) {
            isUse = true;
        }
        return isUse;
    }

    public void setDeltaYYPtsMillions(long deltaPts) {
        YMFLog.info(this, "[Encoder ]", "setDeltaYYPtsMillions:" + deltaPts);
        this.mDeltaPts = deltaPts;
        if (this.mLiveSession != null) {
            this.mLiveSession.setDeltaYYPtsMillions(deltaPts);
        }
    }

    @Override
    public void setExternalVideoInterface(ExternalInterface.IExternalCameraData IExternalCameraData2) {
        this.mIExternalCameraData = IExternalCameraData2;
        if (this.mLiveSession != null) {
            this.mLiveSession.setExternalCameraDataCallback(this.mIExternalCameraData);
        }
    }

    @Override
    public void pushEncodeExternalData(ExternalYYMediaSample externalYYMediaSample) {
        if (this.mLiveSession != null) {
            YYMediaSample sample = null;
            Object object = externalYYMediaSample.mSample;
            if (object instanceof YYMediaSample) {
                sample = (YYMediaSample)object;
                sample.mMasterTextureId = externalYYMediaSample.mMasterTextureId;
                sample.mYYPtsMillions = externalYYMediaSample.mPts;
            }
            this.mLiveSession.startEncodeExternalData(sample);
        }
    }

    @Override
    public void setExternalDecodeInterface(ExternalInterface.IExternalDecode IExternalDecode2) {
        this.mIExternalDecode = IExternalDecode2;
        if (this.mLiveSession != null) {
            this.mLiveSession.setExternalDecodeInterface(this.mIExternalDecode);
        }
    }

    @Override
    public void pushExternalVideoDecodeInfo(ExternalDecodeInfo decodeInfo) {
        if (this.mLiveSession == null || decodeInfo == null) {
            YMFLog.error((Object)this, "[Decoder ]", "invalid VideoLiveSession or sample is null");
            return;
        }
        this.mLiveSession.onOutdoorVideoConfigReceived(decodeInfo.convertToConfig());
        this.mLiveSession.onOutdoorVideoDataReceived(decodeInfo.convertToStreamInfo());
    }

    @Override
    public void onExternalVideoEnd() {
        if (this.mLiveSession == null) {
            YMFLog.error((Object)this, "[Decoder ]", "invalid VideoLiveSession");
            return;
        }
        this.mLiveSession.onExternalVideoEnd();
    }

    @Override
    public void setGLManagerRunnable(Runnable runnable) {
        if (this.mLiveSession != null) {
            this.mLiveSession.setGLManagerRunnable(runnable);
        }
    }

    public void setExtraPerformance(Constant.ExtraPerformance extraPerformance, Boolean on, int value) {
        if (extraPerformance == Constant.ExtraPerformance.PsnrMode) {
            this.mPnasFlagOn = on;
            int n = this.mPnasPeriod = value > 5000 ? value : 20000;
        }
        if (this.mLiveSession != null) {
            this.mLiveSession.setExtraPerformance(extraPerformance, on, value);
        } else {
            YMFLog.warn(this, "[Encoder ]", "setExtraPerformance  mLiveSession == null");
        }
    }

    public void setGPUImageBeautyFilter(IGPUProcess gpuImageProcess) {
        this.mGPUImageProcess = gpuImageProcess;
        if (this.mLiveSession != null) {
            this.mLiveSession.setGPUImageBeautyFilter(gpuImageProcess);
        } else {
            YMFLog.error((Object)this, "[Beauty  ]", "setGPUImageBeautyFilter failed");
        }
    }

    public void addPreviewFrameCallback(PreviewFrameCallback callback) {
        if (this.mLiveSession != null) {
            this.mLiveSession.registerPreviewCallback(callback);
        }
    }

    public void removePreviewFrameCallback(PreviewFrameCallback callback) {
        if (this.mLiveSession != null) {
            this.mLiveSession.unregisterPreviewCallback(callback);
        }
    }
}

