//
//  AudioRecordTool.h
//  audio_engine
//
//  Created by JFChen on 2018/8/14.
//

#import <Foundation/Foundation.h>

typedef NS_ENUM(int,RecordToolCodecType){
    RecordToolCodecTypeUnknown  = -1,
    RecordToolCodecTypeSilk     = 0,
    RecordToolCodecTypeSpeex    = 1,
    RecordToolCodecTypeEaacPlus = 2,
    RecordToolCodecTypeLcAAC    = 3,
    RecordToolCodecTypeWav      = 4
};



@protocol AudioRecordToolDelegate<NSObject>

@optional
- (void)accompanyPlayEnd;
- (void)accompanyPlayVolume:(uint32_t)volume curTime:(uint32_t)curTime;
- (void)voiceRecordVolume:(uint32_t)volume curTime:(uint32_t)curTime;
@end

@interface AudioRecordTool : NSObject
@property (nonatomic) id<AudioRecordToolDelegate> delegate;

/**
 * accompanyPath 伴奏mp3文件路径
 */
- (instancetype)initWithAccompanyPath:(NSString *)accompanyPath;

- (BOOL)startPlayAccompany;
- (BOOL)changeAccompany:(NSString *)accompanyPath;
- (void)pauseAccompany;
- (void)resumeAccompany;
- (void)stopAccompany;
- (void)seekAccompany:(uint32_t)pos;
/*
 * 默认输出wav文件，路径是 tmp/audioRecordCache.wav
 */
- (BOOL)startRecord;

/*
 *	type:编码类型 例如：RecordToolCodecEaacPlus
 *	filePath:输出文件 例如：xxx.aac
 */
- (BOOL)startRecord:(RecordToolCodecType)type saveFilePath:(NSString *)filePath;

- (void)pauseRecord;
- (void)resumeRecord;
- (void)stopRecord;

/**
 * 耳返开关
 */
- (void)enablePlayBack:(BOOL)enable;

/**
 * Set Volume
 * volume: 0 ~ 100, default is 100
 */
- (void)SetVoiceVolume:(int)volume;
- (void)SetAccompanyVolume:(int)volume;


/** option
 * 录制过程中会生成wav的声音文件，和wav的伴奏文件。可以设置路径存放。也可以不设置，使用默认的路径
 */
- (void)setVoiceFilePath:(NSString *)audioPath;
- (void)setAcmpyWavPath:(NSString *)accmpOutPath;
+ (NSString *)voiceDefaultPath;
+ (NSString *)acmpyWavDefaultPath;

@end
