//
//  AudioFilePlayer.h
//  test
//
//  Created by JFChen on 2018/6/12.
//  Copyright © 2018年 yy. All rights reserved.
//

#import <Foundation/Foundation.h>

@protocol AudioFilePlayerDelegate<NSObject>
- (void)playBackEnd;
- (void)playBackProgress:(uint32_t)curTime totalTime:(uint32_t)totalTime;
@end

@interface AudioFilePlayer : NSObject

@property(nonatomic) id<AudioFilePlayerDelegate> playerDelegate;

+ (void)InitEnv;
+ (void)DeInitEnv;

- (void)openWithAudioFile:(NSString *)audioFile;

- (void)play;
- (void)pause;
- (void)resume;
- (void)stop;

- (uint32_t)getPlayTotalLenMS;
- (void)seekTo:(uint32_t)timeMS;
- (uint32_t)getCurrentPlayTimeMS;
- (void)setPlayerVolume:(uint32_t)volume;

- (void)enableEffect:(bool)enable;
- (void)enableReverbEx:(bool)enable;
- (void)enableEqualizerEx:(bool)enable;
- (void)enableCompressor:(bool)enable;

- (void)SetReverbParamEx:(NSArray *)settingDic;
- (void)SetEqGains:(NSArray *)settingDic;
- (void)SetCompressorParam:(NSArray *)settingDic;
@end
