//
//  AudioFileMixer.h
//  audio_engine
//
//  Created by JFChen on 2018/8/14.
//

#import <Foundation/Foundation.h>

@protocol AudioFileMixerDelegate<NSObject>
- (void)playBackEnd;
- (void)playBackProgress:(uint32_t)curTime totalTime:(uint32_t)totalTime;

- (void)fileMixerProgress:(uint32_t)curTime totalTime:(uint32_t)totalTime;
- (void)finishMixer;
@end

@interface AudioFileMixer : NSObject
@property (nonatomic) id<AudioFileMixerDelegate> delegate;

/**
 * aacOutPath 最终生成的 aac文件存放路径。
 */
- (instancetype)initWithOutputAACPath:(NSString *)aacOutPath;

- (BOOL)startPlay;
- (void)pausePlay;
- (void)resumePlay;
- (void)stopPlay;

- (BOOL)startMixVoice;
- (void)StopMix;

/**
 * Set Volume
 * volume: 0 ~ 100, default is 100
 */
- (void)SetVoiceVolume:(int)volume;
- (void)SetAccompanyVolume:(int)volume;


/** option
 * 录制过程中会生成wav的声音文件，和wav的伴奏文件。可以设置路径存放。也可以不设置，使用默认的路径
 */
- (void)setVoiceFilePath:(NSString *)voicePath;
- (void)setAccompanyFilePath:(NSString *)acmpFilePath;

@end
