//
//  AudioFileEncoder.h
//
//  Created by YY on 2019/01/08.
//  Copyright © 2019年 yy. All rights reserved.
//

#import <Foundation/Foundation.h>

typedef NS_ENUM(NSInteger, YYAudioFileEncodeType)
{
    YYAudioFileEncodeTypeWAV,
    YYAudioFileEncodeTypeAAC,
};

@interface YYAudioFileEncoder : NSObject

- (instancetype)initWithAudioFile:(NSString *)audioFile type:(YYAudioFileEncodeType)type sampleRate:(UInt32)sampleRate channelCount:(UInt32)channelCount bitRate:(UInt32)bitRate;
- (BOOL)prepare;
- (UInt32)write:(void *)data len:(UInt32)len;

@end
