//
//  AudioFileDecoder.h
//
//  Created by YY on 2019/01/08.
//  Copyright © 2019年 yy. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface YYAudioFileDecoder : NSObject

- (instancetype)initWithAudioFile:(NSString *)audioFile;
- (BOOL)prepare;
- (UInt32)totalLenMS;
- (UInt32)sampleRate;
- (UInt32)channelCount;
- (UInt32)currentPositionMS;
- (void)seekTo:(UInt32)timeMS;

/*@
 @brief read
 @param buffer: pcm data buffer
 @param len : len to read
 @return : The data available length, 0 when EOF
 */
- (UInt32)readDataOfLength:(void *)buffer len:(UInt32)len;

@end
