/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.audioengine;

import android.app.ActivityManager;
import android.content.Context;
import android.media.AudioManager;
import android.media.AudioRecord;
import android.media.audiofx.AcousticEchoCanceler;
import android.os.Build;
import android.os.Process;
import android.os.SystemClock;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.webrtc.audioengine.AudioManagerAndroid;

class WebRtcAudioRecord {
    private static final boolean DEBUG = false;
    private static final String TAG = "[AudioRecord]";
    private static final int SAMPLE_RATE_HZ = 44100;
    private static final int BITS_PER_SAMPLE = 16;
    private static final int CALLBACK_BUFFER_SIZE_MS = 10;
    private static final int BUFFERS_PER_SECOND = 100;
    private static final int BUFFER_SIZE_FACTOR = 2;
    private ByteBuffer byteBuffer;
    private int bytesPerBuffer;
    private int framesPerBuffer;
    private int sampleRate;
    private int channelCount;
    private final long nativeAudioRecord;
    private final AudioManager audioManager;
    private final ActivityManager activityManager;
    private final Context context;
    private AudioRecord audioRecord = null;
    private AudioRecordThread audioThread = null;
    private AcousticEchoCanceler aec = null;
    private boolean useBuiltInAEC = false;
    private final Set<Long> threadIds = new HashSet<Long>();

    private static boolean runningOnJellyBeanOrHigher() {
        return Build.VERSION.SDK_INT >= 16;
    }

    private static boolean runningOnJellyBeanMR1OrHigher() {
        return Build.VERSION.SDK_INT >= 17;
    }

    private boolean hasRecPermission(Context context, String permission2) {
        return context.checkPermission(permission2, Process.myPid(), Process.myUid()) == 0;
    }

    private void printCurrentThreadName() {
        List infos = this.activityManager.getRunningAppProcesses();
        this.doLog("Begin Print Current Thread Name=====================================");
        try {
            for (ActivityManager.RunningAppProcessInfo info : infos) {
                String name = info.processName;
                this.doLog("Current App Process Name:" + name);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.doLog("End Print Current Thread Name=======================================");
    }

    WebRtcAudioRecord(Context context, long nativeAudioRecord) {
        this.context = context;
        this.nativeAudioRecord = nativeAudioRecord;
        this.audioManager = (AudioManager)context.getSystemService("audio");
        this.activityManager = (ActivityManager)context.getSystemService("activity");
        this.sampleRate = 0;
        this.bytesPerBuffer = 0;
        this.framesPerBuffer = 0;
    }

    private int getNativeSampleRate() {
        if (!WebRtcAudioRecord.runningOnJellyBeanMR1OrHigher()) {
            return 44100;
        }
        String sampleRateString = this.audioManager.getProperty("android.media.property.OUTPUT_SAMPLE_RATE");
        return sampleRateString == null ? 44100 : Integer.parseInt(sampleRateString);
    }

    public static boolean builtInAECIsAvailable() {
        if (!WebRtcAudioRecord.runningOnJellyBeanOrHigher()) {
            return false;
        }
        return AcousticEchoCanceler.isAvailable();
    }

    private boolean enableBuiltInAEC(boolean enable) {
        this.doLog("EnableBuiltInAEC(" + enable + ')');
        if (!WebRtcAudioRecord.runningOnJellyBeanOrHigher()) {
            return false;
        }
        this.useBuiltInAEC = enable;
        if (this.aec != null) {
            int ret = this.aec.setEnabled(enable);
            if (ret != 0) {
                this.doLogErr("AcousticEchoCanceler.setEnabled failed");
                return false;
            }
            this.doLog("AcousticEchoCanceler.getEnabled: " + this.aec.getEnabled());
        }
        return true;
    }

    private int initRecording(int sampleRate, int recordStreamType) {
        int channelMode;
        if (recordStreamType == 256) {
            this.channelCount = 2;
            channelMode = 12;
        } else {
            this.channelCount = 1;
            channelMode = 16;
        }
        int bytesPerFrame = this.channelCount * 2;
        this.bytesPerBuffer = bytesPerFrame * (sampleRate / 100);
        this.framesPerBuffer = sampleRate / 100;
        this.byteBuffer = ByteBuffer.allocateDirect(this.bytesPerBuffer);
        this.nativeCacheDirectBufferAddress(this.byteBuffer, this.nativeAudioRecord);
        int minBufferSize = AudioRecord.getMinBufferSize((int)sampleRate, (int)channelMode, (int)2);
        try {
            if (this.audioRecord != null) {
                this.audioRecord.stop();
                this.audioRecord.release();
                this.audioRecord = null;
            }
        }
        catch (Exception ex) {
            this.doLogErr("InitRecording audioRecord stop and release fail: " + ex.getMessage());
        }
        int bufferSizeInBytes = Math.max(this.byteBuffer.capacity(), 2 * minBufferSize);
        int audioSource = recordStreamType;
        this.doLog("InitRecording, sampleRate:" + sampleRate + ", bufferSizeInBytes: " + bufferSizeInBytes + ", capacity: " + this.byteBuffer.capacity() + ", minBufferSize: " + minBufferSize + " ,audioSource: " + audioSource);
        if (audioSource == 256) {
            audioSource = 1;
        }
        try {
            this.audioRecord = new AudioRecord(audioSource, sampleRate, channelMode, 2, bufferSizeInBytes);
        }
        catch (IllegalArgumentException e) {
            this.doLogErr("AudioRecord parameter error, " + e.getMessage());
            return -1;
        }
        if (this.audioRecord.getState() != 1) {
            this.doLogErr("AudioRecord can not initialized");
            return -1;
        }
        this.doLog("AudioRecordJava: audio format: " + this.audioRecord.getAudioFormat() + ", channels: " + this.audioRecord.getChannelCount() + ", sample rate: " + this.audioRecord.getSampleRate() + ", audio source: " + audioSource);
        return this.framesPerBuffer;
    }

    private boolean startRecording() {
        this.doLog("StartRecording");
        if (this.audioRecord == null) {
            this.doLogErr("start() called before init()");
            return false;
        }
        if (this.audioThread != null) {
            this.doLogErr("start() was already called");
            return false;
        }
        this.audioThread = new AudioRecordThread("YY_Aud_Record_Java");
        this.audioThread.start();
        this.doLog("Create a Thread name:YY_Aud_Record_Java");
        return true;
    }

    private boolean stopRecording() {
        this.doLog("StopRecording...begin");
        if (this.audioThread == null) {
            this.doLogErr("start() was never called, or stop() was already called");
            return false;
        }
        this.audioThread.joinThread();
        this.audioThread = null;
        if (this.aec != null) {
            this.aec.release();
            this.aec = null;
        }
        try {
            if (this.audioRecord != null) {
                this.audioRecord.stop();
                this.audioRecord.release();
                this.audioRecord = null;
            }
        }
        catch (Exception ex) {
            this.doLogErr("StopRecording audioRecord stop and release fail: " + ex.getMessage());
        }
        this.doLog("StopRecording...end");
        this.nativeDataIsRecorded(-6, this.nativeAudioRecord);
        return true;
    }

    private void doLog(String msg) {
        AudioManagerAndroid.doLog(TAG + msg);
    }

    private void doLogErr(String msg) {
        AudioManagerAndroid.doLog("[AudioRecord][Error]" + msg);
    }

    private static String getThreadInfo() {
        return "@[name=" + Thread.currentThread().getName() + ", id=" + Thread.currentThread().getId() + "]";
    }

    private static void assertIsTrue(boolean condition) {
        if (!condition) {
            throw new AssertionError((Object)"Expected condition to be true");
        }
    }

    private void addThreadId() {
        this.threadIds.add(Thread.currentThread().getId());
        this.doLog("addThreadId threadIds: " + this.threadIds + " (#threads=" + this.threadIds.size() + ")");
    }

    private void removeThreadId() {
        this.threadIds.remove(Thread.currentThread().getId());
        this.doLog("removeThreadId threadIds: " + this.threadIds + " (#threads=" + this.threadIds.size() + ")");
    }

    private native void nativeCacheDirectBufferAddress(ByteBuffer var1, long var2);

    private native void nativeDataIsRecorded(int var1, long var2);

    private native long nativeGetTickCount();

    private class AudioRecordThread
    extends Thread {
        private volatile boolean keepAlive;

        public AudioRecordThread(String name) {
            super(name);
            this.keepAlive = true;
        }

        @Override
        public void run() {
            boolean isRecording;
            Process.setThreadPriority((int)-19);
            WebRtcAudioRecord.this.doLog("AudioRecordThread" + WebRtcAudioRecord.getThreadInfo());
            if (!WebRtcAudioRecord.this.hasRecPermission(WebRtcAudioRecord.this.context, "android.permission.RECORD_AUDIO")) {
                WebRtcAudioRecord.this.nativeDataIsRecorded(-1, WebRtcAudioRecord.this.nativeAudioRecord);
                WebRtcAudioRecord.this.doLog("AudioRecordThread has no rec permission");
                return;
            }
            try {
                WebRtcAudioRecord.this.audioRecord.startRecording();
            }
            catch (Exception e) {
                WebRtcAudioRecord.this.nativeDataIsRecorded(-1, WebRtcAudioRecord.this.nativeAudioRecord);
                WebRtcAudioRecord.this.printCurrentThreadName();
                WebRtcAudioRecord.this.doLogErr("AudioRecord.startRecording failed: " + e.getMessage());
                return;
            }
            boolean bl = isRecording = WebRtcAudioRecord.this.audioRecord.getRecordingState() == 3;
            if (!isRecording) {
                WebRtcAudioRecord.this.nativeDataIsRecorded(-2, WebRtcAudioRecord.this.nativeAudioRecord);
                WebRtcAudioRecord.this.printCurrentThreadName();
            } else {
                WebRtcAudioRecord.this.nativeDataIsRecorded(-100, WebRtcAudioRecord.this.nativeAudioRecord);
            }
            long lastTime = System.nanoTime();
            int readFailCount = 0;
            boolean haveNotifyError = false;
            while (this.keepAlive) {
                int bytesRead = -1;
                try {
                    bytesRead = WebRtcAudioRecord.this.audioRecord.read(WebRtcAudioRecord.this.byteBuffer, WebRtcAudioRecord.this.byteBuffer.capacity());
                }
                catch (Exception ex) {
                    WebRtcAudioRecord.this.doLogErr("AudioRecord.read failed: " + ex.getMessage());
                }
                if (bytesRead == WebRtcAudioRecord.this.byteBuffer.capacity()) {
                    readFailCount = 0;
                    haveNotifyError = false;
                    WebRtcAudioRecord.this.nativeDataIsRecorded(bytesRead, WebRtcAudioRecord.this.nativeAudioRecord);
                    continue;
                }
                if (bytesRead == -3 && isRecording) {
                    WebRtcAudioRecord.this.nativeDataIsRecorded(-3, WebRtcAudioRecord.this.nativeAudioRecord);
                    WebRtcAudioRecord.this.printCurrentThreadName();
                    this.keepAlive = false;
                    break;
                }
                if (!haveNotifyError && ++readFailCount > 3) {
                    haveNotifyError = true;
                    WebRtcAudioRecord.this.nativeDataIsRecorded(-4, WebRtcAudioRecord.this.nativeAudioRecord);
                    WebRtcAudioRecord.this.printCurrentThreadName();
                }
                SystemClock.sleep((long)100L);
            }
            WebRtcAudioRecord.this.removeThreadId();
        }

        public void joinThread() {
            this.keepAlive = false;
            while (this.isAlive()) {
                try {
                    this.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

