/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.audioengine;

import android.annotation.TargetApi;
import android.content.Context;
import android.media.AudioManager;
import android.media.AudioTrack;
import android.os.Build;
import android.os.Process;
import java.nio.ByteBuffer;
import org.webrtc.audioengine.AudioManagerAndroid;

class WebRtcAudioTrack {
    private static final String TAG = "WebRtcAudioTrack";
    private static final int SAMPLE_RATE_HZ = 44100;
    private static final int BITS_PER_SAMPLE = 16;
    private static final int CALLBACK_BUFFER_SIZE_MS = 10;
    private static final int BUFFERS_PER_SECOND = 100;
    private final Context context;
    private final long nativeAudioTrack;
    private final AudioManager audioManager;
    private ByteBuffer byteBuffer;
    private AudioTrack audioTrack = null;
    private AudioTrackThread audioThread = null;
    private int _bufferedPlaySamples = 0;
    private int _sampleRate = 44100;
    private int _channel = 2;
    private int _playPosition = 0;
    final String logTag = "[AudioTrack]";

    WebRtcAudioTrack(Context context, long nativeAudioTrack) {
        this.DoLog("ctor" + WebRtcAudioTrack.getThreadInfo());
        this.context = context;
        this.nativeAudioTrack = nativeAudioTrack;
        this.audioManager = (AudioManager)context.getSystemService("audio");
    }

    private boolean initPlayout(int sampleRate, int channels, int streamType) {
        this.DoLog("initPlayout(sampleRate=" + sampleRate + ", channels=" + channels + ", streamType=" + streamType + ")");
        int channelMode = 4;
        if (channels == 2) {
            channelMode = 12;
        }
        int bytesPerFrame = channels * 2;
        this.byteBuffer = ByteBuffer.allocateDirect(bytesPerFrame * (sampleRate / 100));
        this.DoLog("byteBuffer.capacity: " + this.byteBuffer.capacity());
        this.nativeCacheDirectBufferAddress(this.byteBuffer, this.nativeAudioTrack);
        this._bufferedPlaySamples = 0;
        this._channel = channels;
        this._sampleRate = sampleRate;
        this._playPosition = 0;
        int minBufferSizeInBytes = AudioTrack.getMinBufferSize((int)sampleRate, (int)channelMode, (int)2);
        int blockSize = sampleRate / 100 * bytesPerFrame;
        int playBufSize = minBufferSizeInBytes;
        if (minBufferSizeInBytes % blockSize != 0 && (playBufSize = (minBufferSizeInBytes / blockSize + 1) * blockSize) < blockSize * 10) {
            playBufSize = blockSize * 10;
        }
        try {
            this.audioTrack = new AudioTrack(streamType, sampleRate, channelMode, 2, playBufSize, 1);
        }
        catch (IllegalArgumentException e) {
            this.DoLogErr(e.getMessage());
            return false;
        }
        int bufferMs = (int)(1000.0 * (double)playBufSize / 2.0 / (double)this._channel / (double)sampleRate);
        this.DoLog("AudioTrack.getMinBufferSize: " + minBufferSizeInBytes + ", playBufSize: " + playBufSize + ", bufferMs: " + bufferMs);
        this.nativeSetTrackBufferSizeMs(bufferMs);
        if (this.audioTrack.getState() != 1) {
            this.DoLogErr("Initialization of audio track failed.");
            return false;
        }
        return true;
    }

    private boolean startPlayout() {
        this.DoLog("startPlayout");
        WebRtcAudioTrack.assertTrue(this.audioTrack != null);
        WebRtcAudioTrack.assertTrue(this.audioThread == null);
        if (this.audioTrack.getState() != 1) {
            this.DoLogErr("Audio track is not successfully initialized.");
            return false;
        }
        this.audioThread = new AudioTrackThread("YY_Aud_Track_Java");
        this.audioThread.start();
        this.DoLog("Create a Thread name:YY_Aud_Track_Java");
        return true;
    }

    private boolean stopPlayout() {
        this.DoLog("stopPlayout");
        WebRtcAudioTrack.assertTrue(this.audioThread != null);
        this.audioThread.joinThread();
        this.audioThread = null;
        if (this.audioTrack != null) {
            this.audioTrack.release();
            this.audioTrack = null;
        }
        return true;
    }

    private static void assertTrue(boolean condition) {
        if (!condition) {
            throw new AssertionError((Object)"Expected condition to be true");
        }
    }

    private native void nativeCacheDirectBufferAddress(ByteBuffer var1, long var2);

    private native void nativeGetPlayoutData(int var1, long var2, int var4);

    private native long nativeGetTickCount();

    private native void nativeSetTrackBufferSizeMs(int var1);

    public static boolean runningOnLollipopOrHigher() {
        return Build.VERSION.SDK_INT >= 21;
    }

    private int SetPlayoutSpeaker(boolean loudspeakerOn) {
        if (this.audioManager != null) {
            this.audioManager.setSpeakerphoneOn(loudspeakerOn);
            this.DoLog("[Info][SetPlayoutSpeaker] AudioManager Mode: " + this.audioManager.getMode() + ", loudspeakerOn: " + loudspeakerOn + ", isLoudSpeaker: " + this.audioManager.isSpeakerphoneOn());
        }
        return 0;
    }

    private int SetPlayoutVolume(int level) {
        int retVal = -1;
        if (this.audioManager != null) {
            this.audioManager.setStreamVolume(0, level, 1);
            retVal = 0;
        }
        return retVal;
    }

    private int GetMaxPlayoutVolume() {
        int level = -1;
        if (this.audioManager != null) {
            level = this.audioManager.getStreamMaxVolume(0);
        }
        return level;
    }

    private int GetPlayoutVolume() {
        int level = -1;
        if (this.audioManager != null) {
            level = this.audioManager.getStreamVolume(0);
        }
        return level;
    }

    private void DoLog(String msg) {
        AudioManagerAndroid.DoLog("[AudioTrack]" + msg);
    }

    private void DoLogErr(String msg) {
        AudioManagerAndroid.DoLog("[AudioTrack][Error]" + msg);
    }

    private static String getThreadInfo() {
        return "@[name=" + Thread.currentThread().getName() + ", id=" + Thread.currentThread().getId() + "]";
    }

    private static boolean runningOnJellyBeanOrHigher() {
        return Build.VERSION.SDK_INT >= 16;
    }

    private static boolean runningOnJellyBeanMR1OrHigher() {
        return Build.VERSION.SDK_INT >= 17;
    }

    private int GetNativeSampleRate() {
        if (!WebRtcAudioTrack.runningOnJellyBeanMR1OrHigher()) {
            return 44100;
        }
        String sampleRateString = this.audioManager.getProperty("android.media.property.OUTPUT_SAMPLE_RATE");
        return sampleRateString == null ? 44100 : Integer.parseInt(sampleRateString);
    }

    private class AudioTrackThread
    extends Thread {
        private volatile boolean keepAlive;

        public AudioTrackThread(String name) {
            super(name);
            this.keepAlive = true;
        }

        @Override
        public void run() {
            Process.setThreadPriority((int)-19);
            WebRtcAudioTrack.this.DoLog("AudioTrackThread" + WebRtcAudioTrack.getThreadInfo());
            try {
                WebRtcAudioTrack.this.audioTrack.play();
                WebRtcAudioTrack.assertTrue(WebRtcAudioTrack.this.audioTrack.getPlayState() == 3);
            }
            catch (IllegalStateException e) {
                WebRtcAudioTrack.this.DoLogErr("AudioTrack.play failed: " + e.getMessage());
                return;
            }
            int sizeInBytes = WebRtcAudioTrack.this.byteBuffer.capacity();
            while (this.keepAlive) {
                WebRtcAudioTrack.this.nativeGetPlayoutData(sizeInBytes, WebRtcAudioTrack.this.nativeAudioTrack, WebRtcAudioTrack.this._bufferedPlaySamples);
                WebRtcAudioTrack.assertTrue(sizeInBytes <= WebRtcAudioTrack.this.byteBuffer.remaining());
                int bytesWritten = 0;
                bytesWritten = WebRtcAudioTrack.runningOnLollipopOrHigher() ? this.writeOnLollipop(WebRtcAudioTrack.this.audioTrack, WebRtcAudioTrack.this.byteBuffer, sizeInBytes) : this.writePreLollipop(WebRtcAudioTrack.this.audioTrack, WebRtcAudioTrack.this.byteBuffer, sizeInBytes);
                WebRtcAudioTrack.this._bufferedPlaySamples = WebRtcAudioTrack.this._bufferedPlaySamples + (bytesWritten >> 1);
                int pos = WebRtcAudioTrack.this.audioTrack.getPlaybackHeadPosition() * WebRtcAudioTrack.this._channel;
                if (pos < WebRtcAudioTrack.this._playPosition) {
                    WebRtcAudioTrack.this._playPosition = 0;
                }
                WebRtcAudioTrack.this._bufferedPlaySamples = WebRtcAudioTrack.this._bufferedPlaySamples - (pos - WebRtcAudioTrack.this._playPosition);
                WebRtcAudioTrack.this._playPosition = pos;
                if (bytesWritten != sizeInBytes) {
                    WebRtcAudioTrack.this.DoLogErr("AudioTrack.write failed: " + bytesWritten);
                    if (bytesWritten == -3) {
                        this.keepAlive = false;
                    }
                }
                WebRtcAudioTrack.this.byteBuffer.rewind();
            }
            try {
                WebRtcAudioTrack.this.audioTrack.stop();
            }
            catch (IllegalStateException e) {
                WebRtcAudioTrack.this.DoLogErr("AudioTrack.stop failed: " + e.getMessage());
            }
            WebRtcAudioTrack.assertTrue(WebRtcAudioTrack.this.audioTrack.getPlayState() == 1);
            WebRtcAudioTrack.this.audioTrack.flush();
        }

        @TargetApi(value=21)
        private int writeOnLollipop(AudioTrack audioTrack, ByteBuffer byteBuffer, int sizeInBytes) {
            return audioTrack.write(byteBuffer, sizeInBytes, 0);
        }

        private int writePreLollipop(AudioTrack audioTrack, ByteBuffer byteBuffer, int sizeInBytes) {
            return audioTrack.write(byteBuffer.array(), byteBuffer.arrayOffset(), sizeInBytes);
        }

        public void joinThread() {
            this.keepAlive = false;
            while (this.isAlive()) {
                try {
                    this.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

