/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.audioengine;

import android.app.ActivityManager;
import android.content.Context;
import android.media.AudioManager;
import android.media.AudioRecord;
import android.media.audiofx.AcousticEchoCanceler;
import android.os.Build;
import android.os.Process;
import android.os.SystemClock;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.webrtc.audioengine.AudioManagerAndroid;

class WebRtcAudioRecord {
    private static final boolean DEBUG = false;
    private static final String TAG = "[AudioRecord]";
    private static final int SAMPLE_RATE_HZ = 44100;
    private static final int BITS_PER_SAMPLE = 16;
    private static final int CALLBACK_BUFFER_SIZE_MS = 10;
    private static final int BUFFERS_PER_SECOND = 100;
    private static final int BUFFER_SIZE_FACTOR = 2;
    private ByteBuffer byteBuffer;
    private int bytesPerBuffer;
    private int framesPerBuffer;
    private int sampleRate;
    private int channelCount;
    private final long nativeAudioRecord;
    private final AudioManager audioManager;
    private final ActivityManager activityManager;
    private final Context context;
    private AudioRecord audioRecord = null;
    private AudioRecordThread audioThread = null;
    private AcousticEchoCanceler aec = null;
    private boolean useBuiltInAEC = false;
    private final Set<Long> threadIds = new HashSet<Long>();

    private static boolean runningOnJellyBeanOrHigher() {
        return Build.VERSION.SDK_INT >= 16;
    }

    private static boolean runningOnJellyBeanMR1OrHigher() {
        return Build.VERSION.SDK_INT >= 17;
    }

    private boolean hasRecPermission(Context context, String permission2) {
        return context.checkPermission(permission2, Process.myPid(), Process.myUid()) == 0;
    }

    private void PrintCurrentThreadName() {
        List infos = this.activityManager.getRunningAppProcesses();
        this.DoLog("Begin Print Current Thread Name=====================================");
        try {
            for (ActivityManager.RunningAppProcessInfo info : infos) {
                String name = info.processName;
                this.DoLog("Current App Process Name:" + name);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.DoLog("End Print Current Thread Name=======================================");
    }

    WebRtcAudioRecord(Context context, long nativeAudioRecord) {
        this.DoLog("ctor" + WebRtcAudioRecord.getThreadInfo());
        this.context = context;
        this.nativeAudioRecord = nativeAudioRecord;
        this.audioManager = (AudioManager)context.getSystemService("audio");
        this.activityManager = (ActivityManager)context.getSystemService("activity");
        this.sampleRate = 0;
        this.bytesPerBuffer = 0;
        this.framesPerBuffer = 0;
    }

    private int GetNativeSampleRate() {
        if (!WebRtcAudioRecord.runningOnJellyBeanMR1OrHigher()) {
            return 44100;
        }
        String sampleRateString = this.audioManager.getProperty("android.media.property.OUTPUT_SAMPLE_RATE");
        return sampleRateString == null ? 44100 : Integer.parseInt(sampleRateString);
    }

    public static boolean BuiltInAECIsAvailable() {
        if (!WebRtcAudioRecord.runningOnJellyBeanOrHigher()) {
            return false;
        }
        return AcousticEchoCanceler.isAvailable();
    }

    private boolean EnableBuiltInAEC(boolean enable) {
        this.DoLog("EnableBuiltInAEC(" + enable + ')');
        if (!WebRtcAudioRecord.runningOnJellyBeanOrHigher()) {
            return false;
        }
        this.useBuiltInAEC = enable;
        if (this.aec != null) {
            int ret = this.aec.setEnabled(enable);
            if (ret != 0) {
                this.DoLogErr("AcousticEchoCanceler.setEnabled failed");
                return false;
            }
            this.DoLog("AcousticEchoCanceler.getEnabled: " + this.aec.getEnabled());
        }
        return true;
    }

    private int InitRecording(int SampleRate, int recordstreamType) {
        int channelMode;
        this.sampleRate = SampleRate;
        if (recordstreamType == 256) {
            this.channelCount = 2;
            channelMode = 12;
        } else {
            this.channelCount = 1;
            channelMode = 16;
        }
        int BYTES_PER_FRAME = this.channelCount * 2;
        this.bytesPerBuffer = BYTES_PER_FRAME * (this.sampleRate / 100);
        this.framesPerBuffer = this.sampleRate / 100;
        this.byteBuffer = ByteBuffer.allocateDirect(this.bytesPerBuffer);
        this.nativeCacheDirectBufferAddress(this.byteBuffer, this.nativeAudioRecord);
        this.DoLog("InitRecording(sampleRate=" + this.sampleRate + ")");
        int minBufferSize = AudioRecord.getMinBufferSize((int)this.sampleRate, (int)channelMode, (int)2);
        this.DoLog("AudioRecord.getMinBufferSize: " + minBufferSize);
        try {
            if (this.audioRecord != null) {
                this.audioRecord.stop();
                this.audioRecord.release();
                this.audioRecord = null;
            }
        }
        catch (Exception ex) {
            this.DoLogErr("InitRecording audioRecord stop and release fail: " + ex.getMessage());
        }
        int bufferSizeInBytes = Math.max(this.byteBuffer.capacity(), 2 * minBufferSize);
        this.DoLog("bufferSizeInBytes: " + bufferSizeInBytes + ", " + this.byteBuffer.capacity() + ", " + minBufferSize);
        int audioSource = recordstreamType;
        this.DoLog("audioSource: " + audioSource);
        if (audioSource == 256) {
            audioSource = 1;
        }
        try {
            this.audioRecord = new AudioRecord(audioSource, this.sampleRate, channelMode, 2, bufferSizeInBytes);
        }
        catch (IllegalArgumentException e) {
            this.DoLog(e.getMessage());
            return -1;
        }
        if (this.audioRecord.getState() != 1) {
            return -1;
        }
        this.DoLog("AudioRecord audio format: " + this.audioRecord.getAudioFormat() + ", channels: " + this.audioRecord.getChannelCount() + ", sample rate: " + this.audioRecord.getSampleRate());
        return this.framesPerBuffer;
    }

    private boolean StartRecording() {
        this.DoLog("StartRecording");
        if (this.audioRecord == null) {
            this.DoLogErr("start() called before init()");
            return false;
        }
        if (this.audioThread != null) {
            this.DoLogErr("start() was already called");
            return false;
        }
        this.audioThread = new AudioRecordThread("YY_Aud_Record_Java");
        this.audioThread.start();
        this.DoLog("Create a Thread name:YY_Aud_Record_Java");
        return true;
    }

    private boolean StopRecording() {
        this.DoLog("StopRecording");
        if (this.audioThread == null) {
            this.DoLogErr("start() was never called, or stop() was already called");
            return false;
        }
        this.audioThread.joinThread();
        this.audioThread = null;
        if (this.aec != null) {
            this.aec.release();
            this.aec = null;
        }
        try {
            if (this.audioRecord != null) {
                this.audioRecord.stop();
                this.audioRecord.release();
                this.audioRecord = null;
            }
        }
        catch (Exception ex) {
            this.DoLogErr("StopRecording audioRecord stop and release fail: " + ex.getMessage());
        }
        return true;
    }

    private void DoLog(String msg) {
        AudioManagerAndroid.DoLog(TAG + msg);
    }

    private void DoLogErr(String msg) {
        AudioManagerAndroid.DoLog("[AudioRecord][Error]" + msg);
    }

    private static String getThreadInfo() {
        return "@[name=" + Thread.currentThread().getName() + ", id=" + Thread.currentThread().getId() + "]";
    }

    private static void assertIsTrue(boolean condition) {
        if (!condition) {
            throw new AssertionError((Object)"Expected condition to be true");
        }
    }

    private void AddThreadId() {
        this.threadIds.add(Thread.currentThread().getId());
        this.DoLog("threadIds: " + this.threadIds + " (#threads=" + this.threadIds.size() + ")");
    }

    private void RemoveThreadId() {
        this.threadIds.remove(Thread.currentThread().getId());
        this.DoLog("threadIds: " + this.threadIds + " (#threads=" + this.threadIds.size() + ")");
    }

    private native void nativeCacheDirectBufferAddress(ByteBuffer var1, long var2);

    private native void nativeDataIsRecorded(int var1, long var2);

    private native long nativeGetTickCount();

    private class AudioRecordThread
    extends Thread {
        private volatile boolean keepAlive;

        public AudioRecordThread(String name) {
            super(name);
            this.keepAlive = true;
        }

        @Override
        public void run() {
            boolean isRecording;
            Process.setThreadPriority((int)-19);
            WebRtcAudioRecord.this.DoLog("AudioRecordThread" + WebRtcAudioRecord.getThreadInfo());
            if (!WebRtcAudioRecord.this.hasRecPermission(WebRtcAudioRecord.this.context, "android.permission.RECORD_AUDIO")) {
                WebRtcAudioRecord.this.nativeDataIsRecorded(-5, WebRtcAudioRecord.this.nativeAudioRecord);
                WebRtcAudioRecord.this.PrintCurrentThreadName();
                return;
            }
            try {
                WebRtcAudioRecord.this.audioRecord.startRecording();
            }
            catch (IllegalStateException e) {
                WebRtcAudioRecord.this.nativeDataIsRecorded(-1, WebRtcAudioRecord.this.nativeAudioRecord);
                WebRtcAudioRecord.this.PrintCurrentThreadName();
                WebRtcAudioRecord.this.DoLogErr("AudioRecord.startRecording failed: " + e.getMessage());
                return;
            }
            boolean bl = isRecording = WebRtcAudioRecord.this.audioRecord.getRecordingState() == 3;
            if (!isRecording) {
                WebRtcAudioRecord.this.nativeDataIsRecorded(-2, WebRtcAudioRecord.this.nativeAudioRecord);
                WebRtcAudioRecord.this.PrintCurrentThreadName();
            }
            long lastTime = System.nanoTime();
            int readFailCount = 0;
            boolean haveNotifyError = false;
            while (this.keepAlive) {
                int bytesRead = -1;
                try {
                    bytesRead = WebRtcAudioRecord.this.audioRecord.read(WebRtcAudioRecord.this.byteBuffer, WebRtcAudioRecord.this.byteBuffer.capacity());
                }
                catch (Exception ex) {
                    WebRtcAudioRecord.this.DoLogErr("AudioRecord.read failed: " + ex.getMessage());
                }
                if (bytesRead == WebRtcAudioRecord.this.byteBuffer.capacity()) {
                    readFailCount = 0;
                    haveNotifyError = false;
                    WebRtcAudioRecord.this.nativeDataIsRecorded(bytesRead, WebRtcAudioRecord.this.nativeAudioRecord);
                    continue;
                }
                if (bytesRead == -3 && isRecording) {
                    WebRtcAudioRecord.this.nativeDataIsRecorded(-3, WebRtcAudioRecord.this.nativeAudioRecord);
                    WebRtcAudioRecord.this.PrintCurrentThreadName();
                    this.keepAlive = false;
                    break;
                }
                if (!haveNotifyError && ++readFailCount > 3) {
                    haveNotifyError = true;
                    WebRtcAudioRecord.this.nativeDataIsRecorded(-4, WebRtcAudioRecord.this.nativeAudioRecord);
                    WebRtcAudioRecord.this.PrintCurrentThreadName();
                }
                SystemClock.sleep((long)100L);
            }
            try {
                WebRtcAudioRecord.this.audioRecord.stop();
            }
            catch (IllegalStateException e) {
                WebRtcAudioRecord.this.DoLogErr("AudioRecord.stop failed: " + e.getMessage());
            }
            WebRtcAudioRecord.this.RemoveThreadId();
        }

        public void joinThread() {
            this.keepAlive = false;
            while (this.isAlive()) {
                try {
                    this.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

