/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.audioengine;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Environment;
import android.os.Looper;
import android.os.Process;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import com.yy.audioengine.MainHandler;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.Calendar;
import org.json.JSONArray;
import org.json.JSONObject;
import org.webrtc.audioengine.UploadESampleThread;

class AudioManagerAndroid {
    private static final int DEFAULT_SAMPLING_RATE = 44100;
    private static final int DEFAULT_FRAMES_PER_BUFFER = 256;
    private int mNativeOutputSampleRate;
    private boolean mAudioLowLatencySupported;
    private int mAudioLowLatencyOutputFrameSize;
    private static final String TAG = "Audio";
    private final Context mContext;
    private final AudioManager mAudioManager;
    private final String bluetoothHeadsetIntent;
    private final String scoAudioStateIntent;
    private PhoneStateListener mPhoneStateListener = null;
    private boolean initialized = false;
    private String mModel = null;
    private boolean mIsHeadsetPlugReceiverRegistered = false;
    private BroadcastReceiver mHeadsetPlugReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (intent.hasExtra("state")) {
                int state = intent.getIntExtra("state", 0);
                AudioManagerAndroid.this.nativeNotifyHeadsetPlug(state);
                if (state == 0) {
                    AudioManagerAndroid.DoLog("headset not connected");
                } else if (state == 1) {
                    AudioManagerAndroid.DoLog("headset connected");
                }
            }
        }
    };
    private boolean BluetoothReceiverRegistered = false;
    private BroadcastReceiver BluetoothReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action.equals(AudioManagerAndroid.this.bluetoothHeadsetIntent)) {
                int bluetoothHeadsetState = intent.getIntExtra("android.bluetooth.profile.extra.STATE", 0);
                if (bluetoothHeadsetState == 2) {
                    AudioManagerAndroid.this.nativeNotifyBluetoothPlug(1);
                } else if (bluetoothHeadsetState == 0) {
                    AudioManagerAndroid.this.nativeNotifyBluetoothPlug(0);
                }
            }
        }
    };
    private boolean mPhoneStateListenerRegistered = false;
    private static Context mCtx;
    String url = "http://do.yy.duowan.com/dynamic-shunt-data/type2/109/AudioengineConfig";
    String filename = "AudioengineConfig";
    private static String filesDir;
    private int[] config = new int[]{-128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, 0};

    private AudioManagerAndroid(Context context) {
        AudioManager audioManager;
        this.mContext = context;
        this.bluetoothHeadsetIntent = "android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED";
        this.scoAudioStateIntent = Build.VERSION.SDK_INT >= 14 ? "android.media.ACTION_SCO_AUDIO_STATE_UPDATED" : "android.media.SCO_AUDIO_STATE_CHANGED";
        this.mAudioManager = audioManager = (AudioManager)context.getSystemService("audio");
        this.mNativeOutputSampleRate = 44100;
        this.mAudioLowLatencyOutputFrameSize = 256;
        if (Build.VERSION.SDK_INT >= 17) {
            String framesPerBuffer;
            String sampleRateString = audioManager.getProperty("android.media.property.OUTPUT_SAMPLE_RATE");
            if (sampleRateString != null) {
                this.mNativeOutputSampleRate = Integer.parseInt(sampleRateString);
            }
            if ((framesPerBuffer = audioManager.getProperty("android.media.property.OUTPUT_FRAMES_PER_BUFFER")) != null) {
                this.mAudioLowLatencyOutputFrameSize = Integer.parseInt(framesPerBuffer);
            }
        }
        this.mModel = Build.BRAND.toLowerCase() + "-" + Build.MODEL.toLowerCase();
        try {
            this.mAudioLowLatencySupported = context.getPackageManager().hasSystemFeature("android.hardware.audio.low_latency");
        }
        catch (RuntimeException e) {
            this.mAudioLowLatencySupported = false;
        }
    }

    private void init(Context context) {
        if (this.initialized) {
            return;
        }
        AudioManagerAndroid.DoLog("audio mode is: " + this.mAudioManager.getMode());
        this.initialized = true;
    }

    private int getNativeOutputSampleRate() {
        return this.mNativeOutputSampleRate;
    }

    private boolean isAudioLowLatencySupported() {
        return this.mAudioLowLatencySupported;
    }

    private int getAudioLowLatencyOutputFrameSize() {
        return this.mAudioLowLatencyOutputFrameSize;
    }

    private static int getMode(Context context) {
        int result = 0;
        try {
            AudioManager audioManager = (AudioManager)context.getSystemService("audio");
            result = audioManager.getMode();
            return result;
        }
        catch (Exception e) {
            AudioManagerAndroid.DoLog("AudioManagerAndroid getMode error");
        }
        finally {
            return result;
        }
    }

    private static int isSpeakerphoneOn(Context context) {
        int result = 0;
        try {
            AudioManager audioManager = (AudioManager)context.getSystemService("audio");
            result = audioManager.isSpeakerphoneOn() ? 1 : 0;
            return result;
        }
        catch (Exception e) {
            AudioManagerAndroid.DoLog("AudioManagerAndroid isSpeakerphoneOn error");
        }
        finally {
            return result;
        }
    }

    private static int isHeadsetPlugin(Context context) {
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        return audioManager.isWiredHeadsetOn() ? 1 : 0;
    }

    private static void setMode(final Context context, final int mode) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            AsyncTask.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    AudioManagerAndroid.setModeInner(context, mode);
                }
            });
        } else {
            AudioManagerAndroid.setModeInner(context, mode);
        }
    }

    private static void setModeInner(Context context, int mode) {
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        try {
            audioManager.setMode(mode);
        }
        catch (Exception e) {
            AudioManagerAndroid.DoLog("AudioManagerAndroid: setMode failed: " + e.getMessage().toString());
            return;
        }
    }

    private static void setSpeakerphoneOn(Context context, boolean on) {
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        audioManager.setSpeakerphoneOn(on);
        AudioManagerAndroid.DoLog("AudioManagerAndroid setSpeakerphoneOn: " + String.valueOf(on));
    }

    public static void DoLog(String msg) {
        AudioManagerAndroid.nativeLogDebugInfo(msg);
    }

    private void SetNotify(int notify) {
        if (notify == 1) {
            this.registerBluetoothReceiver();
            this.registerHeadsetPlugReceiver();
            this.registerPhoneStateListener();
        } else {
            this.unregisterBluetoothReceiver();
            this.unRegisterHeadsetPlugReceiver();
            this.unRegisterPhoneStateListener();
        }
    }

    private void registerHeadsetPlugReceiver() {
        AudioManagerAndroid.DoLog("registerHeadsetPlugReceiver");
        if (!this.mIsHeadsetPlugReceiverRegistered) {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.HEADSET_PLUG");
            this.mContext.registerReceiver(this.mHeadsetPlugReceiver, intentFilter);
            this.mIsHeadsetPlugReceiverRegistered = true;
        }
    }

    private void unRegisterHeadsetPlugReceiver() {
        AudioManagerAndroid.DoLog("unRegisterHeadsetPlugReceiver");
        if (this.mIsHeadsetPlugReceiverRegistered) {
            this.mContext.unregisterReceiver(this.mHeadsetPlugReceiver);
            this.mIsHeadsetPlugReceiverRegistered = false;
        }
    }

    @TargetApi(value=14)
    public boolean isBluetoothHeadsetConnected() {
        try {
            int BluetoothStatus_hdset;
            BluetoothAdapter BTAdapter = BluetoothAdapter.getDefaultAdapter();
            if (BTAdapter == null) {
                return false;
            }
            if (!this.mAudioManager.isBluetoothScoAvailableOffCall()) {
                return false;
            }
            if (Build.VERSION.SDK_INT >= 14 ? 2 == (BluetoothStatus_hdset = BTAdapter.getProfileConnectionState(1)) : !BluetoothAdapter.getDefaultAdapter().getBondedDevices().isEmpty()) {
                return true;
            }
        }
        catch (Exception ex) {
            AudioManagerAndroid.DoLog("detect bluetooth error: " + ex.getMessage());
        }
        return false;
    }

    private boolean hasPermission(Context context, String permission2) {
        return context.checkPermission(permission2, Process.myPid(), Process.myUid()) == 0;
    }

    private void registerBluetoothReceiver() {
        AudioManagerAndroid.DoLog("registerBluetoothReceiver()");
        if (!this.hasPermission(this.mContext, "android.permission.BLUETOOTH") || !this.hasPermission(this.mContext, "android.permission.BLUETOOTH_ADMIN")) {
            return;
        }
        try {
            if (!this.BluetoothReceiverRegistered) {
                this.mContext.registerReceiver(this.BluetoothReceiver, new IntentFilter(this.bluetoothHeadsetIntent));
                this.BluetoothReceiverRegistered = true;
            }
        }
        catch (Exception e) {
            AudioManagerAndroid.DoLog("registerBluetoothReceiver error, " + e.getMessage());
        }
        if (this.isBluetoothHeadsetConnected()) {
            this.nativeNotifyBluetoothPlug(1);
        } else {
            this.nativeNotifyBluetoothPlug(0);
        }
    }

    private void unregisterBluetoothReceiver() {
        if (!this.hasPermission(this.mContext, "android.permission.BLUETOOTH") || !this.hasPermission(this.mContext, "android.permission.BLUETOOTH_ADMIN")) {
            return;
        }
        if (this.BluetoothReceiverRegistered) {
            this.mContext.unregisterReceiver(this.BluetoothReceiver);
            this.BluetoothReceiverRegistered = false;
        }
    }

    private void registerPhoneStateListener() {
        if (this.isCurrentlyOnMainThread()) {
            AudioManagerAndroid.DoLog("registerPhoneStateListener...run on main thread");
            this.listenTelState();
        } else {
            AudioManagerAndroid.DoLog("registerPhoneStateListener...run on async thread");
            MainHandler.getInstance().post(new Runnable(){

                @Override
                public void run() {
                    AudioManagerAndroid.this.listenTelState();
                }
            });
        }
    }

    private void unRegisterPhoneStateListener() {
        if (this.isCurrentlyOnMainThread()) {
            AudioManagerAndroid.DoLog("unRegisterPhoneStateListener...run on main thread");
            this.notListenTelState();
        } else {
            AudioManagerAndroid.DoLog("unRegisterPhoneStateListener...run on async thread");
            MainHandler.getInstance().post(new Runnable(){

                @Override
                public void run() {
                    AudioManagerAndroid.this.notListenTelState();
                }
            });
        }
    }

    private static void setBluetoothScoOn(Context context, int on) {
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        audioManager.setBluetoothScoOn(on > 0);
        AudioManagerAndroid.DoLog("AudioManagerAndroid setBluetoothScoOn: " + on);
    }

    private static void startOrStopBluetoothSco(Context context, int start) {
        try {
            AudioManager audioManager = (AudioManager)context.getSystemService("audio");
            if (start > 0) {
                audioManager.startBluetoothSco();
            } else {
                audioManager.stopBluetoothSco();
            }
            AudioManagerAndroid.DoLog("AudioManagerAndroid startOrStopBluetoothSco: " + start);
        }
        catch (Exception ex) {
            AudioManagerAndroid.DoLog("AudioManagerAndroid startOrStopBluetoothSco exception: " + ex);
        }
    }

    private boolean isCurrentlyOnMainThread() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    private void listenTelState() {
        try {
            if (this.mPhoneStateListener == null) {
                this.mPhoneStateListenerRegistered = true;
                this.mPhoneStateListener = new MediaPhoneStateListener();
                ((TelephonyManager)this.mContext.getSystemService("phone")).listen(this.mPhoneStateListener, 32);
            }
        }
        catch (Exception ex) {
            AudioManagerAndroid.DoLog("MediaPhoneStateListener: listenTelState Error, can't listen, " + ex.getMessage());
        }
    }

    private void notListenTelState() {
        try {
            if (this.mPhoneStateListener != null) {
                ((TelephonyManager)this.mContext.getSystemService("phone")).listen(null, 32);
                this.mPhoneStateListener = null;
                this.mPhoneStateListenerRegistered = false;
            }
        }
        catch (Exception ex) {
            AudioManagerAndroid.DoLog("MediaPhoneStateListener: notListenTelState Error, can't listen, " + ex.getMessage());
        }
    }

    private static int getAndroidOSVersion() {
        return Build.VERSION.SDK_INT;
    }

    private native void nativeNotifyHeadsetPlug(int var1);

    private native void nativeNotifyBluetoothPlug(int var1);

    private native void nativeNotifyPhoneCallReceive(int var1);

    private static native void nativeLogDebugInfo(String var0);

    public int[] AsyncLoad(Context ctx) throws InterruptedException {
        mCtx = ctx;
        try {
            filesDir = ctx.getFilesDir().getAbsolutePath();
        }
        catch (Exception e) {
            AudioManagerAndroid.DoLog("AudioEngineConfig AsyncLoad bug");
        }
        LoadThread lt = new LoadThread();
        Thread th = new Thread(lt);
        th.start();
        th.join();
        AudioManagerAndroid.DoLog("AudioEngineConfig Param:" + this.mModel + ":" + Arrays.toString(this.config));
        return this.config;
    }

    static boolean InToday(long ts) {
        Calendar ca = Calendar.getInstance();
        ca.set(11, 0);
        ca.set(12, 0);
        ca.set(13, 0);
        ca.set(14, 0);
        return ts > ca.getTimeInMillis();
    }

    static String get(String url) throws Exception {
        String lines;
        URL getUrl = new URL(url);
        HttpURLConnection connection = (HttpURLConnection)getUrl.openConnection();
        connection.connect();
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        StringBuilder sb = new StringBuilder();
        while ((lines = reader.readLine()) != null) {
            sb.append(lines);
        }
        reader.close();
        connection.disconnect();
        return sb.toString();
    }

    public static void UploadRecordFile() {
        String Imei = Build.SERIAL;
        AudioManagerAndroid.DoLog("uploaddata SERIAL " + Imei);
        new UploadESampleThread(Environment.getExternalStorageDirectory().getPath() + "/yysdk/logs/audiorec/", Imei).start();
    }

    public static boolean setThreadPriorityAudio(int tid) {
        String module;
        if (Build.VERSION.SDK_INT == 16 && (module = Build.BRAND.toLowerCase() + "-" + Build.MODEL.toLowerCase()).equals("samsung-gt-s6818")) {
            AudioManagerAndroid.DoLog("setThreadPriorityAudio " + tid);
            Process.setThreadPriority((int)tid, (int)-16);
            return true;
        }
        return false;
    }

    static /* synthetic */ int[] access$1002(AudioManagerAndroid x0, int[] x1) {
        x0.config = x1;
        return x1;
    }

    class LoadThread
    implements Runnable {
        LoadThread() {
        }

        @Override
        public void run() {
            try {
                JSONObject js = this.getJsonConfig();
                if (js.has(AudioManagerAndroid.this.mModel)) {
                    AudioManagerAndroid.DoLog("AudioEngineConfig get json has mode");
                    JSONArray aecfarray = js.getJSONArray(AudioManagerAndroid.this.mModel);
                    AudioManagerAndroid.access$1002(AudioManagerAndroid.this, new int[aecfarray.length()]);
                    for (int i = 0; i < aecfarray.length(); ++i) {
                        ((AudioManagerAndroid)AudioManagerAndroid.this).config[i] = aecfarray.getInt(i);
                    }
                    AudioManagerAndroid.DoLog("AudioEngineConfig get json model in" + Arrays.toString(AudioManagerAndroid.this.config));
                } else if (js.has("default")) {
                    JSONArray aecfarray = js.getJSONArray("default");
                    AudioManagerAndroid.access$1002(AudioManagerAndroid.this, new int[aecfarray.length()]);
                    for (int i = 0; i < aecfarray.length(); ++i) {
                        ((AudioManagerAndroid)AudioManagerAndroid.this).config[i] = aecfarray.getInt(i);
                    }
                    AudioManagerAndroid.DoLog("AudioEngineConfig Param get default mode :" + Arrays.toString(AudioManagerAndroid.this.config));
                }
            }
            catch (Exception e) {
                AudioManagerAndroid.DoLog("AudioEngineConfig Param Load Error " + e.getMessage());
            }
        }

        JSONObject getJsonConfig() {
            try {
                int tl;
                File aecf = new File(filesDir + "/" + AudioManagerAndroid.this.filename);
                if (!aecf.exists() || !AudioManagerAndroid.InToday(aecf.lastModified())) {
                    try {
                        String str = AudioManagerAndroid.get(AudioManagerAndroid.this.url);
                        JSONObject js = new JSONObject(str);
                        FileWriter fw = new FileWriter(aecf);
                        fw.write(str);
                        fw.close();
                        AudioManagerAndroid.DoLog("AudioEngineConfig get json finish");
                        return js;
                    }
                    catch (Exception e) {
                        AudioManagerAndroid.DoLog("AudioEngineConfig getJsonConfig fail " + e.getMessage());
                    }
                }
                FileInputStream fi = new FileInputStream(aecf);
                ByteArrayOutputStream bo = new ByteArrayOutputStream();
                byte[] buf = new byte[1024];
                while ((tl = fi.read(buf, 0, 1024)) > 0) {
                    bo.write(buf, 0, tl);
                }
                fi.close();
                String str = bo.toString();
                JSONObject js = new JSONObject(str);
                return js;
            }
            catch (Exception e) {
                AudioManagerAndroid.DoLog("AudioEngineConfig getJsonConfig " + e.getMessage());
                return null;
            }
        }
    }

    private class MediaPhoneStateListener
    extends PhoneStateListener {
        private boolean mInCall = false;

        private MediaPhoneStateListener() {
        }

        public void onCallStateChanged(int state, String incomingNumber) {
            if (AudioManagerAndroid.this.mPhoneStateListenerRegistered) {
                AudioManagerAndroid.DoLog("MediaPhoneStateListener: " + state + ",incomingNumber " + incomingNumber);
                switch (state) {
                    case 0: {
                        if (!this.mInCall) break;
                        this.mInCall = false;
                        AudioManagerAndroid.this.nativeNotifyPhoneCallReceive(0);
                        AudioManagerAndroid.DoLog("MediaPhoneStateListener Not in Call");
                        break;
                    }
                    case 1: 
                    case 2: {
                        if (this.mInCall) break;
                        this.mInCall = true;
                        AudioManagerAndroid.this.nativeNotifyPhoneCallReceive(1);
                        AudioManagerAndroid.DoLog("MediaPhoneStateListener in Call");
                    }
                }
            }
        }
    }
}

