/*
 * Decompiled with CFR 0.152.
 */
package com.yy.audioengine;

import android.os.Build;
import com.yy.audioengine.AudioConfig;
import com.yy.audioengine.IAudioLibJniInit;
import com.yy.audioengine.IKaraokePlaybackNotify;
import com.yy.audioengine.MainHandler;
import com.yy.audioengine.YALog;
import java.util.Arrays;

public class KaraokePlayBack {
    private static String TAG = "[KaraokePlayBack]";
    private IKaraokePlaybackNotify mNotify;
    private long mCtx;

    public void Init() {
        YALog.info(TAG + "Init...IsEnableLowLatencyPlayBack: " + AudioConfig.IsEnableLowLatencyPlayBack());
        if (AudioConfig.IsEnableLowLatencyPlayBack()) {
            IAudioLibJniInit.EnableAndroidOpenSlEs(true);
        }
        if (Build.MODEL.equalsIgnoreCase("A1601")) {
            YALog.info(TAG + "Init, oppo A1601 enable openslesout....");
            IAudioLibJniInit.EnableAndroidOpenSlEs(true);
        }
        this.mCtx = this.nativeCreateKaraokePlayBack(this);
    }

    public void Destroy() {
        YALog.info(TAG + "Destroy.....");
        this.nativeDestroyKaraokePlayBack(this.mCtx);
        this.mCtx = 0L;
        this.mNotify = null;
        if (AudioConfig.IsEnableLowLatencyPlayBack()) {
            IAudioLibJniInit.EnableAndroidOpenSlEs(false);
        }
        if (Build.MODEL.equalsIgnoreCase("A1601")) {
            YALog.info(TAG + "Destroy, oppo A1601 disable openslesout....");
            IAudioLibJniInit.EnableAndroidOpenSlEs(false);
        }
    }

    public boolean Open(String voiceFile, String accompanyFile) {
        YALog.info(TAG + "Open, voiceFile: " + voiceFile + " ,accompanyFile: " + accompanyFile);
        return this.nativeOpen(this.mCtx, voiceFile, accompanyFile);
    }

    public void Play() {
        YALog.info(TAG + "Play.....");
        this.nativePlay(this.mCtx);
    }

    public void Stop() {
        YALog.info(TAG + "Stop.....");
        this.nativeStop(this.mCtx);
    }

    public void Pause() {
        YALog.info(TAG + "Pause.....");
        this.nativePause(this.mCtx);
    }

    public void Resume() {
        YALog.info(TAG + "Resume.....");
        this.nativeResume(this.mCtx);
    }

    public void Seek(long seekTime) {
        YALog.info(TAG + "Seek, seekTime: " + seekTime);
        this.nativeSeek(this.mCtx, seekTime);
    }

    public void SetKaraokePlaybackNotify(IKaraokePlaybackNotify notify) {
        YALog.info(TAG + "setKaraokePlaybackNotify: " + notify);
        this.mNotify = notify;
    }

    public void EnableReverbNew(boolean enable) {
        YALog.info(TAG + "EnableReverbNew. enable: " + enable);
        this.nativeEnableReverbNew(this.mCtx, enable);
    }

    public void SetReverbNewParam(float[] array) {
        YALog.info(TAG + "SetReverbNewParam,array: " + Arrays.toString(array));
        this.nativeSetReverbNewParam(this.mCtx, array);
    }

    public void EnableEqualizer(boolean enable) {
        YALog.info(TAG + "EnableEqualizer. enable: " + enable);
        this.nativeEnableEqualizer(this.mCtx, enable);
    }

    public void SetEqGains(float[] array) {
        YALog.info(TAG + "SetEqGains,array: " + Arrays.toString(array));
        this.nativeSetEqGains(this.mCtx, array);
    }

    public void EnableCompressor(boolean enable) {
        YALog.info(TAG + "EnableCompressor. enable: " + enable);
        this.nativeEnableCompressor(this.mCtx, enable);
    }

    public void SetCompressorParam(int[] array) {
        YALog.info(TAG + "SetCompressorParam,array: " + Arrays.toString(array));
        this.nativeSetCompressorParam(this.mCtx, array);
    }

    public void EnableLimiter(boolean enable) {
        YALog.info(TAG + "EnableLimiter. enable: " + enable);
        this.nativeEnableLimiter(this.mCtx, enable);
    }

    public void SetLimiterParam(float[] array) {
        YALog.info(TAG + "SetLimiterParam,array: " + Arrays.toString(array));
        this.nativeSetLimiterParam(this.mCtx, array);
    }

    public void SetVoiceOffset(int offsetTime) {
        YALog.info(TAG + "SetVoiceOffset: " + offsetTime);
        this.nativeSetVoiceOffset(this.mCtx, offsetTime);
    }

    public void SetTone(int tone) {
        YALog.info(TAG + "SetTone: " + tone);
        this.nativeSetTone(this.mCtx, tone);
    }

    public void SetEtbValue(int value) {
        YALog.info(TAG + "SetEtbValue: " + value);
        this.nativeSetEtbValue(this.mCtx, value);
    }

    public void EnableDenoise(boolean enable) {
        YALog.info(TAG + "EnableDenoise: " + enable);
        this.nativeEnableDenoise(this.mCtx, enable);
    }

    public void EnableDrc(boolean enable) {
        YALog.info(TAG + "EnableDrc: " + enable);
        this.nativeEnableDrc(this.mCtx, enable);
    }

    public void SetVoiceVolume(int volume) {
        YALog.info(TAG + "SetVoiceVolume: " + volume);
        this.nativeSetVoiceVolume(this.mCtx, volume);
    }

    public void SetAccompanyVolume(int volume) {
        YALog.info(TAG + "SetAccompanyVolume: " + volume);
        this.nativeSetAccompanyVolume(this.mCtx, volume);
    }

    public long GetTotalPlayBackTimeMs() {
        return this.nativeGetTotalPlayBackTime(this.mCtx);
    }

    public long GetCurrentPlayBackTimeMs() {
        return this.nativeGetCurrentPlayerTime(this.mCtx);
    }

    public void EnableLoopPlay(boolean enable) {
    }

    public boolean OpenAutoToneFilePlayer(String fileName) {
        boolean res = this.nativeOpenAutoToneFilePlayer(this.mCtx, fileName);
        YALog.info(TAG + "OpenAutoToneFilePlayer: " + fileName + " ,res: " + res);
        return res;
    }

    public boolean StopAutoToneFilePlayer() {
        YALog.info(TAG + "StopAutoToneFilePlayer...");
        return this.nativeStopAutoToneFilePlayer(this.mCtx);
    }

    public void ChooseAutoToneFilePlayer(boolean isAutoTonePlay) {
        YALog.info(TAG + "ChooseAutoToneFilePlayer, isAutoTonePlay: " + isAutoTonePlay);
        this.nativeChooseAutoToneFilePlayer(this.mCtx, isAutoTonePlay);
    }

    public boolean IsAutoToneFilePlaying() {
        return this.nativeIsAutoToneFilePlaying(this.mCtx);
    }

    private void OnPlayerEnd() {
        YALog.info(TAG + "OnPlayerEnd...");
        MainHandler.getInstance().post(new Runnable(){

            @Override
            public void run() {
                if (KaraokePlayBack.this.mNotify != null) {
                    KaraokePlayBack.this.mNotify.OnKaraokePlayBackEnd();
                }
            }
        });
    }

    private void OnPlayerVolume(long volume, final long currentTime, final long totalTime) {
        MainHandler.getInstance().post(new Runnable(){

            @Override
            public void run() {
                if (KaraokePlayBack.this.mNotify != null) {
                    KaraokePlayBack.this.mNotify.OnKaraokePlayBackTimeInfo(currentTime, totalTime);
                }
            }
        });
    }

    private native long nativeCreateKaraokePlayBack(Object var1);

    private native void nativeDestroyKaraokePlayBack(long var1);

    private native boolean nativeOpen(long var1, String var3, String var4);

    private native void nativePlay(long var1);

    private native void nativePause(long var1);

    private native void nativeResume(long var1);

    private native void nativeStop(long var1);

    private native boolean nativeSeek(long var1, long var3);

    private native long nativeGetTotalPlayBackTime(long var1);

    private native long nativeGetCurrentPlayerTime(long var1);

    private native void nativeSetVoiceVolume(long var1, int var3);

    private native void nativeSetAccompanyVolume(long var1, int var3);

    private native void nativeSetTone(long var1, int var3);

    private native void nativeEnableDenoise(long var1, boolean var3);

    private native void nativeEnableDrc(long var1, boolean var3);

    private native void nativeSetEtbValue(long var1, int var3);

    private native void nativeSetVoiceOffset(long var1, int var3);

    private native boolean nativeOpenAutoToneFilePlayer(long var1, String var3);

    private native boolean nativeStopAutoToneFilePlayer(long var1);

    private native boolean nativeChooseAutoToneFilePlayer(long var1, boolean var3);

    private native boolean nativeIsAutoToneFilePlaying(long var1);

    private native void nativeEnableReverbNew(long var1, boolean var3);

    private native void nativeSetReverbNewParam(long var1, float[] var3);

    private native void nativeEnableEqualizer(long var1, boolean var3);

    private native void nativeSetEqGains(long var1, float[] var3);

    private native void nativeEnableCompressor(long var1, boolean var3);

    private native void nativeSetCompressorParam(long var1, int[] var3);

    private native void nativeEnableLimiter(long var1, boolean var3);

    private native void nativeSetLimiterParam(long var1, float[] var3);
}

