/*
 * Decompiled with CFR 0.152.
 */
package com.yy.audioengine;

import com.yy.audioengine.IKaraokeFileMixerNotity;
import com.yy.audioengine.MainHandler;
import com.yy.audioengine.YALog;
import java.util.Arrays;

public class KaraokeFileMixer {
    private static String TAG = "[KaraokeFileMixer]";
    private IKaraokeFileMixerNotity mNotify;
    private long mCtx;

    public void Init() {
        YALog.info(TAG + "Init....");
        this.mCtx = this.nativeCreateKaraokeFileMixer(this);
    }

    public void Destroy() {
        YALog.info(TAG + "Destroy....");
        this.nativeDestroyKaraokeFileMixer(this.mCtx);
        this.mNotify = null;
    }

    public void SetKaraokeFileMixerNotify(IKaraokeFileMixerNotity notify) {
        YALog.info(TAG + "SetKaraokeFileMixerNotify, notify: " + notify);
        this.mNotify = notify;
    }

    public boolean Open(String voiceFile, String accompanyFile) {
        YALog.info(TAG + "Open, voiceFile: " + voiceFile + " ,accompanyFile: " + accompanyFile);
        return this.nativeOpen(this.mCtx, voiceFile, accompanyFile);
    }

    public boolean Start(String fileName) {
        YALog.info(TAG + "Start, fileName: " + fileName);
        boolean res = this.nativeStart(this.mCtx, fileName);
        return res;
    }

    public void Stop() {
        YALog.info(TAG + "Stop....");
        this.nativeStop(this.mCtx);
    }

    public void SetVoiceOffset(int offsetTime) {
        YALog.info(TAG + "SetVoiceOffset, offsetTime: " + offsetTime);
        this.nativeSetVoiceOffset(this.mCtx, offsetTime);
    }

    public void SetEtbValue(int value) {
        YALog.info(TAG + "SetEtbValue, value: " + value);
        this.nativeSetEtbValue(this.mCtx, value);
    }

    public void EnableDenoise(boolean enable) {
        YALog.info(TAG + "EnableDenoise, enable: " + enable);
        this.nativeEnableDenoise(this.mCtx, enable);
    }

    public void SetVoiceVolume(int volume) {
        YALog.info(TAG + "SetVoiceVolume, volume: " + volume);
        this.nativeSetVoiceVolume(this.mCtx, volume);
    }

    public void SetAccompanyVolume(int volume) {
        YALog.info(TAG + "SetAccompanyVolume, volume: " + volume);
        this.nativeSetAccompanyVolume(this.mCtx, volume);
    }

    public void SetTone(int value) {
        YALog.info(TAG + "SetTone, value: " + value);
        this.nativeSetTone(this.mCtx, value);
    }

    public void EnableReverbNew(boolean enable) {
        YALog.info(TAG + "EnableReverbNew, enable: " + enable);
        this.nativeEnableReverbNew(this.mCtx, enable);
    }

    public void SetReverbNewParam(float[] array) {
        YALog.info(TAG + "SetReverbNewParam,array: " + Arrays.toString(array));
        this.nativeSetReverbNewParam(this.mCtx, array);
    }

    public void EnableEqualizer(boolean enable) {
        YALog.info(TAG + "EnableEqualizer, enable: " + enable);
        this.nativeEnableEqualizer(this.mCtx, enable);
    }

    public void SetEqGains(float[] array) {
        YALog.info(TAG + "SetEqGains,array: " + Arrays.toString(array));
        this.nativeSetEqGains(this.mCtx, array);
    }

    public void EnableCompressor(boolean enable) {
        YALog.info(TAG + "EnableCompressor, enable: " + enable);
        this.nativeEnableCompressor(this.mCtx, enable);
    }

    public void SetCompressorParam(int[] array) {
        YALog.info(TAG + "SetCompressorParam,array: " + Arrays.toString(array));
        this.nativeSetCompressorParam(this.mCtx, array);
    }

    public void EnableLimiter(boolean enable) {
        YALog.info(TAG + "EnableLimiter. enable: " + enable);
        this.nativeEnableLimiter(this.mCtx, enable);
    }

    public void SetLimiterParam(float[] array) {
        YALog.info(TAG + "SetLimiterParam,array: " + Arrays.toString(array));
        this.nativeSetLimiterParam(this.mCtx, array);
    }

    private void OnFileMixerState(long curTime, long totalTime) {
        if (this.mNotify != null) {
            this.mNotify.OnFileMixerState(curTime, totalTime);
        }
    }

    private void OnFinishMixer() {
        YALog.info(TAG + "OnFinishMixer...");
        MainHandler.getInstance().post(new Runnable(){

            @Override
            public void run() {
                if (KaraokeFileMixer.this.mNotify != null) {
                    KaraokeFileMixer.this.mNotify.OnFinishMixer();
                }
            }
        });
    }

    private native long nativeCreateKaraokeFileMixer(Object var1);

    private native void nativeDestroyKaraokeFileMixer(long var1);

    private native boolean nativeOpen(long var1, String var3, String var4);

    private native boolean nativeStart(long var1, String var3);

    private native void nativeStop(long var1);

    private native void nativeSetVoiceVolume(long var1, int var3);

    private native void nativeSetAccompanyVolume(long var1, int var3);

    private native void nativeSetTone(long var1, int var3);

    private native void nativeEnableDenoise(long var1, boolean var3);

    private native void nativeSetEtbValue(long var1, int var3);

    private native void nativeSetVoiceOffset(long var1, int var3);

    private native void nativeEnableReverbNew(long var1, boolean var3);

    private native void nativeSetReverbNewParam(long var1, float[] var3);

    private native void nativeEnableEqualizer(long var1, boolean var3);

    private native void nativeSetEqGains(long var1, float[] var3);

    private native void nativeEnableCompressor(long var1, boolean var3);

    private native void nativeSetCompressorParam(long var1, int[] var3);

    private native void nativeEnableLimiter(long var1, boolean var3);

    private native void nativeSetLimiterParam(long var1, float[] var3);
}

