/*
 * Decompiled with CFR 0.152.
 */
package com.yy.audioengine;

import com.yy.audioengine.AudioConfig;
import com.yy.audioengine.IAudioLibJniInit;
import com.yy.audioengine.IKaraokeNotify;
import com.yy.audioengine.LineInfo;
import com.yy.audioengine.MainHandler;
import com.yy.audioengine.TimeRange;
import com.yy.audioengine.YALog;

public class Karaoke {
    private static String TAG = "[Karaoke]";
    private IKaraokeNotify mNotify;
    private long mCtx;

    public void Init() {
        YALog.info(TAG + "Init...IsEnableLowLatencyPlayBack: " + AudioConfig.IsEnableLowLatencyPlayBack());
        if (AudioConfig.IsEnableLowLatencyPlayBack()) {
            IAudioLibJniInit.EnableAndroidOpenSlEs(true);
        }
        this.mCtx = this.nativeCreateKaraoke(this);
    }

    public void Destroy() {
        YALog.info(TAG + "Destroy....");
        this.nativeDestroyKaraoke(this.mCtx);
        this.mCtx = 0L;
        if (AudioConfig.IsEnableLowLatencyPlayBack()) {
            IAudioLibJniInit.EnableAndroidOpenSlEs(false);
        }
        this.mNotify = null;
    }

    public void SetKaraokeListener(IKaraokeNotify notify) {
        YALog.info(TAG + "SetKaraokeListener, notify: " + notify);
        this.mNotify = notify;
    }

    public boolean OpenInputFile(String mixerFile, String accompanyFile) {
        YALog.info(TAG + "OpenInputFile, mixerFile: " + mixerFile + " ,accompanyFile: " + accompanyFile);
        return this.nativeOpenInputFile(this.mCtx, mixerFile, accompanyFile);
    }

    public boolean OpenOutputFile(String voiceRecordFile, String accompanyRecordFile) {
        YALog.info(TAG + "OpenOutputFile, voiceRecordFile: " + voiceRecordFile + " ,accompanyRecordFile: " + accompanyRecordFile);
        return this.nativeOpenOutputFile(this.mCtx, voiceRecordFile, accompanyRecordFile);
    }

    public boolean OpenMixFile(String mixFile) {
        YALog.info(TAG + "OpenMixFile, mixFile: " + mixFile);
        return this.nativeOpenMixFile(this.mCtx, mixFile);
    }

    public boolean OpenAccompanyFile(String accompanyFile) {
        YALog.info(TAG + "OpenAccompanyFile, accompanyFile: " + accompanyFile);
        return this.nativeOpenAccompanyFile(this.mCtx, accompanyFile);
    }

    public void Start() {
        YALog.info(TAG + "Start....");
        this.nativeStart(this.mCtx);
    }

    public void Pause() {
        YALog.info(TAG + "Pause....");
        this.nativePause(this.mCtx);
    }

    public void Resume() {
        YALog.info(TAG + "Resume....");
        this.nativeResume(this.mCtx);
    }

    public void Stop() {
        YALog.info(TAG + "Stop....");
        this.nativeStop(this.mCtx);
    }

    public boolean Seek(long seekTime) {
        YALog.info(TAG + "Seek, seekTime: " + seekTime);
        return this.nativeSeek(this.mCtx, seekTime);
    }

    public boolean SeekToEnd(long seekTime) {
        YALog.info(TAG + "SeekToEnd, seekTime: " + seekTime);
        return this.nativeSeekToEnd(this.mCtx, seekTime);
    }

    public boolean SetLyricPauseTime(long pauseTime) {
        YALog.info(TAG + "SetPause, pauseTime: " + pauseTime);
        return this.nativeSetLyricPauseTime(this.mCtx, pauseTime);
    }

    public byte[] SetScoreTimeRange(TimeRange[] timeRanges, int count) {
        return this.nativeSetScoreTimeRange(this.mCtx, timeRanges, count);
    }

    public void SetLineInfo(LineInfo[] lineInfo, int lineNum) {
        this.nativeSetLineInfo(this.mCtx, lineInfo, lineNum);
    }

    public long GetPlayerTime() {
        return this.nativeGetPlayerTime(this.mCtx);
    }

    public long GetCurrentPlayerTime() {
        return this.nativeGetCurrentPlayerTime(this.mCtx);
    }

    public void SetVoiceVolume(int volume) {
        YALog.info(TAG + "SetVoiceVolume: " + volume);
        this.nativeSetVoiceVolume(this.mCtx, volume);
    }

    public void SetAccompanyVolume(int volume) {
        YALog.info(TAG + "SetAccompanyVolume: " + volume);
        this.nativeSetAccompanyVolume(this.mCtx, volume);
    }

    public void SetTone(int tone) {
        YALog.info(TAG + "SetTone: " + tone);
        this.nativeSetTone(this.mCtx, tone);
    }

    public void SetDisplayTolerate(float lowValue, float highValue) {
        YALog.info(TAG + "SetDisplayTolerate, lowValue" + lowValue + " ,highValue: " + highValue);
        this.nativeSetDisplayTolerate(this.mCtx, lowValue, highValue);
    }

    public boolean SetChooseMixFilePlay(boolean mixPlay) {
        YALog.info(TAG + "SetChooseMixFilePlay: " + mixPlay);
        return this.nativeSetChooseMixFilePlay(this.mCtx, mixPlay);
    }

    public boolean EnablePlayBack(boolean enable) {
        YALog.info(TAG + "EnablePlayBack: " + enable);
        return this.nativeEnablePlayBack(this.mCtx, enable);
    }

    public boolean IsRecordPlayBackEnable() {
        return this.nativeIsRecordPlayBackEnable(this.mCtx);
    }

    public void EnableReverbNew(boolean enable) {
        this.nativeEnableReverbNew(this.mCtx, enable);
    }

    public void SetReverbNewParam(float[] array) {
        this.nativeSetReverbNewParam(this.mCtx, array);
    }

    public void EnableEqualizer(boolean enable) {
        this.nativeEnableEqualizer(this.mCtx, enable);
    }

    public void SetEqGains(float[] array) {
        this.nativeSetEqGains(this.mCtx, array);
    }

    public void EnableCompressor(boolean enable) {
        this.nativeEnableCompressor(this.mCtx, enable);
    }

    public void SetCompressorParam(int[] array) {
        this.nativeSetCompressorParam(this.mCtx, array);
    }

    public void EnableLimiter(boolean enable) {
        this.nativeEnableLimiter(this.mCtx, enable);
    }

    public void SetLimiterParam(float[] array) {
        this.nativeSetLimiterParam(this.mCtx, array);
    }

    private void OnPlayerEnd() {
        if (this.mNotify != null) {
            this.mNotify.OnKaraokePlayEnd();
        }
    }

    private void OnPlayerVolume(final long volume, final long currentTime, final long totalTime) {
        MainHandler.getInstance().post(new Runnable(){

            @Override
            public void run() {
                if (Karaoke.this.mNotify != null) {
                    Karaoke.this.mNotify.OnKaraokeCurrentPlayVolume(volume, currentTime, totalTime);
                }
            }
        });
    }

    private void OnAudioVolumeVisual(final long volume, final long recordTime) {
        MainHandler.getInstance().post(new Runnable(){

            @Override
            public void run() {
                if (Karaoke.this.mNotify != null) {
                    Karaoke.this.mNotify.OnKaraokeCurrentRecordVolume(volume, recordTime);
                }
            }
        });
    }

    private void OnAudioRecordError() {
        YALog.error(TAG + "OnAudioRecordError...");
        if (this.mNotify != null) {
            this.mNotify.OnKaraokeInitError();
        }
    }

    private void OnCalcKaraokeScore(byte score, long lineId) {
        if (this.mNotify != null) {
            this.mNotify.OnKaraokeScore(score, lineId);
        }
    }

    private void OnSingerPitchVisual(byte val, long lineId, long wordId, long wordNum) {
        if (this.mNotify != null) {
            this.mNotify.OnKaraokePitch(val, lineId, wordId, wordNum);
        }
    }

    private void OnFirstPlayData() {
        YALog.info(TAG + "OnFirstPlayData...");
        if (this.mNotify != null) {
            this.mNotify.OnKaraokeFirstPlayData();
        }
    }

    private native long nativeCreateKaraoke(Object var1);

    private native void nativeDestroyKaraoke(long var1);

    private native boolean nativeOpenInputFile(long var1, String var3, String var4);

    private native boolean nativeOpenOutputFile(long var1, String var3, String var4);

    private native boolean nativeOpenMixFile(long var1, String var3);

    private native boolean nativeOpenAccompanyFile(long var1, String var3);

    private native void nativeStart(long var1);

    private native void nativePause(long var1);

    private native void nativeResume(long var1);

    private native void nativeStop(long var1);

    private native boolean nativeSeek(long var1, long var3);

    private native boolean nativeSeekToEnd(long var1, long var3);

    private native boolean nativeSetLyricPauseTime(long var1, long var3);

    private native byte[] nativeSetScoreTimeRange(long var1, TimeRange[] var3, long var4);

    private native void nativeSetLineInfo(long var1, LineInfo[] var3, long var4);

    private native long nativeGetPlayerTime(long var1);

    private native long nativeGetCurrentPlayerTime(long var1);

    private native void nativeSetVoiceVolume(long var1, int var3);

    private native void nativeSetAccompanyVolume(long var1, int var3);

    private native void nativeSetTone(long var1, int var3);

    private native void nativeSetDisplayTolerate(long var1, float var3, float var4);

    private native boolean nativeSetChooseMixFilePlay(long var1, boolean var3);

    private native boolean nativeEnablePlayBack(long var1, boolean var3);

    private native boolean nativeIsRecordPlayBackEnable(long var1);

    private native void nativeEnableReverbNew(long var1, boolean var3);

    private native void nativeSetReverbNewParam(long var1, float[] var3);

    private native void nativeEnableEqualizer(long var1, boolean var3);

    private native void nativeSetEqGains(long var1, float[] var3);

    private native void nativeEnableCompressor(long var1, boolean var3);

    private native void nativeSetCompressorParam(long var1, int[] var3);

    private native void nativeEnableLimiter(long var1, boolean var3);

    private native void nativeSetLimiterParam(long var1, float[] var3);
}

