/*
 * Decompiled with CFR 0.152.
 */
package com.yy.audioengine;

import com.yy.audioengine.AudioEngine;
import com.yy.audioengine.Constant;
import com.yy.audioengine.FilePlayer;
import com.yy.audioengine.IAudioRecordToolNotify;
import com.yy.audioengine.IFilePlayerNotify;
import com.yy.audioengine.ISpeechMsgRecorderNotify;
import com.yy.audioengine.MainHandler;
import com.yy.audioengine.SpeechMsgRecorder;
import com.yy.audioengine.YALog;

public class AudioRecordTool
implements IFilePlayerNotify,
ISpeechMsgRecorderNotify {
    private static String TAG = "[AudioRecordTool]";
    private IAudioRecordToolNotify mNotify;
    private AudioEngine mAudioEngine;
    private FilePlayer mAccompanyFilePlayer;
    private SpeechMsgRecorder mRecorder;

    public void initWithAccompanyPath(String accompanyPath) {
        YALog.info(TAG + "initWithAccompanyPath: " + accompanyPath);
        this.mAudioEngine = new AudioEngine();
        this.mAudioEngine.StartAudioEngine(Constant.AudioEngineMode.Broadcast);
        this.mAudioEngine.SetLoudspeakerStatus(true);
        this.mAccompanyFilePlayer = new FilePlayer();
        this.mAccompanyFilePlayer.EnableVolumeNotify(true);
        this.mAccompanyFilePlayer.Open(accompanyPath);
    }

    public void destroy() {
        YALog.info(TAG + "destroy...");
        if (this.mRecorder != null) {
            this.mRecorder.Destroy();
            this.mRecorder = null;
        }
        if (this.mAccompanyFilePlayer != null) {
            this.mAccompanyFilePlayer.Destroy();
            this.mAccompanyFilePlayer = null;
        }
        if (this.mAudioEngine != null) {
            this.mAudioEngine.Destroy();
            this.mAudioEngine = null;
        }
        this.mNotify = null;
    }

    public void setAudioRecordToolNotify(IAudioRecordToolNotify iAudioRecordToolNotify) {
        YALog.info(TAG + "setAudioRecordToolNotify...");
        this.mNotify = iAudioRecordToolNotify;
    }

    public void startRecord() {
        YALog.info(TAG + "startRecord...");
        if (this.mRecorder != null) {
            this.mRecorder.Start(this);
        }
    }

    public void pauseRecord() {
        YALog.info(TAG + "pauseRecord...");
        if (this.mRecorder != null) {
            this.mRecorder.Pause();
        }
    }

    public void resumeRecord() {
        YALog.info(TAG + "resumeRecord...");
        if (this.mRecorder != null) {
            this.mRecorder.Resume();
        }
    }

    public void stopRecord() {
        YALog.info(TAG + "stopRecord...");
        if (this.mRecorder != null) {
            this.mRecorder.Stop();
        }
    }

    public void startPlayAccompany() {
        YALog.info(TAG + "startPlayAccompany...");
        if (this.mAccompanyFilePlayer != null) {
            this.mAccompanyFilePlayer.RegisterNotify(this);
            this.mAccompanyFilePlayer.Play();
            this.mAccompanyFilePlayer.EnableLoopPlay(true);
        }
    }

    public void pauseAccompany() {
        YALog.info(TAG + "pauseAccompany...");
        if (this.mAccompanyFilePlayer != null) {
            this.mAccompanyFilePlayer.FakePause();
        }
    }

    public void resumeAccompany() {
        YALog.info(TAG + "resumeAccompany...");
        if (this.mAccompanyFilePlayer != null) {
            this.mAccompanyFilePlayer.Resume();
        }
    }

    public void stopAccompany() {
        YALog.info(TAG + "stopAccompany...");
        if (this.mAccompanyFilePlayer != null) {
            this.mAccompanyFilePlayer.Stop();
            this.mAccompanyFilePlayer.StopSaver();
        }
    }

    public void setVoiceFilePath(String audioPath) {
        YALog.info(TAG + "setVoiceFilePath: " + audioPath);
        if (this.mRecorder != null) {
            this.mRecorder.Destroy();
            this.mRecorder = null;
        }
        this.mRecorder = new SpeechMsgRecorder(audioPath, 0, SpeechMsgRecorder.SpeechMsgCodecType.SpeechMsgCodecWav, 600000L);
        this.mRecorder.Init();
    }

    public void setAcmpyWavFilePath(String accompanyFilePath) {
        YALog.info(TAG + "setAcmpyWavFilePath: " + accompanyFilePath);
        if (this.mAccompanyFilePlayer != null) {
            this.mAccompanyFilePlayer.StartSaver(accompanyFilePath);
        }
    }

    public void setVoiceVolume(int volume) {
        if (this.mRecorder != null) {
            this.mRecorder.SetVolume(volume);
        }
    }

    public void setAccompanyVolume(int volume) {
        if (this.mAccompanyFilePlayer != null) {
            this.mAccompanyFilePlayer.SetPlayerVolume(volume);
        }
    }

    @Override
    public void OnPlayerEnd() {
        YALog.info(TAG + "OnPlayerEnd...");
        MainHandler.getInstance().post(new Runnable(){

            @Override
            public void run() {
                if (AudioRecordTool.this.mNotify != null) {
                    AudioRecordTool.this.mNotify.accompanyPlayEnd();
                }
            }
        });
    }

    @Override
    public void OnPlayerVolume(int volume, long currentTime, long totalTime) {
        if (this.mNotify != null) {
            this.mNotify.accompanyPlayVolume(volume, currentTime, totalTime);
        }
    }

    @Override
    public void OnAudioVolumeVisual(long recordTime, long volume) {
        if (this.mNotify != null) {
            this.mNotify.voiceRecordVolume(volume, recordTime);
        }
    }

    @Override
    public void OnAudioRecordError() {
        if (this.mNotify != null) {
            this.mNotify.onAudioRecordError();
        }
    }

    @Override
    public void OnGetFirstRecordData() {
        if (this.mNotify != null) {
            this.mNotify.onGetFirstRecordData();
        }
    }

    @Override
    public void OnStopRecordData(long recordTime, long maxDuration) {
        if (this.mNotify != null) {
            this.mNotify.onStopRecordData(recordTime, maxDuration);
        }
    }

    @Override
    public void OnReachMaxDuration(long recordTime, long maxDuration) {
        YALog.info(TAG + "OnReachMaxDuration, recordTime: " + recordTime + " ,maxDuration: " + maxDuration);
        MainHandler.getInstance().post(new Runnable(){

            @Override
            public void run() {
                if (AudioRecordTool.this.mNotify != null) {
                    AudioRecordTool.this.mNotify.OnReachMaxDuration();
                }
            }
        });
    }
}

