/*
 * Decompiled with CFR 0.152.
 */
package com.yy.audioengine;

import com.yy.audioengine.AudioEngine;
import com.yy.audioengine.AudioFileMixer;
import com.yy.audioengine.AudioFileMixerPoint;
import com.yy.audioengine.Constant;
import com.yy.audioengine.FilePlayer;
import com.yy.audioengine.IAudioPlayBackAndMixNotify;
import com.yy.audioengine.IFileMixerNotify;
import com.yy.audioengine.IFilePlayerNotify;
import com.yy.audioengine.MainHandler;
import com.yy.audioengine.YALog;

public class AudioPlayBackAndMix
implements IFilePlayerNotify,
IFileMixerNotify {
    private static String TAG = "[AudioPlayBackAndMix]";
    private IAudioPlayBackAndMixNotify mNotify;
    private AudioEngine mAudioEngine;
    private FilePlayer mVoicePlayer;
    private FilePlayer mAccompanyFilePlayer;
    private AudioFileMixer mAudioFileMixer;
    private AudioFileMixerPoint mVoicePoint;
    private AudioFileMixerPoint mAccompanyPoint;
    private String mAacOutPath;

    public void initWithOutputAACPath(String aacOutPath) {
        YALog.info(TAG + "initWithOutputAACPath: " + aacOutPath);
        this.mAacOutPath = aacOutPath;
        this.mAudioEngine = new AudioEngine();
        this.mAudioEngine.StartAudioEngine(Constant.AudioEngineMode.Broadcast);
        this.mVoicePlayer = new FilePlayer();
        this.mAccompanyFilePlayer = new FilePlayer();
        this.mVoicePlayer.EnableVolumeNotify(true);
        this.mAccompanyFilePlayer.EnableVolumeNotify(true);
        this.mAudioFileMixer = new AudioFileMixer();
        this.mAudioFileMixer.RegisterNotify(this);
    }

    public void destroy() {
        YALog.info(TAG + "destroy....");
        if (this.mAccompanyFilePlayer != null) {
            this.mAccompanyFilePlayer.Destroy();
            this.mAccompanyFilePlayer = null;
        }
        if (this.mVoicePlayer != null) {
            this.mVoicePlayer.Destroy();
            this.mVoicePlayer = null;
        }
        if (this.mVoicePoint != null) {
            this.mVoicePoint.Close();
            this.mVoicePoint = null;
        }
        if (this.mAccompanyPoint != null) {
            this.mAccompanyPoint.Close();
            this.mVoicePoint = null;
        }
        if (this.mAudioFileMixer != null) {
            this.mAudioFileMixer.Destroy();
            this.mAudioFileMixer = null;
        }
        if (this.mAudioEngine != null) {
            this.mAudioEngine.Destroy();
            this.mAudioEngine = null;
        }
        this.mNotify = null;
    }

    public void setAudioPlayBackAndMixNotify(IAudioPlayBackAndMixNotify iAudioPlayBackAndMixNotify) {
        this.mNotify = iAudioPlayBackAndMixNotify;
    }

    public void startPlay() {
        YALog.info(TAG + "startPlay....");
        if (this.mVoicePlayer != null) {
            this.mVoicePlayer.Play();
        }
        if (this.mAccompanyFilePlayer != null) {
            this.mAccompanyFilePlayer.Play();
        }
    }

    public void pausePlay() {
        YALog.info(TAG + "pausePlay....");
        if (this.mVoicePlayer != null) {
            this.mVoicePlayer.Pause();
        }
        if (this.mAccompanyFilePlayer != null) {
            this.mAccompanyFilePlayer.Pause();
        }
    }

    public void resumePlay() {
        YALog.info(TAG + "resumePlay....");
        if (this.mVoicePlayer != null) {
            this.mVoicePlayer.Resume();
        }
        if (this.mAccompanyFilePlayer != null) {
            this.mAccompanyFilePlayer.Resume();
        }
    }

    public void stopPlay() {
        YALog.info(TAG + "stopPlay....");
        if (this.mVoicePlayer != null) {
            this.mVoicePlayer.Stop();
        }
        if (this.mAccompanyFilePlayer != null) {
            this.mAccompanyFilePlayer.Stop();
        }
    }

    public void startMixVoice() {
        YALog.info(TAG + "startMixVoice....");
        if (this.mAudioFileMixer != null) {
            this.mAudioFileMixer.Start(this.mAacOutPath);
        }
    }

    public void stopMixVoice() {
        YALog.info(TAG + "stopMixVoice....");
        if (this.mAudioFileMixer != null) {
            this.mAudioFileMixer.Stop();
        }
    }

    public void setVoiceFilePath(String voicePath) {
        AudioFileMixerPoint point;
        YALog.info(TAG + "setVoiceFilePath....: " + voicePath);
        this.mVoicePlayer.Open(voicePath);
        this.mVoicePlayer.RegisterNotify(this);
        if (this.mVoicePoint != null) {
            this.mVoicePoint.Close();
            this.mVoicePoint = null;
        }
        if ((point = this.mAudioFileMixer.CreateMixerPoint()).Open(voicePath)) {
            this.mVoicePoint = point;
        } else {
            point.Close();
        }
    }

    public void setAccompanyFilePath(String accompanyFilePath) {
        AudioFileMixerPoint point;
        YALog.info(TAG + "setAccompanyFilePath....: " + accompanyFilePath);
        this.mAccompanyFilePlayer.Open(accompanyFilePath);
        if (this.mAccompanyPoint != null) {
            this.mAccompanyPoint.Close();
            this.mAccompanyPoint = null;
        }
        if ((point = this.mAudioFileMixer.CreateMixerPoint()).Open(accompanyFilePath)) {
            this.mAccompanyPoint = point;
        } else {
            point.Close();
        }
    }

    @Override
    public void OnFileMixerState(long curTime, long totalTime) {
        if (this.mNotify != null) {
            this.mNotify.fileMixerProgress(curTime, totalTime);
        }
    }

    @Override
    public void OnFinishMixer() {
        YALog.info(TAG + "OnFinishMixer....");
        MainHandler.getInstance().post(new Runnable(){

            @Override
            public void run() {
                if (AudioPlayBackAndMix.this.mNotify != null) {
                    AudioPlayBackAndMix.this.mNotify.finishMixer();
                }
            }
        });
    }

    @Override
    public void OnPlayerEnd() {
        YALog.info(TAG + "OnPlayerEnd....");
        MainHandler.getInstance().post(new Runnable(){

            @Override
            public void run() {
                if (AudioPlayBackAndMix.this.mNotify != null) {
                    AudioPlayBackAndMix.this.mNotify.playBackEnd();
                }
            }
        });
    }

    @Override
    public void OnPlayerVolume(int volume, long currentTime, long totalTime) {
        if (this.mNotify != null) {
            this.mNotify.playBackProgress(volume, currentTime, totalTime);
        }
    }
}

