/*
 * Decompiled with CFR 0.152.
 */
package com.yy.audioengine;

import com.yy.audioengine.Constant;
import com.yy.audioengine.IAudioCaptureNotify;
import com.yy.audioengine.IAudioEngine;
import com.yy.audioengine.IAudioEngineNotify;
import com.yy.audioengine.IAudioPullFrameInfo;
import com.yy.audioengine.IAudioPullFrameNotify;
import com.yy.audioengine.IAudioRenderInfo;
import com.yy.audioengine.IAudioRenderNotify;
import com.yy.audioengine.IKaraokeScoreNotify;
import com.yy.audioengine.ISpeechMsgPlayerNotify;
import com.yy.audioengine.ISpeechMsgRecorderNotify;
import com.yy.audioengine.SpeechMsgPlayer;
import com.yy.audioengine.SpeechMsgRecorder;
import com.yy.audioengine.TimeRange;

public class AudioEngine
implements IAudioEngine {
    private static final String TAG = "AudioEngine";
    private long engineCtx = this.nativeCreateAudioEngine(this);
    private IAudioCaptureNotify mCaptureNotify = null;
    private IAudioPullFrameNotify mPullFrameNotify = null;
    private IAudioRenderNotify mRenderNotify = null;
    private SpeechMsgRecorder mSpeechMsgRecorder;
    private SpeechMsgPlayer mSpeechMsgPlayer;
    private IAudioEngineNotify mAudioEngineNotify = null;
    private IKaraokeScoreNotify mKaraokeScoreNotify;

    public void Destroy() {
        this.nativeDestroyAudioEngine(this.engineCtx);
        this.engineCtx = 0L;
    }

    @Override
    public void StartAudioEngine(Constant.AudioEngineMode mode) {
        this.nativeStartAudioEngine(this.engineCtx, mode.ordinal());
    }

    @Override
    public void StopAudioEngine() {
        this.nativeStopAudioEngine(this.engineCtx);
    }

    public void SetAudioEngineNotify(IAudioEngineNotify notify) {
        this.mAudioEngineNotify = notify;
    }

    public void StartCapture(IAudioCaptureNotify notify, Constant.EncoderType encoderType) {
        this.mCaptureNotify = notify;
        this.nativeStartCapture(this.engineCtx, encoderType.ordinal());
    }

    public void EnablePackerVad(boolean enable) {
        this.nativeEnablePackerVad(this.engineCtx, enable);
    }

    public void StopCapture() {
        this.nativeStopCapture(this.engineCtx);
    }

    public void StartPlayout(long uid, IAudioPullFrameNotify notify) {
        this.mPullFrameNotify = notify;
        this.nativeStartPlay(this.engineCtx, uid);
    }

    public void StartPlayout2(long uid, IAudioRenderNotify notify) {
        this.mRenderNotify = notify;
        this.nativeStartPlay(this.engineCtx, uid);
    }

    public void StopPlayout(long uid) {
        this.nativeStopPlay(this.engineCtx, uid);
    }

    public void SetVirtualSpeakerVolume(int volume) {
        this.nativeSetVirtualSpeakerVolume(this.engineCtx, volume);
    }

    public void SetVirtualMicVolume(int volume) {
        this.nativeSetVirtualMicVolume(this.engineCtx, volume);
    }

    public boolean StartAudioSaver(String fileName, Constant.AudioSaverMode mode, Constant.AudioSaverWriteFileMode wfMode) {
        int modeInt = mode.ordinal();
        int wfModeInt = wfMode.ordinal();
        return this.nativeStartAudioSaver(this.engineCtx, fileName, modeInt, wfModeInt);
    }

    public boolean StopAudioSaver() {
        return this.nativeStopAudioSaver(this.engineCtx);
    }

    public void StartSpeechMsgRecorder(String fileName, SpeechMsgRecorder.SpeechMsgCodecType codecType, int maxTime, ISpeechMsgRecorderNotify cb) {
        this.mSpeechMsgRecorder = new SpeechMsgRecorder(fileName, 1, codecType, maxTime);
        this.mSpeechMsgRecorder.Init();
        this.mSpeechMsgRecorder.Start(cb);
    }

    public void StopSpeechMsgRecorder() {
        this.mSpeechMsgRecorder.Stop();
        this.mSpeechMsgRecorder.Destroy();
        this.mSpeechMsgRecorder = null;
    }

    public void StartSpeechMsgPlayer(String fileName, ISpeechMsgPlayerNotify cb) {
        this.mSpeechMsgPlayer = new SpeechMsgPlayer(fileName);
        this.mSpeechMsgPlayer.Init();
        this.mSpeechMsgPlayer.Start(cb);
    }

    public void StopSpeechMsgPlayer() {
        this.mSpeechMsgPlayer.Stop();
        this.mSpeechMsgPlayer.Destroy();
    }

    public void SetReverbMode(Constant.ReverbMode mode) {
        int modeInt = mode.ordinal();
        this.nativeSetReverbmode(this.engineCtx, modeInt);
    }

    public void EnableRenderVolumeNotify(boolean enable) {
        this.nativeEnableRenderVolumeNotify(this.engineCtx, enable);
    }

    public void EnableCaptureVolumeNotify(boolean enable) {
        this.nativeEnableCaptureVolumeNotify(this.engineCtx, enable);
    }

    public void EnableVoiceBeautify(boolean enable) {
        this.nativeEnableVoiceBeautify(this.engineCtx, enable);
    }

    public void SetVoiceBeautifyMode(Constant.VoiceBeautifyMode mode) {
        int modeInt = mode.ordinal();
        float pitch = 0.0f;
        float reverb = 0.0f;
        this.nativeSetVoiceBeautifyMode(this.engineCtx, modeInt, pitch, reverb);
    }

    public void SetVoiceChangerMode(Constant.VoiceChangerMode mode) {
        int modeInt = mode.ordinal();
        this.nativeSetVoiceChangerMode(this.engineCtx, modeInt);
    }

    public void StartWavDebugLogger(String Path) {
        this.nativeStartWavDebugLogger(this.engineCtx, Path);
    }

    public void StopWavDebugLogger() {
        this.nativeStopWavDebugLogger(this.engineCtx);
    }

    public boolean IsHeadsetMode() {
        return true;
    }

    public void EnableEqualizer(boolean enable) {
        this.nativeEnableEqualizer(this.engineCtx, enable);
    }

    public void SetEqualizerParameter(float[] parameter_array) {
        this.nativeSetEqualizerParameter(this.engineCtx, parameter_array);
    }

    public void EnableReverbEx(boolean enable) {
        this.nativeEnableReverbEx(this.engineCtx, enable);
    }

    public void SetReverbParameter(float[] parameter_array) {
        this.nativeSetReverbParamEx(this.engineCtx, parameter_array);
    }

    public void EnableLimiter(boolean enable) {
        this.nativeEnableLimiter(this.engineCtx, enable);
    }

    public void SetLimiterParameter(float[] parameter_array) {
        this.nativeSetLimiterParameter(this.engineCtx, parameter_array);
    }

    public void EnableCompressor(boolean enable) {
        this.nativeEnableCompressor(this.engineCtx, enable);
    }

    public void SetCompressor(int[] parameter_array) {
        this.nativeSetCompressorParameter(this.engineCtx, parameter_array);
    }

    public void StartAudioPreview() {
        this.nativeStartAudioPreview(this.engineCtx);
    }

    public void StopAudioPreview() {
        this.nativeStopAudioPreview(this.engineCtx);
    }

    public void SetLoudspeakerStatus(boolean enable) {
        this.nativeSetLoudspeakerStatus(this.engineCtx, enable);
    }

    public void EnableKaraokeScoreEx(boolean enable) {
        this.nativeEnableKaraokeScoreEx(this.engineCtx, enable);
    }

    public void EnableKaraokeScore(boolean enable) {
        this.nativeEnableKaraokeScore(this.engineCtx, enable);
    }

    public void StartKaraokeScore(IKaraokeScoreNotify notify) {
        this.mKaraokeScoreNotify = notify;
        this.nativeStartKaraokeScore(this.engineCtx);
    }

    public void PauseKaraokeScore(boolean enable) {
        this.nativePauseKaraokeScore(this.engineCtx, enable);
    }

    public void StopKaraokeScore() {
        this.nativeStopKaraokeScore(this.engineCtx);
    }

    public void ResetKaraokeScore(long value) {
        this.nativeResetKaraokeScore(this.engineCtx, value);
    }

    public boolean OpenScoreRefFile(String fileName) {
        return this.nativeOpenScoreRefFile(this.engineCtx, fileName);
    }

    public byte[] SetScoreTimeRange(TimeRange[] timeRanges, int count) {
        return this.nativeSetScoreTimeRange(this.engineCtx, timeRanges, count);
    }

    public void EnableSingingAutoTune(boolean enable) {
        this.nativeEnableSingingAutoTune(this.engineCtx, enable);
    }

    public void SetCurrentPlayingPosition(long value) {
        this.nativeSetCurrentPlayingPosition(this.engineCtx, value);
    }

    public boolean SetSingRefPitchFile(String fileName) {
        return this.nativeSetSingRefPitchFile(this.engineCtx, fileName);
    }

    public boolean SetSingRefLyricTimeRange(TimeRange[] timeRanges, int count) {
        return this.nativeSetSingRefLyricTimeRange(this.engineCtx, timeRanges, count);
    }

    public boolean SetSingRefLyricFile(String fileName) {
        return this.nativeSetSingRefLyricFile(this.engineCtx, fileName);
    }

    public boolean SetSingRefMfccFile(String fileName) {
        return this.nativeSetSingRefMfccFile(this.engineCtx, fileName);
    }

    public boolean OneKeySingingAutoTuneProcess(int mode, String inputPath, String outputPath) {
        return this.nativeOneKeySingingAutoTuneProcess(this.engineCtx, mode, inputPath, outputPath);
    }

    public boolean SetPlaybackModeOn(boolean enable) {
        return this.nativeSetPlaybackModeOn(this.engineCtx, enable);
    }

    public boolean SetPlayBackVolume(long volume) {
        return this.nativeSetPlayBackVolume(this.engineCtx, volume);
    }

    public void SetDspExEnable(boolean enable) {
        this.nativeSetDspExEnable(this.engineCtx, enable);
    }

    public void SetDspExReverbEnable(boolean enable) {
        this.nativeSetDspExReverbEnable(this.engineCtx, enable);
    }

    public void SetDspExLimiterEnable(boolean enable) {
        this.nativeSetDspExLimiterEnable(this.engineCtx, enable);
    }

    public void SetDspExEqEnable(boolean enable) {
        this.nativeSetDspExEqEnable(this.engineCtx, enable);
    }

    public void SetDspExReverbParam(float[] parameter_array) {
        this.nativeSetDspExReverbParam(this.engineCtx, parameter_array);
    }

    public void SetDspExLimiterParameter(float[] parameter_array) {
        this.nativeSetDspExLimiterParameter(this.engineCtx, parameter_array);
    }

    public void SetDspExEqGain(float[] parameter_array) {
        this.nativeSetDspEqualizerParameter(this.engineCtx, parameter_array);
    }

    private void OnEncodedAudioDataEvent(byte[] data, long timeStamp, int ssrc) {
        if (this.mCaptureNotify != null) {
            this.mCaptureNotify.OnEncodedAudioData(data, timeStamp, ssrc);
        }
    }

    private void OnCaptureAudioVolumeEvent(int volume) {
        if (this.mCaptureNotify != null) {
            this.mCaptureNotify.OnCaptureAudioVolume(volume);
        }
    }

    private IAudioRenderInfo OnRenderAudioDataEvent(int dataSize, int nBytesPerSample, int playoutDelayMS) {
        if (this.mRenderNotify != null) {
            return this.mRenderNotify.OnRenderAudioData(dataSize, nBytesPerSample, playoutDelayMS);
        }
        return null;
    }

    private IAudioPullFrameInfo OnPullAudioFrameEvent(long id, boolean forcePull, boolean acceleratePlay, boolean fasterPlayOn, boolean stretchPlay, double accelerateMS, double stretchMS, double playDelayMS) {
        if (this.mPullFrameNotify != null) {
            return this.mPullFrameNotify.OnPullAudioFrame(id, forcePull, acceleratePlay, fasterPlayOn, stretchPlay, accelerateMS, stretchMS, playDelayMS);
        }
        return null;
    }

    private void OnAudioCaptureErrorEvent(int errorType) {
        if (this.mAudioEngineNotify != null) {
            Constant.AudioDeviceErrorType error = Constant.AudioDeviceErrorType.values()[errorType];
            this.mAudioEngineNotify.OnAudioCaptureError(error);
        }
    }

    private void OnAudioRenderErrorEvent(int errorType) {
        if (this.mAudioEngineNotify != null) {
            Constant.AudioDeviceErrorType error = Constant.AudioDeviceErrorType.values()[errorType];
            this.mAudioEngineNotify.OnAudioRenderError(error);
        }
    }

    private void OnReceivePhoneCallEvent(boolean isInCall) {
        if (this.mAudioEngineNotify != null) {
            this.mAudioEngineNotify.OnReceivePhoneCall(isInCall);
        }
    }

    private void OnAudioModeChangeEvent() {
        if (this.mAudioEngineNotify != null) {
            this.mAudioEngineNotify.OnAudioModeChange();
        }
    }

    private void OnHeadsetPlugEvent(boolean enable) {
        if (this.mAudioEngineNotify != null) {
            this.mAudioEngineNotify.OnHeadsetPlug(enable);
        }
    }

    private void OnCalcKaraokeScore(byte score, long lineId) {
        if (this.mKaraokeScoreNotify != null) {
            this.mKaraokeScoreNotify.OnCalcKaraokeScore(score, lineId);
        }
    }

    private void OnSingerPitchVisual(byte val, long lineId, long wordId, long wordNum) {
        if (this.mKaraokeScoreNotify != null) {
            this.mKaraokeScoreNotify.OnSingerPitchVisual(val, lineId, wordId, wordNum);
        }
    }

    private native long nativeCreateAudioEngine(Object var1);

    private native void nativeDestroyAudioEngine(long var1);

    private native void nativeStartAudioEngine(long var1, int var3);

    private native void nativeStopAudioEngine(long var1);

    private native void nativeStartCapture(long var1, int var3);

    private native void nativeEnablePackerVad(long var1, boolean var3);

    private native void nativeStopCapture(long var1);

    private native void nativeStartPlay(long var1, long var3);

    private native void nativeStopPlay(long var1, long var3);

    private native void nativeEnableCaptureVolumeNotify(long var1, boolean var3);

    private native void nativeEnableRenderVolumeNotify(long var1, boolean var3);

    private native void nativeSetVirtualSpeakerVolume(long var1, int var3);

    private native void nativeSetVirtualMicVolume(long var1, int var3);

    private native boolean nativeStartAudioSaver(long var1, String var3, int var4, int var5);

    private native boolean nativeStopAudioSaver(long var1);

    private native void nativeEnableVoiceBeautify(long var1, boolean var3);

    private native void nativeSetVoiceBeautifyMode(long var1, int var3, float var4, float var5);

    private native void nativeSetVoiceChangerMode(long var1, int var3);

    private native void nativeSetReverbmode(long var1, int var3);

    private native void nativeStartWavDebugLogger(long var1, String var3);

    private native void nativeStopWavDebugLogger(long var1);

    private native void nativeSetEqualizerParameter(long var1, float[] var3);

    private native void nativeEnableEqualizer(long var1, boolean var3);

    private native void nativeEnableReverbEx(long var1, boolean var3);

    private native void nativeEnableCompressor(long var1, boolean var3);

    private native void nativeEnableLimiter(long var1, boolean var3);

    private native void nativeSetReverbParamEx(long var1, float[] var3);

    private native void nativeSetLimiterParameter(long var1, float[] var3);

    private native void nativeSetCompressorParameter(long var1, int[] var3);

    private native void nativeStartAudioPreview(long var1);

    private native void nativeStopAudioPreview(long var1);

    private native void nativeSetLoudspeakerStatus(long var1, boolean var3);

    private native void nativeEnableKaraokeScoreEx(long var1, boolean var3);

    private native void nativeEnableKaraokeScore(long var1, boolean var3);

    private native void nativeStartKaraokeScore(long var1);

    private native void nativePauseKaraokeScore(long var1, boolean var3);

    private native void nativeStopKaraokeScore(long var1);

    private native void nativeResetKaraokeScore(long var1, long var3);

    private native boolean nativeOpenScoreRefFile(long var1, String var3);

    private native byte[] nativeSetScoreTimeRange(long var1, TimeRange[] var3, long var4);

    private native void nativeEnableSingingAutoTune(long var1, boolean var3);

    private native void nativeSetCurrentPlayingPosition(long var1, long var3);

    private native boolean nativeSetSingRefPitchFile(long var1, String var3);

    private native boolean nativeSetSingRefLyricTimeRange(long var1, TimeRange[] var3, long var4);

    private native boolean nativeSetSingRefLyricFile(long var1, String var3);

    private native boolean nativeSetSingRefMfccFile(long var1, String var3);

    private native boolean nativeOneKeySingingAutoTuneProcess(long var1, int var3, String var4, String var5);

    private native boolean nativeSetPlaybackModeOn(long var1, boolean var3);

    private native boolean nativeSetPlayBackVolume(long var1, long var3);

    private native void nativeSetDspExEnable(long var1, boolean var3);

    private native void nativeSetDspExReverbEnable(long var1, boolean var3);

    private native void nativeSetDspExLimiterEnable(long var1, boolean var3);

    private native void nativeSetDspExEqEnable(long var1, boolean var3);

    private native void nativeSetDspExReverbParam(long var1, float[] var3);

    private native void nativeSetDspExLimiterParameter(long var1, float[] var3);

    private native void nativeSetDspEqualizerParameter(long var1, float[] var3);
}

