/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.audioengine;

import android.annotation.TargetApi;
import android.content.Context;
import android.media.AudioManager;
import android.media.AudioTrack;
import android.os.Build;
import android.os.Process;
import java.nio.ByteBuffer;
import org.webrtc.audioengine.AudioManagerAndroid;

class WebRtcAudioTrack {
    private static final String TAG = "WebRtcAudioTrack";
    private static final int SAMPLE_RATE_HZ = 44100;
    private static final int BITS_PER_SAMPLE = 16;
    private static final int CALLBACK_BUFFER_SIZE_MS = 10;
    private static final int BUFFERS_PER_SECOND = 100;
    private final Context context;
    private final long nativeAudioTrack;
    private final AudioManager audioManager;
    private ByteBuffer byteBuffer;
    private AudioTrack audioTrack = null;
    private AudioTrackThread audioThread = null;
    private int bufferedPlaySamples = 0;
    private int sampleRate = 44100;
    private int channel = 2;
    private int playPosition = 0;
    private byte[] mMuteData = null;
    private int mMinBufSize = 0;
    private boolean mIsAlreadyMute = false;
    final String logTag = "AudioTrackJava: ";

    WebRtcAudioTrack(Context context, long nativeAudioTrack) {
        this.context = context;
        this.nativeAudioTrack = nativeAudioTrack;
        this.audioManager = (AudioManager)context.getSystemService("audio");
    }

    private boolean initPlayout(int sampleRate, int channels, int streamType) {
        this.doLog("WebRtcAudioTrack:initPlayout(sampleRate=" + sampleRate + ", channels=" + channels + ", streamType=" + streamType + ")");
        int channelMode = 4;
        if (channels == 2) {
            channelMode = 12;
        }
        int bytesPerFrame = channels * 2;
        this.byteBuffer = ByteBuffer.allocateDirect(bytesPerFrame * (sampleRate / 100));
        this.mMuteData = new byte[this.byteBuffer.array().length];
        this.nativeCacheDirectBufferAddress(this.byteBuffer, this.nativeAudioTrack);
        this.bufferedPlaySamples = 0;
        this.channel = channels;
        this.playPosition = 0;
        int minBufferSizeInBytes = AudioTrack.getMinBufferSize((int)sampleRate, (int)channelMode, (int)2);
        int blockSize = sampleRate / 100 * bytesPerFrame;
        int playBufSize = this.mMinBufSize = minBufferSizeInBytes;
        if (minBufferSizeInBytes % blockSize != 0 && (playBufSize = (minBufferSizeInBytes / blockSize + 1) * blockSize) < blockSize * 10) {
            playBufSize = blockSize * 10;
        }
        try {
            this.audioTrack = new AudioTrack(streamType, sampleRate, channelMode, 2, playBufSize, 1);
        }
        catch (IllegalArgumentException e) {
            this.doLogErr(e.getMessage());
            return false;
        }
        int bufferMs = (int)(1000.0 * (double)playBufSize / 2.0 / (double)this.channel / (double)sampleRate);
        this.doLog("AudioTrackJava: getMinBufferSize: " + minBufferSizeInBytes + ", playBufSize: " + playBufSize + ", bufferMs: " + bufferMs + ", streamType: " + streamType);
        this.nativeSetTrackBufferSizeMs(bufferMs);
        if (this.audioTrack.getState() != 1) {
            this.doLogErr("Initialization of audio track failed.");
            return false;
        }
        return true;
    }

    private boolean startPlayout() {
        this.doLog("startPlayout");
        WebRtcAudioTrack.assertTrue(this.audioTrack != null);
        WebRtcAudioTrack.assertTrue(this.audioThread == null);
        if (this.audioTrack.getState() != 1) {
            this.doLogErr("Audio track is not successfully initialized.");
            return false;
        }
        this.audioThread = new AudioTrackThread("YY_Aud_Track_Java");
        this.audioThread.start();
        return true;
    }

    private boolean stopPlayout() {
        this.doLog("stopPlayout...begin");
        WebRtcAudioTrack.assertTrue(this.audioThread != null);
        this.audioThread.joinThread();
        this.audioThread = null;
        if (this.audioTrack != null) {
            this.audioTrack.release();
            this.audioTrack = null;
        }
        this.doLog("stopPlayout...end");
        this.mIsAlreadyMute = false;
        return true;
    }

    private static void assertTrue(boolean condition) {
        if (!condition) {
            throw new AssertionError((Object)"Expected condition to be true");
        }
    }

    private native void nativeCacheDirectBufferAddress(ByteBuffer var1, long var2);

    private native void nativeGetPlayoutData(int var1, long var2, int var4);

    private native long nativeGetTickCount();

    private native void nativeSetTrackBufferSizeMs(int var1);

    private native void nativeSetPlayPos(long var1, int var3);

    public static boolean runningOnLollipopOrHigher() {
        return Build.VERSION.SDK_INT >= 21;
    }

    private void doLog(String msg) {
        AudioManagerAndroid.doLog("AudioTrackJava: " + msg);
    }

    private void doLogErr(String msg) {
        AudioManagerAndroid.doLog("AudioTrackJava: [Error]" + msg);
    }

    private static String getThreadInfo() {
        return "@[name=" + Thread.currentThread().getName() + ", id=" + Thread.currentThread().getId() + "]";
    }

    private static boolean runningOnJellyBeanOrHigher() {
        return Build.VERSION.SDK_INT >= 16;
    }

    private static boolean runningOnJellyBeanMR1OrHigher() {
        return Build.VERSION.SDK_INT >= 17;
    }

    private int getNativeSampleRate() {
        if (!WebRtcAudioTrack.runningOnJellyBeanMR1OrHigher()) {
            return 44100;
        }
        String sampleRateString = this.audioManager.getProperty("android.media.property.OUTPUT_SAMPLE_RATE");
        return sampleRateString == null ? 44100 : Integer.parseInt(sampleRateString);
    }

    static String modeToString(int mode) {
        switch (mode) {
            case 2: {
                return "MODE_IN_CALL";
            }
            case 3: {
                return "MODE_IN_COMMUNICATION";
            }
            case 0: {
                return "MODE_NORMAL";
            }
            case 1: {
                return "MODE_RINGTONE";
            }
        }
        return "MODE_INVALID";
    }

    private class AudioTrackThread
    extends Thread {
        private volatile boolean keepAlive;

        public AudioTrackThread(String name) {
            super(name);
            this.keepAlive = true;
        }

        @Override
        public void run() {
            Process.setThreadPriority((int)-19);
            WebRtcAudioTrack.this.doLog("AudioTrackJava: Thread" + WebRtcAudioTrack.getThreadInfo());
            try {
                WebRtcAudioTrack.this.audioTrack.play();
                WebRtcAudioTrack.assertTrue(WebRtcAudioTrack.this.audioTrack.getPlayState() == 3);
            }
            catch (Exception e) {
                WebRtcAudioTrack.this.doLogErr("AudioTrack.play failed: " + e.getMessage());
                return;
            }
            int sizeInBytes = WebRtcAudioTrack.this.byteBuffer.capacity();
            while (this.keepAlive) {
                WebRtcAudioTrack.this.nativeGetPlayoutData(sizeInBytes, WebRtcAudioTrack.this.nativeAudioTrack, WebRtcAudioTrack.this.bufferedPlaySamples);
                WebRtcAudioTrack.assertTrue(sizeInBytes <= WebRtcAudioTrack.this.byteBuffer.remaining());
                int bytesWritten = 0;
                if (!WebRtcAudioTrack.this.mIsAlreadyMute && WebRtcAudioTrack.this.audioTrack.getPlaybackHeadPosition() < WebRtcAudioTrack.this.mMinBufSize) {
                    System.arraycopy(WebRtcAudioTrack.this.mMuteData, 0, WebRtcAudioTrack.this.byteBuffer.array(), 0, WebRtcAudioTrack.this.byteBuffer.array().length);
                } else {
                    WebRtcAudioTrack.this.mIsAlreadyMute = true;
                }
                bytesWritten = WebRtcAudioTrack.runningOnLollipopOrHigher() ? this.writeOnLollipop(WebRtcAudioTrack.this.audioTrack, WebRtcAudioTrack.this.byteBuffer, sizeInBytes) : this.writePreLollipop(WebRtcAudioTrack.this.audioTrack, WebRtcAudioTrack.this.byteBuffer, sizeInBytes);
                WebRtcAudioTrack.this.bufferedPlaySamples = WebRtcAudioTrack.this.bufferedPlaySamples + (bytesWritten >> 1);
                int pos = WebRtcAudioTrack.this.audioTrack.getPlaybackHeadPosition() * WebRtcAudioTrack.this.channel;
                if (pos < WebRtcAudioTrack.this.playPosition) {
                    WebRtcAudioTrack.this.playPosition = 0;
                }
                WebRtcAudioTrack.this.bufferedPlaySamples = WebRtcAudioTrack.this.bufferedPlaySamples - (pos - WebRtcAudioTrack.this.playPosition);
                WebRtcAudioTrack.this.playPosition = pos;
                WebRtcAudioTrack.this.nativeSetPlayPos(WebRtcAudioTrack.this.nativeAudioTrack, WebRtcAudioTrack.this.playPosition);
                if (bytesWritten != sizeInBytes) {
                    WebRtcAudioTrack.this.doLogErr("AudioTrack.write failed: " + bytesWritten);
                    if (bytesWritten == -3) {
                        this.keepAlive = false;
                    }
                }
                WebRtcAudioTrack.this.byteBuffer.rewind();
            }
            try {
                WebRtcAudioTrack.this.audioTrack.stop();
            }
            catch (Exception e) {
                WebRtcAudioTrack.this.doLogErr("AudioTrack.stop failed: " + e.getMessage());
            }
            WebRtcAudioTrack.assertTrue(WebRtcAudioTrack.this.audioTrack.getPlayState() == 1);
            WebRtcAudioTrack.this.audioTrack.flush();
            WebRtcAudioTrack.this.nativeSetPlayPos(WebRtcAudioTrack.this.nativeAudioTrack, 0);
        }

        @TargetApi(value=21)
        private int writeOnLollipop(AudioTrack audioTrack, ByteBuffer byteBuffer, int sizeInBytes) {
            return audioTrack.write(byteBuffer, sizeInBytes, 0);
        }

        private int writePreLollipop(AudioTrack audioTrack, ByteBuffer byteBuffer, int sizeInBytes) {
            return audioTrack.write(byteBuffer.array(), byteBuffer.arrayOffset(), sizeInBytes);
        }

        public void joinThread() {
            this.keepAlive = false;
            while (this.isAlive()) {
                try {
                    this.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

