/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.audioengine;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioManager;
import org.webrtc.audioengine.AudioManagerAndroid;
import org.webrtc.audioengine.VolumeChangeListener;

public class VolumeChangeReceiver
extends BroadcastReceiver {
    private static final String TAG = "[VolumeChangeReceiver]";
    private static final String VOLUME_CHANGED_ACTION = "android.media.VOLUME_CHANGED_ACTION";
    private static final String EXTRA_VOLUME_STREAM_TYPE = "android.media.EXTRA_VOLUME_STREAM_TYPE";
    private int mPreStreamType = -2;
    private int mPreVolume = -1;
    private boolean mVolumeChangeRegistered = false;
    public Context mContext;
    private VolumeChangeListener mVolumeChangeListener;

    public VolumeChangeReceiver(Context context, VolumeChangeListener listener) {
        this.mContext = context;
        this.mVolumeChangeListener = listener;
    }

    public void onReceive(Context context, Intent intent) {
        AudioManager audioManager = (AudioManager)this.mContext.getSystemService("audio");
        int streamType = intent.getIntExtra(EXTRA_VOLUME_STREAM_TYPE, -1);
        String actionStr = intent.getAction();
        if (VOLUME_CHANGED_ACTION.equals(actionStr) && (streamType == 3 || streamType == 0 || streamType == 2)) {
            int volume = audioManager.getStreamVolume(streamType);
            if ((volume != this.mPreVolume || this.mPreStreamType != streamType) && this.mVolumeChangeListener != null) {
                this.mVolumeChangeListener.onSystemVolumeChange(volume);
            }
            this.mPreVolume = volume;
            this.mPreStreamType = streamType;
        }
    }

    public void init() {
        this.mPreStreamType = -2;
        this.mPreVolume = -1;
        IntentFilter filter = new IntentFilter();
        filter.addAction(VOLUME_CHANGED_ACTION);
        this.mContext.registerReceiver((BroadcastReceiver)this, filter);
        this.mVolumeChangeRegistered = true;
        AudioManagerAndroid.doLog("[VolumeChangeReceiver]registerVolumeChangeReceiver");
    }

    public void uninit() {
        this.mPreStreamType = -2;
        this.mPreVolume = -1;
        if (this.mVolumeChangeRegistered) {
            try {
                this.mContext.unregisterReceiver((BroadcastReceiver)this);
                this.mVolumeChangeRegistered = false;
                AudioManagerAndroid.doLog("[VolumeChangeReceiver]unregisterVolumeChangeReceiver ");
            }
            catch (Exception e) {
                AudioManagerAndroid.doLog("[VolumeChangeReceiver]unregisterVolumeChangeReceiver error:" + e.getMessage());
            }
        }
    }
}

