/*
 * Decompiled with CFR 0.152.
 */
package com.yy.audioengine;

import com.yy.audioengine.IKaraokeFileMixerNotity;
import com.yy.audioengine.MainHandler;
import com.yy.audioengine.YALog;
import java.util.Arrays;

public class KaraokeFileMixer {
    private static String TAG = "[KaraokeFileMixer]";
    private IKaraokeFileMixerNotity mNotify;
    private long mCtx;

    public void init() {
        YALog.info(TAG + "Init....");
        this.mCtx = this.nativeCreateKaraokeFileMixer(this);
    }

    public void destroy() {
        YALog.info(TAG + "Destroy....");
        this.nativeDestroyKaraokeFileMixer(this.mCtx);
        this.mNotify = null;
    }

    public void setKaraokeFileMixerNotify(IKaraokeFileMixerNotity notify) {
        YALog.info(TAG + "SetKaraokeFileMixerNotify, notify: " + notify);
        this.mNotify = notify;
    }

    public boolean open(String voiceFile, String accompanyFile) {
        YALog.info(TAG + "Open, voiceFile: " + voiceFile + " ,accompanyFile: " + accompanyFile);
        return this.nativeOpen(this.mCtx, voiceFile, accompanyFile);
    }

    public boolean start(String fileName) {
        YALog.info(TAG + "Start, fileName: " + fileName);
        boolean res = this.nativeStart(this.mCtx, fileName);
        return res;
    }

    public void stop() {
        YALog.info(TAG + "Stop....");
        this.nativeStop(this.mCtx);
    }

    public void setVoiceOffset(int offsetTime) {
        YALog.info(TAG + "SetVoiceOffset, offsetTime: " + offsetTime);
        this.nativeSetVoiceOffset(this.mCtx, offsetTime);
    }

    public void setEtbValue(int value) {
        YALog.info(TAG + "SetEtbValue, value: " + value);
        this.nativeSetEtbValue(this.mCtx, value);
    }

    public void enableDenoise(boolean enable) {
        YALog.info(TAG + "EnableDenoise, enable: " + enable);
        this.nativeEnableDenoise(this.mCtx, enable);
    }

    public void setVoiceVolume(int volume) {
        YALog.info(TAG + "SetVoiceVolume, volume: " + volume);
        this.nativeSetVoiceVolume(this.mCtx, volume);
    }

    public void setAccompanyVolume(int volume) {
        YALog.info(TAG + "SetAccompanyVolume, volume: " + volume);
        this.nativeSetAccompanyVolume(this.mCtx, volume);
    }

    public void setTone(int value) {
        YALog.info(TAG + "SetTone, value: " + value);
        this.nativeSetTone(this.mCtx, value);
    }

    public void enableReverbNew(boolean enable) {
        YALog.info(TAG + "EnableReverbNew, enable: " + enable);
        this.nativeEnableReverbNew(this.mCtx, enable);
    }

    public void setReverbNewParam(float[] array) {
        YALog.info(TAG + "SetReverbNewParam,array: " + Arrays.toString(array));
        this.nativeSetReverbNewParam(this.mCtx, array);
    }

    public void enableEqualizer(boolean enable) {
        YALog.info(TAG + "EnableEqualizer, enable: " + enable);
        this.nativeEnableEqualizer(this.mCtx, enable);
    }

    public void setEqGains(float[] array) {
        YALog.info(TAG + "SetEqGains,array: " + Arrays.toString(array));
        this.nativeSetEqGains(this.mCtx, array);
    }

    public void enableCompressor(boolean enable) {
        YALog.info(TAG + "EnableCompressor, enable: " + enable);
        this.nativeEnableCompressor(this.mCtx, enable);
    }

    public void setCompressorParam(int[] array) {
        YALog.info(TAG + "SetCompressorParam,array: " + Arrays.toString(array));
        this.nativeSetCompressorParam(this.mCtx, array);
    }

    public void enableLimiter(boolean enable) {
        YALog.info(TAG + "EnableLimiter. enable: " + enable);
        this.nativeEnableLimiter(this.mCtx, enable);
    }

    public void setLimiterParam(float[] array) {
        YALog.info(TAG + "SetLimiterParam,array: " + Arrays.toString(array));
        this.nativeSetLimiterParam(this.mCtx, array);
    }

    private void onFileMixerState(long curTime, long totalTime) {
        if (this.mNotify != null) {
            this.mNotify.onFileMixerState(curTime, totalTime);
        }
    }

    private void onFinishMixer() {
        YALog.info(TAG + "OnFinishMixer...");
        MainHandler.getInstance().post(new Runnable(){

            @Override
            public void run() {
                if (KaraokeFileMixer.this.mNotify != null) {
                    KaraokeFileMixer.this.mNotify.onFinishMixer();
                }
            }
        });
    }

    private native long nativeCreateKaraokeFileMixer(Object var1);

    private native void nativeDestroyKaraokeFileMixer(long var1);

    private native boolean nativeOpen(long var1, String var3, String var4);

    private native boolean nativeStart(long var1, String var3);

    private native void nativeStop(long var1);

    private native void nativeSetVoiceVolume(long var1, int var3);

    private native void nativeSetAccompanyVolume(long var1, int var3);

    private native void nativeSetTone(long var1, int var3);

    private native void nativeEnableDenoise(long var1, boolean var3);

    private native void nativeSetEtbValue(long var1, int var3);

    private native void nativeSetVoiceOffset(long var1, int var3);

    private native void nativeEnableReverbNew(long var1, boolean var3);

    private native void nativeSetReverbNewParam(long var1, float[] var3);

    private native void nativeEnableEqualizer(long var1, boolean var3);

    private native void nativeSetEqGains(long var1, float[] var3);

    private native void nativeEnableCompressor(long var1, boolean var3);

    private native void nativeSetCompressorParam(long var1, int[] var3);

    private native void nativeEnableLimiter(long var1, boolean var3);

    private native void nativeSetLimiterParam(long var1, float[] var3);
}

